/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xml.ras.LoggerUtil;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TypeSpecializationDerivative {
    private static final Logger s_logger = LoggerUtil.getLogger(TypeSpecializationDerivative.class);
    private static final String s_className = TypeSpecializationDerivative.class.getName();
    public Type[] m_types;
    public Type[] m_originalTypeVariables;
    private final int hashCode;
    private static final boolean diagnoseSpecializedFunctions = false;

    public TypeSpecializationDerivative(Type[] types2) {
        this.m_types = types2;
        this.hashCode = TypeSpecializationDerivative.computeHashCode(types2);
    }

    public boolean equals(Object arg0) {
        if (!(arg0 instanceof TypeSpecializationDerivative)) {
            return false;
        }
        TypeSpecializationDerivative tsd = (TypeSpecializationDerivative)arg0;
        if (tsd.m_types.length != this.m_types.length) {
            return false;
        }
        for (int i = 0; i < tsd.m_types.length; ++i) {
            if (tsd.m_types[i] == null && this.m_types[i] == null) continue;
            if (tsd.m_types[i] != null && !tsd.m_types[i].semanticallyEquals(this.m_types[i], true)) {
                return false;
            }
            if (tsd.m_types[i] != null || this.m_types[i] == null) continue;
            return false;
        }
        return true;
    }

    public static Function specializeTypes(Function f2, Type[] types2, TypeEnvironment tenv) {
        TypeSpecializationDerivative tsd = new TypeSpecializationDerivative(types2);
        Function fOrigFunc = f2;
        while (fOrigFunc.isDerivative() && fOrigFunc.getDerivationKey().getClass() == TypeSpecializationDerivative.class) {
            fOrigFunc = fOrigFunc.getOriginalFunction();
        }
        Function f22 = fOrigFunc.lookupDerivative(tsd);
        if (f22 != null) {
            for (int i = 0; i < types2.length; ++i) {
                if ((types2[i] == null || types2[i].semanticallyEquals(f22.m_parameters[i].getBindingType(), true)) && (types2[i] != null || !f22.m_parameters[i].getBindingType().isFullySpecified())) continue;
                f22 = null;
                break;
            }
        }
        if (f22 == null) {
            if (fOrigFunc.m_derivatives.size() > 20) {
                if (fOrigFunc.getName().contains("fn:data")) {
                    if (fOrigFunc.m_derivatives.size() > 100) {
                        return f2;
                    }
                } else if (fOrigFunc.getName().contains("do-check-nodes-only")) {
                    if (fOrigFunc.m_derivatives.size() > 100) {
                        return f2;
                    }
                } else {
                    return f2;
                }
            }
            if (tenv != null) {
                Module m = tenv.getModule();
                if (m.getNumberXMLTypeSpecializations() > 1000L) {
                    return f2;
                }
            } else {
                return f2;
            }
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                StringBuffer sb = new StringBuffer("specializing " + fOrigFunc.getName() + " to types");
                for (int i = 0; i < types2.length; ++i) {
                    sb.append(" " + (types2[i] == null ? "[?]" : types2[i].prettyPrint()));
                }
                s_logger.logp(Level.FINER, s_className, "specializeTypes", sb.toString());
            }
            f22 = fOrigFunc.cloneFunctionForFixup(tsd, false, true, false);
            f22.setInlineHint(fOrigFunc.getInlineHint());
            f22.setMemoizeResult(fOrigFunc.getMemoizeResult());
            tsd.m_originalTypeVariables = new Type[types2.length];
            for (int i = 0; i < types2.length; ++i) {
                tsd.m_originalTypeVariables[i] = f22.m_parameters[i].m_type;
                if (types2[i] == null) continue;
                f22.m_parameters[i].m_type = types2[i];
            }
            if (tenv != null) {
                Module m = tenv.getModule();
                m.setNumberXMLTypeSpecializations(m.getNumberXMLTypeSpecializations() + 1L);
            }
        }
        return f22;
    }

    private static void printDiagnosticFunctionSig(Function f2) {
        System.out.print(f2.getName() + "(");
        Binding[] bindings = f2.getParameters();
        for (int i = 0; i < bindings.length; ++i) {
            Binding binding = bindings[i];
            System.out.print(binding.getBindingType().prettyPrint());
            if (i + 1 == bindings.length) continue;
            System.out.print(", ");
        }
        System.out.println(");");
    }

    private static int computeHashCode(Type[] types2) {
        int hashCode = 0;
        for (int i = 0; i < types2.length; ++i) {
            Type t = types2[i];
            String subKey = t != null ? t.prettyPrint() : "resolve failed";
            hashCode = hashCode * 31 + subKey.hashCode();
        }
        return hashCode;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

