/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.ITypeStore;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.types.BigIntegerType;
import com.ibm.xltxe.rnm1.xylem.types.ByteType;
import com.ibm.xltxe.rnm1.xylem.types.CharType;
import com.ibm.xltxe.rnm1.xylem.types.DecimalType;
import com.ibm.xltxe.rnm1.xylem.types.DoubleType;
import com.ibm.xltxe.rnm1.xylem.types.FloatType;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xltxe.rnm1.xylem.types.JavaObjectType;
import com.ibm.xltxe.rnm1.xylem.types.LambdaType;
import com.ibm.xltxe.rnm1.xylem.types.LongType;
import com.ibm.xltxe.rnm1.xylem.types.NamedType;
import com.ibm.xltxe.rnm1.xylem.types.ShortType;
import com.ibm.xltxe.rnm1.xylem.types.SlotType;
import com.ibm.xltxe.rnm1.xylem.types.StreamType;
import com.ibm.xltxe.rnm1.xylem.types.TupleType;
import com.ibm.xltxe.rnm1.xylem.types.TypeLambda;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import com.ibm.xltxe.rnm1.xylem.types.UnitType;
import java.io.IOException;
import java.io.ObjectOutput;

public class WriteObjectFileHelper {
    protected ObjectOutput m_out;
    protected ITypeStore m_typeStore;

    public WriteObjectFileHelper(ITypeStore ts, ObjectOutput out) {
        this.m_out = out;
        this.m_typeStore = ts;
    }

    public void writeString(String s) throws IOException {
        this.m_out.writeUTF(s);
    }

    public void writeBindingName(Object o) throws IOException {
        if (o instanceof String) {
            this.m_out.writeByte(1);
            this.writeString((String)o);
        } else if (o instanceof Integer) {
            this.m_out.writeByte(2);
            this.m_out.writeInt((Integer)o);
        } else {
            this.m_out.writeByte(3);
            this.m_out.writeObject(o);
        }
    }

    public void writeInstructionTag(Instruction x) throws IOException {
        this.writeString(x.getClass().getName());
    }

    public void writeInt(int n2) throws IOException {
        this.m_out.writeInt(n2);
    }

    public void writeByte(int n2) throws IOException {
        this.m_out.writeByte(n2);
    }

    public void writeBoolean(boolean b) throws IOException {
        this.m_out.writeBoolean(b);
    }

    public void writeInstruction(Instruction x) throws IOException {
        this.writeInstructionTag(x);
        x.write(this);
    }

    public void writeType(Type type2) throws IOException {
        if (type2 instanceof StreamType) {
            this.writeByte(1);
            this.writeType(((StreamType)type2).getElementType());
        } else if (type2 instanceof SlotType) {
            this.writeByte(2);
            this.writeType(((SlotType)type2).getElementType());
        } else if (type2 instanceof TupleType) {
            this.writeByte(3);
            TupleType tt = (TupleType)type2;
            Type[] types2 = tt.getElementTypes();
            int c = types2.length;
            this.writeInt(c);
            for (int i = 0; i < c; ++i) {
                this.writeType(types2[i]);
            }
        } else if (type2 instanceof LambdaType) {
            this.writeByte(4);
            LambdaType lt2 = (LambdaType)type2;
            this.writeBoolean(lt2.isPure());
            this.writeType(lt2.getReturnType());
            Type[] types3 = lt2.getElementTypes();
            int c = types3.length;
            this.writeInt(c);
            for (int i = 0; i < c; ++i) {
                this.writeType(types3[i]);
            }
        } else if (IntType.s_intType.equals(type2)) {
            this.writeByte(5);
        } else if (ShortType.s_shortType.equals(type2)) {
            this.writeByte(6);
        } else if (LongType.s_longType.equals(type2)) {
            this.writeByte(7);
        } else if (FloatType.s_floatType.equals(type2)) {
            this.writeByte(8);
        } else if (DoubleType.s_doubleType.equals(type2)) {
            this.writeByte(9);
        } else if (CharType.s_charType.equals(type2)) {
            this.writeByte(10);
        } else if (ByteType.s_byteType.equals(type2)) {
            this.writeByte(11);
        } else if (BigIntegerType.s_bigIntegerType.equals(type2)) {
            this.writeByte(12);
        } else if (DecimalType.s_decimalType.equals(type2)) {
            this.writeByte(13);
        } else if (UnitType.s_unitType.equals(type2)) {
            this.writeByte(14);
        } else if (JavaObjectType.s_javaStringType.equals(type2)) {
            this.writeByte(15);
        } else if (type2 instanceof TypeVariable) {
            this.writeByte(16);
            this.m_out.writeObject(type2);
        } else if (type2 instanceof NamedType) {
            int cnt;
            this.writeByte(17);
            NamedType ct = (NamedType)type2;
            this.writeString(ct.getName());
            this.writeBoolean(ct.getModule() != null);
            if (ct.getModule() != null) {
                this.writeString(ct.getModule());
            }
            if ((cnt = ct.getChildTypeCount()) > 0) {
                this.writeTypes(ct.getTypeParameters());
            } else {
                this.writeInt(0);
            }
        } else if (type2 instanceof JavaObjectType) {
            this.writeByte(18);
            this.writeString(((JavaObjectType)type2).getClassName());
        } else {
            this.writeByte(19);
            this.writeObject(type2);
        }
    }

    public void writeTypeSpecificBindingSet(Binding[] bindings) throws IOException {
        int c2 = bindings.length;
        this.writeInt(c2);
        for (int j = 0; j < c2; ++j) {
            this.writeBindingName(bindings[j].getName());
            this.writeType(bindings[j].getBindingType());
        }
    }

    public void writeTypes(Type[] bindings) throws IOException {
        int c2 = bindings.length;
        this.writeInt(c2);
        for (int j = 0; j < c2; ++j) {
            this.writeType(bindings[j]);
        }
    }

    public void writeObject(Object o) throws IOException {
        this.m_out.writeObject(o);
    }

    public void writeBindingNames(Binding[] bindings) throws IOException {
        int c2 = bindings.length;
        this.writeInt(c2);
        for (int j = 0; j < c2; ++j) {
            this.writeBindingName(bindings[j].getName());
        }
    }

    public void writeBindingNames(Object[] bindings) throws IOException {
        int c2 = bindings.length;
        this.writeInt(c2);
        for (int j = 0; j < c2; ++j) {
            this.writeBindingName(bindings[j]);
        }
    }

    public void close() throws IOException {
        this.m_out.close();
        this.m_out = null;
    }

    public void writeTypeLambda(TypeLambda t) throws IOException {
        this.writeObject(t);
    }
}

