/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.annot;

import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.NavigationUtilities;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.annot.AnnotationTable;
import com.ibm.xltxe.rnm1.xylem.annot.IAnnotation;
import com.ibm.xltxe.rnm1.xylem.annot.IFunctionAnnotationInfo;
import com.ibm.xltxe.rnm1.xylem.annot.NullAnnotation;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xml.ras.LoggerUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AnnotationEnvironment {
    private static final Logger s_logger = LoggerUtil.getLogger(AnnotationEnvironment.class);
    private static final String s_className = AnnotationEnvironment.class.getName();
    private AnnotationTable m_table;
    private HashMap m_env = new HashMap();
    private HashMap m_literals = new HashMap();
    private HashMap m_infos = new HashMap();
    private boolean m_hasAnnotations = false;
    private IFunctionAnnotationInfo m_functionInfo;

    public AnnotationEnvironment(AnnotationTable t) {
        this.m_table = t;
    }

    public Function getEnclosingFunction() {
        return this.m_functionInfo.getEnclosingFunction();
    }

    public TypeEnvironment getTypeEnvironment() {
        return this.getEnclosingFunction().getTypeEnvironment();
    }

    public BindingEnvironment getBindingEnvironment() {
        return this.getEnclosingFunction().getBindingEnvironment();
    }

    public AnnotationTable getTable() {
        return this.m_table;
    }

    public boolean hasAnnotations() {
        return this.m_hasAnnotations;
    }

    public IAnnotation get(Object var) {
        return (IAnnotation)this.m_env.get(var);
    }

    public IAnnotation[] get(Instruction[] nn) {
        IAnnotation[] aa = new IAnnotation[nn.length];
        for (int i = 0; i < nn.length; ++i) {
            aa[i] = this.get(nn[i]);
        }
        return aa;
    }

    public IAnnotation[] get(Object[] oo) {
        IAnnotation[] aa = new IAnnotation[oo.length];
        for (int i = 0; i < oo.length; ++i) {
            aa[i] = this.get(oo[i]);
        }
        return aa;
    }

    public IAnnotation get(Instruction i) {
        if (i instanceof LiteralInstruction) {
            return this.m_table.getAnnotator().analyzeExpression(this, i, null);
        }
        if (!(i instanceof IdentifierInstruction)) {
            throw new XylemError("ERR_SYSTEM", "Annnotations may only be bound to reduced code");
        }
        return this.get(((IdentifierInstruction)i).getVariable());
    }

    public void setAlias(Object var, IdentifierInstruction alias) {
        this.setAlias(var, alias.getVariable());
    }

    public void setAlias(Object var, Object alias) {
        if (this.m_env.containsKey(var)) {
            throw new XylemError("ERR_SYSTEM", "Can't alias '" + var + "' to '" + alias + "' " + "because '" + var + "' is already bound (to " + this.m_env.get(var) + ").");
        }
        if (!this.m_env.containsKey(alias)) {
            throw new XylemError("ERR_SYSTEM", "Can't alias '" + var + "' to '" + alias + "' because '" + alias + "' is not bound.");
        }
        IAnnotation a = this.get(alias);
        this.m_env.put(var, a);
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "setAlias", "alias(" + var + ")=>" + alias);
        }
    }

    public void set(Object var, IAnnotation a) {
        IAnnotation o;
        if (a != null && !(a instanceof NullAnnotation)) {
            this.m_hasAnnotations = true;
            a.setVariable(var);
        }
        if ((o = this.m_env.put(var, a)) != null) {
            this.m_env.put(var, o);
            throw new XylemError("ERR_SYSTEM", "Annotation for '" + var + "' is already bound to '" + o + "'");
        }
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "set", "annot(" + var + ")=>" + a);
        }
    }

    public void setComputedLiteral(Instruction i, Object computedValue) {
        HashSet<Object> s;
        if (i instanceof IdentifierInstruction) {
            i = NavigationUtilities.resolveReducedIdentifier(i, this.getBindingEnvironment());
        }
        if ((s = (HashSet<Object>)this.m_literals.get(i)) == null) {
            s = new HashSet<Object>();
            this.m_literals.put(i, s);
        }
        s.add(computedValue);
    }

    public Set getComputedLiteral(Instruction i) {
        if (i instanceof LiteralInstruction) {
            return Collections.singleton(((LiteralInstruction)i).getValue());
        }
        if (!(i instanceof IdentifierInstruction)) {
            throw new XylemError("ERR_SYSTEM", "Literals may only be resolved against reduced code");
        }
        i = NavigationUtilities.resolveReducedIdentifier(i, this.getBindingEnvironment());
        return (Set)this.m_literals.get(i);
    }

    public void setFunctionInfo(IFunctionAnnotationInfo functionInfo) {
        this.m_functionInfo = functionInfo;
    }

    public IFunctionAnnotationInfo getFunctionInfo() {
        return this.m_functionInfo;
    }

    public void addInfo(Object table2, Object k, Object v) {
        Object o;
        HashMap<Object, Object> m = (HashMap<Object, Object>)this.m_infos.get(table2);
        if (m == null) {
            m = new HashMap<Object, Object>();
            this.m_infos.put(table2, m);
        }
        if ((o = m.put(k, v)) != null) {
            // empty if block
        }
    }

    public Object getInfo(Object table2, Object k) {
        Map m = (Map)this.m_infos.get(table2);
        if (m == null) {
            return null;
        }
        return m.get(k);
    }

    public void debug() {
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "debug", "ENVIRONMENT:");
            for (Object k : this.m_env.keySet()) {
                s_logger.logp(Level.FINE, s_className, "debug", "  " + k + " => " + this.m_env.get(k));
            }
        }
    }
}

