/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.annot;

import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.annot.AnnotationEnvironment;
import com.ibm.xltxe.rnm1.xylem.annot.FunctionAnnotationInfo;
import com.ibm.xltxe.rnm1.xylem.annot.FunctionCallSpec;
import com.ibm.xltxe.rnm1.xylem.annot.FunctionCallStackItem;
import com.ibm.xltxe.rnm1.xylem.annot.IAnnotation;
import com.ibm.xltxe.rnm1.xylem.annot.IAnnotator;
import com.ibm.xltxe.rnm1.xylem.annot.ICallSpec;
import com.ibm.xltxe.rnm1.xylem.annot.IFunctionAnnotationInfo;
import com.ibm.xltxe.rnm1.xylem.annot.LambdaApplySpec;
import com.ibm.xltxe.rnm1.xylem.annot.meta.LambdaMetaAnnotation;
import com.ibm.xltxe.rnm1.xylem.annot.meta.MetaAnnotation;
import com.ibm.xltxe.rnm1.xylem.annot.meta.StreamMetaAnnotation;
import com.ibm.xltxe.rnm1.xylem.annot.meta.TupleMetaAnnotation;
import com.ibm.xltxe.rnm1.xylem.instructions.ApplyInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.AutomatonInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ChooseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ConstructorInstantiationInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ForEachInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LambdaInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.MatchInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.NaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.TestStreamInstruction;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xml.ras.LoggerUtil;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AnnotationTable {
    private static final Logger s_logger = LoggerUtil.getLogger(AnnotationTable.class);
    private static final String s_className = AnnotationTable.class.getName();
    private Module m_module;
    private IAnnotator m_annotator;
    private HashMap m_functionInfo = new HashMap();
    private HashMap m_globalInfo = new HashMap();
    private ArrayList m_postponedFunctions = new ArrayList();
    private static final int FUNCTION_STACK_LIMIT = 100;
    private int m_currentFunctionStacklimit = 100;

    public AnnotationTable(Module m, IAnnotator a) {
        this.m_module = m;
        this.m_annotator = a;
    }

    public void addGlobalInfo(Object key2, Object value2) {
        this.m_globalInfo.put(key2, value2);
    }

    public Object getGlobalInfo(Object key2) {
        return this.m_globalInfo.get(key2);
    }

    public IAnnotator getAnnotator() {
        return this.m_annotator;
    }

    public Module getModule() {
        return this.m_module;
    }

    public IFunctionAnnotationInfo getFunctionInfo(ICallSpec fcs) {
        return (IFunctionAnnotationInfo)this.m_functionInfo.get(fcs);
    }

    public static AnnotationTable analyzeProgram(Module primaryModule, Function entryPoint, IAnnotator annotator) {
        AnnotationTable at = new AnnotationTable(primaryModule, annotator);
        IAnnotation a = at.analyzeFunction(entryPoint, null);
        if (a != null) {
            s_logger.logp(Level.WARNING, s_className, "analyzeProgram", "non-empty annotation for main return!");
        }
        at.analyzePostponedFunctions();
        return at;
    }

    public IAnnotation analyzeFunction(Function entryPoint, IAnnotation[] paramAnnotations) {
        if (paramAnnotations == null) {
            paramAnnotations = new IAnnotation[entryPoint.m_parameters.length];
        }
        return this.analyzeFunction(new FunctionCallSpec(entryPoint, paramAnnotations), null, new ArrayList(), new ArrayList());
    }

    public IAnnotation analyzeCode(Instruction n2, AnnotationEnvironment env, Object var, ArrayList functionStack, ArrayList pendingStacks) {
        IAnnotation a;
        IAnnotation val;
        IAnnotation ia;
        Instruction li;
        ArrayList<IAnnotation> valueAnnotations = new ArrayList<IAnnotation>();
        while (true) {
            valueAnnotations.clear();
            if (!(n2 instanceof LetInstruction)) break;
            li = (LetInstruction)n2;
            Instruction value2 = li.getValue();
            IAnnotation ia2 = this.analyzeCode(value2, env, li.getVariable(), functionStack, pendingStacks);
            if (ia2 != null && ia2.getVariable() != null) {
                ia2 = ia2.clonePassthru();
            }
            env.set(li.getVariable(), ia2);
            n2 = li.getBody();
        }
        if (n2 instanceof ForEachInstruction) {
            ForEachInstruction fei = (ForEachInstruction)n2;
            ia = env.get(fei.getSource());
            if (ia != null) {
                ia = ia.getLoopBindingAnnotation();
            }
            env.set(fei.getVarName(), ia);
            val = this.analyzeCode(fei.getBody(), env, null, functionStack, pendingStacks);
            if (val == null) {
                return null;
            }
            return val.getLoopValueAnnotation();
        }
        if (n2 instanceof TestStreamInstruction) {
            TestStreamInstruction tsi = (TestStreamInstruction)n2;
            ia = env.get(tsi.getSource());
            if (ia != null) {
                ia = ia.getLoopBindingAnnotation();
            }
            env.set(tsi.getElementBinding().getName(), ia);
            if (env.get(tsi.getHint()) != null) {
                throw new XylemError("ERR_SYSTEM", "not yet supported:" + tsi);
            }
            val = this.analyzeCode(tsi.getBody(), env, null, functionStack, pendingStacks);
            if (val == null) {
                return null;
            }
            return val;
        }
        if (n2 instanceof IdentifierInstruction) {
            a = env.get(n2);
            return a;
        }
        if (n2 instanceof AutomatonInstruction) {
            AutomatonInstruction ai = (AutomatonInstruction)n2;
            IAnnotation src = env.get(ai.getSource());
            IAnnotation istate = env.get(ai.getInitialState());
            IAnnotation elt = null;
            if (src != null) {
                elt = src.getLoopBindingAnnotation();
            }
            if (ai.getDefaultHandler() != null) {
                env.set(ai.getDefaultElementBinding().getName(), elt);
                Instruction h = ai.getDefaultHandler();
                if (istate != null) {
                    throw new Error("TODO: support ai state annotation?");
                }
                IAnnotation a2 = this.analyzeCode(h, env, null, functionStack, pendingStacks);
                valueAnnotations.add(a2);
            }
            for (int i = 0; i < ai.m_matches.length; ++i) {
                if (istate != null || elt != null) {
                    throw new Error("TODO: support annotationg non-default ai matches?");
                }
                Instruction h = ai.getDefaultHandler();
                if (h == null) continue;
                IAnnotation a3 = this.analyzeCode(h, env, null, functionStack, pendingStacks);
                valueAnnotations.add(a3);
            }
            IAnnotation ia3 = this.unionValues(env, valueAnnotations);
            if (ia3 == null) {
                return null;
            }
            return ia3.getLoopValueAnnotation();
        }
        if (n2 instanceof FunctionCallInstruction) {
            return this.analyzeFunctionCall(n2, env, functionStack, pendingStacks);
        }
        if (n2 instanceof ConstructorInstantiationInstruction && ((ConstructorInstantiationInstruction)n2).getConstructorName().startsWith("tuple")) {
            boolean all_null = true;
            for (int i = 0; i < n2.getChildInstructionCount(); ++i) {
                if (env.get(n2.getChildInstruction(i)) == null) continue;
                all_null = false;
                break;
            }
            if (all_null) {
                return null;
            }
            return new TupleMetaAnnotation(((NaryPrimopInstruction)n2).getOperands(), env);
        }
        if (n2 instanceof MatchInstruction && env.get(((MatchInstruction)n2).getToMatch()) instanceof TupleMetaAnnotation) {
            TupleMetaAnnotation sta = (TupleMetaAnnotation)env.get(((MatchInstruction)n2).getToMatch());
            MatchInstruction.Match[] mm = ((MatchInstruction)n2).getMatches();
            if (mm.length != 1) {
                throw new XylemError("ERR_SYSTEM", "isn't this a tuple?");
            }
            MatchInstruction.DeconstructionMatch dm = (MatchInstruction.DeconstructionMatch)mm[0];
            for (int i = 0; i < dm.getBindings().length; ++i) {
                if (sta.getComponents()[i] == null) continue;
                env.set(dm.getBindings()[i].getName(), sta.getComponents()[i].clonePassthru());
            }
            return this.analyzeCode(dm.getHandler(), env, null, functionStack, pendingStacks);
        }
        if (n2 instanceof MatchInstruction) {
            MatchInstruction mi = (MatchInstruction)n2;
            if (mi.getMatches()[0] instanceof MatchInstruction.LiteralMatch && mi.getToMatch() instanceof IdentifierInstruction) {
                IdentifierInstruction toMatch = (IdentifierInstruction)mi.getToMatch();
                Set literals = env.getComputedLiteral(toMatch);
                if (literals == null) {
                    if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                        s_logger.logp(Level.FINER, s_className, "analyzeCode", "no literal for match on " + toMatch);
                    }
                } else {
                    if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                        s_logger.logp(Level.FINER, s_className, "analyzeCode", "proactively optimizing match on " + toMatch + " with " + literals.size() + " values");
                    }
                    Iterator i = literals.iterator();
                    boolean unmatched = false;
                    while (i.hasNext()) {
                        Object toMatchLiteral = i.next();
                        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                            s_logger.logp(Level.FINER, s_className, "analyzeCode", "proactively optimizing match on " + toMatch + " with val " + toMatchLiteral);
                        }
                        MatchInstruction.Match[] matches2 = mi.getMatches();
                        int j = 0;
                        for (j = 0; j < matches2.length; ++j) {
                            LiteralInstruction lit = ((MatchInstruction.LiteralMatch)matches2[j]).getLiteral();
                            if (!lit.getValue().equals(toMatchLiteral)) continue;
                            Instruction handler = matches2[j].getHandler();
                            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                                s_logger.logp(Level.FINER, s_className, "analyzeCode", " -- match found " + toMatch + " with value " + toMatchLiteral);
                            }
                            valueAnnotations.add(this.analyzeCode(handler, env, null, functionStack, pendingStacks));
                            break;
                        }
                        if (j != matches2.length) continue;
                        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                            s_logger.logp(Level.FINER, s_className, "analyzeCode", " -- no match found " + toMatch);
                        }
                        unmatched = true;
                    }
                    if (unmatched) {
                        if (mi.getDefault() != null) {
                            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                                s_logger.logp(Level.FINER, s_className, "analyzeCode", " some literals do not match any value. analyzing default.");
                            }
                            valueAnnotations.add(this.analyzeCode(mi.getDefault(), env, null, functionStack, pendingStacks));
                        } else if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                            s_logger.logp(Level.FINER, s_className, "analyzeCode", " some literal do not match any value. no analysis.");
                        }
                    }
                    return this.unionValues(env, valueAnnotations);
                }
            }
            int c = n2.getChildInstructionCount();
            for (int i = 0; i < c; ++i) {
                Instruction n22 = n2.getChildInstruction(i);
                valueAnnotations.add(this.analyzeCode(n22, env, null, functionStack, pendingStacks));
            }
            return this.unionValues(env, valueAnnotations);
        }
        if (n2 instanceof ChooseInstruction) {
            ChooseInstruction.Case[] cc = ((ChooseInstruction)n2).m_cases;
            for (int i = 0; i < cc.length; ++i) {
                IAnnotation a4 = this.analyzeCode(cc[i].getHandler(), env, null, functionStack, pendingStacks);
                valueAnnotations.add(a4);
            }
            Instruction h = ((ChooseInstruction)n2).getDefaultHandler();
            if (h != null) {
                valueAnnotations.add(this.analyzeCode(h, env, null, functionStack, pendingStacks));
            }
            return this.unionValues(env, valueAnnotations);
        }
        if (n2 instanceof LambdaInstruction) {
            li = (LambdaInstruction)n2;
            return LambdaMetaAnnotation.newA((LambdaInstruction)li, this, env);
        }
        if (n2 instanceof StreamInstruction) {
            return StreamMetaAnnotation.newStream((StreamInstruction)n2, env, this);
        }
        if (n2 instanceof ApplyInstruction) {
            return this.analyzeLambdaApplication((ApplyInstruction)n2, env, functionStack, pendingStacks);
        }
        if (n2 == null) {
            throw new RuntimeException();
        }
        a = this.getAnnotator().analyzeExpression(env, n2, var);
        if (a == null) {
            for (int i = 0; i < n2.getChildInstructionCount(); ++i) {
                IAnnotation aa;
                Instruction n23 = n2.getChildInstruction(i);
                if (n23 instanceof IdentifierInstruction || n23 instanceof LiteralInstruction || (aa = this.analyzeCode(n23, env, null, functionStack, pendingStacks)) == null) continue;
                s_logger.logp(Level.WARNING, s_className, "analyzeCode", "non-null annotation for unsupported special form child in " + n2);
            }
        }
        return a;
    }

    private IAnnotation analyzeFunctionCall(Instruction n2, AnnotationEnvironment env, ArrayList functionStack, ArrayList pendingStacks) {
        FunctionCallInstruction fci = (FunctionCallInstruction)n2;
        Function f2 = env.getTypeEnvironment().getModule().getFunction(fci.getFunction());
        int c = fci.getChildInstructionCount();
        Object o = functionStack.get(functionStack.size() - 1);
        IAnnotation a = this.analyzeFunction(new FunctionCallSpec(fci, env), env, functionStack, pendingStacks);
        if (!functionStack.get(functionStack.size() - 1).equals(o)) {
            throw new RuntimeException();
        }
        return a;
    }

    public IAnnotation analyzeSyntheticFunctionCall(Function f2, Object[] paramVars, AnnotationEnvironment env) {
        IAnnotation[] paramAnnotations = new IAnnotation[paramVars.length];
        for (int i = 0; i < paramVars.length; ++i) {
            paramAnnotations[i] = env.get(paramVars[i]);
        }
        return this.analyzeFunction(f2, paramAnnotations);
    }

    public IAnnotation analyzeSyntheticLambdaApplication(String identifier, LambdaInstruction lambda2, IAnnotation[] paramAnnotations, AnnotationEnvironment env) {
        LambdaApplySpec las = new LambdaApplySpec(identifier, lambda2, paramAnnotations, true);
        lambda2.typeCheckReduced(env.getTypeEnvironment(), env.getBindingEnvironment(), new LinkedList<Function>());
        return this.analyzeFunction(las, env, new ArrayList(), new ArrayList());
    }

    public IAnnotation analyzeLambdaApplication(ApplyInstruction ai, AnnotationEnvironment env, ArrayList functionStack, ArrayList pendingStacks) {
        Object identifier = ((IdentifierInstruction)ai.getLambda()).getVariable();
        LambdaMetaAnnotation sla = (LambdaMetaAnnotation)env.get(identifier);
        return sla.analyzeApplication(env.get(ai.getOperands()), env, functionStack, pendingStacks);
    }

    private IAnnotation analyzeFunction(ICallSpec fcs, AnnotationEnvironment env, ArrayList functionStack, ArrayList pendingFunctionStacks) {
        int nStacks = pendingFunctionStacks.size();
        int stackPosition = functionStack.size();
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "analyzeFunction", "analyzing '" + fcs + "' sp=" + stackPosition + " pending stacks=" + nStacks);
        }
        IFunctionAnnotationInfo fai = null;
        boolean started = this.m_functionInfo.containsKey(fcs);
        fai = started ? (IFunctionAnnotationInfo)this.m_functionInfo.get(fcs) : fcs.newInfo(this, env);
        FunctionCallStackItem fcsi = new FunctionCallStackItem(fcs, fai);
        functionStack.add(fcsi);
        if (!started) {
            int realStackDepth = -1;
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                try {
                    ByteArrayOutputStream iaos = new ByteArrayOutputStream();
                    PrintStream ps = new PrintStream(iaos);
                    new Error().printStackTrace(ps);
                    StreamTokenizer st = new StreamTokenizer(new StringReader(iaos.toString()));
                    while (st.nextToken() != -1) {
                    }
                    realStackDepth = st.lineno();
                    s_logger.logp(Level.FINER, s_className, "analyzeFunction", "stack-depth=" + realStackDepth);
                }
                catch (Exception e) {
                    s_logger.logp(Level.SEVERE, s_className, "analyzeFunction", "", e);
                }
            }
            if (stackPosition > this.m_currentFunctionStacklimit && fcs instanceof FunctionCallSpec && this.m_annotator.isFunctionReturnNotAnnotated((FunctionCallSpec)fcs)) {
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                    s_logger.logp(Level.FINE, s_className, "analyzeFunction", "postponing analysis of " + fai.getFunctionName() + " function stack position = " + stackPosition);
                }
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                    s_logger.logp(Level.FINER, s_className, "analyzeFunction", "postponing analysis of " + fcs + " function stack position = " + stackPosition);
                    s_logger.logp(Level.FINER, s_className, "analyzeFunction", " real stack depth = " + realStackDepth);
                }
                PostponedFunction postponed = new PostponedFunction();
                postponed.env = env;
                postponed.fcs = fcs;
                functionStack.remove(stackPosition);
                postponed.functionStack = new ArrayList(functionStack);
                this.m_postponedFunctions.add(postponed);
                return null;
            }
            if ((double)stackPosition > 1.15 * (double)this.m_currentFunctionStacklimit) {
                s_logger.logp(Level.WARNING, s_className, "analyzeFunction", "Function stack limit exceeded by 15% " + stackPosition + " / " + this.m_currentFunctionStacklimit);
            }
            this.m_functionInfo.put(fcs, fai);
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "analyzeFunction", "analysing " + fcsi);
            }
            IAnnotation ia = this.analyzeCode(fai.getBody(), fai.getEnvironment(), null, functionStack, pendingFunctionStacks);
            functionStack.remove(functionStack.size() - 1);
            fai.setResultAnnotation(ia);
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "analyzeFunction", "analysis complete for " + fcsi);
                s_logger.logp(Level.FINER, s_className, "analyzeFunction", " result: " + ia);
            }
        } else if (fai.isComplete()) {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "analyzeFunction", "analysis already complete for " + fcsi);
            }
            functionStack.remove(functionStack.size() - 1);
        } else {
            IAnnotation ia;
            pendingFunctionStacks.add(new ArrayList(functionStack));
            functionStack.remove(functionStack.size() - 1);
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "analyzeFunction", "analysis already pending for " + fcsi);
            }
            if ((ia = fai.getResultAnnotation()) == null) {
                return null;
            }
            throw new XylemError("ERR_SYSTEM", "recursive function returns cursor !" + fai);
        }
        IAnnotation result2 = fai.getResultAnnotation();
        if (result2 != null) {
            result2 = result2.cloneAsFunctionReturn(new ArrayList(functionStack.subList(functionStack.size() - 1, functionStack.size())));
        }
        result2 = this.backpatchPendingFunctions(fcsi, result2, functionStack, pendingFunctionStacks);
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "analyzeFunction", "result for '" + fcsi + ":");
            s_logger.logp(Level.FINER, s_className, "analyzeFunction", " " + result2);
        }
        return result2;
    }

    private IAnnotation backpatchPendingFunctions(FunctionCallStackItem fcsi, IAnnotation result2, ArrayList functionStack, ArrayList pendingFunctionStacks) {
        int stackPosition = functionStack.size();
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "backpatchPendingFunctions", "backpatching " + fcsi + " ... ");
        }
        FunctionCallStackItem.backpatchFunctionCalls(Collections.singletonList(fcsi));
        Iterator stacksIterator = pendingFunctionStacks.iterator();
        while (stacksIterator.hasNext()) {
            functionStack = (ArrayList)stacksIterator.next();
            if (functionStack.size() <= stackPosition || functionStack.get(stackPosition) != fcsi) continue;
            FunctionCallStackItem topFCSI = (FunctionCallStackItem)functionStack.get(functionStack.size() - 1);
            List pending = functionStack.subList(stackPosition, functionStack.size());
            if (((Object)fcsi.getCallSpec()).equals(topFCSI.getCallSpec())) {
                if (result2 != null) {
                    result2 = result2.cloneAsFunctionReturn(new ArrayList(pending.subList(0, 1)));
                }
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                    s_logger.logp(Level.FINER, s_className, "backpatchPendingFunctions", "call stack is complete, backpatching " + fcsi.getFunctionInfo() + " depth = " + pending);
                }
                FunctionCallStackItem.backpatchFunctionCalls(pending);
                stacksIterator.remove();
                fcsi.getFunctionInfo().setComplete();
                continue;
            }
            if (!LoggerUtil.isAnyTracingEnabled() || !s_logger.isLoggable(Level.FINER)) continue;
            s_logger.logp(Level.FINER, s_className, "backpatchPendingFunctions", "call stack is incomplete, not backpatching yet");
        }
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "backpatchPendingFunctions", "... finished backpatching " + fcsi);
        }
        return result2;
    }

    public void analyzePostponedFunctions() {
        while (!this.m_postponedFunctions.isEmpty()) {
            PostponedFunction pf = (PostponedFunction)this.m_postponedFunctions.remove(0);
            this.m_currentFunctionStacklimit = pf.functionStack.size() + 100;
            ArrayList pendingFunctionStacks = new ArrayList();
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "analyzePostponedFunctions", "resuming analysis of " + pf.fcs);
            }
            IAnnotation a = this.analyzeFunction(pf.fcs, pf.env, pf.functionStack, pendingFunctionStacks);
            while (!pf.functionStack.isEmpty()) {
                FunctionCallStackItem fcsi = (FunctionCallStackItem)pf.functionStack.remove(pf.functionStack.size() - 1);
                a = this.backpatchPendingFunctions(fcsi, a, pf.functionStack, pendingFunctionStacks);
            }
            if (a != null) {
                throw new XylemError("ERR_SYSTEM", "Annotator lied, postponed function " + pf.fcs + " returns annotation '" + a + " (annotator said it wouldn't)");
            }
            if (!LoggerUtil.isAnyTracingEnabled() || !s_logger.isLoggable(Level.FINER)) continue;
            s_logger.logp(Level.FINER, s_className, "analyzePostponedFunctions", "finished resumed analysis of " + pf.fcs);
        }
    }

    public IAnnotation unionValues(AnnotationEnvironment env, List valueAnnotations) {
        if (valueAnnotations.size() == 1) {
            return (IAnnotation)valueAnnotations.iterator().next();
        }
        HashSet set2 = new HashSet(valueAnnotations);
        set2.remove(null);
        if (set2.size() == 0) {
            return null;
        }
        Object first = set2.iterator().next();
        if (first instanceof MetaAnnotation) {
            return ((MetaAnnotation)first).unionValues(env, valueAnnotations);
        }
        return this.m_annotator.unionValues(env, valueAnnotations);
    }

    public FunctionAnnotationInfo[] getEntryPoints() {
        ArrayList<IFunctionAnnotationInfo> epList = new ArrayList<IFunctionAnnotationInfo>();
        for (IFunctionAnnotationInfo fai : this.m_functionInfo.values()) {
            if (!(fai instanceof FunctionAnnotationInfo) || !fai.getEnvironment().hasAnnotations() || fai.isCallAnnotated()) continue;
            epList.add(fai);
        }
        return epList.toArray(new FunctionAnnotationInfo[0]);
    }

    private static class PostponedFunction {
        private ICallSpec fcs;
        private AnnotationEnvironment env;
        private ArrayList functionStack;

        private PostponedFunction() {
        }
    }
}

