/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.annot;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleLinker;
import com.ibm.xltxe.rnm1.xylem.NavigationUtilities;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.PolymorphicADTDesugarer;
import com.ibm.xltxe.rnm1.xylem.Program;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.annot.AnnotationEnvironment;
import com.ibm.xltxe.rnm1.xylem.annot.AnnotationTable;
import com.ibm.xltxe.rnm1.xylem.annot.FunctionAnnotationInfo;
import com.ibm.xltxe.rnm1.xylem.annot.FunctionCallSpec;
import com.ibm.xltxe.rnm1.xylem.annot.IAnnotation;
import com.ibm.xltxe.rnm1.xylem.annot.IAnnotator;
import com.ibm.xltxe.rnm1.xylem.annot.ICallSpec;
import com.ibm.xltxe.rnm1.xylem.annot.IConverter;
import com.ibm.xltxe.rnm1.xylem.annot.IFunctionAnnotationInfo;
import com.ibm.xltxe.rnm1.xylem.annot.LambdaAnnotationInfo;
import com.ibm.xltxe.rnm1.xylem.annot.LambdaApplySpec;
import com.ibm.xltxe.rnm1.xylem.annot.NullAnnotation;
import com.ibm.xltxe.rnm1.xylem.annot.PedanticAnormalForm;
import com.ibm.xltxe.rnm1.xylem.annot.RecursiveADTStreamAppendInstruction;
import com.ibm.xltxe.rnm1.xylem.annot.meta.EmptyStreamMetaAnnotation;
import com.ibm.xltxe.rnm1.xylem.annot.meta.LambdaMetaAnnotation;
import com.ibm.xltxe.rnm1.xylem.annot.meta.MetaAnnotation;
import com.ibm.xltxe.rnm1.xylem.annot.meta.TupleMetaAnnotation;
import com.ibm.xltxe.rnm1.xylem.builders.LetChainBuilder;
import com.ibm.xltxe.rnm1.xylem.instructions.ApplyInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.AssertTypeInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.AutomatonInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ChooseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ConstructorInstantiationInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ForEachInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LambdaInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.MatchInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ParallelForEachInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.PrimitiveArithmeticInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ProcessStreamInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamElementInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.TestStreamInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.TupleInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.TupleMatchInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.DeadLetEliminatorOptimizer;
import com.ibm.xltxe.rnm1.xylem.optimizers.FindFreeVariables;
import com.ibm.xltxe.rnm1.xylem.optimizers.ReducedForm;
import com.ibm.xltxe.rnm1.xylem.types.AbstractDataType;
import com.ibm.xltxe.rnm1.xylem.types.BooleanType;
import com.ibm.xltxe.rnm1.xylem.types.ICollectionType;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xltxe.rnm1.xylem.types.LambdaType;
import com.ibm.xltxe.rnm1.xylem.types.StreamType;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xml.ras.LoggerUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConversionEngine {
    private static final boolean DENNIS_PARALLEL = false;
    private static final Logger s_logger = LoggerUtil.getLogger(ConversionEngine.class);
    private static final String s_className = ConversionEngine.class.getName();
    public static final boolean DEBUG_TYPE_CHECK = false;
    public static final String ITEM_SUFFIX = "$item";
    public static final String ITEM_INDEX_SUFFIX = "$index";
    private LetChainBuilder m_lcb = new LetChainBuilder();
    private Map m_convertedLambdas;
    private AnnotationEnvironment m_environment;
    private IConverter m_converter;
    private Module m_module;
    private ArrayList m_functionsToTypeCheck = new ArrayList();
    private ArrayList m_functionsToConvert = new ArrayList();

    public static Function analyzeAndConvert(String name2, Program prog, Function entryPoint, IAnnotator annotator, boolean dumpIntermediate) {
        try {
            try {
                if (dumpIntermediate) {
                    Program.dumpXylemFile(prog, null, name2 + ".original");
                }
            }
            catch (Exception e) {
                s_logger.logp(Level.SEVERE, s_className, "analyzeAndConvert", "could not dump program", e);
            }
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "analyzeAndConvert", "converting to pedantic anormal");
            }
            prog.optimize(new PedanticAnormalForm());
            prog.typeCheckReduced();
            try {
                if (dumpIntermediate) {
                    Program.dumpXylemFile(prog, null, name2 + ".pedantic");
                }
            }
            catch (Exception e) {
                s_logger.logp(Level.SEVERE, s_className, "analyzeAndConvert", "could not dump program", e);
            }
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "analyzeAndConvert", "applying pre-analysis methods");
            }
            annotator.preAnalysis(prog);
            try {
                if (dumpIntermediate) {
                    Program.dumpXylemFile(prog, null, name2 + ".pre_analysis");
                }
            }
            catch (Exception e) {
                s_logger.logp(Level.SEVERE, s_className, "analyzeAndConvert", "could not dump program", e);
                throw new RuntimeException(e);
            }
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "analyzeAndConvert", "clearing type info");
            }
            prog.clearTypeInformation(true);
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "analyzeAndConvert", "type checking");
            }
            prog.typeCheckReduced();
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "analyzeAndConvert", "instantiating reduced");
            }
            prog.instantiateReducedPolymorphicFunctions();
        }
        catch (TypeCheckException tce) {
            s_logger.logp(Level.SEVERE, s_className, "analyzeAndConvert", "error type-checking pre-conversion form", tce);
            throw new RuntimeException();
        }
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "analyzeAndConvert", "analyzing code with " + annotator);
        }
        AnnotationTable at = AnnotationTable.analyzeProgram(prog, entryPoint, annotator);
        IConverter converter = annotator.getConverter();
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "analyzeAndConvert", "converting code with " + converter);
        }
        converter.preConversion(prog);
        ConversionEngine.convertEntryPoints(prog, at, converter);
        try {
            if (dumpIntermediate) {
                Program.dumpXylemFile(prog, null, name2 + ".converted");
            }
        }
        catch (Exception e) {
            s_logger.logp(Level.SEVERE, s_className, "analyzeAndConvert", "could not dump program", e);
        }
        try {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "analyzeAndConvert", "type checking converted code");
            }
            entryPoint.typeCheckReduced(prog, new LinkedList());
            ModuleLinker.reflattenModules(prog);
            prog.typeCheckReduced();
            prog.instantiateReducedPolymorphicFunctions();
            prog.typeCheckReduced();
            entryPoint.typeCheckReduced(prog, new LinkedList());
            int i = 0;
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "analyzeAndConvert", "optimizing converted code:" + i);
            }
            if (dumpIntermediate) {
                Program.dumpXylemFile(prog, null, name2 + ".optimized." + i++);
            }
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "analyzeAndConvert", "optimizing converted code:" + i);
            }
            if (dumpIntermediate) {
                Program.dumpXylemFile(prog, null, name2 + ".optimized." + i++);
            }
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "analyzeAndConvert", "optimizing converted code:" + i);
            }
            DeadLetEliminatorOptimizer.eliminateDeadLets(prog);
            if (dumpIntermediate) {
                Program.dumpXylemFile(prog, null, name2 + ".optimized." + i++);
            }
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "analyzeAndConvert", "optimizing converted code:" + i);
            }
            prog.removeDeadFunctions();
            prog.typeCheckReduced();
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "analyzeAndConvert", "optimizing converted code:" + i);
            }
            if (dumpIntermediate) {
                Program.dumpXylemFile(prog, null, name2 + ".optimized." + i++);
            }
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "analyzeAndConvert", "optimizing converted code:" + i);
            }
            prog.removeDeadFunctions();
            if (dumpIntermediate) {
                Program.dumpXylemFile(prog, null, name2 + ".optimized." + i++);
            }
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "analyzeAndConvert", "optimizing converted code:" + i);
            }
            new PolymorphicADTDesugarer(prog).desugar();
            if (dumpIntermediate) {
                Program.dumpXylemFile(prog, null, name2 + ".optimized." + i++);
            }
        }
        catch (Throwable e) {
            s_logger.logp(Level.SEVERE, s_className, "analyzeAndConvert", "error optimizing converted code (dumping program to " + name2 + ".exception.xylem)", e);
            Program.dumpXylemFile(prog, null, name2 + ".exception");
            throw new XylemError("ERR_SYSTEM", "error optimizing converted code");
        }
        return null;
    }

    private static void convertEntryPoints(Module module, AnnotationTable table2, IConverter converter) {
        ConversionEngine ce = new ConversionEngine(converter, module);
        FunctionAnnotationInfo[] fais = table2.getEntryPoints();
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "convertEntryPoints", "converting " + fais.length + " entry points");
        }
        ce.m_functionsToConvert.addAll(Arrays.asList(fais));
        while (!ce.m_functionsToConvert.isEmpty()) {
            FunctionAnnotationInfo fai = (FunctionAnnotationInfo)ce.m_functionsToConvert.remove(ce.m_functionsToConvert.size() - 1);
            ce.convertFunctionBody(fai);
        }
    }

    private void reduceFunction(Function f2) {
        Instruction body;
        Instruction bodyOriginal = body = f2.getBody();
        f2.setBody(body);
        try {
            ReducedForm.reduceFunction(f2);
        }
        catch (Exception e) {
            f2.setComment(f2.getComment() + "\n" + e);
            s_logger.logp(Level.SEVERE, s_className, "reduceFunction", "converted code did not reduce. See output in function.xylem", e);
            f2.setBody(bodyOriginal);
            Program.dumpXylemFunctions(new Function[]{f2}, new File("."), "function");
            Program.dumpXylemFile(this.m_module, new File("."), "program");
            throw new Error("died");
        }
    }

    private void convertEntryPoint(FunctionAnnotationInfo fai) {
        Function f2 = fai.getFunction();
        Map bindings = this.m_convertedLambdas;
        this.m_environment = fai.getEnvironment();
        this.m_convertedLambdas = new HashMap();
        f2.setBody(this.convertInstruction(f2.getBody()));
        this.reduceFunction(f2);
        try {
            f2.clearTypeInformation(true);
            f2.typeCheckReduced(this.m_module, new LinkedList());
        }
        catch (Exception e) {
            s_logger.logp(Level.SEVERE, s_className, "convertEntryPoint", "function " + f2.getName() + " did not typeCheck", e);
            throw new RuntimeException();
        }
        this.m_convertedLambdas = bindings;
        this.m_environment = null;
    }

    private ConversionEngine(IConverter converter, Module module) {
        this.m_converter = converter;
        this.m_module = module;
    }

    public static Object generateIdentifier(Object baseIdent, Object qualifier) {
        return baseIdent.toString() + "_" + qualifier.toString();
    }

    public void insertBinding(Object var, Instruction value2) {
        while (value2 instanceof LetInstruction) {
            LetInstruction li = (LetInstruction)value2;
            this.m_lcb.bind(li.getVariable(), li.getValue(), true);
            value2 = li.getBody();
        }
        this.m_lcb.bind(var, value2, true);
    }

    public LetChainBuilder getLetChainBuilder() {
        return this.m_lcb;
    }

    private Function convert(FunctionAnnotationInfo fai) {
        Function f2 = fai.getFunction();
        if (!fai.isCallAnnotated()) {
            return f2;
        }
        Function converted = f2.lookupDerivative(fai.getSpec());
        if (converted != null) {
            return converted;
        }
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "convert", "converting " + fai);
            try {
                ByteArrayOutputStream iaos = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream(iaos);
                new Error().printStackTrace(ps);
                StreamTokenizer st = new StreamTokenizer(new StringReader(iaos.toString()));
                while (st.nextToken() != -1) {
                }
                s_logger.logp(Level.FINER, s_className, "convert", "stack-depth=" + st.lineno());
            }
            catch (Exception e) {
                s_logger.logp(Level.SEVERE, s_className, "convert", "", e);
            }
        }
        Function f22 = f2.cloneFunctionForFixup(fai.getSpec(), false, false, true);
        f22.setReturnType(this.convertReturnType(fai));
        int c = f2.m_parameters.length;
        f22.m_parameters = this.convertParamBindings(fai);
        this.m_module.addFunction(f22);
        this.m_functionsToConvert.add(fai);
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "convert", "created fixup '" + f22.getName() + "' for " + fai);
        }
        return f22;
    }

    private void convertFunctionBody(FunctionAnnotationInfo fai) {
        Function f2 = fai.getFunction();
        final Function f22 = fai.isCallAnnotated() ? f2.lookupDerivative(fai.getSpec()) : f2;
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "convertFunctionBody", "converting body of '" + f22.getName() + "' for " + fai);
        }
        this.m_environment = fai.getEnvironment();
        this.m_environment.debug();
        this.m_convertedLambdas = new HashMap();
        Instruction body = this.convertInstruction(f2.getBody());
        if (f2.getMemoizeResult()) {
            body = new Optimizer(){

                @Override
                protected Instruction optimizeStep(Instruction n2) {
                    if (n2 instanceof MatchInstruction || n2 instanceof ForEachInstruction || n2 instanceof ParallelForEachInstruction) {
                        f22.setMemoizeResult(true);
                    }
                    return n2;
                }
            }.optimize(body);
        }
        f22.setBody(body);
        this.reduceFunction(f22);
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "convertFunctionBody", "finished converting body of '" + f22.getName() + "' for " + fai);
        }
    }

    public Instruction convertInstruction(Instruction n2) {
        LetChainBuilder lcb = this.m_lcb;
        this.m_lcb = new LetChainBuilder();
        n2 = (n2 = this.convertNonLet(this.convertLets(n2), this.m_converter)) != null ? this.m_lcb.packageUp(n2) : this.m_lcb.packageUp(StreamInstruction.charStreamLiteral("dead-code"));
        this.m_lcb = lcb;
        return n2;
    }

    private Instruction convertNonLet(Instruction n2, IConverter converter) {
        IAnnotation a;
        if (n2 instanceof FunctionCallInstruction) {
            FunctionCallInstruction fci = (FunctionCallInstruction)n2;
            FunctionCallSpec fcs = new FunctionCallSpec(fci, this.m_environment);
            Object[] paramVars = new Object[fci.m_parameters.length];
            for (int i = 0; i < paramVars.length; ++i) {
                Instruction x = fci.m_parameters[i];
                if (!(x instanceof IdentifierInstruction)) continue;
                paramVars[i] = ((IdentifierInstruction)x).getVariable();
            }
            return this.convertFunctionCall(fcs, paramVars, fci.m_parameters);
        }
        if (n2 instanceof AutomatonInstruction) {
            return this.convertAutomaton((AutomatonInstruction)n2);
        }
        if (n2 instanceof ForEachInstruction) {
            return this.convertForEach((ForEachInstruction)n2);
        }
        if (n2 instanceof TestStreamInstruction) {
            return this.convertTestStream((TestStreamInstruction)n2);
        }
        if (n2 instanceof MatchInstruction) {
            return this.convertMatch((MatchInstruction)n2);
        }
        n2 = n2 instanceof ApplyInstruction ? this.convertLambdaApplication((ApplyInstruction)n2) : (n2 instanceof IdentifierInstruction ? ((a = this.m_environment.get(n2)) instanceof MetaAnnotation ? ((MetaAnnotation)a).convert(n2, this.m_environment, this) : converter.convert(n2, this.m_environment, this)) : converter.convert(n2, this.m_environment, this));
        return n2;
    }

    public Instruction convertInstructionAsCopy(Instruction n2) {
        Instruction x = n2.cloneShallow();
        int c = n2.getChildInstructionCount();
        for (int i = 0; i < c; ++i) {
            Instruction n22 = n2.getChildInstruction(i);
            n22 = n22 instanceof LetInstruction ? this.convertInstruction(n22) : this.convertNonLet(n22, this.m_converter);
            x.setChildInstruction(i, n22);
        }
        return x;
    }

    private Instruction convertMatch(MatchInstruction mi) {
        Instruction toMatch = mi.getToMatch();
        IAnnotation a = this.m_environment.get(toMatch);
        if (a instanceof TupleMetaAnnotation) {
            MatchInstruction.DeconstructionMatch dm = (MatchInstruction.DeconstructionMatch)mi.getMatches()[0];
            for (int i = 0; i < dm.getBindings().length; ++i) {
                ((TupleMetaAnnotation)a).insertMatchOperation(i, dm.getBindings()[i], this.m_environment, this);
            }
            return this.convertLets(dm.getHandler());
        }
        if (mi.getMatches()[0] instanceof MatchInstruction.LiteralMatch && a == null) {
            Set s = this.m_environment.getComputedLiteral(toMatch);
            ArrayList<MatchInstruction.LiteralMatch> matchList = new ArrayList<MatchInstruction.LiteralMatch>();
            if (s != null) {
                Iterator i = s.iterator();
                Instruction def = null;
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                    s_logger.logp(Level.FINER, s_className, "convertMatch", "proactively optimizing match on " + toMatch);
                }
                while (i.hasNext()) {
                    Object toMatchLiteral = i.next();
                    MatchInstruction.Match[] matches2 = mi.getMatches();
                    int j = 0;
                    for (j = 0; j < matches2.length; ++j) {
                        LiteralInstruction lit = ((MatchInstruction.LiteralMatch)matches2[j]).getLiteral();
                        if (!lit.getValue().equals(toMatchLiteral)) continue;
                        Instruction handler = matches2[j].getHandler();
                        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                            s_logger.logp(Level.FINER, s_className, "convertMatch", "proactively optimizing match on " + toMatch + " for literal " + toMatchLiteral);
                        }
                        handler = this.convertInstruction(handler);
                        matchList.add(new MatchInstruction.LiteralMatch(lit, handler));
                        break;
                    }
                    if (j != matches2.length || def != null) continue;
                    if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                        s_logger.logp(Level.FINER, s_className, "convertMatch", "proactively optimizing match on " + toMatch + " for default");
                    }
                    def = this.convertInstruction(mi.getDefault());
                }
                int branches = matchList.size();
                if (def != null) {
                    ++branches;
                }
                if (branches == 0) {
                    if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                        s_logger.logp(Level.FINER, s_className, "convertMatch", "proactively optimizing match on " + toMatch + " : no case matches replacing with HCFI.");
                    }
                    return Instruction.shouldNeverReach(mi.getType(this.m_environment.getTypeEnvironment(), this.m_environment.getBindingEnvironment()));
                }
                if (branches == 1 && def == null) {
                    if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                        s_logger.logp(Level.FINER, s_className, "convertMatch", "proactively optimizing match on " + toMatch + " : one case matches.");
                    }
                    return ((MatchInstruction.Match)matchList.get(0)).getHandler();
                }
                if (branches == 1 && def != null) {
                    if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                        s_logger.logp(Level.FINER, s_className, "convertMatch", "proactively optimizing match on " + toMatch + " : default case matches.");
                    }
                    return def;
                }
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                    s_logger.logp(Level.FINER, s_className, "convertMatch", "proactively optimizing match on " + toMatch + " : " + branches + " cases match.");
                }
                Instruction mm = this.convertNonLet(toMatch, this.m_converter);
                mm = new MatchInstruction(toMatch, matchList.toArray(new MatchInstruction.Match[0]), def);
                return mm;
            }
        }
        return this.convertInstructionAsCopy(mi);
    }

    private Instruction convertForEach(ForEachInstruction fei) {
        Type sourceType;
        IAnnotation ia_src = this.m_environment.get(fei.getSource());
        Object eltVar = fei.getVarName();
        IAnnotation ia_elt = this.m_environment.get(eltVar);
        if (ia_src == null || ia_elt == null) {
            return this.convertInstructionAsCopy(fei);
        }
        Instruction bodyValue = NavigationUtilities.skipLets(fei.getBody());
        IAnnotation ia_body = this.m_environment.get(bodyValue);
        Instruction body = this.convertInstruction(fei.getBody());
        body = this.insertLoopBindingAnnotationOperation(body, ia_src, ia_elt);
        List srcBindings = ia_src instanceof MetaAnnotation ? ((MetaAnnotation)ia_src).getBindingList(ia_src.getVariable(), ia_src, this) : this.m_converter.getBindingList(ia_src.getVariable(), ia_src, this);
        if (srcBindings == null) {
            throw new XylemError("ERR_SYSTEM", " illegal null bindings in " + ia_src);
        }
        List bodyBindings = null;
        if (ia_body instanceof MetaAnnotation) {
            bodyBindings = ((MetaAnnotation)ia_body).getBindingList(ia_body.getVariable(), ia_body, this);
        } else if (ia_body != null) {
            bodyBindings = this.m_converter.getBindingList(ia_body.getVariable(), ia_body, this);
        }
        if (srcBindings.size() == 0) {
            Type t;
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "convertForEach", "for-each on " + fei.getSource() + " converts to empty");
            }
            if ((t = fei.getType(this.m_environment.getTypeEnvironment(), this.m_environment.getBindingEnvironment())) == null) {
                throw new XylemError("ERR_SYSTEM", "type null for " + fei);
            }
            return new StreamInstruction(((StreamType)t).getElementType());
        }
        String indexVar = ia_src.getVariable() + ITEM_INDEX_SUFFIX;
        if (fei.getIndexVar() != null) {
            body = new LetInstruction(fei.getIndexVar(), new IdentifierInstruction(indexVar), body);
        }
        if ((sourceType = ((Binding)srcBindings.get(0)).getBindingType()) instanceof ICollectionType) {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "convertForEach", "for-each on " + fei.getSource() + " converts to streams");
            }
            body = this.convertForeachOnStreams(ia_src.getVariable(), srcBindings, body, bodyBindings);
        } else if (this.isLambdaIterator(srcBindings)) {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "convertForEach", "for-each on " + fei.getSource() + " converts to lambda-iterator");
            }
            Type t = this.convertType(ia_body, fei.getType(this.m_environment.getTypeEnvironment(), this.m_environment.getBindingEnvironment()));
            body = this.convertForeachOnLambdaIterator(t, ia_src.getVariable(), srcBindings, body, bodyBindings);
        } else {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "convertForEach", "for-each on " + fei.getSource() + " converts to atomic");
            }
            this.insertBinding(indexVar, LiteralInstruction.integerLiteral(0));
            body = this.convertLoopAtomics(srcBindings, body);
        }
        return body;
    }

    private Instruction convertLoopAtomics(List srcBindings, Instruction body) {
        for (IBinding bSrc : srcBindings) {
            body = new LetInstruction(bSrc.getName() + ITEM_SUFFIX, new IdentifierInstruction(bSrc.getName()), body);
        }
        return body;
    }

    private Instruction convertForeachOnStreams(Object srcVar, List srcBindings, Instruction body, List bodyBindings) {
        IBinding bSrc = (IBinding)srcBindings.get(0);
        IdentifierInstruction src = new IdentifierInstruction(bSrc.getName());
        String elt = bSrc.getName() + ITEM_SUFFIX;
        String indexVar = srcVar + ITEM_INDEX_SUFFIX;
        if (bodyBindings != null && bodyBindings.size() > 1) {
            body = this.convertLoopBodyOnStreams(indexVar, Collections.EMPTY_LIST, body);
            Binding[] bb = srcBindings.toArray(new Binding[0]);
            Object[] vv = new Object[bb.length];
            Instruction[] nn = new Instruction[bb.length];
            for (int i = 0; i < bb.length; ++i) {
                nn[i] = new IdentifierInstruction(bb[i].getName());
                vv[i] = bb[i].getName() + ITEM_SUFFIX;
            }
            ParallelForEachInstruction pfei = new ParallelForEachInstruction(nn, vv, body);
            pfei.setIndexVar(indexVar);
            return pfei;
        }
        body = this.convertLoopBodyOnStreams(indexVar, srcBindings.subList(1, srcBindings.size()), body);
        return new ForEachInstruction((Instruction)src, (Object)elt, indexVar, body);
    }

    private void convertAutomatonOtherwiseOnStreams(AutomatonInstruction ai2, Object srcVar, List srcBindings, Instruction body) {
        IBinding bSrc = (IBinding)srcBindings.get(0);
        IdentifierInstruction src = new IdentifierInstruction(bSrc.getName());
        String elt = bSrc.getName() + ITEM_SUFFIX;
        String indexVar = srcVar + ITEM_INDEX_SUFFIX;
        body = this.convertLoopBodyOnStreams(indexVar, srcBindings.subList(1, srcBindings.size()), body);
        ai2.setSource(src);
        ai2.setDefaultHandler(body);
        ai2.getDefaultElementBinding().setName(elt);
        if (ai2.getLoopIndexBinding() != null) {
            ai2.getLoopIndexBinding().setName(indexVar);
        } else {
            ai2.setLoopIndexVar(indexVar);
        }
    }

    private Instruction convertLoopBodyOnStreams(Object indexVar, List srcBindings, Instruction body) {
        LinkedList<IdentifierInstruction> streamSourceIdentifiers = new LinkedList<IdentifierInstruction>();
        LinkedList<String> streamElementVars = new LinkedList<String>();
        LinkedList<IBinding> atomicSourceBindings = new LinkedList<IBinding>();
        for (IBinding bSrc : srcBindings) {
            if (bSrc.getBindingType() instanceof ICollectionType) {
                streamSourceIdentifiers.add(new IdentifierInstruction(bSrc.getName()));
                streamElementVars.add(bSrc.getName() + ITEM_SUFFIX);
                continue;
            }
            atomicSourceBindings.add(bSrc);
        }
        body = this.convertLoopAtomics(atomicSourceBindings, body);
        Iterator src = streamSourceIdentifiers.iterator();
        Iterator elt = streamElementVars.iterator();
        while (src.hasNext()) {
            Object eltVar = elt.next();
            Instruction srcII = (Instruction)src.next();
            body = new LetInstruction(eltVar, new StreamElementInstruction(srcII, new IdentifierInstruction(indexVar)), body);
        }
        return body;
    }

    private boolean isLambdaIterator(List srcBindings) {
        if (srcBindings.size() < 3) {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "isLambdaIterator", "  isLambda: <3 bindings.");
            }
            return false;
        }
        Type stateType = ((IBinding)srcBindings.get(2)).getBindingType();
        IBinding isEmpty_B = (IBinding)srcBindings.get(0);
        if (!(isEmpty_B.getBindingType() instanceof LambdaType)) {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "isLambdaIterator", "  isLambda: " + isEmpty_B + " != lambda.");
            }
            return false;
        }
        LambdaType isEmpty_LT = (LambdaType)isEmpty_B.getBindingType();
        if (isEmpty_LT.getElementTypes().length != 1 || !isEmpty_LT.getReturnType().equals(BooleanType.s_booleanType) || !stateType.equals(isEmpty_LT.getElementTypes()[0])) {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "isLambdaIterator", "  isLambda: " + isEmpty_LT + " != (-> (state) boolean).");
            }
            return false;
        }
        IBinding next_B = (IBinding)srcBindings.get(1);
        if (!(next_B.getBindingType() instanceof LambdaType)) {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "isLambdaIterator", "  isLambda: " + isEmpty_B + " != lambda.");
            }
            return false;
        }
        LambdaType next_LT = (LambdaType)next_B.getBindingType();
        if (next_LT.getElementTypes().length != 1 || !next_LT.getReturnType().equals(stateType) || !stateType.equals(next_LT.getElementTypes()[0])) {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "isLambdaIterator", "  isLambda: " + next_LT + " != (-> (state) state).");
            }
            return false;
        }
        return true;
    }

    private Instruction convertForeachOnLambdaIterator(Type returnType, Object srcVar, List srcBindings, Instruction body, List bodyBindings) {
        int j;
        Binding b;
        List atomicSrcBindings = srcBindings.subList(3, srcBindings.size());
        body = this.convertLoopAtomics(atomicSrcBindings, body);
        Type stateType = ((IBinding)srcBindings.get(2)).getBindingType();
        IBinding srcIsEmpty = (IBinding)srcBindings.get(0);
        IBinding srcNext = (IBinding)srcBindings.get(1);
        IBinding srcState = (IBinding)srcBindings.get(2);
        String NEXT = "$next";
        String itemStateVar = srcState.getName() + ITEM_SUFFIX;
        String itemNextStateVar = itemStateVar + NEXT;
        String indexVar = srcVar + ITEM_INDEX_SUFFIX;
        String nextIndexVar = indexVar + NEXT;
        Set<Object> freeVars = FindFreeVariables.findFreeVariables(body);
        boolean needsIndex = freeVars.remove(indexVar);
        freeVars.remove(itemStateVar);
        freeVars.remove(srcIsEmpty.getName());
        freeVars.remove(srcNext.getName());
        ArrayList<IBinding> fnBindings = new ArrayList<IBinding>(freeVars.size() + 4);
        ArrayList<IdentifierInstruction> fciParams = new ArrayList<IdentifierInstruction>(freeVars.size() + 4);
        fnBindings.add(new Binding((Object)itemStateVar, stateType));
        fciParams.add(new IdentifierInstruction(itemNextStateVar));
        fnBindings.add(srcIsEmpty);
        fciParams.add(new IdentifierInstruction(srcIsEmpty.getName()));
        fnBindings.add(srcNext);
        fciParams.add(new IdentifierInstruction(srcNext.getName()));
        String[] headVar = null;
        String[] nextHeadVar = null;
        if (bodyBindings != null && bodyBindings.size() > 1) {
            headVar = new String[bodyBindings.size()];
            nextHeadVar = new String[bodyBindings.size()];
            Iterator bbI = bodyBindings.iterator();
            int j2 = 0;
            while (bbI.hasNext()) {
                b = (Binding)bbI.next();
                headVar[j2] = "head" + j2;
                nextHeadVar[j2] = headVar[j2] + NEXT;
                Type t = b.getBindingType() instanceof StreamType ? b.getBindingType() : b.getBindingType().getStreamType();
                fnBindings.add(new Binding((Object)headVar[j2], t));
                fciParams.add(new IdentifierInstruction(nextHeadVar[j2]));
                ++j2;
            }
        }
        if (needsIndex) {
            fnBindings.add(new Binding((Object)indexVar, IntType.s_intType));
            fciParams.add(new IdentifierInstruction(nextIndexVar));
        }
        for (Object var : freeVars) {
            b = new Binding(var);
            fnBindings.add(b);
            fciParams.add(new IdentifierInstruction(var));
        }
        String fName = "foreachFunction$" + srcVar + "$" + ReductionHelper.generateIntermediateIdentifier2();
        String bodyVar = srcVar + "$body";
        String isEmptyVar = srcVar + "$isEmpty";
        Instruction tmp = new FunctionCallInstruction(fName, fciParams);
        if (bodyBindings == null || bodyBindings.size() <= 1) {
            tmp = new StreamInstruction(((ICollectionType)((Object)returnType)).getElementType(), new Instruction[]{new IdentifierInstruction(bodyVar), tmp});
        } else {
            Object[] vv = new Object[bodyBindings.size()];
            Iterator bbI = bodyBindings.iterator();
            j = 0;
            while (bbI.hasNext()) {
                Binding b2 = (Binding)bbI.next();
                vv[j] = "body" + j;
                Type t = b2.getBindingType();
                if (t instanceof StreamType) {
                    t = ((StreamType)t).getElementType();
                }
                tmp = new LetInstruction(nextHeadVar[j], new StreamInstruction(t, new Instruction[]{new IdentifierInstruction(headVar[j]), new IdentifierInstruction(vv[j])}), tmp);
                ++j;
            }
            tmp = new TupleMatchInstruction((Instruction)new IdentifierInstruction(bodyVar + "$2"), vv, tmp);
        }
        if (bodyBindings != null && bodyBindings.size() > 1) {
            tmp = new LetInstruction(bodyVar + "$2", new AssertTypeInstruction(new IdentifierInstruction(bodyVar), returnType), tmp);
        }
        tmp = new LetInstruction(bodyVar, body, tmp);
        if (needsIndex) {
            tmp = new LetInstruction(nextIndexVar, new PrimitiveArithmeticInstruction(new IdentifierInstruction(indexVar), LiteralInstruction.integerLiteral(1), 0), tmp);
        }
        ApplyInstruction next = new ApplyInstruction((Instruction)new IdentifierInstruction(srcNext.getName()), new Instruction[]{new IdentifierInstruction(itemStateVar)}, true);
        tmp = new LetInstruction(itemNextStateVar, next, tmp);
        if (bodyBindings == null || bodyBindings.size() <= 1) {
            tmp = new ChooseInstruction(new IdentifierInstruction(isEmptyVar), (Instruction)new StreamInstruction(((ICollectionType)((Object)returnType)).getElementType()), tmp);
        } else {
            Instruction[] nn = new Instruction[headVar.length];
            for (j = 0; j < headVar.length; ++j) {
                nn[j] = new IdentifierInstruction(headVar[j]);
            }
            tmp = new ChooseInstruction(new IdentifierInstruction(isEmptyVar), (Instruction)new TupleInstruction(nn), tmp);
        }
        ApplyInstruction isEmpty = new ApplyInstruction((Instruction)new IdentifierInstruction(srcIsEmpty.getName()), new Instruction[]{new IdentifierInstruction(itemStateVar)}, true);
        tmp = new LetInstruction(isEmptyVar, isEmpty, tmp);
        Function f2 = new Function(fName, fnBindings.toArray(new Binding[0]), tmp);
        this.m_module.addFunction(f2);
        f2.setReturnType(returnType);
        this.reduceFunction(f2);
        this.insertBinding(itemNextStateVar, new IdentifierInstruction(srcState.getName()));
        if (bodyBindings != null && bodyBindings.size() > 1) {
            Iterator bbI = bodyBindings.iterator();
            int j3 = 0;
            while (bbI.hasNext()) {
                Binding b3 = (Binding)bbI.next();
                Type t = b3.getBindingType();
                if (b3.getBindingType() instanceof StreamType) {
                    t = ((StreamType)t).getElementType();
                }
                this.insertBinding(nextHeadVar[j3++], new StreamInstruction(t));
            }
        }
        if (needsIndex) {
            this.insertBinding(nextIndexVar, LiteralInstruction.integerLiteral(0));
        }
        return new FunctionCallInstruction(fName, fciParams);
    }

    private Instruction convertAutomatonOnLambdaIterator(AutomatonInstruction ai2, Object srcVar, List srcBindings, Instruction body) {
        Instruction initAState = ai2.getInitialState();
        Object aStateVar = ai2.getDefaultStateBinding().getName();
        AbstractDataType.Constructor comboCTor = ai2.getStateComboConstructor(this.m_environment.getTypeEnvironment());
        List atomicSrcBindings = srcBindings.subList(3, srcBindings.size());
        body = this.convertLoopAtomics(atomicSrcBindings, body);
        Type returnElementType = ai2.getResultElementType(this.m_environment.getTypeEnvironment());
        Type stateType = ((IBinding)srcBindings.get(2)).getBindingType();
        IBinding srcIsEmpty = (IBinding)srcBindings.get(0);
        IBinding srcNext = (IBinding)srcBindings.get(1);
        IBinding srcState = (IBinding)srcBindings.get(2);
        String itemStateVar = srcState.getName() + ITEM_SUFFIX;
        String indexVar = srcVar + ITEM_INDEX_SUFFIX;
        String NEXT = "$next";
        String itemNextStateVar = itemStateVar + NEXT;
        String nextIndexVar = indexVar + NEXT;
        String nextAStateVar = aStateVar + NEXT;
        String fName = "automatonFunction" + srcVar + "$" + ReductionHelper.generateIntermediateIdentifier2();
        String bodyComboVar = srcVar + "$bodyCombo";
        String bodyValueVar = srcVar + "$bodyValue";
        String isEmptyVar = srcVar + "$isEmpty";
        Set<Object> freeVars = FindFreeVariables.findFreeVariables(body);
        boolean needsIndex = freeVars.remove(indexVar);
        freeVars.remove(itemStateVar);
        freeVars.remove(srcIsEmpty.getName());
        freeVars.remove(srcNext.getName());
        freeVars.remove(aStateVar);
        ArrayList<IBinding> fnBindings = new ArrayList<IBinding>(freeVars.size() + 4);
        ArrayList<IdentifierInstruction> fciParams = new ArrayList<IdentifierInstruction>(freeVars.size() + 4);
        fnBindings.add(new Binding((Object)itemStateVar, stateType));
        fciParams.add(new IdentifierInstruction(itemNextStateVar));
        fnBindings.add(srcIsEmpty);
        fciParams.add(new IdentifierInstruction(srcIsEmpty.getName()));
        fnBindings.add(srcNext);
        fciParams.add(new IdentifierInstruction(srcNext.getName()));
        fnBindings.add(new Binding(aStateVar, IntType.s_intType));
        fciParams.add(new IdentifierInstruction(nextAStateVar));
        if (needsIndex) {
            fnBindings.add(new Binding((Object)indexVar, IntType.s_intType));
            fciParams.add(new IdentifierInstruction(nextIndexVar));
        }
        for (Object var : freeVars) {
            Binding b = new Binding(var);
            fnBindings.add(b);
            fciParams.add(new IdentifierInstruction(var));
        }
        Instruction tmp = null;
        tmp = ai2.getWrapResult() ? new RecursiveADTStreamAppendInstruction(new FunctionCallInstruction(fName, fciParams), new IdentifierInstruction(bodyValueVar + "$2")) : new StreamInstruction(returnElementType, new Instruction[]{new IdentifierInstruction(bodyValueVar + "$2"), new FunctionCallInstruction(fName, fciParams)});
        tmp = new LetInstruction(bodyValueVar + "$2", new AssertTypeInstruction(new IdentifierInstruction(bodyValueVar), returnElementType.getStreamType()), tmp);
        ApplyInstruction next = new ApplyInstruction((Instruction)new IdentifierInstruction(srcNext.getName()), new Instruction[]{new IdentifierInstruction(itemStateVar)}, true);
        tmp = new LetInstruction(itemNextStateVar, next, tmp);
        tmp = new LetInstruction(bodyValueVar, new MatchInstruction((Instruction)new IdentifierInstruction(bodyComboVar), comboCTor, 0), tmp);
        tmp = new LetInstruction(nextAStateVar, new MatchInstruction((Instruction)new IdentifierInstruction(bodyComboVar), comboCTor, 1), tmp);
        tmp = new LetInstruction(bodyComboVar, new AssertTypeInstruction(new IdentifierInstruction(bodyComboVar + "$2"), ai2.getStateComboType()), tmp);
        tmp = new LetInstruction(bodyComboVar + "$2", body, tmp);
        if (needsIndex) {
            tmp = new LetInstruction(nextIndexVar, new PrimitiveArithmeticInstruction(new IdentifierInstruction(indexVar), LiteralInstruction.integerLiteral(1), 0), tmp);
        }
        Integer emptyStreamVar = ReductionHelper.generateIntermediateIdentifier2();
        Instruction result2 = new IdentifierInstruction(emptyStreamVar);
        if (ai2.getWrapResult()) {
            result2 = new ConstructorInstantiationInstruction(comboCTor, new Instruction[]{result2, new IdentifierInstruction(aStateVar)});
        }
        tmp = new ChooseInstruction(new IdentifierInstruction(isEmptyVar), result2, tmp);
        tmp = new LetInstruction(emptyStreamVar, new StreamInstruction(returnElementType), tmp);
        ApplyInstruction isEmpty = new ApplyInstruction((Instruction)new IdentifierInstruction(srcIsEmpty.getName()), new Instruction[]{new IdentifierInstruction(itemStateVar)}, true);
        tmp = new LetInstruction(isEmptyVar, isEmpty, tmp);
        Function f2 = new Function(fName, fnBindings.toArray(new Binding[0]), tmp);
        if (ai2.getWrapResult()) {
            f2.setReturnType(ai2.getStateComboType());
        } else {
            f2.setReturnType(returnElementType.getStreamType());
        }
        this.m_module.addFunction(f2);
        this.reduceFunction(f2);
        this.insertBinding(itemNextStateVar, new IdentifierInstruction(srcState.getName()));
        this.insertBinding(nextAStateVar, initAState);
        if (needsIndex) {
            this.insertBinding(nextIndexVar, LiteralInstruction.integerLiteral(0));
        }
        return new FunctionCallInstruction(fName, fciParams);
    }

    private Instruction convertAutomaton(AutomatonInstruction ai) {
        IAnnotation ia_src = this.m_environment.get(ai.getSource());
        if (ia_src == null || ia_src instanceof EmptyStreamMetaAnnotation && ((EmptyStreamMetaAnnotation)ia_src).getAtomicModel() == null) {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "convertAutomaton", "not converting automaton on " + ai.getSource());
            }
            return this.convertInstructionAsCopy(ai);
        }
        if (ai.getDefaultHandler() == null || ai.m_matches.length != 0) {
            throw new Error("not yet supported! " + ai);
        }
        IAnnotation ia_elt = this.m_environment.get(ai.getDefaultElementBinding().getName());
        if (ia_elt == null) {
            return this.convertInstructionAsCopy(ai);
        }
        Instruction body = this.convertInstruction(ai.getDefaultHandler());
        body = this.insertLoopBindingAnnotationOperation(body, ia_src, ia_elt);
        List srcBindings = ia_src instanceof MetaAnnotation ? ((MetaAnnotation)ia_src).getBindingList(ia_src.getVariable(), ia_src, this) : this.m_converter.getBindingList(ia_src.getVariable(), ia_src, this);
        AbstractDataType.Constructor ctor = ai.getStateComboConstructor(this.m_environment.getTypeEnvironment());
        if (srcBindings.size() == 0) {
            TypeEnvironment tenv;
            Type t;
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "convertAutomaton", "automaton on " + ai.getSource() + " converts to empty");
            }
            if ((t = ai.getResultElementType(tenv = this.m_environment.getTypeEnvironment())) == null) {
                throw new XylemError("ERR_SYSTEM", "type null for " + ai);
            }
            Integer result2 = ReductionHelper.generateIntermediateIdentifier2();
            this.insertBinding(result2, new StreamInstruction(t));
            if (ai.getWrapResult()) {
                Instruction state = ai.getInitialState().cloneShallow();
                IdentifierInstruction stream2 = new IdentifierInstruction(result2);
                result2 = ReductionHelper.generateIntermediateIdentifier2();
                this.insertBinding(result2, new ConstructorInstantiationInstruction(ctor, new Instruction[]{stream2, state}));
            }
            return new IdentifierInstruction(result2);
        }
        String indexVar = ia_src.getVariable() + ITEM_INDEX_SUFFIX;
        if (ai.getLoopIndexBinding() != null) {
            body = new LetInstruction(ai.getLoopIndexBinding().getName(), new IdentifierInstruction(indexVar), body);
        }
        AutomatonInstruction ai2 = (AutomatonInstruction)ai.cloneShallow();
        Type sourceType = ((Binding)srcBindings.get(0)).getBindingType();
        if (sourceType instanceof ICollectionType) {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "convertAutomaton", "automaton otherwise " + ai.getDefaultElementBinding().getName() + " converts to streams " + srcBindings.get(0));
            }
            this.convertAutomatonOtherwiseOnStreams(ai2, ia_src.getVariable(), srcBindings, body);
            body = ai2;
        } else if (this.isLambdaIterator(srcBindings)) {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "convertAutomaton", "automaton otherwise " + ai.getDefaultElementBinding().getName() + " converts to lambda " + srcBindings.get(0));
            }
            body = this.convertAutomatonOnLambdaIterator(ai2, ia_src.getVariable(), srcBindings, body);
        } else {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "convertAutomaton", "automaton on " + ai.getSource() + " converts to atomic " + srcBindings.get(0));
            }
            this.insertBinding(ai.getDefaultStateBinding().getName(), ai.getInitialState());
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "convertAutomaton", "automaton otherwise " + ai.getDefaultElementBinding().getName() + " converts to atomic " + srcBindings.get(0));
            }
            this.insertBinding(indexVar, LiteralInstruction.integerLiteral(0));
            body = this.convertLoopAtomics(srcBindings, body);
            if (!ai.getWrapResult()) {
                body = new MatchInstruction(body, ctor, 0);
            }
        }
        return body;
    }

    private Instruction convertTestStream(TestStreamInstruction tsi) {
        IAnnotation ia_src = this.m_environment.get(tsi.getSource());
        Object eltVar = tsi.getElementBinding().getName();
        IAnnotation ia_elt = this.m_environment.get(eltVar);
        if (ia_src == null || ia_elt == null) {
            tsi = (TestStreamInstruction)tsi.cloneShallow();
            Integer src2 = ReductionHelper.generateIntermediateIdentifier2();
            this.insertBinding(src2, new AssertTypeInstruction(tsi.getSource(), tsi.getSource().getType(this.m_environment.getTypeEnvironment(), this.m_environment.getBindingEnvironment())));
            tsi.setSource(new IdentifierInstruction(src2));
            tsi.setHint(this.convertInstruction(tsi.getHint()));
            tsi.setBody(this.convertInstruction(tsi.getBody()));
            return tsi;
        }
        if (tsi instanceof ProcessStreamInstruction) {
            throw new XylemError("ERR_SYSTEM", "not yet supported");
        }
        Instruction body = this.convertInstruction(tsi.getBody());
        body = this.insertLoopBindingAnnotationOperation(body, ia_src, ia_elt);
        List srcBindings = ia_src instanceof MetaAnnotation ? ((MetaAnnotation)ia_src).getBindingList(ia_src.getVariable(), ia_src, this) : this.m_converter.getBindingList(ia_src.getVariable(), ia_src, this);
        if (srcBindings.size() == 0) {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "convertTestStream", "test-stream on " + tsi.getSource() + " converts to empty");
            }
            if (tsi instanceof ProcessStreamInstruction) {
                ProcessStreamInstruction psi = (ProcessStreamInstruction)tsi;
                Integer result2 = ReductionHelper.generateIntermediateIdentifier2();
                Type t = tsi.getType(this.m_environment.getTypeEnvironment(), this.m_environment.getBindingEnvironment());
                if (!(t instanceof ICollectionType)) {
                    throw new XylemError("ERR_SYSTEM", "not yet supported: conversion of empty psi with wrapResult");
                }
                this.insertBinding(result2, new StreamInstruction(((ICollectionType)((Object)t)).getElementType()));
                return new IdentifierInstruction(result2);
            }
            return tsi.getHint().cloneShallow();
        }
        Type sourceType = ((Binding)srcBindings.get(0)).getBindingType();
        if (sourceType instanceof ICollectionType) {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "convertTestStream", "test-stream on " + tsi.getSource() + " converts to streams");
            }
            IBinding bSrc = (IBinding)srcBindings.get(0);
            IdentifierInstruction src = new IdentifierInstruction(bSrc.getName());
            String elt = bSrc.getName() + ITEM_SUFFIX;
            body = this.convertLoopAtomics(srcBindings.subList(1, srcBindings.size()), body);
            body = new TestStreamInstruction(src, this.convertInstruction(tsi.getHint()), elt, tsi.getHintBinding().getName(), tsi.getIndexVar(), body, (ICollectionType)((Object)sourceType));
        } else if (this.isLambdaIterator(srcBindings)) {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "convertTestStream", "test-stream on " + tsi.getSource() + " converts to lambda-iterator");
            }
            body = this.convertTestStreamOnLambdaIterator(tsi, ia_src.getVariable(), srcBindings, body);
        } else {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "convertTestStream", "test-stream on " + tsi.getSource() + " converts to atomic");
            }
            body = this.convertLoopAtomics(srcBindings, body);
            body = new LetInstruction(tsi.getHintBinding().getName(), tsi.getHint(), body);
        }
        return body;
    }

    private Instruction convertTestStreamOnLambdaIterator(TestStreamInstruction tsi, Object srcVar, List srcBindings, Instruction body) {
        Instruction initHint = tsi.getHint();
        List atomicSrcBindings = srcBindings.subList(3, srcBindings.size());
        body = this.convertLoopAtomics(atomicSrcBindings, body);
        IBinding srcIsEmpty = (IBinding)srcBindings.get(0);
        IBinding srcNext = (IBinding)srcBindings.get(1);
        IBinding srcState = (IBinding)srcBindings.get(2);
        Type stateType = ((IBinding)srcBindings.get(2)).getBindingType();
        String itemStateVar = srcState.getName() + ITEM_SUFFIX;
        Object hintVar = tsi.getHintBinding().getName();
        String isEmptyVar = srcState.getName() + "$isEmpty";
        String NEXT = "$next";
        String itemNextStateVar = itemStateVar + NEXT;
        String nextHintVar = hintVar + NEXT;
        String fName = "testStreamFunction" + srcVar + "$" + ReductionHelper.generateIntermediateIdentifier2();
        Set<Object> freeVars = FindFreeVariables.findFreeVariables(body);
        freeVars.remove(itemStateVar);
        freeVars.remove(srcIsEmpty.getName());
        freeVars.remove(srcNext.getName());
        freeVars.remove(hintVar);
        ArrayList<IBinding> fnBindings = new ArrayList<IBinding>(freeVars.size() + 4);
        ArrayList<IdentifierInstruction> fciParams = new ArrayList<IdentifierInstruction>(freeVars.size() + 4);
        fnBindings.add(new Binding((Object)itemStateVar, stateType));
        fciParams.add(new IdentifierInstruction(itemNextStateVar));
        fnBindings.add(srcIsEmpty);
        fciParams.add(new IdentifierInstruction(srcIsEmpty.getName()));
        fnBindings.add(srcNext);
        fciParams.add(new IdentifierInstruction(srcNext.getName()));
        fnBindings.add(new Binding(hintVar, tsi.getHintBinding().getBindingType()));
        fciParams.add(new IdentifierInstruction(nextHintVar));
        for (Object var : freeVars) {
            Binding b = new Binding(var);
            fnBindings.add(b);
            fciParams.add(new IdentifierInstruction(var));
        }
        Instruction tmp = new FunctionCallInstruction(fName, fciParams);
        ApplyInstruction next = new ApplyInstruction((Instruction)new IdentifierInstruction(srcNext.getName()), new Instruction[]{new IdentifierInstruction(itemStateVar)}, true);
        tmp = new LetInstruction(itemNextStateVar, next, tmp);
        tmp = new LetInstruction(nextHintVar, body, tmp);
        IdentifierInstruction result2 = new IdentifierInstruction(hintVar);
        tmp = new ChooseInstruction(new IdentifierInstruction(isEmptyVar), (Instruction)result2, tmp);
        ApplyInstruction isEmpty = new ApplyInstruction((Instruction)new IdentifierInstruction(srcIsEmpty.getName()), new Instruction[]{new IdentifierInstruction(itemStateVar)}, true);
        tmp = new LetInstruction(isEmptyVar, isEmpty, tmp);
        Function f2 = new Function(fName, fnBindings.toArray(new Binding[0]), tmp);
        f2.setReturnType(tsi.getHint().getType(this.m_environment.getTypeEnvironment(), this.m_environment.getBindingEnvironment()));
        this.m_module.addFunction(f2);
        this.reduceFunction(f2);
        this.insertBinding(itemNextStateVar, new IdentifierInstruction(srcState.getName()));
        this.insertBinding(nextHintVar, initHint);
        return new FunctionCallInstruction(fName, fciParams);
    }

    private Instruction convertLets(Instruction n2) {
        while (n2 instanceof LetInstruction) {
            Instruction value2;
            LetInstruction li = (LetInstruction)n2;
            Object var = li.getVariable();
            Instruction value3 = li.getValue();
            IAnnotation ia = this.m_environment.get(var);
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "convertLets", "converting let val for " + var);
            }
            if ((value2 = ia instanceof MetaAnnotation ? this.convertNonLet(value3, (MetaAnnotation)ia) : this.convertNonLet(value3, this.m_converter)) != null) {
                this.insertBinding(var, value2);
            }
            if (value3 instanceof ISpecialForm || value3 instanceof FunctionCallInstruction) {
                this.insertValueDecomposition(var, ia);
            } else {
                this.insertAnnotationOperation(ia);
            }
            n2 = li.getBody();
        }
        return n2;
    }

    public void insertAnnotationOperation(IAnnotation ia) {
        if (ia != null && !(ia instanceof NullAnnotation)) {
            if (ia instanceof MetaAnnotation) {
                ((MetaAnnotation)ia).insertAnnotationOperation(ia, this.m_environment, this);
            } else {
                this.m_converter.insertAnnotationOperation(ia, this.m_environment, this);
            }
        }
    }

    public void insertValueDecomposition(Object valueVar, IAnnotation ia) {
        if (ia != null && !(ia instanceof NullAnnotation)) {
            if (ia instanceof MetaAnnotation) {
                ((MetaAnnotation)ia).insertValueDecomposition(valueVar, ia, this.m_environment, this);
            } else {
                this.m_converter.insertValueDecomposition(valueVar, ia, this.m_environment, this);
            }
        }
    }

    private Instruction insertLoopBindingAnnotationOperation(Instruction body, IAnnotation src, IAnnotation elt) {
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "insertLoopBindingAnnotationOperation", "inserting loop annotations for (" + elt + ")");
        }
        LetChainBuilder lcb = this.m_lcb;
        this.m_lcb = new LetChainBuilder();
        if (!(elt instanceof NullAnnotation)) {
            if (elt == null) {
                throw new XylemError("ERR_SYSTEM", "null elt for src=" + src);
            }
            if (elt instanceof MetaAnnotation) {
                ((MetaAnnotation)elt).insertLoopBinding(src, elt, this.m_environment, this);
            } else {
                this.m_converter.insertLoopBinding(src, elt, this.m_environment, this);
            }
        }
        body = this.m_lcb.packageUp(body);
        this.m_lcb = lcb;
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "insertLoopBindingAnnotationOperation", "done(" + elt + ")");
        }
        return body;
    }

    public Instruction convertSyntheticFunctionCall(Function f2, Object[] paramVars, AnnotationEnvironment env) {
        AnnotationEnvironment outerEnv = this.m_environment;
        this.m_environment = env;
        IAnnotation[] paramAnnotations = new IAnnotation[paramVars.length];
        for (int i = 0; i < paramVars.length; ++i) {
            paramAnnotations[i] = this.m_environment.get(paramVars[i]);
            if (!LoggerUtil.isAnyTracingEnabled() || !s_logger.isLoggable(Level.FINER)) continue;
            s_logger.logp(Level.FINER, s_className, "convertSyntheticFunctionCall", "paramAnnotations[" + i + "] (i.e., " + paramVars[i] + ")=" + paramAnnotations[i]);
        }
        FunctionCallSpec fcs = new FunctionCallSpec(f2, paramAnnotations);
        Instruction rtn = this.convertFunctionCall(fcs, paramVars, null);
        this.m_environment = outerEnv;
        return rtn;
    }

    private Instruction convertFunctionCall(FunctionCallSpec fcs, Object[] paramVars, Instruction[] originalParams) {
        FunctionAnnotationInfo fai = (FunctionAnnotationInfo)this.m_environment.getTable().getFunctionInfo(fcs);
        Function f2 = fcs.getFunction();
        if (fai != null) {
            f2 = this.convert(fai);
        }
        Instruction[] params = this.convertCallParams(fai, fcs, paramVars, originalParams);
        FunctionCallInstruction fci = new FunctionCallInstruction(f2.getName(), params);
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "convertFunctionCall", "converted call " + fcs);
            s_logger.logp(Level.FINER, s_className, "convertFunctionCall", "            => " + fci);
        }
        return fci;
    }

    private Instruction convertLambdaApplication(ApplyInstruction ai) {
        LambdaMetaAnnotation lma = (LambdaMetaAnnotation)this.m_environment.get(ai.getLambda());
        IAnnotation[] paramAnnotations = this.m_environment.get(ai.getOperands());
        Instruction converted = lma.getIdentifier(paramAnnotations);
        Instruction[] originalParams = ai.getOperands();
        Object[] paramVars = new Object[ai.getOperands().length];
        for (int i = 0; i < paramVars.length; ++i) {
            Instruction x = ai.getOperands()[i];
            if (!(x instanceof IdentifierInstruction)) continue;
            paramVars[i] = ((IdentifierInstruction)x).getVariable();
        }
        Instruction[] params = this.convertCallParams(paramAnnotations, paramVars, originalParams);
        ApplyInstruction ai2 = new ApplyInstruction(converted, params, ai.isPure());
        return ai2;
    }

    public ApplyInstruction convertSyntheticLambdaApplication(String identifier, Instruction lambda2, Object[] params, AnnotationEnvironment env) {
        AnnotationEnvironment outerEnv = this.m_environment;
        this.m_environment = env;
        LambdaApplySpec las = new LambdaApplySpec(identifier, lambda2, env.get(params), true);
        LambdaAnnotationInfo lai = (LambdaAnnotationInfo)this.m_environment.getTable().getFunctionInfo(las);
        if (lai == null) {
            throw new XylemError("ERR_SYSTEM", "no lai for " + las);
        }
        Object convertedIdentifier = this.convertLambda(lai);
        ApplyInstruction apply2 = new ApplyInstruction((Instruction)new IdentifierInstruction(convertedIdentifier), this.convertCallParams(lai, las, params, null), lai.isPure());
        this.m_environment = outerEnv;
        return apply2;
    }

    public Object convertSyntheticLambdaApplication(String identifier, Instruction lambda2, IAnnotation[] params, AnnotationEnvironment env) {
        AnnotationEnvironment outerEnv = this.m_environment;
        this.m_environment = env;
        LambdaApplySpec las = new LambdaApplySpec(identifier, lambda2, params, true);
        LambdaAnnotationInfo lai = (LambdaAnnotationInfo)this.m_environment.getTable().getFunctionInfo(las);
        if (lai == null) {
            throw new XylemError("ERR_SYSTEM", "no lai for " + las);
        }
        Object convertedIdentifier = this.convertLambda(lai);
        this.m_environment = outerEnv;
        return convertedIdentifier;
    }

    public Object convertLambda(LambdaAnnotationInfo lai) {
        Object convertedIdentifier = this.m_convertedLambdas.get(lai);
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "convertLambda", "converting " + lai);
            try {
                ByteArrayOutputStream iaos = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream(iaos);
                new Error().printStackTrace(ps);
                StreamTokenizer st = new StreamTokenizer(new StringReader(iaos.toString()));
                while (st.nextToken() != -1) {
                }
                s_logger.logp(Level.FINER, s_className, "convertLambda", "stack-depth=" + st.lineno());
            }
            catch (Exception e) {
                s_logger.logp(Level.SEVERE, s_className, "convertLambda", "", e);
            }
        }
        AnnotationEnvironment env = this.m_environment;
        Map bindings = this.m_convertedLambdas;
        this.m_environment = lai.getEnvironment();
        this.m_convertedLambdas = new HashMap();
        Instruction body = this.convertInstruction(lai.getBody());
        this.m_convertedLambdas = bindings;
        this.m_environment = env;
        LambdaInstruction l2 = new LambdaInstruction(body, this.convertParamBindings(lai), lai.isPure());
        convertedIdentifier = ReductionHelper.generateIntermediateIdentifier2();
        this.insertBinding(convertedIdentifier, l2);
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "convertLambda", "created new lambda '" + convertedIdentifier + "' for " + lai);
        }
        this.m_convertedLambdas.put(lai, convertedIdentifier);
        return convertedIdentifier;
    }

    public Type convertReturnType(IFunctionAnnotationInfo fai) {
        if (fai.getResultAnnotation() == null) {
            return fai.getOriginalReturnType();
        }
        if (fai.getResultAnnotation() instanceof MetaAnnotation) {
            return ((MetaAnnotation)fai.getResultAnnotation()).getValueType(fai.getResultAnnotation(), this);
        }
        return this.m_converter.getValueType(fai.getResultAnnotation(), this);
    }

    public List getBindingList(Object var, IAnnotation a) {
        if (a instanceof MetaAnnotation) {
            return ((MetaAnnotation)a).getBindingList(var, a, this);
        }
        return this.m_converter.getBindingList(var, a, this);
    }

    public Binding[] convertParamBindings(IFunctionAnnotationInfo fai) {
        int c = fai.getParamBindings().length;
        ArrayList<Object> newBindingList = new ArrayList<Object>(c);
        for (int i = 0; i < c; ++i) {
            Binding b = fai.getParamBindings()[i];
            IAnnotation a = fai.getParamAnnotations()[i];
            if (a == null) {
                newBindingList.add(b.clone());
                continue;
            }
            if (a instanceof MetaAnnotation) {
                newBindingList.addAll(((MetaAnnotation)a).getBindingList(a.getVariable(), a, this));
                continue;
            }
            newBindingList.addAll(this.m_converter.getBindingList(a.getVariable(), a, this));
        }
        return newBindingList.toArray(new Binding[0]);
    }

    public Type convertType(IAnnotation a, Type original) {
        if (a == null) {
            return original;
        }
        if (a instanceof MetaAnnotation) {
            return ((MetaAnnotation)a).getValueType(a, this);
        }
        return this.m_converter.getValueType(a, this);
    }

    public Binding[] convertParamBindings(IAnnotation[] params, IBinding[] original) {
        int c = original.length;
        ArrayList<Object> newBindingList = new ArrayList<Object>(c);
        for (int i = 0; i < c; ++i) {
            Binding b = (Binding)original[i];
            IAnnotation a = params[i];
            if (a == null) {
                newBindingList.add(b.clone());
                continue;
            }
            if (a instanceof MetaAnnotation) {
                newBindingList.addAll(((MetaAnnotation)a).getBindingList(a.getVariable(), a, this));
                continue;
            }
            newBindingList.addAll(this.m_converter.getBindingList(a.getVariable(), a, this));
        }
        return newBindingList.toArray(new Binding[0]);
    }

    private Instruction[] convertCallParams(IFunctionAnnotationInfo fai, ICallSpec fcs, Object[] paramVars, Instruction[] originalParams) {
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            int ix;
            StringBuilder sb = new StringBuilder();
            sb.append("converting call/apply " + fcs + "\n");
            sb.append("originalParams=\n");
            if (null == originalParams) {
                sb.append("null\n");
            } else {
                for (ix = 0; ix < originalParams.length; ++ix) {
                    sb.append("  " + originalParams[ix]);
                }
            }
            sb.append("\nparamVars=\n");
            for (ix = 0; ix < paramVars.length; ++ix) {
                sb.append("  " + paramVars[ix]);
            }
            sb.append("\n");
            s_logger.logp(Level.FINER, s_className, "convertCallParams", sb.toString());
        }
        IAnnotation[] paramAA = new IAnnotation[paramVars.length];
        if (fai != null) {
            paramAA = fai.getParamAnnotations();
        } else if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "convertCallParams", "no fai found for '" + fcs + "'");
        }
        return this.convertCallParams(paramAA, paramVars, originalParams);
    }

    private Instruction[] convertCallParams(IAnnotation[] paramAnnotations, Object[] paramVars, Instruction[] originalParams) {
        int c = paramVars.length;
        ArrayList<IdentifierInstruction> newParamsList = new ArrayList<IdentifierInstruction>(c);
        for (int i = 0; i < c; ++i) {
            IAnnotation a;
            Object p = paramVars[i];
            if (p != null && (a = this.m_environment.get(p)) != null && paramAnnotations[i] != null) {
                List params = this.getIdentifierList(a.getVariable(), paramAnnotations[i]);
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                    s_logger.logp(Level.FINER, s_className, "convertCallParams", "    param " + p + " => ");
                }
                Iterator j = params.iterator();
                while (j.hasNext()) {
                    if (!LoggerUtil.isAnyTracingEnabled() || !s_logger.isLoggable(Level.FINER)) continue;
                    s_logger.logp(Level.FINER, s_className, "convertCallParams", "    " + j.next());
                }
                newParamsList.addAll(params);
                continue;
            }
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "convertCallParams", "    param " + p + " unchanged.");
            }
            newParamsList.add((IdentifierInstruction)(originalParams == null ? new IdentifierInstruction(p) : originalParams[i]));
        }
        return newParamsList.toArray(new Instruction[0]);
    }

    public List getIdentifierList(Object var, IAnnotation a) {
        List bb = this.getBindingList(var, a);
        ArrayList<IdentifierInstruction> ii = new ArrayList<IdentifierInstruction>(bb.size());
        Iterator bbi = bb.iterator();
        while (bbi.hasNext()) {
            ii.add(new IdentifierInstruction(((Binding)bbi.next()).getName()));
        }
        return ii;
    }
}

