/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.annot;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.annot.AnnotationEnvironment;
import com.ibm.xltxe.rnm1.xylem.annot.AnnotationTable;
import com.ibm.xltxe.rnm1.xylem.annot.FunctionAnnotationInfo;
import com.ibm.xltxe.rnm1.xylem.annot.IAnnotation;
import com.ibm.xltxe.rnm1.xylem.annot.ICallSpec;
import com.ibm.xltxe.rnm1.xylem.annot.IFunctionAnnotationInfo;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;

public class FunctionCallSpec
implements ICallSpec {
    private IAnnotation[] m_paramAnnotations;
    private Function m_function;

    public FunctionCallSpec(FunctionCallInstruction fci, AnnotationEnvironment env) {
        this.m_function = env.getTypeEnvironment().getModule().getFunction(fci.getFunction());
        if (this.m_function == null) {
            throw new Error("not found: " + fci.getFunction());
        }
        int len = fci.getChildInstructionCount();
        this.m_paramAnnotations = new IAnnotation[len];
        for (int i = 0; i < len; ++i) {
            this.m_paramAnnotations[i] = env.get(fci.getChildInstruction(i));
        }
    }

    public FunctionCallSpec(Function f2, IAnnotation[] paramAnnotations) {
        this.m_paramAnnotations = paramAnnotations;
        this.m_function = f2;
        if (this.m_paramAnnotations.length != this.m_function.getParameters().length) {
            throw new XylemError("ERR_SYSTEM", "paramAnnotations(" + paramAnnotations.length + ") != " + "f(" + f2.getParameters().length + ") " + f2.getName());
        }
    }

    public FunctionCallSpec(Function f2) {
        this(f2, new IAnnotation[f2.m_parameters.length]);
    }

    public Function getFunction() {
        return this.m_function;
    }

    @Override
    public IAnnotation[] getParamAnnotations() {
        return this.m_paramAnnotations;
    }

    @Override
    public Binding[] getParamBindings() {
        return this.getFunction().getParameters();
    }

    @Override
    public IFunctionAnnotationInfo newInfo(AnnotationTable table2, AnnotationEnvironment env) {
        return new FunctionAnnotationInfo(this, table2);
    }

    @Override
    public boolean equals(Object arg0) {
        if (!(arg0 instanceof FunctionCallSpec)) {
            return false;
        }
        FunctionCallSpec fas = (FunctionCallSpec)arg0;
        if (this.getFunction() != fas.getFunction()) {
            return false;
        }
        if (this.getParamAnnotations().length != fas.getParamAnnotations().length) {
            return false;
        }
        for (int i = 0; i < this.getParamAnnotations().length; ++i) {
            if (!(this.getParamAnnotations()[i] == null ? fas.getParamAnnotations()[i] != null : !this.getParamAnnotations()[i].equals(fas.getParamAnnotations()[i]))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return this.getFunction().hashCode();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("FCS: " + this.m_function.getName());
        sb.append("(");
        Binding[] params = this.getFunction().m_parameters;
        IAnnotation[] paramAnnot = this.getParamAnnotations();
        for (int i = 0; i < params.length; ++i) {
            sb.append(params[i]);
            sb.append("@");
            sb.append(i < paramAnnot.length ? this.getParamAnnotations()[i] + "" : "UNDEF!");
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }
}

