/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.annot;

import com.ibm.xltxe.rnm1.xylem.annot.IAnnotation;
import com.ibm.xltxe.rnm1.xylem.annot.ICallSpec;
import com.ibm.xltxe.rnm1.xylem.annot.IFunctionAnnotationInfo;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xml.ras.LoggerUtil;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FunctionCallStackItem {
    private static final Logger s_logger = LoggerUtil.getLogger(FunctionCallStackItem.class);
    private static final String s_className = FunctionCallStackItem.class.getName();
    private ICallSpec m_fcs;
    private IFunctionAnnotationInfo m_fai;

    public FunctionCallStackItem(ICallSpec fcs, IFunctionAnnotationInfo fai) {
        this.m_fai = fai;
        this.m_fcs = fcs;
    }

    public String toString() {
        return "FCSI:" + this.m_fai;
    }

    public ICallSpec getCallSpec() {
        return this.m_fcs;
    }

    public IFunctionAnnotationInfo getFunctionInfo() {
        return this.m_fai;
    }

    public static boolean backpatchFunctionCalls(List fcsiStack) {
        FunctionCallStackItem i_fcsi;
        int i;
        boolean b = false;
        FunctionCallStackItem topFCSI = (FunctionCallStackItem)fcsiStack.get(fcsiStack.size() - 1);
        if (fcsiStack.size() == 1) {
            b |= topFCSI.backpatchFunctionCall();
            topFCSI.m_fai.setComplete();
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "backpatchFunctionCalls", "backpatched call " + topFCSI.m_fai.getFunctionName() + " (non-recursive)");
            }
            return b;
        }
        if (!topFCSI.m_fai.equals(((FunctionCallStackItem)fcsiStack.get((int)0)).m_fai)) {
            throw new XylemError("ERR_SYSTEM", "FCSI looks corrupt (or not ready), top and bottom don't match!\ntop:   " + topFCSI.m_fai + "\n" + "bottom:" + topFCSI.m_fai + "\n");
        }
        int max_tries = fcsiStack.size() * 2 + 2;
        int tries = 0;
        boolean changed = false;
        do {
            changed = false;
            if (tries++ > max_tries) {
                throw new Error("recursion won't resolve (" + topFCSI + ") limit = " + max_tries);
            }
            for (i = fcsiStack.size() - 1; i >= 0; --i) {
                i_fcsi = (FunctionCallStackItem)fcsiStack.get(i);
                if (!i_fcsi.backpatchFunctionCall()) continue;
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                    s_logger.logp(Level.FINER, s_className, "backpatchFunctionCalls", "recursive backpatch caused changes.");
                }
                changed = true;
                b = true;
            }
            if (!LoggerUtil.isAnyTracingEnabled() || !s_logger.isLoggable(Level.FINER)) continue;
            s_logger.logp(Level.FINER, s_className, "backpatchFunctionCalls", "backpatched call stack " + topFCSI.m_fai.getFunctionName() + " depth=" + fcsiStack.size() + " (trial " + tries + ")");
        } while (changed);
        for (i = fcsiStack.size() - 1; i >= 0; --i) {
            i_fcsi = (FunctionCallStackItem)fcsiStack.get(i);
            i_fcsi.m_fai.setComplete();
        }
        return b;
    }

    private boolean backpatchFunctionCall() {
        int c = this.m_fcs.getParamAnnotations().length;
        boolean b = false;
        for (int i = 0; i < c; ++i) {
            if (this.m_fai.getParamAnnotations()[i] != null) {
                IAnnotation call = this.m_fcs.getParamAnnotations()[i];
                IAnnotation param = this.m_fai.getParamAnnotations()[i];
                if (param != null) {
                    if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                        s_logger.logp(Level.FINER, s_className, "backpatchFunctionCall", " backpatching '" + call.getVariable() + "' calls '" + param.getVariable() + "' " + "in " + this.m_fai.getFunctionName() + " call=" + call + " param=" + param);
                    }
                    if (!call.propagateDependancies(param)) continue;
                    b = true;
                    if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                        s_logger.logp(Level.FINER, s_className, "backpatchFunctionCall", " there were changes");
                    }
                    if (!call.propagateDependancies(param)) continue;
                    throw new Error("non-stabilizing propagation " + param);
                }
                s_logger.logp(Level.SEVERE, s_className, "backpatchFunctionCall", " no annotations to backpatch for param " + i + "'.");
                continue;
            }
            if (!LoggerUtil.isAnyTracingEnabled() || !s_logger.isLoggable(Level.FINER)) continue;
            s_logger.logp(Level.FINER, s_className, "backpatchFunctionCall", " not backpatching '" + this.m_fcs.getParamBindings()[i].getName() + "'" + "in " + this.m_fai.getFunctionName());
        }
        return b;
    }
}

