/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.annot;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.NavigationUtilities;
import com.ibm.xltxe.rnm1.xylem.annot.AnnotationEnvironment;
import com.ibm.xltxe.rnm1.xylem.annot.AnnotationTable;
import com.ibm.xltxe.rnm1.xylem.annot.IAnnotation;
import com.ibm.xltxe.rnm1.xylem.annot.ICallSpec;
import com.ibm.xltxe.rnm1.xylem.annot.IFunctionAnnotationInfo;
import com.ibm.xltxe.rnm1.xylem.annot.LambdaAnnotationInfo;
import com.ibm.xltxe.rnm1.xylem.instructions.ApplyInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;

public class LambdaApplySpec
implements ICallSpec {
    private IAnnotation[] m_paramAnnotations;
    private Binding[] m_lambdaBindings;
    private Instruction m_lambda;
    private String m_identifier;
    private boolean m_isPure;

    public LambdaApplySpec(String identifier, Instruction lambda2, IBinding[] lambdaBindings, IAnnotation[] annots, boolean isPure) {
        this.m_paramAnnotations = annots;
        this.m_lambdaBindings = (Binding[])lambdaBindings;
        this.m_lambda = lambda2;
        this.m_identifier = identifier;
        if (identifier == null) {
            this.m_identifier = "lambda$" + System.identityHashCode(this.m_lambda);
        }
        this.m_isPure = isPure;
    }

    public LambdaApplySpec(String identifier, Instruction lambda2, IAnnotation[] annots, boolean isPure) {
        this(identifier, lambda2, ((ISpecialForm)((Object)lambda2)).getChildInstructionBindings(0), annots, isPure);
    }

    public LambdaApplySpec(ApplyInstruction ai, AnnotationEnvironment env) {
        this("lambda$" + ((IdentifierInstruction)ai.getLambda()).getVariable(), NavigationUtilities.resolveReducedIdentifier(ai.getLambda(), env.getBindingEnvironment()), env.get(ai.getOperands()), ai.isPure());
    }

    public boolean isPure() {
        return this.m_isPure;
    }

    @Override
    public IAnnotation[] getParamAnnotations() {
        return this.m_paramAnnotations;
    }

    @Override
    public Binding[] getParamBindings() {
        return this.m_lambdaBindings;
    }

    public Instruction getLambda() {
        return this.m_lambda;
    }

    public String getName() {
        return this.m_identifier;
    }

    @Override
    public IFunctionAnnotationInfo newInfo(AnnotationTable table2, AnnotationEnvironment env) {
        return new LambdaAnnotationInfo(this, env);
    }

    @Override
    public boolean equals(Object arg0) {
        if (!(arg0 instanceof LambdaApplySpec)) {
            return false;
        }
        LambdaApplySpec las = (LambdaApplySpec)arg0;
        if (this.m_lambda != las.m_lambda) {
            return false;
        }
        if (this.getParamAnnotations().length != las.getParamAnnotations().length) {
            return false;
        }
        for (int i = 0; i < this.getParamAnnotations().length; ++i) {
            if (!(this.getParamAnnotations()[i] == null ? las.getParamAnnotations()[i] != null : !this.getParamAnnotations()[i].equals(las.getParamAnnotations()[i]))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this.m_lambda);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("LAS: " + this.m_identifier);
        sb.append("(");
        IAnnotation[] paramAnnot = this.getParamAnnotations();
        for (int i = 0; i < this.getParamBindings().length; ++i) {
            sb.append(this.getParamBindings()[i].getName());
            sb.append("@");
            sb.append(i < paramAnnot.length ? this.getParamAnnotations()[i] + "" : "UNDEF!");
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }
}

