/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.annot.meta;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.annot.AnnotationEnvironment;
import com.ibm.xltxe.rnm1.xylem.annot.ConversionEngine;
import com.ibm.xltxe.rnm1.xylem.annot.IAnnotation;
import com.ibm.xltxe.rnm1.xylem.annot.meta.MetaAnnotation;
import com.ibm.xltxe.rnm1.xylem.annot.meta.ReturnValueMetaAnnotation;
import com.ibm.xltxe.rnm1.xylem.annot.meta.StreamMetaAnnotation;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.types.ICollectionType;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class EmptyStreamMetaAnnotation
extends MetaAnnotation {
    private EmptyStreamMetaAnnotation m_base;
    private Type m_originalType;
    private boolean m_isDefined;
    private StreamMetaAnnotation m_model;

    EmptyStreamMetaAnnotation(Type originalType) {
        this.m_originalType = originalType;
    }

    EmptyStreamMetaAnnotation(EmptyStreamMetaAnnotation sesa) {
        this.m_originalType = sesa.m_originalType;
        this.m_model = sesa.m_model;
        this.m_isDefined = sesa.m_isDefined;
    }

    @Override
    public boolean propagateDependancies(IAnnotation ba) {
        return false;
    }

    public Type getOriginalType() {
        return this.m_originalType;
    }

    public IAnnotation getAtomicModel() {
        if (this.m_model == null) {
            return null;
        }
        return this.m_model.getAtomicAnnotation();
    }

    @Override
    public boolean equals(Object arg0) {
        if (arg0 == this) {
            return true;
        }
        if (arg0 == null) {
            if (this.m_isDefined) {
                return this.m_model == null;
            }
            return true;
        }
        if (arg0 instanceof ReturnValueMetaAnnotation) {
            return arg0.equals(this);
        }
        if (arg0 instanceof StreamMetaAnnotation) {
            if (this.m_isDefined) {
                return arg0.equals(this.m_model);
            }
            this.define((StreamMetaAnnotation)arg0);
            return true;
        }
        if (arg0 instanceof EmptyStreamMetaAnnotation) {
            if (this.m_isDefined && ((EmptyStreamMetaAnnotation)arg0).m_isDefined) {
                if (this.m_model == null) {
                    return ((EmptyStreamMetaAnnotation)arg0).m_model == null;
                }
                return this.m_model.equals(((EmptyStreamMetaAnnotation)arg0).m_model);
            }
            if (this.m_originalType.equals(((EmptyStreamMetaAnnotation)arg0).getOriginalType())) {
                if (this.m_isDefined) {
                    ((EmptyStreamMetaAnnotation)arg0).define(this.m_model);
                } else if (((EmptyStreamMetaAnnotation)arg0).m_isDefined) {
                    this.define(((EmptyStreamMetaAnnotation)arg0).m_model);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public List getBindingList(Object var, IAnnotation a, ConversionEngine ce) {
        if (this.m_model != null) {
            return this.m_model.getBindingList(var, a, ce);
        }
        return Collections.singletonList(new Binding(var, this.m_originalType));
    }

    @Override
    public void insertAnnotationOperation(IAnnotation ia, AnnotationEnvironment env, ConversionEngine ce) {
        if (ia != this) {
            throw new XylemError("ERR_SYSTEM", "!");
        }
        if (this.m_model != null) {
            for (Binding b : this.m_model.getBindingList(this.getVariable(), this.m_model, ce)) {
                ce.insertBinding(b.getName(), new StreamInstruction(((ICollectionType)((Object)b.getBindingType())).getElementType()));
            }
        } else {
            ce.insertBinding(this.getVariable(), new StreamInstruction(((ICollectionType)((Object)this.m_originalType)).getElementType()));
        }
    }

    @Override
    public Instruction convert(Instruction expr, AnnotationEnvironment env, ConversionEngine ce) {
        if (this.m_base == null && expr instanceof StreamInstruction) {
            return null;
        }
        return super.convert(expr, env, ce);
    }

    @Override
    public IAnnotation cloneAsFunctionParam() {
        return this.clonePassthru();
    }

    @Override
    public IAnnotation clonePassthru() {
        return new EmptyStreamMetaAnnotation(this);
    }

    @Override
    public IAnnotation getLoopBindingAnnotation() {
        if (this.m_model != null) {
            return this.m_model.getLoopBindingAnnotation();
        }
        return null;
    }

    @Override
    public IAnnotation getLoopValueAnnotation() {
        return this.clonePassthru();
    }

    public boolean define(StreamMetaAnnotation ssa) {
        boolean b = false;
        if (this.m_isDefined) {
            if (this.m_model == null && ssa != null || this.m_model != null && !this.m_model.equals(ssa)) {
                throw new XylemError("ERR_SYSTEM", "can't unify " + this + " " + ssa);
            }
        } else {
            this.m_model = ssa;
            this.m_isDefined = true;
            b = true;
        }
        if (b) {
            this.propagateDependanciesToBase();
        }
        return b;
    }

    @Override
    public boolean propagateDependanciesTo(MetaAnnotation sa) {
        boolean b = false;
        if (sa instanceof EmptyStreamMetaAnnotation) {
            b |= ((EmptyStreamMetaAnnotation)sa).define(this.m_model);
        }
        return b;
    }

    @Override
    public void propagateDependanciesToBase() {
        if (this.m_isDefined && this.m_base != null) {
            this.m_base.define(this.m_model);
        }
    }

    public IAnnotation unionValues(AnnotationEnvironment env, ArrayList values2) {
        Iterator i = values2.iterator();
        IAnnotation retVal = this;
        while (i.hasNext()) {
            IAnnotation a = (IAnnotation)i.next();
            if (a instanceof ReturnValueMetaAnnotation) {
                a = ((ReturnValueMetaAnnotation)a).getReturnAnnotation();
            }
            if (a instanceof StreamMetaAnnotation) {
                this.define((StreamMetaAnnotation)a);
                retVal = a;
                continue;
            }
            if (this.equals(a)) continue;
            throw new XylemError("ERR_SYSTEM", "not supported " + this + " " + a);
        }
        return this;
    }

    public String toString() {
        return "(EmptyStreamAnnot" + (this.m_isDefined ? "@defined " : "@? ") + this.getVariable() + " base=" + (this.m_base == null ? "null" : this.m_base.getVariable()) + " " + this.m_model + ")";
    }
}

