/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.annot.meta;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.annot.AnnotationEnvironment;
import com.ibm.xltxe.rnm1.xylem.annot.AnnotationTable;
import com.ibm.xltxe.rnm1.xylem.annot.ConversionEngine;
import com.ibm.xltxe.rnm1.xylem.annot.IAnnotation;
import com.ibm.xltxe.rnm1.xylem.annot.meta.MetaAnnotation;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LambdaInstruction;
import com.ibm.xltxe.rnm1.xylem.types.LambdaType;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public abstract class LambdaMetaAnnotation
extends MetaAnnotation {
    private LambdaType m_type;
    private IBinding[] m_modelBindings;
    protected HashSet m_applications = new HashSet();
    protected AnnotationTable m_table;
    private static int s_kNumber = 0;

    public static LambdaMetaAnnotation newA(LambdaInstruction li, AnnotationTable at, AnnotationEnvironment env) {
        return new Base(li, at, env);
    }

    LambdaMetaAnnotation(LambdaType lt2, IBinding[] bb, AnnotationTable at) {
        this.m_type = lt2;
        this.m_modelBindings = bb;
        this.m_table = at;
    }

    @Override
    public IAnnotation clonePassthru() {
        return new Passthru(this, this);
    }

    @Override
    public IAnnotation cloneAsFunctionParam() {
        return new Passthru(null, this);
    }

    @Override
    public boolean propagateDependanciesTo(MetaAnnotation sa) {
        if (!(sa instanceof LambdaMetaAnnotation)) {
            throw new XylemError("ERR_SYSTEM", "?" + sa);
        }
        return ((LambdaMetaAnnotation)sa).m_applications.addAll(this.m_applications);
    }

    public IAnnotation analyzeApplication(IAnnotation[] paramAnnotations, AnnotationEnvironment env, ArrayList functionStack, ArrayList pendingStacks) {
        ApplicationKey ak = new ApplicationKey(paramAnnotations, env);
        ApplicationKey a = (ApplicationKey)this.m_table.getGlobalInfo(ak);
        if (a == null) {
            a = ak;
            this.m_table.addGlobalInfo(a, a);
        }
        this.m_applications.add(a);
        this.propagateDependanciesToBase();
        return a.returnVal;
    }

    protected String getVarName(Object var, ApplicationKey apply2) {
        return var + "$lambda" + apply2.kNumber;
    }

    public Instruction getIdentifier(IAnnotation[] params) {
        ApplicationKey k = new ApplicationKey(params, null);
        k = (ApplicationKey)this.m_table.getGlobalInfo(k);
        return new IdentifierInstruction(this.getVarName(this.getVariable(), k));
    }

    @Override
    public List getBindingList(Object var, IAnnotation a, ConversionEngine ce) {
        ArrayList<Binding> bb = new ArrayList<Binding>(this.m_applications.size());
        for (ApplicationKey key2 : this.m_applications) {
            bb.add(new Binding((Object)this.getVarName(var, key2), this.getLambdaType(key2, ce)));
        }
        return bb;
    }

    protected Type getLambdaType(ApplicationKey key2, ConversionEngine ce) {
        Binding[] bb = ce.convertParamBindings(key2.params, this.m_modelBindings);
        Type[] tt = new Type[bb.length];
        for (int i = 0; i < bb.length; ++i) {
            tt[i] = bb[i].getBindingType();
        }
        return new LambdaType(tt, ce.convertType(key2.returnVal, this.m_type.getReturnType()), this.m_type.isPure());
    }

    @Override
    public boolean equals(Object arg0) {
        if (arg0 == null) {
            return false;
        }
        if (arg0 == this) {
            return true;
        }
        if (!(arg0 instanceof LambdaMetaAnnotation)) {
            return false;
        }
        return this.m_type.equals(((LambdaMetaAnnotation)arg0).m_type);
    }

    public String toString() {
        return "(LambdaAnnot " + this.m_type + ")";
    }

    static /* synthetic */ int access$708() {
        return s_kNumber++;
    }

    private class ApplicationKey {
        private IAnnotation[] params;
        private AnnotationEnvironment env;
        private IAnnotation returnVal;
        private int kNumber = LambdaMetaAnnotation.access$708();

        private ApplicationKey(IAnnotation[] aa, AnnotationEnvironment e) {
            this.params = aa;
            this.env = e;
        }

        public int hashCode() {
            return LambdaMetaAnnotation.this.m_type.hashCode();
        }

        public boolean equals(Object arg0) {
            if (arg0 == null) {
                return false;
            }
            if (!(arg0 instanceof ApplicationKey)) {
                return false;
            }
            ApplicationKey a2 = (ApplicationKey)arg0;
            if (a2.params.length != this.params.length) {
                return false;
            }
            for (int i = 0; i < this.params.length; ++i) {
                if (this.params[i] == null && a2.params[i] != null) {
                    return false;
                }
                if (this.params[i] == null || this.params[i].equals(a2.params[i])) continue;
                return false;
            }
            return true;
        }
    }

    private static class Passthru
    extends LambdaMetaAnnotation {
        private MetaAnnotation m_base;

        public Passthru(MetaAnnotation base2, LambdaMetaAnnotation model) {
            super(model.m_type, model.m_modelBindings, model.m_table);
            this.m_base = base2;
        }

        @Override
        public void propagateDependanciesToBase() {
            if (this.m_base != null) {
                this.propagateDependancies(this.m_base);
            }
        }

        @Override
        public void insertAnnotationOperation(IAnnotation ia, AnnotationEnvironment environment, ConversionEngine ce) {
            this.insertPassthru(this, this.m_base, environment, ce);
        }
    }

    private static class Base
    extends LambdaMetaAnnotation {
        private AnnotationEnvironment m_enclosingEnvironment;
        private LambdaInstruction m_lambda;

        public Base(LambdaInstruction li, AnnotationTable at, AnnotationEnvironment env) {
            super((LambdaType)li.getType(env.getTypeEnvironment(), env.getBindingEnvironment()), li.getChildInstructionBindings(0), at);
            this.m_lambda = li;
            this.m_enclosingEnvironment = env;
        }

        @Override
        public void propagateDependanciesToBase() {
            for (ApplicationKey apply2 : this.m_applications) {
                IAnnotation a = this.m_table.analyzeSyntheticLambdaApplication(null, this.m_lambda, apply2.params, this.m_enclosingEnvironment);
                if (a != null && this.m_enclosingEnvironment != apply2.env) {
                    throw new XylemError("ERR_SYSTEM", "UNSUPPORTED: non-local lambdas that have annotated return value");
                }
                apply2.returnVal = a;
            }
        }

        @Override
        public void insertAnnotationOperation(IAnnotation ia, AnnotationEnvironment environment, ConversionEngine ce) {
            if (ia != this) {
                throw new XylemError("ERR_SYSTEM", "!");
            }
            for (ApplicationKey key2 : this.m_applications) {
                Object id2 = ce.convertSyntheticLambdaApplication((String)null, (Instruction)this.m_lambda, key2.params, environment);
                ce.insertBinding(this.getVarName(this.getVariable(), key2), new IdentifierInstruction(id2));
            }
        }

        @Override
        public void insertValueDecomposition(Object valueVar, IAnnotation ia, AnnotationEnvironment env, ConversionEngine ce) {
            this.insertAnnotationOperation(ia, env, ce);
        }

        @Override
        public Instruction convert(Instruction expr, AnnotationEnvironment env, ConversionEngine ce) {
            if (expr == this.m_lambda) {
                return null;
            }
            return super.convert(expr, env, ce);
        }
    }
}

