/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.annot.meta;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.Program;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.annot.AnnotationEnvironment;
import com.ibm.xltxe.rnm1.xylem.annot.BaseAnnotation;
import com.ibm.xltxe.rnm1.xylem.annot.ConversionEngine;
import com.ibm.xltxe.rnm1.xylem.annot.IAnnotation;
import com.ibm.xltxe.rnm1.xylem.annot.IConverter;
import com.ibm.xltxe.rnm1.xylem.annot.meta.ReturnValueMetaAnnotation;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.TupleInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.TupleMatchInstruction;
import com.ibm.xltxe.rnm1.xylem.types.TupleType;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class MetaAnnotation
extends BaseAnnotation
implements IConverter {
    @Override
    public boolean propagateDependancies(IAnnotation ba) {
        MetaAnnotation sa = (MetaAnnotation)ba;
        if (sa.propagateDependanciesTo(this)) {
            this.propagateDependanciesToBase();
            return true;
        }
        return false;
    }

    public boolean propagateDependanciesTo(MetaAnnotation sa) {
        return false;
    }

    public abstract void propagateDependanciesToBase();

    @Override
    public IAnnotation getLoopBindingAnnotation() {
        MetaAnnotation sa = (MetaAnnotation)this.clonePassthru();
        return sa;
    }

    @Override
    public IAnnotation getLoopValueAnnotation() {
        throw new XylemError("ERR_SYSTEM", "!");
    }

    @Override
    public IAnnotation cloneAsFunctionReturn(ArrayList functionCallStack) {
        return new ReturnValueMetaAnnotation(this, functionCallStack);
    }

    public abstract boolean equals(Object var1);

    public IAnnotation unionValues(AnnotationEnvironment env, List values2) {
        for (IAnnotation a : values2) {
            if (this.equals(a)) continue;
            throw new XylemError("ERR_SYSTEM", "not supported union " + this + " " + a);
        }
        return this;
    }

    @Override
    public void addConversionSupport(Module m) {
    }

    @Override
    public Instruction convert(Instruction expr, AnnotationEnvironment env, ConversionEngine ce) {
        if (expr instanceof IdentifierInstruction) {
            IAnnotation a = env.get(expr);
            if (a != this) {
                throw new XylemError("ERR_SYSTEM", "?");
            }
            return this.getValueExpression(a, ce);
        }
        return ce.convertInstructionAsCopy(expr);
    }

    public List getIdentifierList(Object var, IAnnotation a, ConversionEngine ce) {
        List bb = this.getBindingList(var, a, ce);
        Iterator i = bb.iterator();
        ArrayList<IdentifierInstruction> ii = new ArrayList<IdentifierInstruction>(bb.size());
        while (i.hasNext()) {
            ii.add(new IdentifierInstruction(((IBinding)i.next()).getName()));
        }
        return ii;
    }

    @Override
    public Type getValueType(IAnnotation a, ConversionEngine ce) {
        Binding[] bb = this.getBindingList(a.getVariable(), a, ce).toArray(new Binding[0]);
        if (bb.length == 1) {
            return bb[0].getBindingType();
        }
        Type[] tt = new Type[bb.length];
        for (int i = 0; i < bb.length; ++i) {
            tt[i] = bb[i].getBindingType();
        }
        return new TupleType(tt);
    }

    public Instruction getValueExpression(IAnnotation a, ConversionEngine ce) {
        Instruction[] nn = this.getIdentifierList(a.getVariable(), a, ce).toArray(new Instruction[0]);
        if (nn.length != 1) {
            return new TupleInstruction(nn);
        }
        return nn[0];
    }

    @Override
    public void preConversion(Program prog) {
    }

    protected void insertPassthru(IAnnotation a, IAnnotation base2, AnnotationEnvironment environment, ConversionEngine ce) {
        if (a != this) {
            throw new XylemError("ERR_SYSTEM", "!");
        }
        Iterator i = this.getBindingList(base2.getVariable(), this, ce).iterator();
        Iterator j = this.getBindingList(this.getVariable(), this, ce).iterator();
        while (i.hasNext()) {
            IdentifierInstruction n2 = new IdentifierInstruction(((IBinding)i.next()).getName());
            ce.insertBinding(((IBinding)j.next()).getName(), n2);
        }
    }

    @Override
    public void insertLoopBinding(IAnnotation source, IAnnotation element2, AnnotationEnvironment env, ConversionEngine ce) {
        if (element2 != this) {
            throw new XylemError("ERR_SYSTEM", "!");
        }
        Iterator i = this.getBindingList(source.getVariable(), this, ce).iterator();
        Iterator j = this.getBindingList(this.getVariable(), this, ce).iterator();
        while (i.hasNext()) {
            IdentifierInstruction n2 = new IdentifierInstruction(((IBinding)i.next()).getName() + "$item");
            ce.insertBinding(((IBinding)j.next()).getName(), n2);
        }
    }

    @Override
    public void insertValueDecomposition(Object valueVar, IAnnotation ia, AnnotationEnvironment env, ConversionEngine ce) {
        IBinding[] bb = this.getBindingList(ia.getVariable(), ia, ce).toArray(new Binding[0]);
        IdentifierInstruction val = new IdentifierInstruction(valueVar);
        if (bb.length == 1) {
            ce.insertBinding(bb[0].getName(), val);
        } else {
            for (int i = 0; i < bb.length; ++i) {
                ce.insertBinding(bb[i].getName(), new TupleMatchInstruction((Instruction)val, bb.length, i));
            }
        }
    }
}

