/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.annot.meta;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.annot.AnnotationEnvironment;
import com.ibm.xltxe.rnm1.xylem.annot.AnnotationTable;
import com.ibm.xltxe.rnm1.xylem.annot.ConversionEngine;
import com.ibm.xltxe.rnm1.xylem.annot.IAnnotation;
import com.ibm.xltxe.rnm1.xylem.annot.meta.EmptyStreamMetaAnnotation;
import com.ibm.xltxe.rnm1.xylem.annot.meta.MetaAnnotation;
import com.ibm.xltxe.rnm1.xylem.annot.meta.ReturnValueMetaAnnotation;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.types.StreamType;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class StreamMetaAnnotation
extends MetaAnnotation {
    private Type m_originalType;
    private IAnnotation m_atomicAnnotation;
    private StreamMetaAnnotation m_base;

    public static IAnnotation newStream(StreamInstruction si, AnnotationEnvironment env, AnnotationTable table2) {
        return null;
    }

    private StreamMetaAnnotation(Type originalType, IAnnotation atomic2) {
        this.m_originalType = originalType;
        this.m_atomicAnnotation = atomic2.clonePassthru();
        this.m_base = null;
    }

    private StreamMetaAnnotation(StreamMetaAnnotation base2) {
        this.m_base = base2;
        this.m_atomicAnnotation = base2.m_atomicAnnotation.clonePassthru();
    }

    @Override
    public boolean propagateDependancies(IAnnotation ba) {
        if (!(ba instanceof StreamMetaAnnotation)) {
            return this.m_atomicAnnotation.propagateDependancies(ba);
        }
        return this.m_atomicAnnotation.propagateDependancies(((StreamMetaAnnotation)ba).m_atomicAnnotation);
    }

    @Override
    public boolean equals(Object arg0) {
        while (arg0 instanceof ReturnValueMetaAnnotation) {
            arg0 = ((ReturnValueMetaAnnotation)arg0).getReturnAnnotation();
        }
        if (arg0 == null) {
            return false;
        }
        if (arg0 == this) {
            return true;
        }
        if (arg0 instanceof EmptyStreamMetaAnnotation) {
            return arg0.equals(this);
        }
        if (!(arg0 instanceof StreamMetaAnnotation)) {
            return false;
        }
        return this.m_atomicAnnotation.equals(((StreamMetaAnnotation)arg0).m_atomicAnnotation);
    }

    @Override
    public List getBindingList(Object var, IAnnotation a, ConversionEngine ce) {
        List bb = ce.getBindingList(var, this.m_atomicAnnotation);
        for (Binding b : bb) {
            b.setType(StreamType.makeStreamType(b.getBindingType()));
        }
        return bb;
    }

    @Override
    public void insertAnnotationOperation(IAnnotation ia, AnnotationEnvironment environment, ConversionEngine engine) {
        if (ia != this) {
            throw new XylemError("ERR_SYSTEM", "!");
        }
        if (this.m_base != null) {
            this.insertPassthru(this, this.m_base, environment, engine);
        } else {
            engine.insertAnnotationOperation(this.m_atomicAnnotation);
            Iterator i = this.getBindingList(this.getVariable(), this, engine).iterator();
            Iterator j = engine.getBindingList(this.m_atomicAnnotation.getVariable(), this.m_atomicAnnotation).iterator();
            while (i.hasNext()) {
                Binding str = (Binding)i.next();
                Binding atom2 = (Binding)j.next();
                if (atom2.getBindingType() instanceof StreamType) {
                    engine.insertBinding(str.getName(), new IdentifierInstruction(atom2.getName()));
                    continue;
                }
                engine.insertBinding(str.getName(), new StreamInstruction(atom2.getBindingType(), new IdentifierInstruction(atom2.getName())));
            }
        }
    }

    @Override
    public void setVariable(Object var) {
        super.setVariable(var);
        this.m_atomicAnnotation.setVariable(var);
    }

    public Type getOriginalType() {
        return this.m_originalType;
    }

    @Override
    public IAnnotation cloneAsFunctionParam() {
        return new StreamMetaAnnotation(this.m_originalType, this.m_atomicAnnotation.cloneAsFunctionParam());
    }

    @Override
    public IAnnotation clonePassthru() {
        return new StreamMetaAnnotation(this);
    }

    @Override
    public IAnnotation getLoopBindingAnnotation() {
        return this.m_atomicAnnotation.getLoopBindingAnnotation();
    }

    @Override
    public IAnnotation getLoopValueAnnotation() {
        return this.clonePassthru();
    }

    @Override
    public void propagateDependanciesToBase() {
        throw new XylemError("ERR_SYSTEM", "!");
    }

    @Override
    public boolean propagateDependanciesTo(MetaAnnotation sa) {
        if (sa instanceof StreamMetaAnnotation) {
            return ((StreamMetaAnnotation)sa).m_atomicAnnotation.propagateDependancies(this.m_atomicAnnotation);
        }
        if (sa instanceof EmptyStreamMetaAnnotation) {
            return false;
        }
        return this.m_atomicAnnotation.propagateDependancies(sa);
    }

    public String toString() {
        return "(StreamAnnot " + this.getVariable() + " base=" + (this.m_base == null ? "null" : this.m_base.getVariable()) + " " + this.m_atomicAnnotation + ")";
    }

    public IAnnotation getAtomicAnnotation() {
        return this.m_atomicAnnotation;
    }

    public IAnnotation unionValues(AnnotationEnvironment env, ArrayList values2) {
        for (IAnnotation a : values2) {
            while (a instanceof ReturnValueMetaAnnotation) {
                a = ((ReturnValueMetaAnnotation)a).getReturnAnnotation();
            }
            if (a instanceof EmptyStreamMetaAnnotation) {
                ((EmptyStreamMetaAnnotation)a).define(this);
                continue;
            }
            if (this.equals(a)) continue;
            throw new XylemError("ERR_SYSTEM", "not supported " + this + " " + a);
        }
        return this;
    }

    @Override
    public Instruction convert(Instruction expr, AnnotationEnvironment env, ConversionEngine ce) {
        if (this.m_base == null && expr instanceof StreamInstruction) {
            return null;
        }
        return super.convert(expr, env, ce);
    }
}

