/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.annot.meta;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.annot.AnnotationEnvironment;
import com.ibm.xltxe.rnm1.xylem.annot.ConversionEngine;
import com.ibm.xltxe.rnm1.xylem.annot.IAnnotation;
import com.ibm.xltxe.rnm1.xylem.annot.meta.MetaAnnotation;
import com.ibm.xltxe.rnm1.xylem.instructions.ConstructorInstantiationInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.TupleInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.TupleMatchInstruction;
import com.ibm.xltxe.rnm1.xylem.types.TupleType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class TupleMetaAnnotation
extends MetaAnnotation {
    TupleMetaAnnotation m_base;
    Instruction[] m_originalParams;
    Type[] m_types;
    IAnnotation[] m_components;

    public TupleMetaAnnotation(Instruction[] nn, AnnotationEnvironment env) {
        this.m_originalParams = nn;
        this.m_types = new Type[nn.length];
        this.m_components = new IAnnotation[nn.length];
        for (int i = 0; i < nn.length; ++i) {
            this.m_components[i] = env.get(nn[i]);
            if (this.m_components[i] != null) {
                this.m_components[i] = this.m_components[i].clonePassthru();
            }
            this.m_types[i] = nn[i].getType(env.getTypeEnvironment(), env.getBindingEnvironment());
        }
    }

    public TupleMetaAnnotation(TupleMetaAnnotation base2) {
        IAnnotation[] aa = new IAnnotation[base2.m_components.length];
        for (int i = 0; i < base2.m_components.length; ++i) {
            if (base2.m_components[i] == null) continue;
            aa[i] = base2.m_components[i].clonePassthru();
        }
        this.m_types = base2.m_types;
        this.m_components = aa;
        this.m_base = base2;
    }

    public TupleMetaAnnotation(TupleMetaAnnotation base2, IAnnotation[] aa) {
        this.m_types = base2.m_types;
        this.m_components = aa;
        this.m_base = base2;
    }

    @Override
    public void propagateDependanciesToBase() {
        for (int i = 0; i < this.m_components.length; ++i) {
            if (this.m_components[i] == null) continue;
            this.m_components[i].propagateDependancies(this);
        }
    }

    public IAnnotation[] getComponents() {
        return this.m_components;
    }

    @Override
    public IAnnotation clonePassthru() {
        return new TupleMetaAnnotation(this);
    }

    @Override
    public IAnnotation cloneAsFunctionParam() {
        IAnnotation[] aa = new IAnnotation[this.m_components.length];
        for (int i = 0; i < this.m_components.length; ++i) {
            if (this.m_components[i] == null) continue;
            aa[i] = this.m_components[i].cloneAsFunctionParam();
        }
        return new TupleMetaAnnotation(this, aa);
    }

    @Override
    public void setVariable(Object var) {
        for (int i = 0; i < this.m_components.length; ++i) {
            if (this.m_components[i] == null) continue;
            this.m_components[i].setVariable(var + "_" + i);
        }
        super.setVariable(var);
    }

    private String getVarName(Object var) {
        return var + "$tuple";
    }

    public void insertMatchOperation(int i, Binding b, AnnotationEnvironment environment, ConversionEngine ce) {
        String varName = this.getVarName(this.getVariable()) + i;
        IdentifierInstruction value2 = new IdentifierInstruction(this.getVarName(this.getVariable()));
        ce.insertBinding(varName, new TupleMatchInstruction((Instruction)value2, this.m_components.length, i));
        value2 = new IdentifierInstruction(varName);
        if (this.m_components[i] == null) {
            ce.insertBinding(b.getName(), value2);
        } else {
            ce.insertValueDecomposition(varName, this.m_components[i]);
            Iterator j = ce.getBindingList(varName, this.m_components[i]).iterator();
            Iterator k = ce.getBindingList(b.getName(), this.m_components[i]).iterator();
            while (j.hasNext()) {
                Binding b1 = (Binding)j.next();
                Binding b2 = (Binding)k.next();
                ce.insertBinding(b2.getName(), new IdentifierInstruction(b1.getName()));
            }
        }
    }

    @Override
    public boolean equals(Object arg0) {
        if (arg0 == null) {
            return false;
        }
        if (!(arg0 instanceof TupleMetaAnnotation)) {
            return false;
        }
        IAnnotation[] aa = ((TupleMetaAnnotation)arg0).m_components;
        if (aa.length != this.m_components.length) {
            return false;
        }
        for (int i = 0; i < aa.length; ++i) {
            if (!(aa[i] == null ? this.m_components[i] != null : !aa[i].equals(this.m_components[i]))) continue;
            return false;
        }
        return true;
    }

    @Override
    public List getBindingList(Object var, IAnnotation a, ConversionEngine ce) {
        return Collections.singletonList(new Binding((Object)this.getVarName(var), this.getType(ce)));
    }

    @Override
    public void insertAnnotationOperation(IAnnotation ia, AnnotationEnvironment environment, ConversionEngine ce) {
        if (this.m_originalParams == null) {
            this.insertPassthru(this, this.m_base, environment, ce);
        } else {
            ce.insertBinding(this.getVarName(this.getVariable()), ce.convertInstruction(new TupleInstruction(this.m_originalParams)));
        }
    }

    public Type getType(ConversionEngine ce) {
        String varName = this.getVarName(this.getVariable());
        Type[] outerTuple = new Type[this.m_components.length];
        for (int i = 0; i < this.m_components.length; ++i) {
            outerTuple[i] = ce.convertType(this.m_components[i], this.m_types[i]);
        }
        return new TupleType(outerTuple);
    }

    @Override
    public Instruction convert(Instruction expr, AnnotationEnvironment env, ConversionEngine ce) {
        if (expr instanceof ConstructorInstantiationInstruction) {
            return null;
        }
        return super.convert(expr, env, ce);
    }

    @Override
    public IAnnotation cloneAsFunctionReturn(ArrayList functionCallStack) {
        return super.cloneAsFunctionReturn(functionCallStack);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("(TupleAnnot ");
        sb.append(this.getVariable());
        sb.append(" base=");
        if (this.m_base != null) {
            sb.append(this.m_base.getVariable());
        } else {
            sb.append("null");
        }
        for (int i = 0; i < this.m_components.length; ++i) {
            sb.append(' ');
            sb.append(this.m_components[i]);
        }
        sb.append(")");
        return sb.toString();
    }
}

