/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.builders;

import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.INewNameGenerator;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.builders.PseudoLetChainBuilder;
import com.ibm.xltxe.rnm1.xylem.instructions.BeginInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetBaseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StaticMethodInvocationInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.OptimizerUtilities;
import com.ibm.xltxe.rnm1.xylem.types.UnitType;
import com.ibm.xltxe.rnm1.xylem.utils.HiddenOptions;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.util.HashMap;
import java.util.LinkedList;

public class LetChainBuilder {
    protected LetInstruction m_outer = null;
    protected LetInstruction m_inner = null;
    protected LetChainBuilder m_parent = null;
    private static boolean genReducedCode = HiddenOptions.wasSpecified("genReducedCode");
    private static boolean genTracingCode = HiddenOptions.wasSpecified("genTracingCode");

    public LetChainBuilder() {
    }

    public LetChainBuilder(LetChainBuilder parent2) {
        this.m_parent = parent2;
    }

    public Instruction bind(Instruction n2) {
        if (n2 instanceof LetInstruction) {
            LetInstruction outerLet;
            LetInstruction innerLet = outerLet = (LetInstruction)n2;
            Instruction body = innerLet.getBody();
            while (body instanceof LetInstruction) {
                innerLet = (LetInstruction)body;
                body = innerLet.getBody();
            }
            if (body instanceof IdentifierInstruction) {
                if (this.m_outer == null) {
                    this.m_outer = outerLet;
                    this.m_inner = innerLet;
                } else {
                    this.m_inner.setBody(outerLet);
                    this.m_inner = innerLet;
                }
                innerLet.setBody(null);
                return body;
            }
        }
        return this.bind(ReductionHelper.generateIntermediateIdentifier2(), n2, false);
    }

    public Object bindToVar(Instruction n2) {
        if (n2 instanceof IdentifierInstruction) {
            return ((IdentifierInstruction)n2).getVariable();
        }
        Integer var = ReductionHelper.generateIntermediateIdentifier2();
        this.bind(var, n2, true);
        return var;
    }

    public Object bindToVar(Object var, Instruction n2) {
        this.bind(var, n2, true);
        return var;
    }

    public Instruction bind(Object var, Instruction n2) {
        return this.bind(var, n2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Instruction bind(Object var, Instruction n2, boolean force) {
        LetInstruction leti;
        if (var instanceof Instruction || n2 == null) {
            throw new IllegalArgumentException();
        }
        if (!force && (n2 instanceof IdentifierInstruction || n2 instanceof LiteralInstruction)) {
            return n2;
        }
        if (genTracingCode) {
            try {
                genTracingCode = false;
                LetChainBuilder lcb = LetChainBuilder.newInstance(false);
                StringBuffer sb = new StringBuffer("<step>");
                String s = n2.toString();
                if (s.length() >= 2 && s.charAt(0) != '\r' && s.charAt(1) != '\n') {
                    sb.append("\r\n");
                }
                sb.append(s);
                sb.append("\r\n</step>\r\n");
                Instruction[] params = new Instruction[]{lcb.bind(StreamInstruction.charStreamLiteral(sb.toString()))};
                Instruction i = lcb.bind(new StaticMethodInvocationInstruction("com.ibm.xltxe.rnm1.xtq.xslt.runtime.v2.BasisLibrary2", "FILTraceF", params, UnitType.s_unitType));
                n2 = new BeginInstruction(lcb.packageUp(i), n2);
            }
            finally {
                genTracingCode = true;
            }
        }
        if (n2 instanceof LetInstruction) {
            leti = (LetInstruction)n2;
            if (this.m_outer == null) {
                this.m_inner = this.m_outer = leti;
            } else {
                this.m_inner.setBody(leti);
            }
            n2 = leti.getBody();
            while (n2 instanceof LetInstruction) {
                leti = (LetInstruction)n2;
                n2 = leti.getBody();
            }
            if (n2 == null) {
                throw new XylemError("ERR_SYSTEM", "LetChainBuilder: bind where value is a let itself but body of let is null!" + this);
            }
            this.m_inner = new LetInstruction(var, n2, null);
            leti.setBody(this.m_inner);
        } else {
            leti = new LetInstruction(var, n2, null);
            if (this.m_outer == null) {
                this.m_inner = this.m_outer = leti;
            } else {
                this.m_inner.setBody(leti);
                this.m_inner = leti;
            }
        }
        return new IdentifierInstruction(var);
    }

    public Instruction packageUp(Instruction body) {
        if (this.m_outer == null) {
            return body;
        }
        this.m_inner.setBody(body);
        return this.m_outer;
    }

    public static Instruction inlinebody(Instruction[] params, IBinding[] bindings, Instruction body) {
        LetChainBuilder lcb = new LetChainBuilder();
        Instruction val = lcb.bindAndRenameBody(params, bindings, body, new BindingEnvironment());
        return lcb.packageUp(val);
    }

    public Instruction bindAndRenameBody(Instruction[] params, IBinding[] bindings, Instruction body, BindingEnvironment benv) {
        if (params.length != bindings.length) {
            throw new RuntimeException();
        }
        HashMap<Object, Object> map2 = new HashMap<Object, Object>();
        for (int k = 0; k < params.length; ++k) {
            Object var;
            Instruction param = params[k];
            if (param == null) continue;
            if (param instanceof IdentifierInstruction) {
                var = ((IdentifierInstruction)param).getVariable();
            } else if (param instanceof LiteralInstruction) {
                var = this.bindToVar(param);
                if (benv != null) {
                    benv.setVariableBinding(this.m_inner);
                }
            } else {
                throw new IllegalArgumentException();
            }
            map2.put(bindings[k].getName(), var);
        }
        return this.rebindLetsInternal(body, map2, benv);
    }

    public Instruction rebindLets(Instruction li, BindingEnvironment benv) {
        return this.rebindLetsInternal(li, new HashMap(), benv);
    }

    public Instruction tryToResolve(Instruction instr) {
        if (instr instanceof LetBaseInstruction) {
            return this.resolveLetInstruction((LetBaseInstruction)instr);
        }
        if (instr instanceof IdentifierInstruction) {
            return this.tryToResolve((IdentifierInstruction)instr, this.m_outer);
        }
        return instr;
    }

    private Instruction tryToResolve(IdentifierInstruction identifier, LetBaseInstruction let) {
        Object targetIdentifierVar = identifier.getVariable();
        if (targetIdentifierVar == null) {
            return null;
        }
        while (let != null) {
            Object var = let.getVariable();
            if (var != null && var.equals(targetIdentifierVar)) {
                Instruction resolvedMaybe = let.getValue();
                if (resolvedMaybe == null) {
                    return null;
                }
                if (resolvedMaybe instanceof IdentifierInstruction) {
                    return this.tryToResolve(resolvedMaybe);
                }
                if (resolvedMaybe instanceof LetBaseInstruction) {
                    return this.resolveLetInstruction((LetBaseInstruction)resolvedMaybe);
                }
                return resolvedMaybe;
            }
            Instruction instr = let.getBody();
            if (instr instanceof LetBaseInstruction) {
                let = (LetBaseInstruction)instr;
                continue;
            }
            let = null;
        }
        return this.m_parent != null ? this.m_parent.tryToResolve(identifier) : null;
    }

    private Instruction resolveLetInstruction(LetBaseInstruction instr) {
        Instruction resolvedMaybe = instr;
        while ((resolvedMaybe = resolvedMaybe.getBody()) instanceof LetBaseInstruction) {
        }
        if (resolvedMaybe instanceof IdentifierInstruction) {
            return this.tryToResolve(resolvedMaybe);
        }
        return resolvedMaybe;
    }

    private Instruction rebindLetsInternal(Instruction li, HashMap map2, BindingEnvironment benv) {
        INewNameGenerator ng = new INewNameGenerator(){

            @Override
            public Object getNewName() {
                return ReductionHelper.generateIntermediateIdentifier2();
            }
        };
        LinkedList<LetInstruction> lets = new LinkedList<LetInstruction>();
        Instruction body = OptimizerUtilities.skipLets(li, lets);
        for (LetInstruction li2 : lets) {
            Object var = li2.getVariable();
            Instruction val = li2.getValue().assignNewNames(map2, ng);
            IdentifierInstruction newVar = new IdentifierInstruction(this.bindToVar(val));
            if (benv != null) {
                benv.setVariableBinding(this.m_inner);
            }
            map2.put(var, newVar);
        }
        body = body.assignNewNames(map2, ng);
        Instruction id2 = this.bind(body);
        if (benv != null && this.m_inner != null) {
            benv.setVariableBinding(this.m_inner);
        }
        return id2;
    }

    public LetChainBuilder newInstance() {
        return new LetChainBuilder();
    }

    public LetChainBuilder newInstanceParented() {
        return new LetChainBuilder(this);
    }

    public static LetChainBuilder newInstance(boolean unreduced) {
        if (genReducedCode) {
            unreduced = false;
        }
        if (unreduced) {
            return new PseudoLetChainBuilder();
        }
        return new LetChainBuilder();
    }
}

