/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.codegen;

import com.ibm.xltxe.rnm1.fcg.FcgAttrs;
import com.ibm.xltxe.rnm1.fcg.FcgClassGen;
import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgMethodGen;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgVariable;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.LazyAdditionGenerationState;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ClosureGenerationUtilities {
    public static void generateClosureInitSuffix(Set freeBindings, CodeGenerationTracker cgt, FcgCodeGenHelper cgh, FcgClassGen classGen, FcgInstructionList il) {
        IBinding b;
        TypeEnvironment tenv = cgt.m_typeEnvironment;
        BindingEnvironment benv = cgt.m_bindingEnvironment;
        FcgClassReferenceType classType = cgh.getClassReferenceType(classGen.getClassType().getTypeName());
        FcgMethodGen mg = classGen.newConstructorGen(FcgAttrs.PUBLIC);
        FcgInstructionList ilConstructor = mg.getInstructionList();
        String thisName = "__this__";
        FcgClassReferenceType thisType = cgh.getClassReferenceType(cgh.getClassName());
        FcgVariable thisParam = mg.addParameter(thisType, thisName);
        classGen.newInstanceField(FcgAttrs.NONE, thisType, thisName);
        FcgVariable[] params = new FcgVariable[freeBindings.size()];
        Iterator iter = freeBindings.iterator();
        int i = 0;
        while (iter.hasNext()) {
            b = (IBinding)iter.next();
            String paramName = cgh.getSafeName(b.getName().toString());
            FcgType paramType = b.getBindingType(tenv, benv).getFCGType(cgh);
            params[i] = mg.addParameter(paramType, paramName);
            classGen.newInstanceField(FcgAttrs.NONE, paramType, "m_" + paramName);
            ++i;
        }
        ilConstructor.beginMethod();
        ilConstructor.loadThis();
        ilConstructor.invokeSuperConstructor(classGen.getSuperClassType(), 0);
        ilConstructor.loadThis();
        ilConstructor.loadVar(thisParam);
        ilConstructor.storeInstanceFieldStmt(classType, thisName, thisType);
        cgh.loadThisVar(il);
        iter = freeBindings.iterator();
        i = 0;
        while (iter.hasNext()) {
            b = (IBinding)iter.next();
            FcgVariable param = params[i];
            ilConstructor.loadThis();
            ilConstructor.loadVar(param);
            ilConstructor.storeInstanceFieldStmt(classType, "m_" + param.getName(), param.getType());
            FcgType expectedType = param.getType();
            FcgType argType = cgt.generateConventionally(b, cgh, false, il, ValueGenStyle.DEFAULT_NO_PUSH, false);
            if (!expectedType.equals(argType)) {
                argType = il.convertExpr(argType, expectedType);
            }
            ++i;
        }
        ilConstructor.returnInstruction();
        ilConstructor.endMethod();
        il.createObjectExpr((FcgType)classType, freeBindings.size() + 1);
    }

    public static List generateClosureFunctionCallParameters(FunctionCallInstruction fci, Set freeBindings, CodeGenerationTracker cgt, FcgCodeGenHelper cgh, FcgInstructionList il) {
        ArrayList<Binding> set2 = new ArrayList<Binding>();
        int c = fci.getChildInstructionCount();
        Function f2 = cgt.m_typeEnvironment.getModule().getFunction(fci.getFunction());
        for (int i = 0; i < c; ++i) {
            IdentifierInstruction n2;
            IBinding b;
            Instruction n0 = fci.getChildInstruction(i);
            if (!(n0 instanceof IdentifierInstruction) || !freeBindings.contains(b = (n2 = (IdentifierInstruction)n0).getBinding(cgt.m_bindingEnvironment))) continue;
            cgt.generateConventionally(b, cgh, false, il, ValueGenStyle.DEFAULT, false);
            set2.add(f2.m_parameters[i]);
        }
        return set2;
    }

    public static List determineClosureFunctionCallFreeBindings(FunctionCallInstruction fci, Set freeBindings, TypeEnvironment tenv, BindingEnvironment benv, CodeGenerationTracker cgt, FcgCodeGenHelper cgh, FcgInstructionList il) {
        int c = fci.getChildInstructionCount();
        ArrayList<Binding> set2 = new ArrayList<Binding>();
        Function f2 = tenv.getModule().getFunction(fci.getFunction());
        for (int i = 0; i < c; ++i) {
            IdentifierInstruction n2;
            IBinding b;
            Instruction n0 = fci.getChildInstruction(i);
            if (!(n0 instanceof IdentifierInstruction) || !freeBindings.contains(b = (n2 = (IdentifierInstruction)n0).getBinding(benv))) continue;
            set2.add(f2.m_parameters[i]);
        }
        return set2;
    }

    public static void generateClosureSuffix(String baseClassName, List freeBindings, CodeGenerationTracker cgt, FcgCodeGenHelper cgh, FcgClassGen classGen) {
        FcgClassReferenceType classType = cgh.getClassReferenceType(baseClassName);
        FcgMethodGen mg = classGen.newConstructorGen(FcgAttrs.PUBLIC);
        FcgInstructionList il = mg.getInstructionList();
        String thisName = "__this__";
        FcgClassReferenceType thisType = cgh.getClassReferenceType(cgh.getClassName());
        FcgVariable thisParam = mg.addParameter(thisType, thisName);
        classGen.newInstanceField(FcgAttrs.NONE, thisType, thisName);
        FcgVariable[] params = new FcgVariable[freeBindings.size()];
        Iterator iter = freeBindings.iterator();
        int i = 0;
        while (iter.hasNext()) {
            IBinding b = (IBinding)iter.next();
            String paramName = "x" + (i + 1);
            FcgType paramType = b.getBindingType().getFCGType(cgh);
            params[i] = mg.addParameter(paramType, paramName);
            String fieldName = "m_" + paramName;
            classGen.newInstanceField(FcgAttrs.NONE, paramType, fieldName);
            cgt.registerBinding(b, new LazyAdditionGenerationState(b, null, fieldName, paramType));
            ++i;
        }
        il.beginMethod();
        il.loadThis();
        il.invokeSuperConstructor(classGen.getSuperClassType(), 0);
        il.loadThis();
        il.loadVar(thisParam);
        il.storeInstanceFieldStmt(classType, thisName, thisType);
        for (i = 0; i < params.length; ++i) {
            String fieldName = "m_" + params[i].getName();
            il.loadThis();
            il.loadVar(params[i]);
            il.storeInstanceFieldStmt(classType, fieldName, params[i].getType());
        }
        il.returnInstruction();
        il.endMethod();
    }
}

