/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.codegen;

import com.ibm.xltxe.rnm1.xtq.common.utils.Util;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGeneration;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationSettings;
import com.ibm.xltxe.rnm1.xylem.codegen.FunctionGenerationStyle;
import com.ibm.xltxe.rnm1.xylem.types.LambdaType;
import com.ibm.xltxe.rnm1.xylem.types.LazyStreamType;
import com.ibm.xltxe.rnm1.xylem.types.PromiseType;
import com.ibm.xltxe.rnm1.xylem.types.SlotType;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;

public class CodeGenerationHelper
implements CodeGeneration {
    private static final char ESCAPE_DELIM_CHAR = '$';
    private String m_className;
    private CodeGenerationSettings m_settings;
    private HashMap m_obfuscatedFunctionNames = new HashMap();
    private HashMap m_generationMemos = new HashMap();
    private HashMap m_lambdaTypeGenerationRequests = new HashMap();
    private HashMap m_slotTypeGenerationRequests = new HashMap();
    private HashMap m_lazyStreamTypeGenerationRequests = new HashMap();
    private HashMap m_promiseTypeGenerationRequests = new HashMap();
    private TreeSet m_functionGenerationRequests = new TreeSet(new Comparator(){

        public int compare(Object arg0, Object arg1) {
            return ((FunctionGenerationStyle)arg0).getSignature().compareTo(((FunctionGenerationStyle)arg1).getSignature());
        }
    });
    HashMap<String, String> safeNamesMap = new HashMap();
    HashSet<String> namesInUse = new HashSet();
    private int uniqueSuffix = 0;

    @Override
    public final String getClassName() {
        return this.m_className;
    }

    @Override
    public final void setClassName(String className) {
        this.m_className = className;
    }

    @Override
    public void requestFunctionGeneration(FunctionGenerationStyle fgs) {
        this.m_functionGenerationRequests.add(fgs);
    }

    @Override
    public Iterator functionGenerationRequestsIterator() {
        return this.m_functionGenerationRequests.iterator();
    }

    @Override
    public boolean functionGenerationRequestsIsEmpty() {
        return this.m_functionGenerationRequests.isEmpty();
    }

    @Override
    public void requestLambdaTypeGeneration(String className, LambdaType lt2) {
        this.m_lambdaTypeGenerationRequests.put(className, lt2);
    }

    @Override
    public void requestPromiseTypeGeneration(String name2, PromiseType type2) {
        this.m_promiseTypeGenerationRequests.put(name2, type2);
    }

    @Override
    public final Iterator promiseTypeGenerationRequestsIterator() {
        return this.m_promiseTypeGenerationRequests.keySet().iterator();
    }

    @Override
    public final PromiseType promiseTypeGenerationRequestsGet(String className) {
        return (PromiseType)this.m_promiseTypeGenerationRequests.get(className);
    }

    @Override
    public void requestSlotTypeGeneration(String className, SlotType lt2) {
        this.m_slotTypeGenerationRequests.put(className, lt2);
    }

    @Override
    public final Iterator slotTypeGenerationRequestsIterator() {
        return this.m_slotTypeGenerationRequests.keySet().iterator();
    }

    @Override
    public final SlotType slotTypeGenerationRequestsGet(String className) {
        return (SlotType)this.m_slotTypeGenerationRequests.get(className);
    }

    public void requestLazyStreamTypeGeneration(String className, LazyStreamType lt2) {
        this.m_lazyStreamTypeGenerationRequests.put(className, lt2);
    }

    public final Iterator lazyStreamTypeGenerationRequestsIterator() {
        return this.m_lazyStreamTypeGenerationRequests.keySet().iterator();
    }

    public final LazyStreamType lazyStreamTypeGenerationRequestsGet(String className) {
        return (LazyStreamType)this.m_lazyStreamTypeGenerationRequests.get(className);
    }

    @Override
    public String getSafeName(String name2) {
        if (this.m_settings.isObfuscateFunctionNames()) {
            return this.getObfuscatedFunctionName(name2);
        }
        String hashed = this.safeNamesMap.get(name2);
        if (hashed != null) {
            return hashed;
        }
        String escaped = Util.toJavaInternalName(name2);
        if (escaped.length() > 80) {
            escaped = escaped.substring(0, 80) + '$' + escaped.hashCode();
        }
        if (this.namesInUse.contains(escaped)) {
            escaped = escaped + '$' + this.uniqueSuffix++;
        }
        this.namesInUse.add(escaped);
        this.safeNamesMap.put(name2, escaped);
        return escaped;
    }

    @Override
    public final CodeGenerationSettings getSettings() {
        return this.m_settings;
    }

    @Override
    public final void setSettings(CodeGenerationSettings settings) {
        this.m_settings = settings;
    }

    @Override
    public final String getObfuscatedFunctionName(String name2) {
        String s = (String)this.m_obfuscatedFunctionNames.get(name2);
        if (s == null) {
            s = "f" + this.m_obfuscatedFunctionNames.size();
            this.m_obfuscatedFunctionNames.put(name2, s);
        }
        return s;
    }

    @Override
    public final void generationMemosPut(Object key2, Object value2) {
        this.m_generationMemos.put(key2, value2);
    }

    @Override
    public final Object generationMemosGet(Object key2) {
        return this.m_generationMemos.get(key2);
    }

    @Override
    public final int generationMemosSize() {
        return this.m_generationMemos.size();
    }

    @Override
    public final boolean generationMemosContainsKey(Object key2) {
        return this.m_generationMemos.containsKey(key2);
    }

    @Override
    public final LambdaType lambdaTypeGenerationRequestsGet(String className) {
        return (LambdaType)this.m_lambdaTypeGenerationRequests.get(className);
    }

    @Override
    public final Iterator lambdaTypeGenerationRequestsIterator() {
        return this.m_lambdaTypeGenerationRequests.keySet().iterator();
    }
}

