/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.codegen;

import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.instructions.BeginInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.TryCatchInstruction;

public class CodeGenerationOptUtils {
    public static final int LEN_UNKNOWN = -1;

    public static int getStreamLength(Instruction instr, BindingEnvironment benv) {
        int len = 0;
        if (instr instanceof StreamInstruction) {
            StreamInstruction si = (StreamInstruction)instr;
            int children = si.getChildInstructionCount();
            for (int i = 0; i < children; ++i) {
                Instruction ins = si.getChildInstruction(i);
                int integer2 = CodeGenerationOptUtils.numberOfElements(ins, benv);
                if (integer2 == -1) {
                    return -1;
                }
                len += integer2;
            }
            return len;
        }
        if (instr instanceof IdentifierInstruction) {
            Object variable6;
            IBinding ib7;
            LetInstruction li8;
            IdentifierInstruction identifier = (IdentifierInstruction)instr;
            BindingEnvironment be7 = identifier.getBindingEnvironment();
            if (be7 == null) {
                be7 = benv;
            }
            if ((li8 = (ib7 = be7.getVariableBinding(variable6 = identifier.getVariable())).getLet()) != null) {
                Instruction instr9 = li8.getValue();
                return CodeGenerationOptUtils.getStreamLength(instr9, benv);
            }
        } else if (instr instanceof BeginInstruction) {
            BeginInstruction bi = (BeginInstruction)instr;
            int last2 = bi.getChildInstructionCount();
            if (last2 >= 0) {
                Instruction lastChild = bi.getChildInstruction(last2 - 1);
                return CodeGenerationOptUtils.getStreamLength(lastChild, benv);
            }
        } else if (instr instanceof TryCatchInstruction) {
            TryCatchInstruction tci = (TryCatchInstruction)instr;
            Instruction body = tci.getBody();
            return CodeGenerationOptUtils.getStreamLength(body, benv);
        }
        return -1;
    }

    private static int numberOfElements(Instruction instr, BindingEnvironment benv) {
        if (instr instanceof LiteralInstruction) {
            return 1;
        }
        return CodeGenerationOptUtils.getStreamLength(instr, benv);
    }
}

