/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.codegen;

import com.ibm.xltxe.rnm1.xylem.IntegerSettings;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.JavaCSettings;
import com.ibm.xltxe.rnm1.xylem.codegen.LazyStreamFixedIndexOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.StreamInADTOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.StreamOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.bcel.ClassCollector;
import com.ibm.xltxe.rnm1.xylem.config.Settings;
import com.ibm.xml.ras.LoggerUtil;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CodeGenerationSettings
extends Settings
implements IntegerSettings {
    private static final Logger s_logger = LoggerUtil.getLogger(CodeGenerationSettings.class);
    private static final String s_className = CodeGenerationSettings.class.getName();
    protected boolean m_makeAllMethodsStatic = true;
    protected boolean m_multiClassMethodOutput = true;
    protected boolean m_singleThreadPerInstance = true;
    protected boolean m_enableTracing = false;
    protected boolean m_obfuscateFunctionNames = false;
    protected int m_maxFunctionsPerPartition = 800;
    protected boolean m_suppressComments = true;
    public boolean m_dumpxylem = false;
    protected int m_targetLanguage = 3;
    protected JavaCSettings m_javaCSettings = new JavaCSettings();
    protected int m_postReductionSplitLimit = 0;
    protected boolean m_threadSafe = false;
    protected boolean m_byteCodeLineNumbers = false;
    protected boolean m_bufferDiagnostics = false;
    protected ClassCollector m_classCollector = null;
    protected boolean m_bcelAutoSplitFunctions = false;
    protected boolean m_emitAutoSplitWarning = true;
    protected int m_reservedBytes = 0;
    protected boolean m_orderSafeSplit = true;
    protected boolean m_externalizeStrings = false;
    protected boolean m_outlineStreamAppend = false;
    protected boolean m_mixedModeModuleCompilation = false;
    protected List<String> m_mixedModeFunctionExcludeList = null;
    protected boolean m_arbitraryPrecision = false;
    protected boolean m_overflowDetection = false;
    protected CodeGenerationOptimizationStyle[] m_optGenerationStyles;
    public static final int s_cpp = 1;
    public static final int s_cxo = 2;
    public static final int s_javaSource = 3;
    public static final int s_bcel = 4;

    public CodeGenerationSettings(CodeGenerationOptimizationStyle[] optGenStyles) {
        this.m_optGenerationStyles = optGenStyles;
    }

    public CodeGenerationSettings() {
        this.m_optGenerationStyles = new CodeGenerationOptimizationStyle[]{StreamOptimizationStyle.s_streamOptimizationStyle, LazyStreamFixedIndexOptimizationStyle.s_lazyStreamFixedIndexOptimizationStyle, StreamInADTOptimizationStyle.s_streamInADTOptimizationStyle};
    }

    public void setMakeAllMethodsStatic(boolean b) {
        this.m_makeAllMethodsStatic = b;
    }

    public boolean isMakeAllMethodsStatic() {
        return this.m_makeAllMethodsStatic;
    }

    public void setTargetLanguage(int n2) {
        this.m_targetLanguage = n2;
    }

    public int getTargetLanguage() {
        return this.m_targetLanguage;
    }

    public void setSuppressComments(boolean b) {
        this.m_suppressComments = b;
    }

    public boolean isSuppressComments() {
        return this.m_suppressComments;
    }

    public void setMultiPartitionOutput(boolean b) {
        this.m_multiClassMethodOutput = b;
    }

    public boolean isMultiPartitionOutput() {
        return this.m_multiClassMethodOutput;
    }

    public void setSingleThreadPerInstance(boolean b) {
        this.m_singleThreadPerInstance = b;
    }

    public boolean isSingleThreadPerInstance() {
        return this.m_singleThreadPerInstance;
    }

    public void setFunctionCallTracing(boolean b) {
        this.m_enableTracing = b;
    }

    public boolean isFunctionCallTracing() {
        return this.m_enableTracing;
    }

    public void setObfuscateFunctionNames(boolean b) {
        this.m_obfuscateFunctionNames = b;
    }

    public boolean isObfuscateFunctionNames() {
        return this.m_obfuscateFunctionNames;
    }

    public void setMaxFunctionsPerPartition(int n2) {
        this.m_maxFunctionsPerPartition = n2;
    }

    public int getMaxFunctionsPerPartition() {
        return this.m_maxFunctionsPerPartition;
    }

    public JavaCSettings getJavaCSettings() {
        return this.m_javaCSettings;
    }

    public boolean getBCELAutoSplitFunctions() {
        return this.m_bcelAutoSplitFunctions;
    }

    public void setBCELAutoSplitFunctions(boolean bcelAutoSplitFunctions) {
        this.m_bcelAutoSplitFunctions = bcelAutoSplitFunctions;
    }

    public boolean getEmitAutoSplitWarning() {
        return this.m_emitAutoSplitWarning;
    }

    public void setEmitAutoSplitWarning(boolean emitAutoSplitWarning) {
        this.m_emitAutoSplitWarning = emitAutoSplitWarning;
    }

    public int getReservedBytes() {
        return this.m_reservedBytes;
    }

    public void setReservedBytes(int bytes2) {
        this.m_reservedBytes = bytes2;
    }

    public boolean getOrderSafeSplit() {
        return this.m_orderSafeSplit;
    }

    public void setOrderSafeSplit(boolean orderLetChains) {
        this.m_orderSafeSplit = orderLetChains;
    }

    public boolean isExternalizeStrings() {
        return this.m_externalizeStrings;
    }

    public void setExternalizeStrings(boolean externalizeStrings) {
        this.m_externalizeStrings = externalizeStrings;
    }

    public boolean isMixedModeModuleCompilation() {
        return this.m_mixedModeModuleCompilation;
    }

    public void setMixedModeModuleCompilation(boolean mixedModeModuleCompilation) {
        this.m_mixedModeModuleCompilation = mixedModeModuleCompilation;
    }

    public List<String> getMixedModeFunctionExcludeList() {
        return this.m_mixedModeFunctionExcludeList;
    }

    public void setMixedModeFunctionExcludeList(List<String> l) {
        this.m_mixedModeFunctionExcludeList = l;
    }

    public boolean isOutlineStreamAppend() {
        return this.m_outlineStreamAppend;
    }

    public void setOutlineStreamAppend(boolean outlineStreamAppend) {
        this.m_outlineStreamAppend = outlineStreamAppend;
    }

    public int parseOption(String[] args, int i) {
        if (args[i].equals("-help") || args[i].equals("-?") || args[i].equals("-h")) {
            System.out.println("\t[-language java|cpp]\n\t[-disablejavac]\n\t[-dumpxylem]\n\t[-suppressComments]\n\t[-combinePartitions]\n\t[-enableTracing]\n\t[-newsplit n]\n\t[-maxfunctionsperpartition n]\n\t[-reservebytes bytes]\n\t[-generateBCEL]\n\t[-autosplitBCEL]\n\t[-obfuscate]\n\t[-externStrings]\n\t[-outlineAppend]\n\t[-generateCXO]\n");
            return i;
        }
        if (args[i].equals("-language")) {
            if (++i == args.length) {
                s_logger.logp(Level.SEVERE, s_className, "parseOption", "-language missing parameter");
                return -1;
            }
            if (!args[i].equals("java")) {
                if (args[i].equals("cpp")) {
                    this.setTargetLanguage(1);
                } else {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "invalid language: " + args[i]);
                    return -1;
                }
            }
            return i;
        }
        if (args[i].equals("-suppressComments")) {
            this.setSuppressComments(true);
            return i;
        }
        if (args[i].equals("-combinepartitions")) {
            this.setMultiPartitionOutput(false);
            return i;
        }
        if (args[i].equals("-enabletracing")) {
            this.setFunctionCallTracing(true);
            return i;
        }
        if (args[i].equals("-newsplit")) {
            if (++i == args.length) {
                s_logger.logp(Level.SEVERE, s_className, "parseOption", "-newsplit missing parameter");
                return -1;
            }
            try {
                this.setPostReductionSplitLimit(Integer.parseInt(args[i]));
            }
            catch (NumberFormatException nfe) {
                s_logger.logp(Level.SEVERE, s_className, "parseOption", "invalid split limit: " + args[i]);
                return -1;
            }
            return i;
        }
        if (args[i].equals("-generateBCEL")) {
            this.setTargetLanguage(4);
            return i;
        }
        if (args[i].equals("-generateCXO")) {
            this.setTargetLanguage(2);
            return i;
        }
        if (args[i].equals("-autosplitBCEL")) {
            this.setBCELAutoSplitFunctions(true);
            return i;
        }
        if (args[i].equals("-obfuscate")) {
            this.setObfuscateFunctionNames(true);
            return i;
        }
        if (args[i].equals("-externStrings")) {
            this.setExternalizeStrings(true);
            return i;
        }
        if (args[i].equals("-outlineAppend")) {
            this.setOutlineStreamAppend(true);
            return i;
        }
        if (args[i].equals("-maxfunctionsperpartition")) {
            if (++i == args.length) {
                s_logger.logp(Level.SEVERE, s_className, "parseOption", "-maxfunctionsperpartition missing parameter");
                return -1;
            }
            this.setMaxFunctionsPerPartition(Integer.parseInt(args[i]));
            return i;
        }
        if (args[i].equals("-reservebytes")) {
            if (++i == args.length) {
                s_logger.logp(Level.SEVERE, s_className, "parseOption", "-reservebytes missing parameter");
                return -1;
            }
            this.setReservedBytes(Integer.parseInt(args[i]));
            return i;
        }
        if (args[i].equals("-disablejavac")) {
            this.getJavaCSettings().setJavaCDisabled(true);
            return i;
        }
        if (args[i].equals("-dumpxylem")) {
            this.m_dumpxylem = true;
            return i;
        }
        return -2;
    }

    public int getPostReductionSplitLimit() {
        return this.m_postReductionSplitLimit;
    }

    public void setPostReductionSplitLimit(int n2) {
        this.m_postReductionSplitLimit = n2;
    }

    public boolean isThreadSafe() {
        return this.m_threadSafe;
    }

    public void setThreadSafe(boolean b) {
        this.m_threadSafe = b;
    }

    public boolean isByteCodeLineNumbers() {
        return this.m_byteCodeLineNumbers;
    }

    public boolean isBufferDiagnostics() {
        return this.m_bufferDiagnostics;
    }

    public void setBCELClassCollector(ClassCollector classCollector) {
        this.m_classCollector = classCollector;
    }

    public ClassCollector getBCELClassCollector() {
        return this.m_classCollector;
    }

    @Override
    public boolean getArbitraryPrecision() {
        return this.m_arbitraryPrecision;
    }

    @Override
    public boolean getOverflowDetection() {
        return this.m_overflowDetection;
    }

    @Override
    public void setArbitraryPrecision(boolean flag) {
        this.m_arbitraryPrecision = flag;
    }

    @Override
    public void setOverflowDetection(boolean flag) {
        this.m_overflowDetection = flag;
    }

    public void setCodeGenptimizationStyles(CodeGenerationOptimizationStyle[] optGenStyles) {
        this.m_optGenerationStyles = optGenStyles;
    }

    public CodeGenerationOptimizationStyle[] getCodeGenOptimizationStyles() {
        return this.m_optGenerationStyles;
    }
}

