/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.codegen;

import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgVariable;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.ConventionalGenerationState;
import com.ibm.xltxe.rnm1.xylem.codegen.ExtantGenerationState;
import com.ibm.xltxe.rnm1.xylem.codegen.GenerationState;
import com.ibm.xltxe.rnm1.xylem.codegen.IStreamInADTOptimizationInstruction;
import com.ibm.xltxe.rnm1.xylem.codegen.IStreamOptimizationInstruction;
import com.ibm.xltxe.rnm1.xylem.codegen.StreamInADTOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.StreamInADTOptimizedGenerationState;
import com.ibm.xltxe.rnm1.xylem.codegen.StreamOptimizedGenerationState;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.ForkStack;
import com.ibm.xltxe.rnm1.xylem.types.AbstractDataType;
import com.ibm.xltxe.rnm1.xylem.types.IConstructableAsStreamType;
import com.ibm.xltxe.rnm1.xylem.types.NamedType;
import com.ibm.xltxe.rnm1.xylem.types.StreamType;
import com.ibm.xltxe.rnm1.xylem.types.UnitType;
import com.ibm.xltxe.rnm1.xylem.utils.HiddenOptions;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.SessionContext;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class CodeGenerationTracker {
    protected HashMap m_bindings = new HashMap(63);
    protected CodeGenerationTracker m_parent = null;
    protected HashMap m_bindingDependencies;
    public TypeEnvironment m_typeEnvironment;
    public Function m_function;
    public BindingEnvironment m_bindingEnvironment;
    private static final Logger s_logger = LoggerUtil.getLogger(CodeGenerationTracker.class);
    private static final String s_className = CodeGenerationTracker.class.getName();
    private final SessionContext _sessionContext;
    private final CodeGenerationOptimizationStyle[] m_optimizationStyles;
    public final Hashtable<String, String> _executablesTable;
    public final Hashtable<String, FcgVariable> _globalVars;
    protected int m_registerCounter = 1;
    public static final String STABLE_CODE_ORDER_OPTION = "stableCodeOrder";
    public static final boolean sStableCodeOrder = HiddenOptions.wasSpecified("stableCodeOrder") && !HiddenOptions.optionValueIs("stableCodeOrder", "off");
    public static boolean DORELEASEMANAGEMENT = !HiddenOptions.wasSpecified("doreleasemanagement") || !HiddenOptions.optionValueIs("doreleasemanagement", "off");

    public CodeGenerationTracker(HashMap bindingDependencies, Function f2, CodeGenerationOptimizationStyle[] optimizationStyles, SessionContext session) {
        this(bindingDependencies, f2, optimizationStyles, 1, session, new Hashtable<String, String>(), new Hashtable<String, FcgVariable>());
    }

    private CodeGenerationTracker(HashMap bindingDependencies, Function f2, CodeGenerationOptimizationStyle[] optimizationStyles, int registerCount, SessionContext session, Hashtable<String, String> executablesTable, Hashtable<String, FcgVariable> globalVars) {
        this.m_bindingDependencies = bindingDependencies;
        this.m_typeEnvironment = f2.getTypeEnvironment();
        this.m_function = f2;
        this.m_bindingEnvironment = f2.getBindingEnvironment();
        this.m_registerCounter = registerCount;
        this._sessionContext = session;
        this.m_optimizationStyles = optimizationStyles;
        this._executablesTable = executablesTable;
        this._globalVars = globalVars;
    }

    public int allocateRegister() {
        return this.m_registerCounter++;
    }

    public int allocateRegister(com.ibm.xltxe.rnm1.xtq.bcel.generic.Type t) {
        int x = this.m_registerCounter;
        this.m_registerCounter += t.getSize();
        return x;
    }

    protected HashMap getBindingDependencies() {
        if (this.m_bindingDependencies.isEmpty()) {
            this.m_function.determineDataDependencies(null, this.m_bindingDependencies);
        }
        return this.m_bindingDependencies;
    }

    public boolean isBindingUsed(IBinding b) {
        HashMap bindingDependencies = this.getBindingDependencies();
        return bindingDependencies.containsKey(b) && ((List)bindingDependencies.get(b)).size() > 0;
    }

    public int getBindingUseCount(IBinding b) {
        HashMap bindingDependencies = this.getBindingDependencies();
        if (!bindingDependencies.containsKey(b)) {
            return 0;
        }
        return ((List)bindingDependencies.get(b)).size();
    }

    public CodeGenerationTracker cloneBranch() {
        CodeGenerationTracker cgt = new CodeGenerationTracker(this.m_bindingDependencies, this.m_function, this.m_optimizationStyles, this.m_registerCounter, this._sessionContext, this._executablesTable, this._globalVars);
        cgt.m_parent = this;
        return cgt;
    }

    public void registerBinding(IBinding b, Instruction n2) {
        HashMap bindingDependencies = this.getBindingDependencies();
        List dependencies = (List)bindingDependencies.get(b);
        if (dependencies != null) {
            for (int i = 0; i < this.m_optimizationStyles.length; ++i) {
                GenerationState genState = this.m_optimizationStyles[i].getSupportedGenerationState(b, n2, dependencies, this.m_typeEnvironment, this.m_bindingEnvironment);
                if (genState == null) continue;
                this.registerBinding(b, genState);
                return;
            }
        }
        ConventionalGenerationState cgs = new ConventionalGenerationState(b, n2, dependencies == null ? -1 : dependencies.size());
        this.registerBinding(b, cgs);
    }

    public void registerExtantBinding(IBinding b, String varName) {
        this.m_bindings.put(b, new ExtantGenerationState(b, varName));
    }

    public void registerBinding(IBinding b, GenerationState gs) {
        HashMap bindingDependencies;
        List list;
        if (gs instanceof ConventionalGenerationState && (list = (List)(bindingDependencies = this.getBindingDependencies()).get(b)) != null && list.size() <= 1) {
            ((ConventionalGenerationState)gs).setOneTime();
        }
        this.m_bindings.put(b, gs);
    }

    public GenerationState getGenerationState(IBinding b) {
        GenerationState gs = (GenerationState)this.m_bindings.get(b);
        if (gs == null && this.m_parent != null && (gs = this.m_parent.getGenerationState(b)) != null) {
            gs = (GenerationState)gs.clone();
            this.m_bindings.put(b, gs);
        }
        return gs;
    }

    public GenerationState getGenerationState(Instruction x) {
        return this.getGenerationState(((IdentifierInstruction)x).getBinding(this.m_bindingEnvironment));
    }

    public void generateAddToStream(Instruction n2, String stream2, IConstructableAsStreamType streamType, FcgCodeGenHelper cgh, FcgInstructionList il, boolean tailPosition, ValueGenStyle valueStyleRequest) {
        Type itemToAppendType = n2.getCachedType();
        if (itemToAppendType == null) {
            itemToAppendType = n2.getType(this.m_typeEnvironment, this.m_bindingEnvironment);
        }
        assert (itemToAppendType != null);
        if (n2 instanceof IdentifierInstruction) {
            IdentifierInstruction ii = (IdentifierInstruction)n2;
            ConventionalGenerationState cgs = (ConventionalGenerationState)this.getGenerationState(ii.getBinding(this.m_bindingEnvironment));
            if (cgs == null) {
                throw new XylemError("ERR_SYSTEM", "Null CGS for ii=" + ii);
            }
            if (cgs.isGenerated() || !(cgs instanceof StreamOptimizedGenerationState)) {
                FcgType fcgTypeElement = cgs.generate(cgh, this, tailPosition, il, ValueGenStyle.DEFAULT, false);
                streamType.generateAddMultipleElementsToStream(cgh, this, il, stream2, itemToAppendType, fcgTypeElement);
            } else {
                ((StreamOptimizedGenerationState)cgs).generateAddToStream(cgh, il, this, stream2, streamType, tailPosition, valueStyleRequest);
            }
        } else {
            CodeGenerationOptimizationStyle[] codeGenOpts = streamType.getPotentialStreamOptimizations();
            boolean foundCodeGenOpt = false;
            for (int i = 0; i < codeGenOpts.length; ++i) {
                if (!n2.supportsCodeGenerationOptimization(codeGenOpts[i], this.m_typeEnvironment, this.m_bindingEnvironment)) continue;
                foundCodeGenOpt = true;
                IStreamOptimizationInstruction streamOptInst = (IStreamOptimizationInstruction)((Object)n2);
                streamOptInst.generateCodeWithStreamOptimization(cgh, il, stream2, streamType, this, tailPosition, ValueGenStyle.DEFAULT);
                break;
            }
            if (!foundCodeGenOpt) {
                FcgType fcgTypeElement = n2.generateCode(cgh, this, null, false, il, ValueGenStyle.DEFAULT);
                streamType.generateAddMultipleElementsToStream(cgh, this, il, stream2, itemToAppendType, fcgTypeElement);
            }
        }
    }

    public void generateAddElementToStream(Instruction n2, String stream2, IConstructableAsStreamType streamType, FcgCodeGenHelper cgh, FcgInstructionList il, boolean tailPosition) {
        Type filType = this.getType(n2);
        if (n2 instanceof IdentifierInstruction) {
            IdentifierInstruction ii = (IdentifierInstruction)n2;
            ConventionalGenerationState cgs = (ConventionalGenerationState)this.getGenerationState(ii.getBinding(this.m_bindingEnvironment));
            if (cgs == null) {
                throw new XylemError("ERR_SYSTEM", "Null CGS for ii=" + ii);
            }
            if (cgs.isGenerated() || !(cgs instanceof StreamOptimizedGenerationState)) {
                FcgType elemType = cgs.generate(cgh, this, tailPosition, il, ValueGenStyle.DEFAULT, false);
                streamType.generateAddElementToStream(cgh, il, stream2, filType, elemType, this);
            } else {
                ((StreamOptimizedGenerationState)cgs).generateAddToStream(cgh, il, this, stream2, streamType, tailPosition, ValueGenStyle.DEFAULT);
            }
        } else {
            CodeGenerationOptimizationStyle[] codeGenOpts = streamType.getPotentialStreamOptimizations();
            boolean foundCodeGenOpt = false;
            for (int i = 0; i < codeGenOpts.length; ++i) {
                if (!n2.supportsCodeGenerationOptimization(codeGenOpts[i], this.m_typeEnvironment, this.m_bindingEnvironment)) continue;
                foundCodeGenOpt = true;
                IStreamOptimizationInstruction streamOptInst = (IStreamOptimizationInstruction)((Object)n2);
                streamOptInst.generateCodeWithStreamOptimization(cgh, il, stream2, streamType, this, tailPosition, ValueGenStyle.DEFAULT);
                break;
            }
            if (!foundCodeGenOpt) {
                FcgType elemType = n2.generateCode(cgh, this, null, false, il, ValueGenStyle.DEFAULT);
                streamType.generateAddElementToStream(cgh, il, stream2, filType, elemType, this);
            }
        }
    }

    public FcgType generateAddToStreamInADT(Instruction n2, String streamName, Binding memberInADT, FcgCodeGenHelper cgh, FcgInstructionList il, boolean tailPosition) {
        IdentifierInstruction ii = (IdentifierInstruction)n2;
        GenerationState gs = this.getGenerationState(ii.getBinding(this.m_bindingEnvironment));
        try {
            if (!(gs instanceof StreamInADTOptimizedGenerationState) && ((ConventionalGenerationState)gs).getNumDependencies() == 1 && ((ConventionalGenerationState)gs).m_instruction.supportsCodeGenerationOptimization(StreamInADTOptimizationStyle.s_streamInADTOptimizationStyle, this.m_typeEnvironment, this.m_bindingEnvironment)) {
                Instruction inst = ((ConventionalGenerationState)gs).m_instruction;
                return ((IStreamInADTOptimizationInstruction)((Object)inst)).generateCode(cgh, il, streamName, memberInADT, this, ((IStreamInADTOptimizationInstruction)((Object)inst)).canGenerateObjectless(this.m_typeEnvironment), tailPosition);
            }
            StreamInADTOptimizedGenerationState siadtogs = (StreamInADTOptimizedGenerationState)gs;
            if (siadtogs.isGenerated()) {
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                    s_logger.logp(Level.FINE, s_className, "generateAddToStreamInADT", "ADT optimization could not occur unfortunately");
                }
                StreamType type2 = (StreamType)memberInADT.getBindingType();
                FcgType fcgType = type2.getFCGType(cgh);
                FcgClassReferenceType classType = (FcgClassReferenceType)siadtogs.generate(cgh, this, tailPosition, il, ValueGenStyle.DEFAULT_NO_PUSH, false);
                NamedType nt = (NamedType)this.resolveType(n2);
                AbstractDataType.Constructor c = nt.resolveNameToADT((Module)this.getCurrentModule()).m_constructors[0];
                Type itemTypeToAppend = gs.m_binding.getBindingType();
                FcgType fcgTypeElement = il.loadInstanceField(classType, c.getConstructorQualifiedFieldName(c.findBinding(memberInADT), cgh), fcgType);
                type2.generateAddMultipleElementsToStream(cgh, this, il, streamName, itemTypeToAppend, fcgTypeElement);
                return fcgType;
            }
            if (!siadtogs.m_member.getName().equals(memberInADT.getName().toString())) {
                throw new XylemError("ERR_SYSTEM", "Add to stream in ADT called for a member that was not expected");
            }
            return siadtogs.generateAddToStreamInADT(cgh, il, this, streamName, tailPosition);
        }
        catch (ClassCastException e) {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "generateAddToStreamInADT", "could not generate stream-in-adt state for " + ii + " ");
            }
            throw e;
        }
    }

    public boolean isADTBindingGeneratedObjectless(Instruction n2) {
        IdentifierInstruction ii = (IdentifierInstruction)n2;
        GenerationState gs = this.getGenerationState(ii.getBinding(this.m_bindingEnvironment));
        if (!(gs instanceof StreamInADTOptimizedGenerationState)) {
            return false;
        }
        StreamInADTOptimizedGenerationState siadtogs = (StreamInADTOptimizedGenerationState)gs;
        return siadtogs.isObjectless();
    }

    public Type resolveType(Instruction n2) {
        return this.getType(n2).resolveType(this.m_typeEnvironment);
    }

    private Type getType(Instruction n2) {
        return n2.getType(this.m_typeEnvironment, this.m_bindingEnvironment);
    }

    public Module getCurrentModule() {
        return this.m_typeEnvironment.getModule();
    }

    public void generateFreeBindings(Instruction instruction2, FcgCodeGenHelper cgh, FcgInstructionList il, IBinding toSkip, boolean tailPosition, boolean screenVoidReturnMethods, ValueGenStyle valueStyleRequest) {
        Iterator<IBinding> j = this.getNonLiteralFreeBindingsIterator(instruction2);
        while (j.hasNext()) {
            IBinding b = j.next();
            if (b == toSkip) continue;
            Type t = b.getBindingType(this.m_typeEnvironment, this.m_bindingEnvironment);
            if (screenVoidReturnMethods && t == UnitType.s_unitType) continue;
            if (!screenVoidReturnMethods && t != UnitType.s_unitType) {
                FcgType out = this.generateConventionally(b, cgh, tailPosition, il, valueStyleRequest, false);
                if (out == FcgType.VOID) continue;
                String tmp = cgh.generateNewLocalVariableName();
                il.defineVar(out, tmp, true);
                continue;
            }
            this.generateConventionally(b, cgh, tailPosition, il, valueStyleRequest, true);
        }
    }

    private Iterator<IBinding> getNonLiteralFreeBindingsIterator(Instruction instruction2) {
        HashSet set2 = new HashSet();
        instruction2.accumulateNonLiteralFreeBindings(set2, this.m_bindingEnvironment);
        Iterator<IBinding> j = set2.iterator();
        if (sStableCodeOrder) {
            j = this.makeStableList(j);
        }
        return j;
    }

    private Iterator<IBinding> makeStableList(Iterator<IBinding> j) {
        TreeMap<String, IBinding> sortedList = new TreeMap<String, IBinding>();
        while (j.hasNext()) {
            IBinding b = j.next();
            sortedList.put(b.getName().toString(), b);
        }
        j = sortedList.values().iterator();
        return j;
    }

    public FcgType generateConventionally(IBinding b, FcgCodeGenHelper cgh, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest, boolean onlyForVariable) {
        ConventionalGenerationState cgs = (ConventionalGenerationState)this.getGenerationState(b);
        if (cgs == null) {
            throw new XylemError("ERR_SYSTEM", "ConventionalGenerationState is null, for b=" + b);
        }
        FcgType fcgType = cgs.generate(cgh, this, tailPosition, il, valueStyleRequest, onlyForVariable);
        return fcgType;
    }

    public FcgType generateConventionally(Instruction n2, FcgCodeGenHelper cgh, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        if (n2 instanceof LiteralInstruction) {
            return n2.generateCode(cgh, this, null, tailPosition, il, valueStyleRequest);
        }
        if (n2 instanceof IdentifierInstruction) {
            IdentifierInstruction ii = (IdentifierInstruction)n2;
            IBinding tmp = ii.getBinding(this.m_bindingEnvironment);
            return this.generateConventionally(tmp, cgh, tailPosition, il, valueStyleRequest, false);
        }
        throw new XylemError("ERR_SYSTEM", "should not occur in reduced code " + n2 + " " + n2.getClass());
    }

    public FcgType boxIfNeeded(Instruction n2, FcgCodeGenHelper cgh, FcgInstructionList il, FcgType fcgResultType) {
        Type t1 = n2.evaluateType(this.m_function);
        FcgType expectedType = t1.getFCGType(cgh);
        if (!fcgResultType.equals(expectedType)) {
            fcgResultType = il.convertExpr(fcgResultType, expectedType);
        }
        return fcgResultType;
    }

    public FcgType getResolvedType(FcgCodeGenHelper cgh, Type typeIn) {
        Type type2 = typeIn.resolveType(this.m_typeEnvironment);
        if (type2 == null) {
            throw new XylemError("ERR_SYSTEM", "type not found for " + typeIn);
        }
        FcgType fcgType = type2.getFCGType(cgh);
        return fcgType;
    }

    public Function getFunction() {
        return this.m_function;
    }

    public SessionContext getSessionContext() {
        return this._sessionContext;
    }

    public FcgClassReferenceType generateRefToForkStack(FcgCodeGenHelper cgh, FcgInstructionList il) {
        if (!DORELEASEMANAGEMENT) {
            return null;
        }
        FcgClassReferenceType forkStackContainerClass = cgh.getForkStackOwnerClass();
        assert (forkStackContainerClass != null);
        if (forkStackContainerClass != null) {
            FcgClassReferenceType thisClass = cgh.loadThisVar(il);
            assert (thisClass != null);
            if (thisClass != null) {
                FcgClassReferenceType forkType = cgh.getClassReferenceType(ForkStack.class.getName());
                String forkStackVarName = "__ForkStack";
                il.loadInstanceField(forkStackContainerClass, forkStackVarName, forkType);
            }
            return thisClass;
        }
        return null;
    }
}

