/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.codegen;

import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.types.CharType;

public class ConstantStringManager
extends Optimizer {
    public int m_count;

    @Override
    protected Instruction optimizeStep(Instruction n2) {
        if (n2 instanceof StreamInstruction) {
            StreamInstruction si = (StreamInstruction)n2;
            int c = si.getChildInstructionCount();
            if (si.isString()) {
                this.m_count += c;
            } else {
                for (int i = 0; i < c; ++i) {
                    Instruction child2 = si.getChildInstruction(i);
                    if (child2 instanceof LiteralInstruction) {
                        if (!(((LiteralInstruction)child2).getType() instanceof CharType)) continue;
                        ++this.m_count;
                        continue;
                    }
                    if (!(child2 instanceof StreamInstruction)) continue;
                    this.optimizeStep(child2);
                }
            }
            return null;
        }
        return super.optimizeStep(n2);
    }

    public static int countConstantStrings(Module m) {
        ConstantStringManager csc = new ConstantStringManager();
        m.optimize(csc);
        System.err.println(">> count: " + csc.m_count);
        return csc.m_count;
    }
}

