/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.codegen;

import com.ibm.xltxe.rnm1.fcg.FcgAttrs;
import com.ibm.xltxe.rnm1.fcg.FcgClassGen;
import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgMethodGen;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgVariable;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.FunctionGenerationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.interpreter.ForkStack;
import java.util.ArrayList;

public class ConventionalFunctionGenerationStyle
extends FunctionGenerationStyle {
    public ConventionalFunctionGenerationStyle(Function fi) {
        super(fi);
    }

    @Override
    public void generateFunction(FcgCodeGenHelper cgh, CodeGenerationTracker cgt) {
        FcgClassGen classGen = cgh.getCurrentFcgClassGen();
        ArrayList paramNames = new ArrayList();
        ArrayList paramTypes = new ArrayList();
        ConventionalFunctionGenerationStyle.generateStaticThisIfNeeded(cgh, paramNames, paramTypes);
        this.generateParamSpecs(cgh, paramNames, paramTypes, cgt);
        String[] paramNames2 = new String[paramNames.size()];
        paramNames.toArray(paramNames2);
        FcgType[] paramTypes2 = new FcgType[paramTypes.size()];
        paramTypes.toArray(paramTypes2);
        Function f2 = this.m_function;
        TypeEnvironment tenv = this.prepareTypeEnvironment();
        Type returnType = f2.getReturnType().resolveType(tenv);
        FcgType fcgRetType = returnType.getFCGType(cgh);
        f2.switchOverTypeEnvironment(tenv);
        String methName = this.generatedFunctionName(cgh);
        FcgClassReferenceType clazz = cgh.getClassReferenceType(cgh.getClassName());
        FcgMethodGen mg = cgh.getSettings().isMakeAllMethodsStatic() ? classGen.newMethodGen(FcgAttrs.PUBLIC_STATIC_FINAL, fcgRetType, methName) : classGen.newMethodGen(FcgAttrs.PUBLIC_FINAL, fcgRetType, methName);
        FcgInstructionList il = mg.getInstructionList();
        for (int p = 0; p < paramNames2.length; ++p) {
            mg.addParameter(paramTypes2[p], paramNames2[p]);
        }
        Instruction body = f2.getBody();
        il.beginMethod();
        int foundForkCount = f2.getFoundForkCount();
        boolean shouldBracketWithForkStackFrame = foundForkCount > 0 && !f2.getName().startsWith("xslt2$") ? ConventionalFunctionGenerationStyle.startForkScope(cgh, il, true) : false;
        il.beginConditionalLoop("__tailrecurse__", 0);
        FcgType fcgBodyType = body.generateCode(cgh, cgt, null, true, il, ValueGenStyle.DEFAULT);
        if (shouldBracketWithForkStackFrame) {
            ConventionalFunctionGenerationStyle.popForkScope(cgh, cgt, fcgRetType, il, returnType);
        }
        FcgType fcgRetTypeBoxed = returnType.genBoxIfNeeded(cgh, cgt, il, fcgBodyType);
        il.returnInstruction(fcgRetTypeBoxed);
        il.endConditionalLoop();
        il.endMethod();
    }

    public static void popForkScope(FcgCodeGenHelper cgh, CodeGenerationTracker cgt, FcgType fcgRetType, FcgInstructionList il, Type returnType) {
        if (!CodeGenerationTracker.DORELEASEMANAGEMENT) {
            return;
        }
        boolean resultForkable = returnType.isForkReleaseManaged(cgt);
        FcgVariable escapingValue = resultForkable ? il.defineVar(fcgRetType, cgh.generateNewLocalVariableName(), true) : null;
        FcgClassReferenceType thisClass = ConventionalFunctionGenerationStyle.generateRefToForkStack(cgh, il);
        if (thisClass != null) {
            if (resultForkable && escapingValue != null) {
                il.loadVar(escapingValue);
                FcgClassReferenceType forkType = cgh.getClassReferenceType(ForkStack.class.getName());
                FcgType[] argTypes = new FcgType[]{cgh.getClassReferenceType(Object.class.getName())};
                il.invokeInstanceMethodStmt(forkType, "popForkScope", (FcgType)FcgType.VOID, argTypes);
                il.loadVar(escapingValue);
            } else {
                FcgClassReferenceType forkType = cgh.getClassReferenceType(ForkStack.class.getName());
                il.invokeInstanceMethodStmt(forkType, "popForkScope", (FcgType)FcgType.VOID, 0);
            }
        }
    }

    public static void popForkScope(FcgCodeGenHelper cgh, FcgInstructionList il) {
        if (!CodeGenerationTracker.DORELEASEMANAGEMENT) {
            return;
        }
        FcgClassReferenceType thisClass = ConventionalFunctionGenerationStyle.generateRefToForkStack(cgh, il);
        if (thisClass != null) {
            FcgClassReferenceType forkType = cgh.getClassReferenceType(ForkStack.class.getName());
            il.invokeInstanceMethodStmt(forkType, "popForkScope", (FcgType)FcgType.VOID, 0);
        }
    }

    public static FcgClassReferenceType generateRefToForkStack(FcgCodeGenHelper cgh, FcgInstructionList il) {
        if (!CodeGenerationTracker.DORELEASEMANAGEMENT) {
            return null;
        }
        FcgClassReferenceType forkStackContainerClass = cgh.getForkStackOwnerClass();
        assert (forkStackContainerClass != null);
        if (forkStackContainerClass != null) {
            FcgClassReferenceType thisClass = cgh.loadThisVar(il);
            assert (thisClass != null);
            if (thisClass != null) {
                FcgClassReferenceType forkType = cgh.getClassReferenceType(ForkStack.class.getName());
                String forkStackVarName = "__ForkStack";
                il.loadInstanceField(forkStackContainerClass, forkStackVarName, forkType);
            }
            return thisClass;
        }
        return null;
    }

    public static boolean startForkScope(FcgCodeGenHelper cgh, FcgInstructionList il, boolean shouldBracketWithForkStackFrame) {
        if (!CodeGenerationTracker.DORELEASEMANAGEMENT) {
            return false;
        }
        FcgClassReferenceType thisClass = ConventionalFunctionGenerationStyle.generateRefToForkStack(cgh, il);
        if (thisClass != null) {
            FcgClassReferenceType forkType = cgh.getClassReferenceType(ForkStack.class.getName());
            il.invokeInstanceMethodStmt(forkType, "pushForkScope", (FcgType)FcgType.VOID, 0);
        } else {
            shouldBracketWithForkStackFrame = false;
        }
        return shouldBracketWithForkStackFrame;
    }

    @Override
    public String generatedFunctionName(FcgCodeGenHelper cgh) {
        return this.m_function.generateFunctionName(cgh);
    }
}

