/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.codegen;

import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgVariable;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.GenerationState;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;

public class ConventionalGenerationState
extends GenerationState {
    protected Instruction m_instruction;
    protected int m_numDependencies;
    protected String m_varName = null;
    protected FcgVariable m_varFCG = null;
    protected FcgVariable m_assertedVarFCG = null;
    protected int m_hits = 0;
    protected boolean m_oneTime = false;
    protected boolean m_mustFork = false;
    protected Type m_type = null;
    protected FcgType m_varFcgType = null;

    protected void setVarName(String name2) {
        this.m_varName = name2;
    }

    public ConventionalGenerationState(IBinding b, Instruction n2, int numDependencies) {
        super(b);
        if (b instanceof Binding) {
            this.m_type = ((Binding)b).getBindingType();
        }
        this.m_instruction = n2;
        this.m_numDependencies = numDependencies;
    }

    public void setOneTime() {
        this.m_oneTime = true;
    }

    public boolean isOneTime() {
        return this.m_oneTime;
    }

    public final Instruction getInstruction() {
        return this.m_instruction;
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.m_instruction;
    }

    @Override
    public boolean isGenerated() {
        return this.m_varName != null;
    }

    public String getVariableName() {
        return this.m_varName;
    }

    public int getNumDependencies() {
        return this.m_numDependencies;
    }

    public int getHits() {
        return this.m_hits;
    }

    @Override
    public Object clone() {
        ConventionalGenerationState cgs = new ConventionalGenerationState(this.getBinding(), this.m_instruction, this.m_numDependencies);
        cgs.setVarName(this.m_varName);
        cgs.m_varFCG = this.m_varFCG;
        cgs.m_varFcgType = this.m_varFcgType;
        cgs.m_oneTime = this.m_oneTime;
        return cgs;
    }

    public FcgType generate(FcgCodeGenHelper cgh, CodeGenerationTracker cgt, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest, boolean onlyToVariable) {
        int nElemEnd;
        int nElemStart = il.codeGenStackDepth();
        boolean generatingConstantPool = cgh.getConstantGenerationState();
        if (this.isGenerated() && !generatingConstantPool) {
            FcgType t;
            if (this.m_varFCG == null) {
                this.m_varFCG = il.findVar(this.m_varName);
            }
            if (onlyToVariable) {
                t = this.m_varFCG.getType();
            } else {
                t = il.loadVar(this.m_varFCG);
                if (valueStyleRequest == ValueGenStyle.DEFAULT_WITH_PUSH) {
                    this.m_binding.getBindingType(cgt.m_typeEnvironment, cgt.m_bindingEnvironment).generateObjectFork(cgh, il, cgt, valueStyleRequest);
                }
            }
            return t;
        }
        if (!cgh.getSettings().isSuppressComments()) {
            il.comment(" generated by FCG from: " + this.m_instruction.getClass().getName());
            String s = this.m_instruction.getLocationComment();
            if (s != null) {
                il.comment(s);
            }
        }
        this.m_varFcgType = this.m_instruction.generateCode(cgh, cgt, Binding.generateVariableName(this.m_binding, cgh), tailPosition, il, valueStyleRequest);
        if (!(generatingConstantPool || this.isOneTime() && !onlyToVariable)) {
            if (this.m_assertedVarFCG == null) {
                String name2 = cgh.generateNewLocalVariableName();
                this.setVarName(name2);
                this.m_varFCG = il.defineVar(this.m_varFcgType, name2, true);
            } else {
                if (valueStyleRequest != ValueGenStyle.DEFAULT && this.m_mustFork) {
                    if (this.m_type != null) {
                        this.m_type.generateObjectFork(cgh, il, cgt, valueStyleRequest);
                    } else {
                        this.m_binding.getBindingType(cgt.m_typeEnvironment, cgt.m_bindingEnvironment).generateObjectFork(cgh, il, cgt, valueStyleRequest);
                    }
                }
                this.setVarName(this.m_assertedVarFCG.getName());
                this.m_varFCG = this.m_assertedVarFCG;
                il.storeVar(this.m_varFCG);
            }
            if (!onlyToVariable) {
                il.loadVar(this.m_varFCG);
            }
        }
        if ((nElemEnd = il.codeGenStackDepth()) - nElemStart > 1) {
            throw new XylemError("ERR_SYSTEM", "We shouldn't leave more than one item on the FCG codegen stack");
        }
        return this.m_varFcgType;
    }

    public void assertVarFCG(FcgVariable v) {
        this.assertVarFCGwithoutFork(v);
    }

    public void assertVarFCGwithoutFork(FcgVariable v) {
        this.m_assertedVarFCG = v;
        this.m_oneTime = false;
    }

    public void assertVarFCGwithFork(FcgVariable v) {
        this.m_assertedVarFCG = v;
        this.m_mustFork = true;
        this.m_oneTime = false;
    }
}

