/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.codegen;

import com.ibm.xltxe.rnm1.xylem.codegen.JavaCSettings;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xml.ras.LoggerUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JavaC {
    private static final Logger s_logger = LoggerUtil.getLogger(JavaC.class);
    private static final String s_className = JavaC.class.getName();
    private static final String s_encoding = "UTF-8";

    public static final int compile(File file, JavaCSettings settings) {
        return JavaC.compile(file.getParentFile(), new String[]{file.getName()}, new File("."), null, null, settings);
    }

    public static final int compile(File parent2, String[] files, File outputDir, String classpath, String bootclasspath, JavaCSettings settings) {
        if (classpath == null) {
            classpath = System.getProperty("java.class.path");
        }
        if (bootclasspath == null) {
            bootclasspath = System.getProperty("sun.boot.class.path");
        }
        if (parent2 == null) {
            parent2 = new File(".");
        }
        if (settings.isJavaCDisabled()) {
            return JavaC.printCompileLine(parent2, files, outputDir, classpath, settings);
        }
        try {
            return JavaC.compileInThisJVM(parent2, files, outputDir, classpath, settings);
        }
        catch (Exception e) {
            if (!(e instanceof ClassNotFoundException)) {
                s_logger.logp(Level.WARNING, s_className, "compile", "could not run javac-internal", e);
            }
            return JavaC.compileWithSpawnOtherJVM(parent2, files, outputDir, classpath, bootclasspath, settings);
        }
    }

    private static int printCompileLine(File parent2, String[] files, File outputDir, String classpath, JavaCSettings settings) {
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            ArrayList<String> params = new ArrayList<String>();
            params.add(settings.getPathToJavaC());
            params.add("-J-Xmx" + settings.getMaxJavaHeap());
            if (settings.isGenerateSymbols()) {
                params.add("-g");
            }
            params.add("-sourcepath");
            params.add("\"" + parent2.getAbsolutePath() + "\"");
            params.add("-d");
            params.add("\"" + outputDir.getAbsolutePath() + "\"");
            params.add("-target");
            params.add("1.3");
            if (!System.getProperty("java.version").startsWith("1.3")) {
                params.add("-source");
                params.add("1.3");
            }
            params.add("-classpath");
            params.add("\"" + classpath + "\"");
            int c = params.size();
            String[] args = new String[c + files.length];
            params.toArray(args);
            for (int i = 0; i < files.length; ++i) {
                args[i + c] = new File(parent2, files[i]).getAbsolutePath();
            }
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < args.length; ++i) {
                sb.append(args[i]);
                sb.append(" ");
            }
            s_logger.logp(Level.FINE, s_className, "printCompileLine", sb.toString());
        }
        return 0;
    }

    private static final int compileInThisJVM(File parent2, String[] files, File outputDir, String classpath, JavaCSettings settings) throws Exception {
        int exitVal = 0;
        ArrayList<String> params = new ArrayList<String>();
        params.add("-sourcepath");
        params.add(parent2.getAbsolutePath());
        if (settings.isGenerateSymbols()) {
            params.add("-g");
        }
        params.add("-encoding");
        params.add(s_encoding);
        params.add("-d");
        params.add(outputDir.getAbsolutePath());
        params.add("-target");
        params.add("1.3");
        if (!System.getProperty("java.version").startsWith("1.3")) {
            params.add("-source");
            params.add("1.3");
        }
        params.add("-classpath");
        params.add(classpath);
        int c = params.size();
        String[] args = new String[c + files.length];
        params.toArray(args);
        for (int i = 0; i < files.length; ++i) {
            args[i + c] = new File(parent2, files[i]).getAbsolutePath();
        }
        StringBuffer sb = new StringBuffer();
        sb.append("javac-internal ");
        for (int i = 0; i < args.length; ++i) {
            sb.append(args[i]);
            sb.append(" ");
        }
        long start = System.currentTimeMillis();
        Class<?> clazz = Class.forName("com.sun.tools.javac.Main", true, ClassLoader.getSystemClassLoader());
        Object main = clazz.newInstance();
        Method meth = clazz.getMethod("compile", String[].class);
        boolean success = (Integer)meth.invoke(main, new Object[]{args}) == 0;
        long stop = System.currentTimeMillis();
        if (!success) {
            String message = "JavaC.java: javac-internal reported errors";
            s_logger.logp(Level.SEVERE, s_className, "compileInThisJVM", message);
            throw new XylemError("ERR_SYSTEM", message);
        }
        s_logger.logp(Level.INFO, s_className, "compileInThisJVM", sb.toString());
        s_logger.logp(Level.INFO, s_className, "compileInThisJVM", "timing: javac-internal took " + (stop - start) + " milliseconds.");
        return exitVal;
    }

    private static final int compileWithSpawnOtherJVM(File parent2, String[] files, File outputDir, String classpath, String bootclasspath, JavaCSettings settings) {
        int exitVal = 0;
        ArrayList<String> params = new ArrayList<String>();
        params.add(settings.getPathToJavaC());
        params.add("-J-Xmx" + settings.getMaxJavaHeap());
        if (settings.isGenerateSymbols()) {
            params.add("-g");
        }
        params.add("-encoding");
        params.add(s_encoding);
        params.add("-sourcepath");
        params.add(parent2.getAbsolutePath());
        params.add("-d");
        params.add(outputDir.getAbsolutePath());
        params.add("-target");
        params.add("1.5");
        if (!System.getProperty("java.version").startsWith("1.3")) {
            params.add("-source");
            params.add("1.3");
        }
        params.add("-classpath");
        params.add(classpath);
        params.add("-bootclasspath");
        params.add(bootclasspath);
        String endorsedDirs = System.getProperty("java.endorsed.dirs");
        if (endorsedDirs != null && endorsedDirs.length() > 0) {
            params.add("-endorseddirs");
            params.add(endorsedDirs);
        }
        int c = params.size();
        String[] args = new String[c + files.length];
        params.toArray(args);
        for (int i = 0; i < files.length; ++i) {
            args[i + c] = new File(parent2, files[i]).getAbsolutePath();
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].indexOf(32) >= 0) {
                sb.append('\"');
                sb.append(args[i]);
                sb.append('\"');
            } else {
                sb.append(args[i]);
            }
            sb.append(" ");
        }
        JavaC.writeRunJavacDotBat(sb);
        s_logger.logp(Level.INFO, s_className, "compileWithSpawnOtherJVM", sb.toString());
        long start = System.currentTimeMillis();
        try {
            Process p = Runtime.getRuntime().exec(args);
            LineNumberReader stdErr = new LineNumberReader(new InputStreamReader(new BufferedInputStream(p.getErrorStream())));
            LineNumberReader stdOut = new LineNumberReader(new InputStreamReader(new BufferedInputStream(p.getInputStream())));
            while (true) {
                if (stdOut.ready()) {
                    s_logger.logp(Level.SEVERE, s_className, "compileWithSpawnOtherJVM", stdOut.readLine());
                    continue;
                }
                while (stdErr.ready()) {
                    s_logger.logp(Level.SEVERE, s_className, "compileWithSpawnOtherJVM", stdErr.readLine());
                }
                try {
                    Thread.sleep(100L);
                    exitVal = p.exitValue();
                }
                catch (Exception e) {
                    continue;
                }
                break;
            }
            while (stdOut.ready()) {
                s_logger.logp(Level.SEVERE, s_className, "compileWithSpawnOtherJVM", stdOut.readLine());
            }
            while (stdErr.ready()) {
                s_logger.logp(Level.SEVERE, s_className, "compileWithSpawnOtherJVM", stdErr.readLine());
            }
        }
        catch (Exception e) {
            s_logger.logp(Level.SEVERE, s_className, "compileWithSpawnOtherJVM", "could not run javac", e);
            exitVal = -11;
        }
        long stop = System.currentTimeMillis();
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "compileWithSpawnOtherJVM", "timing: javac took " + (stop - start) + " milliseconds.");
        }
        if (exitVal != 0) {
            s_logger.logp(Level.SEVERE, s_className, "compileWithSpawnOtherJVM", "JAVAC FAILED(" + exitVal + ")");
        }
        return exitVal;
    }

    private static final void writeRunJavacDotBat(StringBuffer sb) {
        try {
            FileWriter fw = new FileWriter("run-javac.bat");
            fw.write(sb.toString());
            fw.close();
        }
        catch (IOException e) {
            s_logger.logp(Level.WARNING, s_className, "writeRunJavacDotBat", "Couldn't write run-javac.bat.");
            return;
        }
    }
}

