/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.codegen;

import com.ibm.xltxe.rnm1.fcg.FcgAttrs;
import com.ibm.xltxe.rnm1.fcg.FcgClassGen;
import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgMethodGen;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.codegen.ClosureGenerationUtilities;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGeneration;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.FunctionGenerationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.types.LambdaType;
import java.util.Iterator;
import java.util.List;

public class LambdaFunctionGenerationStyle
extends FunctionGenerationStyle {
    protected List m_paramInfo;
    protected LambdaType m_lambdaType;
    protected IBinding[] m_bindings;
    protected LiteralInstruction[] m_literalParameters;

    public LambdaFunctionGenerationStyle(Function fi, List paramInfo, LambdaType lt2, IBinding[] bindings, LiteralInstruction[] literalParameters) {
        super(fi);
        this.m_paramInfo = paramInfo;
        this.m_lambdaType = lt2;
        this.m_bindings = bindings;
        this.m_literalParameters = literalParameters;
    }

    @Override
    public boolean equals(Object arg0) {
        if (!super.equals(arg0)) {
            return false;
        }
        LambdaFunctionGenerationStyle lfgs = (LambdaFunctionGenerationStyle)arg0;
        if (lfgs.m_literalParameters.length != this.m_literalParameters.length) {
            return false;
        }
        for (int i = 0; i < this.m_literalParameters.length; ++i) {
            LiteralInstruction li0 = this.m_literalParameters[i];
            LiteralInstruction li1 = lfgs.m_literalParameters[i];
            if (!(li0 == null && li1 != null || li1 == null && li0 != null) && li1.equals(li0)) continue;
            return false;
        }
        return ((Object)lfgs.m_paramInfo).equals(this.m_paramInfo) && lfgs.m_lambdaType.equals(this.m_lambdaType);
    }

    public String generateClassName(CodeGeneration cg) {
        int index2;
        Integer n2 = (Integer)cg.generationMemosGet(this.getSignature());
        if (n2 != null) {
            index2 = n2;
        } else {
            index2 = cg.generationMemosSize();
            cg.generationMemosPut(this.computeSignature(), new Integer(index2));
        }
        return this.m_function.generateFunctionName(cg) + "$Lambda" + index2;
    }

    @Override
    public void generateFunction(FcgCodeGenHelper cgh, CodeGenerationTracker cgt) {
        TypeEnvironment tenv = this.prepareTypeEnvironment();
        Function func = this.m_function;
        String className = cgh.getClassName() + "$" + this.generateClassName(cgh);
        FcgClassReferenceType classType = cgh.getClassReferenceType(className);
        String baseClassName = this.m_lambdaType.getImplementationName(cgh);
        FcgClassGen classGen = cgh.newClassGen(classType, cgh.getClassReferenceType(baseClassName), FcgAttrs.PUBLIC_FINAL);
        for (int i = 0; i < this.m_literalParameters.length; ++i) {
            if (this.m_literalParameters[i] == null) continue;
            Binding ib = this.m_function.m_parameters[i];
            cgt.registerBinding((IBinding)ib, this.m_literalParameters[i]);
        }
        ClosureGenerationUtilities.generateClosureSuffix(className, this.m_paramInfo, cgt, cgh, classGen);
        FcgType fcgRetType = this.m_lambdaType.getReturnType().getFCGType(cgh);
        FcgMethodGen methodGen = classGen.newMethodGen(FcgAttrs.PUBLIC_FINAL, fcgRetType, "invoke");
        FcgInstructionList ilInvoke = methodGen.getInstructionList();
        Type[] paramTypes = this.m_lambdaType.getElementTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            String paramName = cgh.generateNewLocalVariableName();
            methodGen.addParameter(paramTypes[i].getFCGType(cgh), paramName);
            if (this.m_bindings[i] == null) continue;
            cgt.registerExtantBinding(this.m_bindings[i], paramName);
        }
        func.switchOverTypeEnvironment(tenv);
        ilInvoke.beginMethod();
        FcgClassReferenceType thisType = cgh.getClassReferenceType(cgh.getClassName());
        ilInvoke.loadThis();
        ilInvoke.loadInstanceField(classType, "__this__", thisType);
        ilInvoke.defineConstVar(thisType, "__this__");
        func.getBody().generateCode(cgh, cgt, null, true, ilInvoke, ValueGenStyle.DEFAULT);
        ilInvoke.returnInstruction(fcgRetType);
        ilInvoke.endMethod();
        cgh.completeClassGeneration(classGen);
    }

    @Override
    protected String computeSignature() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.computeSignature());
        for (int i = 0; i < this.m_literalParameters.length; ++i) {
            sb.append(',');
            sb.append(this.m_literalParameters[i]);
        }
        Iterator i = this.m_paramInfo.iterator();
        while (i.hasNext()) {
            sb.append(',');
            sb.append(((IBinding)i.next()).getBindingType());
        }
        sb.append(this.m_lambdaType.prettyPrint());
        return sb.toString();
    }

    @Override
    public String generatedFunctionName(FcgCodeGenHelper cgh) {
        throw new UnsupportedOperationException();
    }
}

