/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.codegen;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public final class MemoryEfficientBuffer
extends PrintWriter {
    private Writer m_writer;
    private File m_file;
    private boolean m_autoMoveToDisk;

    private MemoryEfficientBuffer(Writer fw, boolean autoMoveToDisk) {
        super(new BufferedWriter(fw));
        this.m_writer = fw;
        this.m_autoMoveToDisk = autoMoveToDisk;
    }

    public static MemoryEfficientBuffer obtainBuffer() {
        try {
            File f2 = File.createTempFile("xylem", "tmp");
            f2.deleteOnExit();
            FileOutputStream fos = new FileOutputStream(f2);
            OutputStreamWriter osw = new OutputStreamWriter(fos);
            MemoryEfficientBuffer meb = new MemoryEfficientBuffer(osw, false);
            meb.m_file = f2;
            return meb;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int length() {
        if (this.m_writer instanceof StringWriter) {
            this.flush();
            return ((StringWriter)this.m_writer).getBuffer().length();
        }
        throw new UnsupportedOperationException();
    }

    public static MemoryEfficientBuffer obtainCountableBuffer() {
        return new MemoryEfficientBuffer(new StringWriter(), false);
    }

    public void releaseAndWriteOut(Writer w) {
        this.releaseAndWriteOut(w, new char[131072]);
    }

    public void releaseAndWriteOut(Writer w, char[] buffer) {
        try {
            this.flush();
            this.close();
            if (this.m_file != null) {
                FileInputStream fis = new FileInputStream(this.m_file);
                InputStreamReader fr = new InputStreamReader(fis);
                int c = 0;
                while ((c = fr.read(buffer, 0, buffer.length)) > 0) {
                    w.write(buffer, 0, c);
                }
                fr.close();
                this.m_file.delete();
            } else {
                w.write(((StringWriter)this.m_writer).getBuffer().toString());
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public void releaseAndWriteOut(OutputStream w, byte[] buffer) {
        try {
            this.flush();
            this.close();
            if (this.m_file != null) {
                FileInputStream fis = new FileInputStream(this.m_file);
                int c = 0;
                while ((c = fis.read(buffer, 0, buffer.length)) > 0) {
                    w.write(buffer, 0, c);
                }
                fis.close();
                this.m_file.delete();
            } else {
                OutputStreamWriter osw = new OutputStreamWriter(w);
                osw.write(((StringWriter)this.m_writer).getBuffer().toString());
                osw.flush();
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public String toString() {
        throw new UnsupportedOperationException();
    }
}

