/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.codegen;

import com.ibm.xltxe.rnm1.fcg.FcgAttrs;
import com.ibm.xltxe.rnm1.fcg.FcgClassGen;
import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgMethodGen;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgVariable;
import com.ibm.xltxe.rnm1.fcg.impl.FcgClassGenImpl;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.FunctionGenerationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.IStreamInADTOptimizationInstruction;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.types.ConstructorDataType;
import com.ibm.xltxe.rnm1.xylem.types.NamedType;
import com.ibm.xltxe.rnm1.xylem.types.StreamType;
import java.util.ArrayList;
import java.util.Iterator;

public class StreamInADTOptimizedFunctionGenerationStyle
extends FunctionGenerationStyle {
    protected Binding m_streamBinding;
    protected boolean m_objectless;

    public StreamInADTOptimizedFunctionGenerationStyle(Function fi, Binding streamBinding, boolean objectless) {
        super(fi);
        this.m_streamBinding = streamBinding;
        this.m_objectless = objectless;
    }

    @Override
    public void generateFunction(FcgCodeGenHelper cgh, CodeGenerationTracker cgt) {
        TypeEnvironment tenv = this.prepareTypeEnvironment();
        StreamType streamType = (StreamType)this.m_streamBinding.getBindingType().resolveType(this.m_streamBinding.getTypeEnvironment());
        Type adtType = this.m_function.getReturnType().resolveType(tenv);
        Type returnType = this.m_objectless ? streamType : adtType;
        ArrayList paramNames = new ArrayList();
        ArrayList paramTypes = new ArrayList();
        this.generateParamSpecs(cgh, paramNames, paramTypes, cgt);
        ConstructorDataType adt = (ConstructorDataType)((NamedType)adtType).resolveNameToADT(tenv);
        Function f2 = this.m_function;
        f2.switchOverTypeEnvironment(tenv);
        FcgClassGen classGen = cgh.startFunctionGeneration();
        FcgInstructionList il = ((FcgClassGenImpl)classGen).newInstructionList();
        FcgAttrs attrs = FcgAttrs.PUBLIC_FINAL;
        if (cgh.getSettings().isMakeAllMethodsStatic()) {
            attrs = FcgAttrs.PUBLIC_STATIC_FINAL;
        }
        String name2 = this.generatedFunctionName(cgh);
        String bindingVarName = Binding.generateVariableName(this.m_streamBinding, cgh);
        FcgMethodGen methodGen = ((FcgClassGenImpl)classGen).newMethodGen(attrs, returnType.getFCGType(cgh), name2, il);
        StreamInADTOptimizedFunctionGenerationStyle.generateStaticThisIfNeeded(cgh, paramNames, paramTypes);
        streamType.generateStreamParameterList(bindingVarName, cgh, paramNames, paramTypes, cgt);
        Iterator nameIter = paramNames.iterator();
        Iterator typeIter = paramTypes.iterator();
        while (nameIter.hasNext()) {
            methodGen.addParameter((FcgType)typeIter.next(), (String)nameIter.next());
        }
        il.beginMethod();
        il.beginConditionalLoop("__tailrecurse__", 0);
        if (this.m_objectless) {
            il.loadVar(il.findVar(bindingVarName + "_size"));
            il.defineConstVar(FcgType.INT, "original_" + bindingVarName + "_size");
            ((IStreamInADTOptimizationInstruction)((Object)f2.getBody())).generateCode(cgh, il, bindingVarName, this.m_streamBinding, cgt, true, true);
            Binding[] params = adt.m_constructors[0].m_parameters;
            for (int k = params.length - 1; k >= 0; --k) {
                Binding b2 = params[k];
                if (b2 == this.m_streamBinding) continue;
                String var = adt.m_constructors[0].getConstructorQualifiedFieldName(k, cgh);
                FcgType type2 = b2.getBindingType().getFCGType(cgh);
                FcgVariable tempVar = il.defineConstVar(type2, cgh.generateNewLocalVariableName());
                FcgClassReferenceType classType = cgh.loadThisVar(il);
                il.loadVar(tempVar);
                cgh.allocateThreadLocalVariable(var, b2.getBindingType().getFCGType(cgh));
                il.storeInstanceFieldStmt(classType, cgh.generateThreadLocalVarReference(var), type2);
            }
            streamType.generateStreamFunctionSuffix(cgh, il, bindingVarName);
            FcgType retType = il.loadVar(il.findVar(bindingVarName + "_stream"));
            il.returnInstruction(retType);
        } else {
            ((IStreamInADTOptimizationInstruction)((Object)f2.getBody())).generateCode(cgh, il, bindingVarName, this.m_streamBinding, cgt, false, true);
            FcgVariable x = il.defineVar(f2.getReturnType().getFCGType(cgh), cgh.generateNewLocalVariableName(), true);
            streamType.generateStreamFunctionSuffix(cgh, il, bindingVarName);
            il.loadVar(x);
            il.returnInstruction(x.getType());
        }
        il.endConditionalLoop();
        il.endMethod();
    }

    @Override
    public boolean equals(Object arg0) {
        if (!super.equals(arg0)) {
            return false;
        }
        StreamInADTOptimizedFunctionGenerationStyle siadtofgs = (StreamInADTOptimizedFunctionGenerationStyle)arg0;
        return this.m_objectless == siadtofgs.m_objectless && this.m_streamBinding == siadtofgs.m_streamBinding;
    }

    @Override
    public String computeSignature() {
        return super.computeSignature() + "___" + this.m_objectless + "___" + this.m_streamBinding;
    }

    @Override
    public String generatedFunctionName(FcgCodeGenHelper cgh) {
        String bindingVarName = Binding.generateVariableName(this.m_streamBinding, cgh);
        String name2 = this.m_function.generateFunctionName(cgh) + "_" + bindingVarName;
        if (this.m_objectless) {
            name2 = name2 + "$objectless";
        }
        return name2;
    }
}

