/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.codegen;

import com.ibm.xltxe.rnm1.fcg.FcgAttrs;
import com.ibm.xltxe.rnm1.fcg.FcgClassGen;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgMethodGen;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgVariable;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.FunctionGenerationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.IStreamOptimizationInstruction;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.types.IConstructableAsStreamType;
import com.ibm.xml.ras.LoggerUtil;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StreamOptimizedFunctionGenerationStyle
extends FunctionGenerationStyle {
    private static final Logger s_logger = LoggerUtil.getLogger(StreamOptimizedFunctionGenerationStyle.class);
    private static final String s_className = StreamOptimizedFunctionGenerationStyle.class.getName();

    public StreamOptimizedFunctionGenerationStyle(Function fi) {
        super(fi);
    }

    @Override
    public void generateFunction(FcgCodeGenHelper cgh, CodeGenerationTracker cgt) {
        FcgClassGen classGen = cgh.startFunctionGeneration();
        TypeEnvironment tenv = this.prepareTypeEnvironment();
        if (!(this.m_function.getReturnType().resolveType(tenv) instanceof IConstructableAsStreamType)) {
            s_logger.logrb(Level.WARNING, s_className, "generateFunction", "com.ibm.xltxe.rnm1.xylem.res.XylemMessages", "ERR_SYSTEM", new Object[]{"StreamOptimizedFunctionGenerationStyle for " + this.m_function.getName() + " has return type " + this.m_function.getReturnType()});
        }
        IConstructableAsStreamType returnType = (IConstructableAsStreamType)((Object)this.m_function.getReturnType().resolveType(tenv));
        String streamName = "__stream__";
        ArrayList paramNames = new ArrayList();
        ArrayList paramTypes = new ArrayList();
        StreamOptimizedFunctionGenerationStyle.generateStaticThisIfNeeded(cgh, paramNames, paramTypes);
        this.generateParamSpecs(cgh, paramNames, paramTypes, cgt);
        returnType.generateStreamParameterList("__stream__", cgh, paramNames, paramTypes, cgt);
        Function f2 = this.m_function;
        f2.switchOverTypeEnvironment(tenv);
        FcgAttrs attrs = FcgAttrs.PUBLIC_STATIC_FINAL;
        FcgType retType = returnType.getFCGType(cgh);
        String methodName = this.generatedFunctionName(cgh);
        FcgMethodGen mg = classGen.newMethodGen(attrs, retType, methodName);
        FcgInstructionList il = mg.getInstructionList();
        for (int p = 0; p < paramNames.size(); ++p) {
            mg.addParameter((FcgType)paramTypes.get(p), (String)paramNames.get(p));
        }
        il.beginMethod();
        ((IStreamOptimizationInstruction)((Object)f2.getBody())).generateCodeWithStreamOptimization(cgh, il, "__stream__", returnType, cgt, true, ValueGenStyle.DEFAULT);
        returnType.generateStreamFunctionSuffix(cgh, il, "__stream__");
        FcgVariable streamVar = il.findVar("__stream___stream");
        il.loadVar(streamVar);
        il.returnInstruction(retType);
        il.endMethod();
    }

    @Override
    public String generatedFunctionName(FcgCodeGenHelper cgh) {
        return this.m_function.generateFunctionName(cgh) + "$stream";
    }
}

