/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.codegen;

import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.xylem.codegen.FcgXmlType;
import java.util.HashMap;

public enum ValueGenStyle {
    DEFAULT(false, FcgXmlType.CURSOR_TYPE),
    DEFAULT_NO_PUSH(false, FcgXmlType.CURSOR_TYPE),
    DEFAULT_WITH_PUSH(false, FcgXmlType.CURSOR_TYPE),
    CURSOR(false, FcgXmlType.CURSOR_TYPE),
    VOLATILECDATA(true, FcgXmlType.VOLATILE_CDATA),
    CDATA(true, FcgXmlType.CDATA),
    CHARS(true, FcgXmlType.CHARS),
    QNAME(true, FcgXmlType.QNAME),
    INT(true, FcgType.INT),
    INT_ARRAY(true, FcgType.INT_ARRAY),
    INT_OBJECT(true, FcgType.INT_OBJECT),
    LONG(true, FcgType.LONG),
    LONG_ARRAY(true, FcgType.LONG_ARRAY),
    LONG_OBJECT(true, FcgType.LONG_OBJECT),
    FLOAT(true, FcgType.FLOAT),
    FLOAT_ARRAY(true, FcgType.FLOAT_ARRAY),
    FLOAT_OBJECT(true, FcgType.FLOAT_OBJECT),
    DOUBLE(true, FcgType.DOUBLE),
    DOUBLE_ARRAY(true, FcgType.DOUBLE_ARRAY),
    DOUBLE_OBJECT(true, FcgType.DOUBLE_OBJECT),
    CHAR(true, FcgType.CHAR),
    CHAR_ARRAY(true, FcgType.CHAR_ARRAY),
    CHAR_OBJECT(true, FcgType.CHAR_OBJECT),
    BOOLEAN(true, FcgType.BOOLEAN),
    BOOLEAN_ARRAY(true, FcgType.BOOLEAN_ARRAY),
    BOOLEAN_OBJECT(true, FcgType.BOOLEAN_OBJECT),
    VOID(true, FcgType.VOID),
    BYTE(true, FcgType.BYTE),
    BYTE_ARRAY(true, FcgType.BYTE_ARRAY),
    BYTE_OBJECT(true, FcgType.BYTE_OBJECT),
    SHORT(true, FcgType.SHORT),
    SHORT_ARRAY(true, FcgType.SHORT_ARRAY),
    SHORT_OBJECT(true, FcgType.SHORT_OBJECT),
    CHARSEQUENCE(true, FcgType.CHARSEQUENCE),
    STRING(true, FcgType.STRING),
    BIG_INTEGER(true, FcgType.BIG_INTEGER),
    BIG_DECIMAL(true, FcgType.BIG_DECIMAL),
    STRING_ARRAY(true, FcgType.STRING_ARRAY);

    private boolean _isUnboxed;
    private FcgType _fcgType;
    private static HashMap<FcgType, ValueGenStyle> _forFcgType;

    public boolean fcgTypeMatches(FcgType fcgType) {
        FcgType fcgType2 = this._fcgType;
        return fcgType2.equals(fcgType);
    }

    public boolean isUnboxed() {
        return this._isUnboxed;
    }

    public static boolean isSequenceConcatAllowedType(FcgType fcgType) {
        return fcgType.equals(FcgXmlType.VOLATILE_CDATA) || fcgType.equals(FcgType.INT) || fcgType.equals(FcgType.BOOLEAN) || fcgType.equals(FcgXmlType.QNAME) || fcgType.equals(FcgType.DOUBLE) || fcgType.equals(FcgType.FLOAT) || fcgType.equals(FcgType.STRING) || fcgType.equals(FcgType.CHAR_ARRAY) || fcgType.equals(FcgXmlType.CHARS);
    }

    public static boolean isSequenceConcatAllowedPrimitiveType(FcgType fcgType) {
        return fcgType.equals(FcgType.INT) || fcgType.equals(FcgType.BOOLEAN) || fcgType.equals(FcgXmlType.QNAME) || fcgType.equals(FcgType.DOUBLE) || fcgType.equals(FcgType.FLOAT) || fcgType.equals(FcgType.STRING) || fcgType.equals(FcgType.CHAR_ARRAY) || fcgType.equals(FcgXmlType.CHARS);
    }

    public FcgType getFcgType() {
        return this._fcgType;
    }

    public static ValueGenStyle forFcgType(FcgType ft) {
        ValueGenStyle vs = _forFcgType.get(ft);
        if (vs == null) {
            vs = DEFAULT;
        }
        return vs;
    }

    private static synchronized void register(FcgType t, ValueGenStyle s) {
        if (null == _forFcgType) {
            _forFcgType = new HashMap();
        }
        _forFcgType.put(t, s);
    }

    private ValueGenStyle(boolean isUnboxed, FcgType fcgType) {
        this._isUnboxed = isUnboxed;
        this._fcgType = fcgType;
        ValueGenStyle.register(fcgType, this);
    }
}

