/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.codegen.fcg;

import com.ibm.xltxe.rnm1.fcg.FcgAttrs;
import com.ibm.xltxe.rnm1.fcg.FcgClassCollector;
import com.ibm.xltxe.rnm1.fcg.FcgClassGen;
import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgCodeGen;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgMethodGen;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.impl.FcgClassGenImpl;
import com.ibm.xltxe.rnm1.fcg.impl.FinalCodeGenerator;
import com.ibm.xltxe.rnm1.fcg.javasrc.FcgClassGenJavaSrc;
import com.ibm.xltxe.rnm1.fcg.javasrc.FcgMethodGenJavaSrc;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationSettings;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;

public class FcgCodeGenHelperJavaSrc
extends FcgCodeGenHelper {
    private final FcgClassReferenceType m_baseClassName;
    private final String m_constantsClassPrefix;
    private int m_constantClassIndex = 0;
    private FcgClassReferenceType m_currentClass;
    private FcgClassReferenceType m_currentBaseClass;
    private FcgAttrs m_currentClassAttrs;
    private int m_staticMethodIndex = 0;
    private int m_functionCount;

    protected FcgCodeGenHelperJavaSrc(FcgCodeGen cg, String className, String baseClassName, CodeGenerationSettings settings, FcgClassCollector cc) {
        super(cg, cc);
        this.setSettings(settings);
        this.setClassName(className);
        if (baseClassName == null) {
            baseClassName = "java.lang.Object";
        }
        this.m_baseClassName = this.m_cg.getClassReferenceType(baseClassName);
        this.m_constantsClassPrefix = this.isMultiPartitionOutput() ? this.getClassName() + "_" : this.getClassName();
        this.m_cgh = this.makeNewPartition();
        FcgClassGen cgh0 = this.makeNewPartition();
        this.m_staticILB = ((FcgClassGenImpl)cgh0).newInstructionList();
        ((FinalCodeGenerator)this.m_staticILB).setStaticContext(true);
        this.m_constructorILB = ((FcgClassGenImpl)cgh0).newInstructionList();
        this.generateCTorWithSessionContextParam(cgh0, this.m_constructorILB);
    }

    public FcgClassReferenceType generateThisVar(FcgInstructionList il) {
        FcgClassReferenceType classType = this.getSettings().isMakeAllMethodsStatic() ? (FcgClassReferenceType)il.loadVar(il.findVar("__this__")) : il.loadThis();
        return classType;
    }

    @Override
    public void checkForStaticFlush(boolean forceFinalFlush) {
        int numStaticFields = this.m_staticILB.getFcgClassGen().getNumberOfClassFields();
        if (!forceFinalFlush && numStaticFields / 2048 < this.m_staticMethodIndex + 1) {
            return;
        }
        FcgInstructionList il = this.m_staticILB;
        FcgClassGen cgh = this.m_staticILB.getFcgClassGen();
        ((FcgClassGenImpl)cgh).newMethodGen(FcgAttrs.PUBLIC_STATIC, FcgType.VOID, "__xylem_initStatic" + this.m_staticMethodIndex, il);
        il.beginMethod();
        il.returnInstruction();
        il.endMethod();
        ++this.m_staticMethodIndex;
        if (forceFinalFlush || this.m_staticMethodIndex % 20 == 0) {
            if (this.m_constructorILB != null) {
                this.m_constructorILB.endMethod();
            }
            this.completeClassGeneration(cgh);
            if (!forceFinalFlush) {
                cgh = this.makeNewPartition();
                this.m_constructorILB = ((FcgClassGenImpl)cgh).newInstructionList();
                this.generateCTorWithSessionContextParam(cgh, this.m_constructorILB);
            }
        }
        if (forceFinalFlush) {
            this.m_staticILB = null;
        } else {
            this.m_staticILB = ((FcgClassGenImpl)cgh).newInstructionList();
            ((FinalCodeGenerator)this.m_staticILB).setStaticContext(true);
        }
    }

    @Override
    public void checkConstructorSize() {
    }

    @Override
    protected FcgClassGen makeNewPartition() {
        FcgClassGenJavaSrc partition = null;
        if (this.isMultiPartitionOutput()) {
            this.m_currentClass = this.m_cg.getClassReferenceType(this.m_constantsClassPrefix + "Partition" + this.m_constantClassIndex);
            this.m_currentBaseClass = this.m_constantClassIndex == 0 ? this.m_baseClassName : this.m_cg.getClassReferenceType(this.m_constantsClassPrefix + "Partition" + (this.m_constantClassIndex - 1));
            this.m_currentClassAttrs = FcgAttrs.PUBLIC_SUPER_ABSTRACT;
        } else {
            this.m_currentClass = this.m_cg.getClassReferenceType(this.m_constantsClassPrefix);
            this.m_currentBaseClass = this.m_baseClassName;
            this.m_currentClassAttrs = FcgAttrs.PUBLIC;
        }
        String filename = "ThisNameIsProbablyNeverUsed_" + this.m_constantsClassPrefix + "Partition" + this.m_constantClassIndex;
        String[] interfaces = null;
        partition = new FcgClassGenJavaSrc(this.m_cg, this.m_currentClass, this.m_currentBaseClass, filename, this.m_currentClassAttrs, interfaces);
        ++this.m_constantClassIndex;
        return partition;
    }

    @Override
    public FcgClassGen startFunctionGeneration() {
        if (this.shouldSplit()) {
            this.m_functionCount = 0;
            this.generateCTorWithSessionContextParam((FcgClassGenImpl)this.m_cgh);
            this.completeClassGeneration(this.m_cgh);
            this.m_cgh = this.makeNewPartition();
        } else {
            ++this.m_functionCount;
        }
        return this.m_cgh;
    }

    @Override
    public void finish() {
        this.generateCTorWithSessionContextParam((FcgClassGenImpl)this.m_cgh);
        this.completeClassGeneration(this.m_cgh);
        this.checkForStaticFlush(true);
        FcgClassReferenceType cType = this.m_cg.getClassReferenceType(this.getClassName());
        FcgClassReferenceType bType = this.m_currentClass;
        FcgClassGen cgh2 = this.m_cg.newClassGen(cType, bType, FcgAttrs.PUBLIC_SUPER_ABSTRACT);
        this.generateCTorWithSessionContextParam(cgh2);
        this.generateRecycleMethod(cgh2);
        FcgInstructionList il = ((FcgClassGenImpl)cgh2).getClassInstructionList();
        int count2 = this.m_staticMethodIndex;
        for (int i = 0; i < count2; ++i) {
            String methodName = "__xylem_initStatic" + (this.m_staticMethodIndex - count2 + i);
            il.invokeClassMethodStmt(cType, methodName, (FcgType)FcgType.VOID, 0);
        }
        this.completeClassGeneration(cgh2);
    }

    @Override
    public boolean shouldSplit() {
        return ((FcgClassGenImpl)this.m_cgh).getMethodCount() >= this.getSettings().getMaxFunctionsPerPartition();
    }

    @Override
    public FcgMethodGen newConstructorGen(FcgAttrs accessAttrs, FcgClassGen cgh, FcgInstructionList il) {
        FcgMethodGenJavaSrc mg = new FcgMethodGenJavaSrc(cgh, il);
        return mg;
    }
}

