/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.commandline;

import com.ibm.xml.ras.LoggerUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CommandLineParser {
    protected static final Logger s_logger = LoggerUtil.getLogger(CommandLineParser.class);
    protected static final String s_className = CommandLineParser.class.getName();
    public LinkedList m_signatureSearchPath = new LinkedList();

    public static String removeExtension(File f2) {
        String path2 = f2.getAbsolutePath();
        String name2 = f2.getName();
        int nameLength = name2.length();
        int i = name2.lastIndexOf(46);
        if (i != -1 && i < nameLength - 1) {
            return path2.substring(0, i += path2.length() - nameLength);
        }
        return path2;
    }

    public static List separatePath(String s) {
        int c = s.length();
        char separator = File.pathSeparatorChar;
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < c; ++i) {
            char ch = s.charAt(i);
            if (ch == separator) {
                if (sb.length() <= 0) continue;
                list.add(sb.toString());
                continue;
            }
            sb.append(ch);
        }
        if (sb.length() > 0) {
            list.add(sb.toString());
        }
        return list;
    }

    protected boolean handleCommandOption(String filename) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            String s;
            URL url = this.validateInputFilename(filename, false);
            if (url == null) {
                return false;
            }
            InputStreamReader isr = new InputStreamReader(url.openStream());
            BufferedReader br = new BufferedReader(isr);
            while ((s = br.readLine()) != null) {
                if ((s = s.trim()).length() <= 0) continue;
                list.add(s);
            }
            br.close();
            isr.close();
        }
        catch (Exception e) {
            s_logger.logp(Level.SEVERE, s_className, "handleCommandOption", "Error reading command file " + filename, e);
            return false;
        }
        String[] args2 = new String[list.size()];
        list.toArray(args2);
        for (int k = 0; k < args2.length; ++k) {
            int j = this.parseOption(args2, k);
            if (j == -1) {
                return false;
            }
            k = j;
        }
        return true;
    }

    protected int parseOption(String[] args, int i) {
        boolean last2;
        boolean bl = last2 = i == args.length - 1;
        if (args[i].equals("-help") || args[i].equals("-?") || args[i].equals("-h")) {
            System.out.println("\t[-command commandfile]\n\t[-I signature_search_directory]");
            return -1;
        }
        if ("-I".equals(args[i])) {
            if (last2) {
                s_logger.logp(Level.SEVERE, s_className, "parseOption", "-I missing parameter");
                return -1;
            }
            for (String s : CommandLineParser.separatePath(args[++i])) {
                File dir = new File(s);
                if (!dir.exists() || !dir.isDirectory()) {
                    s_logger.logp(Level.WARNING, s_className, "parseOption", "Directory " + s + " not found; ignoring");
                    continue;
                }
                try {
                    this.m_signatureSearchPath.add(dir.toURL());
                }
                catch (MalformedURLException e) {
                    s_logger.logp(Level.WARNING, s_className, "parseOption", "Unexpected failure converting directory " + s + " to URL; ignoring.");
                }
            }
        } else {
            return -2;
        }
        return i;
    }

    public URL validateInputFilename(String s, boolean topResolve) {
        URL url;
        if (s.startsWith("classpath:")) {
            return this.getClass().getClassLoader().getResource(s.substring(10));
        }
        File inputFile = new File(s);
        if (!(topResolve || inputFile.exists() && !inputFile.isDirectory() && inputFile.canRead())) {
            s_logger.logp(Level.SEVERE, s_className, "validateInputFilename", "Cannot find or access input file " + s);
            return null;
        }
        try {
            url = inputFile.toURL();
        }
        catch (MalformedURLException e) {
            s_logger.logp(Level.SEVERE, s_className, "validateInputFilename", "File cannot be put into URL form: " + s);
            return null;
        }
        return url;
    }

    public boolean parseCommandLine(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            int j = this.parseOption(args, i);
            if (j == -1) {
                return false;
            }
            if (j == -2) {
                s_logger.logp(Level.WARNING, s_className, "parseCommandLine", "Unrecognized command line token: " + args[i]);
                j = i;
            }
            i = j;
        }
        return true;
    }
}

