/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.commandline;

import com.ibm.xltxe.rnm1.xylem.FunctionSignature;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.ModuleSignatureStore;
import com.ibm.xltxe.rnm1.xylem.codegen.JavaC;
import com.ibm.xltxe.rnm1.xylem.codegen.JavaCSettings;
import com.ibm.xltxe.rnm1.xylem.commandline.CommandLineParserSingleInputFile;
import com.ibm.xltxe.rnm1.xylem.commandline.SearchPathSourceResolver;
import com.ibm.xltxe.rnm1.xylem.drivers.Linker;
import com.ibm.xltxe.rnm1.xylem.optimizers.VDTMapOptimizer;
import com.ibm.xltxe.rnm1.xylem.parser.Parser;
import com.ibm.xltxe.rnm1.xylem.parser.ParserSource;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.SessionContext;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class XylemC
extends CommandLineParserSingleInputFile {
    private static final Logger s_logger = LoggerUtil.getLogger(XylemC.class);
    private static final String s_className = XylemC.class.getName();
    public static XylemC XYLEMC = new XylemC();
    public ArrayList m_files = new ArrayList();
    int m_dumpLevel = 0;
    boolean m_compileOnly = false;
    String m_packageName = null;
    boolean m_javac = true;
    protected File m_outputDir = new File(".");
    boolean m_isPerf = false;
    public int m_optimizationLevel;
    protected ModuleSignatureStore m_mss;
    protected ArrayList m_filesToLink = new ArrayList();

    @Override
    protected int parseOption(String[] args, int i) {
        if (args[i].equals("-help") || args[i].equals("-?") || args[i].equals("-h")) {
            System.out.println("Usage: XylemC [-disablejavac] [-c] [-O] [-O2] [-I searchpath] [-package packagename] [-output dirname] (file.xylem | file.xylemi)*");
            System.out.println(" -d/--dump to dump final xylem, twice (-d -d) to also dump intermediate xylem");
            return -1;
        }
        if ("-c".equals(args[i])) {
            this.m_compileOnly = true;
            return i;
        }
        if ("-d".equals(args[i]) || "--dump".equals(args[i])) {
            ++this.m_dumpLevel;
            return i;
        }
        if ("-javac".equals(args[i]) || "--javac".equals(args[i])) {
            s_logger.logp(Level.INFO, s_className, "parseOption", "-javac is now the default; use -disablejavac to prevent classfile generation");
            return i;
        }
        if ("-disablejavac".equals(args[i]) || "--disablejavac".equals(args[i])) {
            this.m_javac = false;
            return i;
        }
        if ("-perf".equals(args[i]) || "--perf".equals(args[i])) {
            this.m_isPerf = true;
            return i;
        }
        if ("-package".equals(args[i]) || "--package".equals(args[i])) {
            if (++i == args.length) {
                s_logger.logp(Level.SEVERE, s_className, "parseOption", "-package missing parameter");
                return -1;
            }
            this.m_packageName = args[i];
            return i;
        }
        if ("-output".equals(args[i]) || "--output".equals(args[i])) {
            if (++i == args.length) {
                s_logger.logp(Level.SEVERE, s_className, "parseOption", "-output missing parameter");
                return -1;
            }
            this.m_outputDir = new File(args[i]);
            if (!this.m_outputDir.exists() || !this.m_outputDir.isDirectory()) {
                s_logger.logp(Level.SEVERE, s_className, "parseOption", "Directory " + this.m_outputDir + " does not exist");
                return -1;
            }
            return i;
        }
        if ("-I".equals(args[i])) {
            if (++i == args.length) {
                s_logger.logp(Level.SEVERE, s_className, "parseOption", "-I missing parameter");
                return -1;
            }
            for (String s : XylemC.separatePath(args[i])) {
                File dir = new File(s);
                if (!dir.exists() || !dir.isDirectory()) {
                    s_logger.logp(Level.WARNING, s_className, "parseOption", "Directory " + s + " not found; ignoring");
                    continue;
                }
                try {
                    this.m_signatureSearchPath.add(dir.toURL());
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
            return i;
        }
        if ("-O".equals(args[i])) {
            this.m_optimizationLevel = 1;
            return i;
        }
        if ("-O2".equals(args[i])) {
            this.m_optimizationLevel = 2;
            return i;
        }
        this.m_inputFile = this.validateInputFilename(args[i], false);
        if (this.m_inputFile == null) {
            return -1;
        }
        this.m_files.add(this.m_inputFile);
        return i;
    }

    public static void main(String[] args) {
        new XylemC(args);
    }

    public XylemC(String[] args) {
        this.init(args);
        this.run();
    }

    private XylemC() {
    }

    public void init(String[] args) {
        if (!this.parseCommandLine(args)) {
            return;
        }
        try {
            this.m_signatureSearchPath.addFirst(new File(".").toURL());
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        this.m_mss = new ModuleSignatureStore(this.m_signatureSearchPath);
    }

    public void run() {
        Iterator i = this.m_files.iterator();
        SessionContext session = new SessionContext();
        while (i.hasNext()) {
            URL url = (URL)i.next();
            this.m_signatureSearchPath.addFirst(url);
            this.handleFile(url, this.m_optimizationLevel);
            this.m_signatureSearchPath.removeFirst();
        }
        if (!this.m_compileOnly && !this.m_filesToLink.isEmpty()) {
            File file = this.link(this.m_filesToLink, this.m_mss, null, null, this.m_packageName, this.m_outputDir, this.m_isPerf, session);
            if (file == null) {
                System.exit(-1);
            } else {
                JavaC.compile(file.getParentFile(), new String[]{file.getName()}, this.m_outputDir, null, null, new JavaCSettings());
            }
        }
    }

    protected void handleFile(URL url, int optimizationLevel) {
        String s = url.toString();
        if (s.endsWith(".xylem")) {
            ModuleSignature ms = null;
            try {
                String s2 = url.getPath();
                ms = this.m_mss.resolveModuleSignature(s2.substring(0, s2.length() - 6));
            }
            catch (Exception e) {
                s_logger.logp(Level.SEVERE, s_className, "handleFile", "Error reading compiled interface file", e);
                System.exit(-1);
            }
            Module m = null;
            try {
                m = this.compile(url, ms, this.m_signatureSearchPath, this.m_mss);
            }
            catch (Exception e) {
                s_logger.logp(Level.SEVERE, s_className, "handleFile", "Error occurred during compilation of " + url, e);
                System.exit(-1);
            }
            if (m.getName().equals("")) {
                String name2 = url.getPath();
                name2 = name2.substring(name2.lastIndexOf("/") + 1);
                name2 = name2.substring(0, name2.lastIndexOf(".xylem"));
                m.setName(name2);
            }
            String cxo = m.getName() + ".cxo";
            try {
                File cxoFile = new File(cxo);
                ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(cxoFile));
                Module.writeModule(oos, m);
                oos.flush();
                oos.close();
                this.m_filesToLink.add(cxoFile.toURL());
            }
            catch (Exception e) {
                s_logger.logp(Level.SEVERE, s_className, "handleFile", "Error occurred writing of compiled module to " + cxo, e);
                System.exit(-1);
            }
            String cxi = ModuleSignatureStore.makeFilename(m.getName()) + ".cxi";
            XylemC.writeOutSignature(m.m_signature, cxi);
        } else if (s.endsWith(".xylemi")) {
            ModuleSignature ms = null;
            try {
                ms = XylemC.compileSignature(url, this.m_signatureSearchPath, this.m_mss);
            }
            catch (Exception e) {
                s_logger.logp(Level.SEVERE, s_className, "handleFile", "Error occurred during compilation of signature " + url, e);
                System.exit(-1);
            }
            String cxi = ModuleSignatureStore.makeFilename(ms.getName()) + ".cxi";
            XylemC.writeOutSignature(ms, cxi);
        } else if (s.endsWith(".cxo")) {
            this.m_filesToLink.add(url);
        } else {
            s_logger.logp(Level.WARNING, s_className, "handleFile", "Ignoring file with unrecognized extension: " + url);
        }
    }

    public File link(List filesToLink, ModuleSignatureStore mss, Collection functionsToExport, String className, String packageName, File outputDir, boolean isPerf, SessionContext session) {
        Linker linker = new Linker();
        if (this.m_dumpLevel >= 1) {
            linker.m_dumpXylem = true;
        }
        if (this.m_dumpLevel >= 2) {
            linker.m_dumpIntermediateXylem = true;
        }
        linker.m_mss = mss;
        linker.m_outputDir = outputDir;
        linker.m_isPerf = isPerf;
        return linker.linkFiles(filesToLink, className, packageName, functionsToExport, this.m_optimizationLevel, session);
    }

    public static final void writeOutSignature(ModuleSignature ms, String cxi) {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(cxi));
            ms.write(oos);
            oos.flush();
            oos.close();
        }
        catch (Exception e) {
            s_logger.logp(Level.SEVERE, s_className, "writeOutSignature", "Error occurred writing of compiled signature to " + cxi, e);
            System.exit(-1);
        }
    }

    public static final void writeOutSignature(ModuleSignature ms, String cxi, File outputDir) {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(new File(outputDir, cxi)));
            ms.write(oos);
            oos.flush();
            oos.close();
        }
        catch (Exception e) {
            s_logger.logp(Level.SEVERE, s_className, "writeOutSignature", "Error occurred writing of compiled signature to " + cxi, e);
            System.exit(-1);
        }
    }

    public static final ModuleSignature compileSignature(URL sourceFile, List signatureSearchPath, ModuleSignatureStore mss) throws Exception {
        ParserSource ps = new ParserSource(sourceFile);
        Parser parser = new Parser(new SearchPathSourceResolver(signatureSearchPath), ps, mss);
        return XylemC.compileSignature(sourceFile, parser);
    }

    public static final ModuleSignature compileSignature(URL sourceFile, Parser parser) throws Exception {
        ParserSource ps = new ParserSource(sourceFile);
        ModuleSignature ms = parser.parseExternalModuleSignature(ps);
        return ms;
    }

    public Module compile(URL sourceFile, ModuleSignature ms, List signatureSearchPath, ModuleSignatureStore mss) throws Exception {
        return this.compile(ms, new Parser(new SearchPathSourceResolver(signatureSearchPath), new ParserSource(sourceFile), mss));
    }

    public Module compile(ModuleSignature ms, Parser parser) throws Exception {
        Module module = parser.parseModule(ms);
        if (ms == null) {
            module.exportAllSymbols();
        }
        module.typeCheck();
        if (ms == null) {
            for (String s : new HashSet<String>(module.m_signature.m_functionSignatures.keySet())) {
                module.m_signature.addFunctionSignature(new FunctionSignature(module.getFunction(s)));
            }
        }
        module.reduce();
        if (module.getVDTMap() != null) {
            VDTMapOptimizer vmo = new VDTMapOptimizer(module.getVDTMap());
            module.optimize(vmo);
            vmo.doUpdate(module);
            vmo = null;
        }
        return module;
    }
}

