/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.commandline;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleImportDirective;
import com.ibm.xltxe.rnm1.xylem.ModuleLinker;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.PolymorphicADTDesugarer;
import com.ibm.xltxe.rnm1.xylem.Program;
import com.ibm.xltxe.rnm1.xylem.commandline.XylemC;
import com.ibm.xltxe.rnm1.xylem.instructions.EvalInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.parser.Parser;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.exec.BasicDynamicContext;
import com.ibm.xml.xci.exec.DynamicContext;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class XylemInterpreter
extends XylemC {
    private static final Logger s_logger = LoggerUtil.getLogger(XylemInterpreter.class);
    private static final String s_className = XylemInterpreter.class.getName();
    protected boolean m_debugger;
    protected String m_function;
    protected ArrayList m_args;

    public XylemInterpreter(String[] args) {
        super(args);
    }

    public static void main(String[] args) {
        new XylemInterpreter(args);
    }

    @Override
    public void init(String[] args) {
        this.m_function = "main";
        this.m_args = new ArrayList();
        this.m_debugger = false;
        super.init(args);
    }

    @Override
    public Module compile(ModuleSignature ms, Parser parser) throws Exception {
        return super.compile(ms, parser);
    }

    @Override
    protected int parseOption(String[] args, int i) {
        if (args[i].equals("-debug")) {
            this.m_debugger = true;
            return i;
        }
        if (args[i].equals("-function")) {
            this.m_function = args[++i];
            return i;
        }
        if (args[i].equals("-arg")) {
            String a;
            if ((a = args[++i]).equals("{")) {
                StringBuffer sb = new StringBuffer();
                while (!args[++i].equals("}")) {
                    sb.append(args[i]);
                    sb.append(" ");
                }
                a = sb.toString();
            }
            this.m_args.add(a);
            return i;
        }
        if (args[i].equals("-help") || args[i].equals("-?") || args[i].equals("-h")) {
            System.out.println("Usage: XylemInterpreter [-debug] [-function main] ([-arg {script}])* (file.xylem | file.xylemi | file.cxo)*");
            return -1;
        }
        return super.parseOption(args, i);
    }

    @Override
    public void run() {
        for (URL url : this.m_files) {
            this.m_signatureSearchPath.addFirst(url);
            this.handleFile(url, this.m_optimizationLevel);
            this.m_signatureSearchPath.removeFirst();
        }
        SessionContext session = new SessionContext();
        BasicDynamicContext dynamicContext = new BasicDynamicContext(session);
        this.evaluate(dynamicContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluate(DynamicContext dynamicContext) {
        Module prog = null;
        LinkedList<Module> modules = new LinkedList<Module>();
        for (URL url : this.m_filesToLink) {
            try {
                Module module = Module.loadCompiled(url, this.m_mss);
                if (module instanceof Program) {
                    prog = (Program)module;
                    continue;
                }
                modules.add(module);
            }
            catch (Exception e) {
                s_logger.logp(Level.SEVERE, s_className, "evaluate", "", e);
                throw new Error();
            }
        }
        if (prog == null) {
            ModuleSignature ms = new ModuleSignature("");
            prog = new Program(ms);
        }
        Iterator<Object> i = modules.iterator();
        while (i.hasNext()) {
            prog.addModule((Module)i.next());
        }
        try {
            prog.typeCheckReduced();
        }
        catch (Exception e) {
            s_logger.logp(Level.SEVERE, s_className, "evaluate", "", e);
            throw new Error(e.getMessage());
        }
        Program.dumpXylemFile(prog, null, "program-preflatten");
        ModuleLinker.reflattenModules((Program)prog);
        Program.dumpXylemFile(prog, null, "program-postflatten");
        Function main = null;
        Module primary = null;
        for (Module module : prog.getModules()) {
            s_logger.logp(Level.INFO, s_className, "evaluate", "checking " + module.getName());
            if (main != null || (main = prog.getFunction(ModuleImportDirective.translateFunctionName(this.m_function, module))) == null) continue;
            primary = module;
        }
        Object y = null;
        if (main == null) {
            Program.dumpXylemFile(prog, null, "program");
            throw new XylemError("ERR_SYSTEM", "function '" + this.m_function + "' not found");
        }
        try {
            prog.exportAllSymbols();
            prog.clearTypeInformation(true);
            prog.typeCheckReduced();
            prog.removeDeadFunctions();
            prog.instantiateReducedPolymorphicFunctions();
            prog.removeDeadFunctions();
            new PolymorphicADTDesugarer(prog).desugar();
            String className = main.getName();
            ((Program)prog).setClassName(className);
            prog.removeDeadFunctions();
            prog.typeCheckReduced();
            main.typeCheckReduced(prog, new LinkedList());
        }
        catch (Exception e) {
            Program.dumpXylemFile(prog, null, "program");
            s_logger.logp(Level.SEVERE, s_className, "evaluate", "error typechecking module", e);
            throw new XylemError("ERR_SYSTEM", "!");
        }
        Debugger d = null;
        Environment e = new Environment(dynamicContext);
        if (this.m_debugger) {
            d = new Debugger(prog);
            d.enterContext(main);
        }
        if (this.m_args.size() != main.m_parameters.length) {
            throw new XylemError("ERR_SYSTEM", "Wrong number of args for " + main.getName() + ", " + "got " + this.m_args.size() + ", need " + main.m_parameters.length);
        }
        e.establishStackFrame(main.getStackFrameSize());
        e.pushForkScope();
        Object ans = null;
        try {
            for (int j = 0; j < main.m_parameters.length; ++j) {
                EvalInstruction n2 = new EvalInstruction(main.m_parameters[j].getBindingType(), (String)this.m_args.get(j));
                Object val = ((Instruction)n2).evaluate(e, main, d, false);
                Binding binding = main.m_parameters[j];
                e.bindInEstablishedFrame(binding, val);
            }
            e.pushStackFrame();
            ans = main.getBody().evaluate(e, main, d, false);
            if (this.m_debugger) {
                d.leaveContext(main, ans);
            } else {
                System.out.println("result = " + ans);
            }
            e.popStackFrame();
            e.popForkScope(ans);
            e.release(ans);
        }
        catch (Throwable throwable) {
            e.popForkScope(ans);
            e.release(ans);
            throw throwable;
        }
    }
}

