/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.commandline;

import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleSignatureStore;
import com.ibm.xltxe.rnm1.xylem.commandline.CommandLineParserSingleInputFile;
import com.ibm.xml.ras.LoggerUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class XylemP
extends CommandLineParserSingleInputFile {
    private static final Logger s_logger = LoggerUtil.getLogger(XylemP.class);
    private static final String s_className = XylemP.class.getName();
    private static final int XYLEM = 0;
    private static final int XYLEMQ = 1;
    private static final int XYLEMML = 2;
    private static int m_language = 0;
    private ArrayList m_files = new ArrayList();
    private File m_outputDir = null;
    private PrintWriter m_currentPrintWriter = null;

    @Override
    protected int parseOption(String[] args, int i) {
        if (args[i].equals("-help") || args[i].equals("-?") || args[i].equals("-h")) {
            System.out.println("Usage: XylemP [-q] [-ml] [-I searchpath] [-output dirname] (file.cxo)*");
            return -1;
        }
        if ("-q".equals(args[i])) {
            m_language = 1;
            return i;
        }
        if ("-ml".equals(args[i])) {
            m_language = 2;
            return i;
        }
        if ("-output".equals(args[i]) || "--output".equals(args[i])) {
            if (++i == args.length) {
                s_logger.logp(Level.SEVERE, s_className, "parseOption", "-output missing parameter");
                return -1;
            }
            this.m_outputDir = new File(args[i]);
            if (!this.m_outputDir.exists() || !this.m_outputDir.isDirectory()) {
                s_logger.logp(Level.SEVERE, s_className, "parseOption", "Directory " + this.m_outputDir + " does not exist");
                return -1;
            }
            return i;
        }
        this.m_inputFile = this.validateInputFilename(args[i], false);
        if (this.m_inputFile == null) {
            return -1;
        }
        this.m_files.add(this.m_inputFile);
        return i;
    }

    public static void main(String[] args) {
        new XylemP(args);
    }

    public XylemP(String[] args) {
        if (!this.parseCommandLine(args)) {
            return;
        }
        try {
            this.m_signatureSearchPath.addFirst(new File(".").toURL());
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        ModuleSignatureStore m_mss = new ModuleSignatureStore(this.m_signatureSearchPath);
        Iterator i = this.m_files.iterator();
        while (i.hasNext()) {
            URL url = (URL)i.next();
            this.m_signatureSearchPath.addFirst(url);
            try {
                String baseName = new File(url.getPath()).getName();
                baseName = baseName.substring(0, baseName.lastIndexOf(".cxo"));
                Module module = Module.loadCompiled(url, m_mss);
                switch (m_language) {
                    case 0: {
                        this.println(baseName, module.toString());
                        if (!i.hasNext()) break;
                        this.println(null, ";; ============================================");
                        break;
                    }
                    case 2: {
                        s_logger.logp(Level.SEVERE, s_className, "XylemP", "XylemML output not supported.");
                        throw new Error("XylemML output not supported.");
                    }
                    case 1: {
                        try {
                            Class<?> qClass = Class.forName("com.ibm.xltxe.rnm1.xylem.xylemq.parser.QPrettyPrint");
                            Method qMethod = qClass.getMethod("printModule", Module.class, PrintStream.class);
                            if (null != this.m_outputDir) {
                                File outputFile = new File(this.m_outputDir, baseName + ".xylemq");
                                PrintStream psOutputFile = new PrintStream(new FileOutputStream(outputFile));
                                qMethod.invoke(null, module, psOutputFile);
                                break;
                            }
                            qMethod.invoke(null, module, System.out);
                            if (i.hasNext()) {
                                this.println(null, "// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-");
                            }
                            break;
                        }
                        catch (ClassNotFoundException e) {
                            s_logger.logp(Level.SEVERE, s_className, "XylemP", "Can't do XylemQ pretty print without QPrettyPrint");
                            throw new Error("Can't do XylemQ pretty print without QPrettyPrint");
                        }
                    }
                }
            }
            catch (Exception e) {
                s_logger.logp(Level.SEVERE, s_className, "XylemP", "Error converting CXO to Module", e);
                throw new Error("Error converting CXO to Module");
            }
            this.m_signatureSearchPath.removeFirst();
        }
    }

    private void println(String baseName, String str) {
        if (null != this.m_outputDir) {
            if (null == this.m_currentPrintWriter) {
                try {
                    File outputFile = new File(this.m_outputDir, baseName + ".xylem");
                    if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                        s_logger.logp(Level.FINE, s_className, "println", "Dumping program to file " + outputFile);
                    }
                    FileWriter xw = new FileWriter(outputFile);
                    this.m_currentPrintWriter = new PrintWriter(xw);
                    this.m_currentPrintWriter.write(str);
                    this.m_currentPrintWriter.close();
                    this.m_currentPrintWriter = null;
                }
                catch (IOException e2) {
                    s_logger.logp(Level.SEVERE, s_className, "println", "i/o error", e2);
                }
            }
        } else {
            System.out.println(str);
        }
    }
}

