/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.dataflow;

public class CursorGrammarStateMachine {
    static final int numOperations = Operation.values().length;
    static final int forkFull = Operation.forkFull.ordinal();
    static final int forkMustNavigate = Operation.forkMustNavigate.ordinal();
    static final int toAttributes = Operation.toAttributes.ordinal();
    static final int toChildren = Operation.toChildren.ordinal();
    static final int toNext = Operation.toNext.ordinal();
    static final int whileToNext = Operation.whileToNext.ordinal();
    static final int release = Operation.release.ordinal();
    static final int ifItemKindIsElement = Operation.ifItemKindIsElement.ordinal();
    static final int itemKind = Operation.itemKind.ordinal();
    static final int itemName = Operation.itemName.ordinal();
    static final int itemTypedValue = Operation.itemTypedValue.ordinal();
    static final int itemStringValue = Operation.itemStringValue.ordinal();
    static final int itemCopy = Operation.itemCopy.ordinal();
    static final int serialize = Operation.serialize.ordinal();
    static final int other = Operation.other.ordinal();
    static final int numStates = State.values().length;
    static final int sequence = State.SEQUENCE.ordinal();
    static final int needsIfItemKindIsElement = State.NEEDS_IF_ITEMKIND_IS_ELEMENT.ordinal();
    static final int knowItemKind = State.KNOW_ITEMKIND.ordinal();
    static final int needsAttrFork = State.NEEDS_ATTR_FORK.ordinal();
    static final int needsToAttr = State.NEEDS_TO_ATTRIBUTE.ordinal();
    static final int attrSequence = State.ATTR_SEQUENCE.ordinal();
    static final int needsChildrenFork = State.NEEDS_CHILDREN_FORK.ordinal();
    static final int needsToChildren = State.NEEDS_TO_CHILDREN.ordinal();
    static final int childrenSequence = State.CHILDREN_SEQUENCE.ordinal();
    static final int needsToNext = State.NEEDS_TO_NEXT.ordinal();
    static final int openForAny = State.OPEN_FOR_ANY.ordinal();
    static final int numGrammarLevels = GrammarLevel.values().length;
    static final int MINIMAL_FORK = GrammarLevel.MINIMAL_FORK.ordinal();
    static final int MINIMAL_STREAMING_NAVIGATION = GrammarLevel.MINIMAL_STREAMING_NAVIGATION.ordinal();
    static final int MINIMAL_SKIP_STREAMING_NAVIGATION = GrammarLevel.MINIMAL_SKIP_STREAMING_NAVIGATION.ordinal();
    static final int MINIMAL_STACK_NAVIGATION = GrammarLevel.MINIMAL_STACK_NAVIGATION.ordinal();
    static final int MINIMAL_FRONTIER_NAVIGATION = GrammarLevel.MINIMAL_FRONTIER_NAVIGATION.ordinal();

    public static void main(String[] args) {
    }

    private static class GrammarLevelsTable {
        static GrammarLevelStateMachine[] _grammars;

        private GrammarLevelsTable() {
        }

        static {
            int i;
            _grammars = new GrammarLevelStateMachine[numGrammarLevels];
            for (i = 0; i < numGrammarLevels; ++i) {
                GrammarLevelsTable._grammars[i] = new GrammarLevelStateMachine(GrammarLevel.values()[i]);
            }
            for (i = 0; i < numGrammarLevels; ++i) {
                for (int stateIndex = 0; stateIndex < numStates; ++stateIndex) {
                    block6: for (int operationIndex = 0; operationIndex < numOperations; ++operationIndex) {
                        switch (Operation.values()[stateIndex]) {
                            case itemKind: 
                            case itemName: {
                                GrammarLevelsTable._grammars[i].states[stateIndex].grammar = _grammars[i];
                                continue block6;
                            }
                            default: {
                                GrammarLevelsTable._grammars[i].states[stateIndex].grammar = _grammars[GrammarLevel.MINIMAL_FRONTIER_NAVIGATION.ordinal()];
                            }
                        }
                    }
                }
            }
            GrammarLevelsTable._grammars[CursorGrammarStateMachine.MINIMAL_FORK].states[CursorGrammarStateMachine.sequence].transitions[CursorGrammarStateMachine.ifItemKindIsElement] = State.KNOW_ITEMKIND;
            GrammarLevelsTable._grammars[CursorGrammarStateMachine.MINIMAL_FORK].states[CursorGrammarStateMachine.knowItemKind].transitions[CursorGrammarStateMachine.itemName] = State.NEEDS_ATTR_FORK;
            GrammarLevelsTable._grammars[CursorGrammarStateMachine.MINIMAL_FORK].states[CursorGrammarStateMachine.knowItemKind].transitions[CursorGrammarStateMachine.forkMustNavigate] = State.NEEDS_TO_ATTRIBUTE;
            GrammarLevelsTable._grammars[CursorGrammarStateMachine.MINIMAL_FORK].states[CursorGrammarStateMachine.needsAttrFork].transitions[CursorGrammarStateMachine.forkMustNavigate] = State.NEEDS_TO_ATTRIBUTE;
            GrammarLevelsTable._grammars[CursorGrammarStateMachine.MINIMAL_FORK].states[CursorGrammarStateMachine.needsToAttr].transitions[CursorGrammarStateMachine.toAttributes] = State.ATTR_SEQUENCE;
            GrammarLevelsTable._grammars[CursorGrammarStateMachine.MINIMAL_FORK].states[CursorGrammarStateMachine.attrSequence].transitions[CursorGrammarStateMachine.itemStringValue] = State.NEEDS_TO_NEXT;
            GrammarLevelsTable._grammars[CursorGrammarStateMachine.MINIMAL_FORK].states[CursorGrammarStateMachine.attrSequence].transitions[CursorGrammarStateMachine.itemTypedValue] = State.NEEDS_TO_NEXT;
            GrammarLevelsTable._grammars[CursorGrammarStateMachine.MINIMAL_FORK].states[CursorGrammarStateMachine.toNext].transitions[CursorGrammarStateMachine.itemTypedValue] = State.ATTR_SEQUENCE;
            GrammarLevelsTable._grammars[CursorGrammarStateMachine.MINIMAL_FORK].states[CursorGrammarStateMachine.toNext].transitions[CursorGrammarStateMachine.release] = State.NEEDS_CHILDREN_FORK;
            GrammarLevelsTable._grammars[CursorGrammarStateMachine.MINIMAL_FORK].states[CursorGrammarStateMachine.attrSequence].transitions[CursorGrammarStateMachine.release] = State.NEEDS_CHILDREN_FORK;
            GrammarLevelsTable._grammars[CursorGrammarStateMachine.MINIMAL_FORK].states[CursorGrammarStateMachine.needsToAttr].transitions[CursorGrammarStateMachine.toAttributes] = State.ATTR_SEQUENCE;
            GrammarLevelsTable._grammars[CursorGrammarStateMachine.MINIMAL_FORK].states[CursorGrammarStateMachine.attrSequence].transitions[CursorGrammarStateMachine.release] = State.NEEDS_CHILDREN_FORK;
            GrammarLevelsTable._grammars[CursorGrammarStateMachine.MINIMAL_FORK].states[CursorGrammarStateMachine.needsChildrenFork].transitions[CursorGrammarStateMachine.toChildren] = State.CHILDREN_SEQUENCE;
            GrammarLevelsTable._grammars[CursorGrammarStateMachine.MINIMAL_FORK].states[CursorGrammarStateMachine.childrenSequence].transitions[CursorGrammarStateMachine.release] = State.NEEDS_TO_NEXT;
            GrammarLevelsTable._grammars[CursorGrammarStateMachine.MINIMAL_FORK].states[CursorGrammarStateMachine.attrSequence].transitions[CursorGrammarStateMachine.itemTypedValue] = State.NEEDS_TO_NEXT;
            GrammarLevelsTable._grammars[CursorGrammarStateMachine.MINIMAL_FORK].states[CursorGrammarStateMachine.attrSequence].transitions[CursorGrammarStateMachine.itemStringValue] = State.NEEDS_TO_NEXT;
            GrammarLevelsTable._grammars[CursorGrammarStateMachine.MINIMAL_FORK].states[CursorGrammarStateMachine.needsToNext].transitions[CursorGrammarStateMachine.whileToNext] = State.SEQUENCE;
            GrammarLevelsTable._grammars[CursorGrammarStateMachine.MINIMAL_FORK].states[CursorGrammarStateMachine.attrSequence].transitions[CursorGrammarStateMachine.whileToNext] = State.SEQUENCE;
            GrammarLevelsTable._grammars[CursorGrammarStateMachine.MINIMAL_FORK].states[CursorGrammarStateMachine.childrenSequence].transitions[CursorGrammarStateMachine.toNext] = State.NEEDS_ATTR_FORK;
        }
    }

    private static class GrammarLevelStateMachine {
        GrammarLevel _grammarLevel;
        CursorState[] states;
        CursorState currentState;

        public GrammarLevelStateMachine(GrammarLevel state) {
            this._grammarLevel = state;
            this.states = new CursorState[numStates];
            for (int i = 0; i < numStates; ++i) {
                this.states[i] = new CursorState(State.values()[i]);
            }
        }

        GrammarLevelStateMachine changeState(Operation operation) {
            this.currentState = this.states[this.currentState.transitions[operation.ordinal()].ordinal()];
            return this.currentState.grammar;
        }
    }

    private static class CursorState {
        State state;
        GrammarLevelStateMachine grammar;
        State[] transitions;

        public CursorState(State state) {
            this.state = state;
            this.transitions = new State[numOperations];
            for (int i = 0; i < numOperations; ++i) {
                this.transitions[i] = State.OPEN_FOR_ANY;
            }
        }
    }

    private static enum GrammarLevel {
        MINIMAL_FORK,
        MINIMAL_STREAMING_NAVIGATION,
        MINIMAL_SKIP_STREAMING_NAVIGATION,
        MINIMAL_STACK_NAVIGATION,
        MINIMAL_FRONTIER_NAVIGATION;

    }

    private static enum State {
        SEQUENCE,
        NEEDS_IF_ITEMKIND_IS_ELEMENT,
        KNOW_ITEMKIND,
        NEEDS_ATTR_FORK,
        NEEDS_TO_ATTRIBUTE,
        ATTR_SEQUENCE,
        NEEDS_CHILDREN_FORK,
        NEEDS_TO_CHILDREN,
        CHILDREN_SEQUENCE,
        NEEDS_TO_ATTR_NEXT,
        NEEDS_CHILDREN_TO_NEXT,
        NEEDS_TO_NEXT,
        OPEN_FOR_ANY;

    }

    private static enum Operation {
        forkFull,
        forkMustNavigate,
        release,
        toAttributes,
        toChildren,
        toNext,
        whileToNext,
        ifItemKindIsElement,
        itemKind,
        itemName,
        itemTypedValue,
        itemStringValue,
        itemCopy,
        serialize,
        other;

    }
}

