/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.drivers;

import com.ibm.xltxe.rnm1.xylem.FunctionSignature;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.ModuleSignatureStore;
import com.ibm.xltxe.rnm1.xylem.commandline.CommandLineParserMultipleInputFile;
import com.ibm.xltxe.rnm1.xylem.commandline.SearchPathSourceResolver;
import com.ibm.xltxe.rnm1.xylem.drivers.IXylemDriver;
import com.ibm.xltxe.rnm1.xylem.optimizers.VDTMapOptimizer;
import com.ibm.xltxe.rnm1.xylem.parser.Parser;
import com.ibm.xltxe.rnm1.xylem.parser.ParserSource;
import com.ibm.xml.ras.LoggerUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Compiler
implements IXylemDriver {
    private static final Logger s_logger = LoggerUtil.getLogger(Compiler.class);
    private static final String s_className = Compiler.class.getName();
    public ModuleSignatureStore m_mss;
    public File m_outputDir = new File(".").getAbsoluteFile();

    public static void main(String[] args) {
        CLP clp = new CLP();
        Compiler compiler = clp.m_compiler = new Compiler();
        if (!clp.parseCommandLine(args)) {
            System.exit(-1);
        }
        try {
            clp.m_signatureSearchPath.addFirst(new File(".").toURL());
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        compiler.m_mss = new ModuleSignatureStore(clp.m_signatureSearchPath);
        try {
            List modules = compiler.compileFiles(clp, null, true, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List compileFiles(CLP clp, Collection functionsToExport, boolean writeCX, boolean returnModules) {
        LinkedList<Module> modules = new LinkedList<Module>();
        for (URL url : clp.m_files) {
            s_logger.logp(Level.INFO, s_className, "compileFiles", "compiling " + url.getPath());
            try {
                Module m = this.handleFile(url, clp, writeCX);
                if (!returnModules) continue;
                modules.add(m);
            }
            catch (Exception e) {
                s_logger.logp(Level.SEVERE, s_className, "compileFiles", "", e);
                throw new Error();
            }
        }
        return returnModules ? modules : null;
    }

    protected Module handleFile(URL url, CLP clp, boolean writeCX) {
        String s = url.toString();
        if (s.endsWith(".xylem")) {
            String name2;
            ModuleSignature ms = null;
            try {
                String s2 = url.getPath();
                s2 = s2.substring(s2.lastIndexOf("/") + 1);
                ms = this.m_mss.resolveModuleSignature(s2.substring(0, s2.length() - 6));
            }
            catch (Exception e) {
                s_logger.logp(Level.SEVERE, s_className, "handleFile", "Error reading compiled interface file", e);
                System.exit(-1);
            }
            Module m = null;
            try {
                m = this.compile(url, ms, clp.m_signatureSearchPath, this.m_mss);
            }
            catch (Exception e) {
                s_logger.logp(Level.SEVERE, s_className, "handleFile", "Error occurred during compilation of " + url, e);
                System.exit(-1);
            }
            if (m.getName().equals("")) {
                name2 = url.getPath();
                name2 = name2.substring(name2.lastIndexOf("/") + 1);
                m.setName(name2);
            }
            if (m.getName().endsWith(".xylem")) {
                name2 = m.getName();
                name2 = name2.substring(0, name2.lastIndexOf(".xylem"));
                m.setName(name2);
            }
            if (writeCX) {
                String cxo = m.getName() + ".cxo";
                try {
                    File cxoFile = new File(cxo);
                    ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(cxoFile));
                    Module.writeModule(oos, m);
                    oos.flush();
                    oos.close();
                }
                catch (Exception e) {
                    s_logger.logp(Level.SEVERE, s_className, "handleFile", "Error occurred writing of compiled module to " + cxo, e);
                    System.exit(-1);
                }
                String cxi = ModuleSignatureStore.makeFilename(m.getName()) + ".cxi";
                Compiler.writeOutSignature(m.m_signature, cxi);
            }
            return m;
        }
        if (s.endsWith(".xylemi")) {
            ModuleSignature ms = null;
            try {
                ms = Compiler.compileSignature(url, clp.m_signatureSearchPath, this.m_mss);
            }
            catch (Exception e) {
                s_logger.logp(Level.SEVERE, s_className, "handleFile", "Error occurred during compilation of signature " + url, e);
                System.exit(-1);
            }
            if (writeCX) {
                String cxi = ModuleSignatureStore.makeFilename(ms.getName()) + ".cxi";
                Compiler.writeOutSignature(ms, cxi);
            }
            return null;
        }
        s_logger.logp(Level.WARNING, s_className, "handleFile", "Ignoring file with unrecognized extension: " + url);
        return null;
    }

    public Module compile(URL sourceFile, ModuleSignature ms, List signatureSearchPath, ModuleSignatureStore mss) throws Exception {
        return this.compile(ms, new Parser(new SearchPathSourceResolver(signatureSearchPath), new ParserSource(sourceFile), mss));
    }

    public Module compile(ModuleSignature ms, Parser parser) throws Exception {
        Module module = parser.parseModule(ms);
        if (ms == null) {
            module.exportAllSymbols();
        }
        module.typeCheck();
        if (ms == null) {
            for (String s : new HashSet<String>(module.m_signature.m_functionSignatures.keySet())) {
                module.m_signature.addFunctionSignature(new FunctionSignature(module.getFunction(s)));
            }
        }
        module.reduce();
        if (module.getVDTMap() != null) {
            VDTMapOptimizer vmo = new VDTMapOptimizer(module.getVDTMap());
            module.optimize(vmo);
            vmo.doUpdate(module);
            vmo = null;
        }
        return module;
    }

    public static final ModuleSignature compileSignature(URL sourceFile, List signatureSearchPath, ModuleSignatureStore mss) throws Exception {
        ParserSource ps = new ParserSource(sourceFile);
        Parser parser = new Parser(new SearchPathSourceResolver(signatureSearchPath), ps, mss);
        return Compiler.compileSignature(sourceFile, parser);
    }

    public static final ModuleSignature compileSignature(URL sourceFile, Parser parser) throws Exception {
        ParserSource ps = new ParserSource(sourceFile);
        ModuleSignature ms = parser.parseExternalModuleSignature(ps);
        return ms;
    }

    public static final void writeOutSignature(ModuleSignature ms, String cxi) {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(cxi));
            ms.write(oos);
            oos.flush();
            oos.close();
        }
        catch (Exception e) {
            s_logger.logp(Level.SEVERE, s_className, "writeOutSignature", "Error occurred writing of compiled signature to " + cxi, e);
            System.exit(-1);
        }
    }

    public static final void writeOutSignature(ModuleSignature ms, String cxi, File outputDir) {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(new File(outputDir, cxi)));
            ms.write(oos);
            oos.flush();
            oos.close();
        }
        catch (Exception e) {
            s_logger.logp(Level.SEVERE, s_className, "writeOutSignature", "Error occurred writing of compiled signature to " + cxi, e);
            System.exit(-1);
        }
    }

    public static class CLP
    extends CommandLineParserMultipleInputFile {
        public Compiler m_compiler;

        @Override
        protected int parseOption(String[] args, int i) {
            if (args[i].equals("-help") || args[i].equals("-?") || args[i].equals("-h")) {
                System.out.println("Usage: Compiler");
                super.parseOption(args, i);
                System.out.println("Input files should be be *.xylem or *.xylemi");
                return -1;
            }
            return super.parseOption(args, i);
        }
    }
}

