/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.drivers;

import com.ibm.xltxe.rnm1.fcg.FcgAttrs;
import com.ibm.xltxe.rnm1.fcg.FcgClassCollector;
import com.ibm.xltxe.rnm1.fcg.FcgClassGen;
import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgCodeGen;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgMethodGen;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgVariable;
import com.ibm.xltxe.rnm1.fcg.impl.HiddenOptions;
import com.ibm.xltxe.rnm1.fcg.javasrc.FcgClassGenJavaSrc;
import com.ibm.xltxe.rnm1.xylem.AbstractTypeStore;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IdentifierConsolidator;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleImportDirective;
import com.ibm.xltxe.rnm1.xylem.ModuleLinker;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.ModuleSignatureStore;
import com.ibm.xltxe.rnm1.xylem.PolymorphicADTDesugarer;
import com.ibm.xltxe.rnm1.xylem.Program;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationSettings;
import com.ibm.xltxe.rnm1.xylem.codegen.JavaC;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.commandline.CommandLineParserMultipleInputFile;
import com.ibm.xltxe.rnm1.xylem.drivers.IXylemDriver;
import com.ibm.xltxe.rnm1.xylem.optimizers.DeadLetEliminatorOptimizer;
import com.ibm.xltxe.rnm1.xylem.optimizers.SplitFunctions;
import com.ibm.xltxe.rnm1.xylem.optimizers.TerminalLetOptimizer;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluationOptimizer;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.SessionContext;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Linker
implements IXylemDriver {
    static final boolean SHOW_CPP_RESULT = false;
    private static final Logger s_logger = LoggerUtil.getLogger(Linker.class);
    private static final String s_className = Linker.class.getName();
    public ModuleSignatureStore m_mss;
    public static final String JAVADESTDIR_OPTION = "javeDestDir";
    public static final String relativeDir = HiddenOptions.getStringValue("javeDestDir", ".");
    public File m_outputDir = new File(relativeDir).getAbsoluteFile();
    public boolean m_isPerf;
    public boolean m_dumpXylem;
    public boolean m_dumpIntermediateXylem;
    public CodeGenerationSettings m_codeGenerationSettings = new CodeGenerationSettings();

    protected void optimize(Module prog, Function main) {
    }

    public static void main(String[] args) {
        Linker linker;
        SessionContext session = new SessionContext();
        CLP clp = new CLP();
        clp.m_linker = linker = new Linker();
        if (!clp.parseCommandLine(args)) {
            System.exit(-1);
        }
        try {
            clp.m_signatureSearchPath.addFirst(new File(".").toURL());
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        linker.m_mss = new ModuleSignatureStore(clp.m_signatureSearchPath);
        linker.m_dumpXylem = linker.m_codeGenerationSettings.m_dumpxylem;
        linker.m_dumpIntermediateXylem = clp.m_dumpIntermediateXylem;
        linker.m_isPerf = clp.m_isPerf;
        try {
            File file = linker.linkFiles(clp.m_files, clp.m_className, null, null, 1, session);
            if (file != null && !linker.m_codeGenerationSettings.getJavaCSettings().isJavaCDisabled()) {
                JavaC.compile(file.getParentFile(), new String[]{file.getName()}, linker.m_outputDir, null, null, linker.m_codeGenerationSettings.getJavaCSettings());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public File linkFiles(List filesToLink, String className, String packageName, Collection functionsToExport, int optimizationLevel, SessionContext session) {
        LinkedList<Module> modules = new LinkedList<Module>();
        for (URL url : filesToLink) {
            s_logger.logp(Level.INFO, s_className, "linkFiles", "linking " + url.getPath());
            try {
                Module module = Module.loadCompiled(url, this.m_mss);
                modules.add(module);
            }
            catch (Exception e) {
                s_logger.logp(Level.SEVERE, s_className, "linkFiles", "", e);
                throw new Error();
            }
        }
        return this.linkModules(modules, className, packageName, functionsToExport, optimizationLevel, session);
    }

    public File linkModules(List modules, String className, String packageName, Collection functionsToExport, int optimizationLevel, SessionContext session) {
        Program prog = null;
        Iterator i = modules.iterator();
        boolean flattened = false;
        while (i.hasNext()) {
            Module module = (Module)i.next();
            if (!(module instanceof Program)) continue;
            if (prog != null) {
                s_logger.logp(Level.WARNING, s_className, "linkModules", "Program conflict noted: " + module.getName() + " dominates over " + prog.getName());
            }
            prog = (Program)module;
        }
        if (prog == null) {
            ModuleSignature ms = new ModuleSignature("");
            prog = new Program(ms);
        } else {
            flattened = true;
        }
        i = modules.iterator();
        while (i.hasNext()) {
            prog.addModule((Module)i.next());
        }
        if (flattened) {
            ModuleLinker.reflattenModules(prog);
        } else {
            ModuleLinker.flattenModules(prog);
        }
        prog.expandTypeAliases();
        Function main = null;
        AbstractTypeStore primary = null;
        for (Module module : modules) {
            s_logger.logp(Level.INFO, s_className, "linkModules", "checking " + module.getName());
            if (main != null || (main = prog.getFunction(ModuleImportDirective.translateFunctionName("main", module))) == null) continue;
            primary = module;
            break;
        }
        if (primary == null) {
            s_logger.logp(Level.SEVERE, s_className, "linkModules", "no primary module found");
            return null;
        }
        String translatedMainFunctionName = null;
        if (main != null) {
            translatedMainFunctionName = ModuleImportDirective.translateFunctionName("main", primary);
            prog.forceFunctionGeneration(prog.getFunction(translatedMainFunctionName));
        }
        if (functionsToExport != null) {
            for (String s : functionsToExport) {
                prog.forceFunctionGeneration(prog.getFunction(s));
            }
        }
        if (this.m_dumpIntermediateXylem) {
            s_logger.logp(Level.INFO, s_className, "linkModules", "Dumping pre-optimization Xylem code");
            if (className == null) {
                className = primary.getName();
            }
            Program.dumpXylemFile(prog, this.m_outputDir, className + ".preopt");
        }
        try {
            prog.typeCheckReduced();
            prog.removeDeadFunctions();
            prog.instantiateReducedPolymorphicFunctions();
            prog.removeDeadFunctions();
            this.desugar(prog);
            if (className == null) {
                className = primary.getName();
            }
            prog.setClassName(className);
            prog.removeDeadFunctions();
            HashSet<String> entryPoints = new HashSet<String>();
            entryPoints.add(className + "$main");
            IdentifierConsolidator ic = new IdentifierConsolidator();
            PartialEvaluationOptimizer peo = new PartialEvaluationOptimizer(entryPoints, new CodeGenerationSettings());
            peo.m_ic = ic;
            prog.optimize(peo);
            peo = new PartialEvaluationOptimizer(entryPoints, new CodeGenerationSettings());
            peo.m_ic = ic;
            prog.optimize(peo);
            prog.optimize(new TerminalLetOptimizer());
            if (this.m_codeGenerationSettings.getPostReductionSplitLimit() > 0) {
                prog.optimize(new SplitFunctions((Module)prog, this.m_codeGenerationSettings.getPostReductionSplitLimit()));
                DeadLetEliminatorOptimizer.eliminateDeadLets(prog);
            }
            this.optimize(prog, main);
            if (this.m_dumpXylem) {
                s_logger.logp(Level.INFO, s_className, "linkModules", "Dumping Xylem code to " + new File(this.m_outputDir, className));
                Program.dumpXylemFile(prog, this.m_outputDir, className);
            }
            switch (this.m_codeGenerationSettings.getTargetLanguage()) {
                case 3: 
                case 4: {
                    final String fnameExtension = this.m_codeGenerationSettings.getTargetLanguage() == 3 ? ".java" : ".class";
                    File file = new File(this.m_outputDir, className + fnameExtension);
                    FileWriter fw = new FileWriter(file);
                    PrintWriter pw = new PrintWriter(fw);
                    s_logger.logp(Level.INFO, s_className, "linkModules", "Starting generation");
                    FcgClassCollector fcgClassCollector = new FcgClassCollector(){

                        @Override
                        public void acceptGeneratedClass(FcgClassGen jc) {
                            try {
                                jc.dump(new File(Linker.this.m_outputDir, jc.getClassType().getTypeName() + fnameExtension));
                            }
                            catch (IOException e) {
                                s_logger.logp(Level.SEVERE, s_className, "linkModules", "I/O error", e);
                            }
                        }
                    };
                    FcgCodeGenHelper cgh = FcgCodeGenHelper.createFcgCodeGenHelper(className + "_Common", null, null, this.m_codeGenerationSettings, fcgClassCollector);
                    prog.generateCode(cgh, session);
                    FcgCodeGen cg = cgh.getFcgCodeGen();
                    FcgClassGenJavaSrc fcgClassGen = null;
                    FcgClassReferenceType clazz = cgh.getClassReferenceType(className);
                    FcgClassReferenceType directSuperClazz = cgh.getClassReferenceType(className + "_Common");
                    fcgClassGen = new FcgClassGenJavaSrc(cg, clazz, directSuperClazz, className + ".java", null, null);
                    FcgMethodGen meth = fcgClassGen.newMethodGen(FcgAttrs.PUBLIC_STATIC, FcgType.VOID, "main");
                    meth.addParameter(FcgType.STRING_ARRAY, "argv");
                    FcgInstructionList fcgIL = meth.getInstructionList();
                    fcgIL.beginMethod();
                    fcgIL.createObjectExpr((FcgType)clazz, 0);
                    FcgVariable instance2 = fcgIL.defineVar(clazz, "instance", true);
                    fcgIL.loadVar(instance2);
                    String methodName = Function.generateFunctionName(cgh, translatedMainFunctionName);
                    fcgIL.invokeClassMethod(clazz, methodName, null, 1);
                    fcgIL.printOut();
                    fcgIL.returnInstruction();
                    fcgIL.endMethod();
                    fcgClassCollector.acceptGeneratedClass(fcgClassGen);
                    pw.flush();
                    pw.close();
                    return file;
                }
            }
            throw new XylemError("ERR_SYSTEM", "Unsupported target language");
        }
        catch (Throwable e) {
            s_logger.logp(Level.SEVERE, s_className, "linkModules", "Error occurred during linking", e);
            return null;
        }
    }

    protected void desugar(Program prog) {
        new PolymorphicADTDesugarer(prog).desugar();
    }

    public static class CLP
    extends CommandLineParserMultipleInputFile {
        public Linker m_linker;
        public String m_className;
        public boolean m_dumpIntermediateXylem = false;
        public boolean m_isPerf = false;
        public String m_pkgName = null;

        @Override
        protected int parseOption(String[] args, int i) {
            if (args[i].equals("-help") || args[i].equals("-?") || args[i].equals("-h")) {
                System.out.println("Usage: Linker\n\t[-classname name]\n\t[-packagename name]\n\t[-dumpIntermediateXylem]\n\t[-d outputDir]");
                this.m_linker.m_codeGenerationSettings.parseOption(args, i);
                super.parseOption(args, i);
                System.out.println("Input files should be *.cxo");
                return -1;
            }
            if (args[i].equals("-classname")) {
                if (++i == args.length) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "-classname missing parameter");
                    return -1;
                }
                this.m_className = args[i];
                return i;
            }
            if (args[i].equals("-packagename")) {
                if (++i == args.length) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "-packagename missing parameter");
                    return -1;
                }
                this.m_pkgName = args[i];
                return i;
            }
            if (args[i].equals("-javac")) {
                s_logger.logp(Level.INFO, s_className, "parseOption", "-javac is now default; use -disablejavac to suppress");
                return i;
            }
            if (args[i].equals("-dumpIntermediateXylem")) {
                this.m_dumpIntermediateXylem = true;
                return i;
            }
            if (args[i].equals("-d")) {
                if (++i == args.length) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "-d missing parameter");
                    return -1;
                }
                this.m_linker.m_outputDir = new File(args[i]).getAbsoluteFile();
                return i;
            }
            if (args[i].equals("-perf")) {
                this.m_isPerf = true;
                return i;
            }
            int j = this.m_linker.m_codeGenerationSettings.parseOption(args, i);
            if (j == -1) {
                return -1;
            }
            if (j != -2) {
                return j;
            }
            return super.parseOption(args, i);
        }
    }
}

