/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgBinOp;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgUnaryOp;
import com.ibm.xltxe.rnm1.fcg.FcgVariable;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.UnaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.types.BigIntegerType;
import com.ibm.xltxe.rnm1.xylem.types.DecimalType;
import com.ibm.xltxe.rnm1.xylem.types.DoubleType;
import com.ibm.xltxe.rnm1.xylem.types.FloatType;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xltxe.rnm1.xylem.types.IntegerType;
import com.ibm.xltxe.rnm1.xylem.types.LongType;
import com.ibm.xltxe.rnm1.xylem.utils.OverflowException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.LinkedList;

public class AbsoluteValueInstruction
extends UnaryPrimopInstruction {
    public AbsoluteValueInstruction(Instruction parameter) {
        super(parameter);
    }

    public AbsoluteValueInstruction() {
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        AbsoluteValueInstruction i = new AbsoluteValueInstruction(this.m_operand.cloneWithoutTypeInformation());
        AbsoluteValueInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        super.doDefaultTypeCheck(tenv, benv, functionStack);
        return this.setCachedType(this.m_operand.typeCheck(tenv, benv, functionStack));
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        return this.m_operand.getType(tenv, benv);
    }

    @Override
    public Type getPreTypecheckType(ModuleSignature msig) {
        return this.m_operand.getPreTypecheckType(msig);
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cgh, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        FcgType fcgVarType = null;
        cgt.generateConventionally(this.m_operand, cgh, false, il, ValueGenStyle.DEFAULT);
        Type t = cgt.resolveType(this);
        if (t.equals(IntType.s_intType) || t.equals(FloatType.s_floatType) || t.equals(DoubleType.s_doubleType) || t.equals(IntegerType.s_integerType) || t.equals(LongType.s_longType) || t.equals(BigIntegerType.s_bigIntegerType) || t.equals(DecimalType.s_decimalType)) {
            if (t.equals(IntegerType.s_integerType) && !cgh.getSettings().getArbitraryPrecision() && cgh.getSettings().getOverflowDetection()) {
                FcgVariable temp = il.defineVar(FcgType.LONG, cgh.generateNewLocalVariableName(), true);
                il.loadVar(temp);
                il.loadLiteral(Long.MIN_VALUE);
                il.binaryOperationExpr(FcgBinOp.COMPARE_EQ);
                il.beginIf();
                il.createObjectExpr((FcgType)FcgType.OVERFLOW_EXCEPTION, 0);
                il.throwObject();
                il.endIf();
                il.loadVar(temp);
            }
        } else {
            throw new UnsupportedOperationException("Absolute value not supported for type " + t);
        }
        fcgVarType = il.unaryOperationExpr(FcgUnaryOp.ABSOLUTE_VALUE);
        return fcgVarType;
    }

    @Override
    public String innerToString() {
        return "abs";
    }

    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        Object x;
        if (null != di) {
            di.enter(this, e, f2);
        }
        if ((x = this.m_operand.evaluate(e, f2, di, false)) instanceof Long) {
            Long l = (Long)x;
            if (e.getOverflowDetection() && l == Long.MIN_VALUE) {
                throw new OverflowException();
            }
            Long ans = new Long(Math.abs((Long)x));
            return Debugger.leave(di, this, e, f2, (Object)ans);
        }
        if (x instanceof Integer) {
            Integer ans = new Integer(Math.abs((Integer)x));
            return Debugger.leave(di, this, e, f2, (Object)ans);
        }
        if (x instanceof Double) {
            Double ans = new Double(Math.abs((Double)x));
            return Debugger.leave(di, this, e, f2, (Object)ans);
        }
        if (x instanceof Float) {
            Float ans = new Float(Math.abs(((Float)x).floatValue()));
            return Debugger.leave(di, this, e, f2, (Object)ans);
        }
        if (x instanceof BigInteger) {
            BigInteger ans = ((BigInteger)x).abs();
            return Debugger.leave(di, this, e, f2, (Object)ans);
        }
        if (x instanceof BigDecimal) {
            BigDecimal ans = ((BigDecimal)x).abs();
            return Debugger.leave(di, this, e, f2, (Object)ans);
        }
        throw new UnsupportedOperationException("Absolute value is not supported on type " + x.getClass());
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction operand2) {
        AbsoluteValueInstruction i = new AbsoluteValueInstruction(operand2);
        AbsoluteValueInstruction.propagateInfo(this, i);
        return i;
    }
}

