/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgVariable;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.NaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Closure;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.interpreter.IAppendableStream;
import com.ibm.xltxe.rnm1.xylem.types.LambdaType;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class ApplyInstruction
extends NaryPrimopInstruction {
    protected Instruction m_lambda;
    private Object m_tailLoopApply = null;
    private IBinding[] m_tailLoopParams = null;
    private boolean m_isPure = true;
    protected LambdaType m_lambdaType;

    public ApplyInstruction() {
    }

    public ApplyInstruction(Instruction lambda2, Instruction[] parameters, boolean isPure) {
        super(parameters);
        this.m_lambda = lambda2;
        this.m_isPure = isPure;
    }

    public ApplyInstruction(Instruction lambda2, List parameters, boolean isPure) {
        super(parameters);
        this.m_lambda = lambda2;
        this.m_isPure = isPure;
    }

    @Override
    public boolean isPure() {
        return this.m_isPure;
    }

    public Instruction[] getParameters() {
        return this.m_parameters;
    }

    public int getParameterCount() {
        return this.m_parameters.length;
    }

    public Instruction getLambda() {
        return this.m_lambda;
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        Type returnType = this.m_lambdaType.getReturnType();
        Type ans = returnType.resolveType(tenv);
        return null != ans ? ans : returnType;
    }

    protected void setupType(TypeEnvironment tenv, BindingEnvironment benv) {
        Type t = this.m_lambda.getType(tenv, benv);
        if (t instanceof LambdaType) {
            this.m_lambdaType = (LambdaType)t;
        } else if (this.m_lambdaType == null) {
            Type[] paramVars = new Type[this.m_parameters.length];
            for (int i = 0; i < this.m_parameters.length; ++i) {
                paramVars[i] = new TypeVariable();
            }
            this.m_lambdaType = new LambdaType(paramVars, new TypeVariable(), this.m_isPure);
            try {
                tenv.unify(this.m_lambdaType, this.m_lambda.getType(tenv, benv), this);
            }
            catch (TypeCheckException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void typeCheckReduced(TypeEnvironment tenv, BindingEnvironment benv, LinkedList<Function> functionStack) {
        super.typeCheckReduced(tenv, benv, functionStack);
        this.setupType(tenv, benv);
    }

    @Override
    public void generateReducedForm(ReductionHelper rh, Instruction[] state, BindingEnvironment benv) {
        this.m_lambda = rh.reduceToBasicInstruction(state, this.m_lambda, benv);
        super.generateReducedForm(rh, state, benv);
        this.setupType(rh.m_typeEnvironment, benv);
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        super.doDefaultTypeCheck(tenv, benv, functionStack);
        Type[] paramTypes = new Type[this.m_parameters.length];
        for (int i = 0; i < this.m_parameters.length; ++i) {
            paramTypes[i] = new TypeVariable();
            tenv.unify(this.m_parameters[i].typeCheck(tenv, benv, functionStack), paramTypes[i], this);
        }
        Type t = this.setCachedType(new TypeVariable());
        LambdaType lt2 = new LambdaType(paramTypes, t, this.m_isPure);
        tenv.unify(this.m_lambda.typeCheck(tenv, benv, functionStack), lt2, this);
        return t;
    }

    @Override
    public Instruction getChildInstruction(int i) {
        switch (i) {
            case 0: {
                return this.m_lambda;
            }
        }
        return this.m_parameters[i - 1];
    }

    @Override
    public int getChildInstructionCount() {
        return this.m_parameters.length + 1;
    }

    @Override
    public void setChildInstruction(int i, Instruction n2) {
        switch (i) {
            case 0: {
                this.m_lambda = n2;
                break;
            }
            default: {
                this.m_parameters[i - 1] = n2;
            }
        }
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        Instruction[] parameters = new Instruction[this.m_parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = this.m_parameters[i].cloneWithoutTypeInformation();
        }
        ApplyInstruction i = new ApplyInstruction(this.m_lambda.cloneWithoutTypeInformation(), parameters, this.m_isPure);
        ApplyInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Instruction cloneShallow() {
        Instruction[] parameters = (Instruction[])this.m_parameters.clone();
        ApplyInstruction i = new ApplyInstruction(this.m_lambda, parameters, this.m_isPure);
        ApplyInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public String innerToString() {
        return "apply";
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cgh, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        if (this.isTailLoopApply()) {
            int i;
            il.comment("calling self loop '" + this.m_tailLoopApply + "' via tail recursion");
            int nparams = this.m_parameters.length;
            String[] paramNames = new String[nparams];
            FcgType[] paramTypes = new FcgType[nparams];
            FcgVariable[] params = new FcgVariable[nparams];
            for (i = 0; i < nparams; ++i) {
                if (this.m_parameters[i] instanceof IdentifierInstruction && ((IdentifierInstruction)this.m_parameters[i]).getVariable().equals(this.m_tailLoopParams[i].getName())) continue;
                paramNames[i] = cgh.generateNewLocalVariableName();
                paramTypes[i] = cgt.generateConventionally(this.m_parameters[i], cgh, false, il, ValueGenStyle.DEFAULT);
                params[i] = il.defineVar(paramTypes[i], paramNames[i], true);
            }
            for (i = 0; i < nparams; ++i) {
                if (this.m_parameters[i] instanceof IdentifierInstruction && ((IdentifierInstruction)this.m_parameters[i]).getVariable().equals(this.m_tailLoopParams[i].getName())) continue;
                cgt.generateConventionally(this.m_tailLoopParams[i], cgh, tailPosition, il, valueStyleRequest, false);
                il.loadVar(params[i]);
                il.storeAtStmt();
            }
            il.nextIterationOfLoop();
            return il.loadLiteral("___unreachableTailRecursionReturnValue_doNotAssign___");
        }
        FcgClassReferenceType objType = (FcgClassReferenceType)cgt.generateConventionally(this.m_lambda, cgh, tailPosition, il, valueStyleRequest);
        FcgType[] types2 = new FcgType[this.m_parameters.length];
        LambdaType lt2 = (LambdaType)cgt.resolveType(this.m_lambda);
        for (int i = 0; i < this.m_parameters.length; ++i) {
            FcgType expectedType = lt2.getElementTypes()[i].getFCGType(cgh);
            FcgType argType = cgt.generateConventionally(this.m_parameters[i], cgh, false, il, ValueGenStyle.forFcgType(expectedType));
            if (!argType.equals(expectedType)) {
                argType = il.convertExpr(argType, expectedType);
            }
            types2[i] = argType;
        }
        FcgType retType = lt2.getReturnType().getFCGType(cgh);
        il.invokeInstanceMethod(objType, "invoke", retType, this.m_parameters.length);
        return retType;
    }

    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        return this.evaluate(null, e, f2, di, tailPosition);
    }

    @Override
    public void evaluate(IAppendableStream as, Environment e, Function f2, IDebuggerInterceptor di) {
        this.evaluate(as, e, f2, di, false);
    }

    private Object evaluate(IAppendableStream as, Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        if (null != di) {
            di.enter(this, e, f2);
        }
        Closure closure = (Closure)this.m_lambda.evaluate(e, f2, di, false);
        Object ans = null;
        if (as != null) {
            closure.evaluate(as, e, f2, this.m_parameters, di);
        } else {
            ans = closure.evaluate(e, f2, this.m_parameters, di);
        }
        return Debugger.leave(di, this, e, f2, ans);
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        super.read(rofh, benv);
        this.m_isPure = rofh.readBoolean();
        this.m_lambda = rofh.readInstruction(benv);
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        super.write(wofh);
        wofh.writeBoolean(this.m_isPure);
        wofh.writeInstruction(this.m_lambda);
    }

    public void setTailLoopApply(Object tailLoopApply, IBinding[] params) {
        this.m_tailLoopApply = tailLoopApply;
        this.m_tailLoopParams = params;
    }

    public boolean isTailLoopApply() {
        return null != this.m_tailLoopApply;
    }
}

