/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgBinOp;
import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgVariable;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.INewNameGenerator;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.IStreamInADTOptimizationInstruction;
import com.ibm.xltxe.rnm1.xylem.codegen.IStreamOptimizationInstruction;
import com.ibm.xltxe.rnm1.xylem.codegen.StreamInADTOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.StreamOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.AndInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ConstructorInstantiationInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.DeepEqualityInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.AbstractDataObject;
import com.ibm.xltxe.rnm1.xylem.interpreter.CharArrayWriterStream;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.interpreter.IAppendableStream;
import com.ibm.xltxe.rnm1.xylem.interpreter.IStream;
import com.ibm.xltxe.rnm1.xylem.interpreter.ListStream;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.LetChainManager;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.types.AbstractDataType;
import com.ibm.xltxe.rnm1.xylem.types.CharType;
import com.ibm.xltxe.rnm1.xylem.types.ICollectionType;
import com.ibm.xltxe.rnm1.xylem.types.IConstructableAsStreamType;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xltxe.rnm1.xylem.types.NamedType;
import com.ibm.xltxe.rnm1.xylem.types.StreamType;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AutomatonInstruction
extends Instruction
implements IStreamInADTOptimizationInstruction,
IStreamOptimizationInstruction,
ISpecialForm {
    protected Instruction m_source;
    protected Type m_varType;
    protected Type m_collectionType;
    public Match[] m_matches;
    protected Instruction m_default;
    protected Instruction m_initialState;
    protected Type m_stateComboType;
    protected Binding m_defaultStateBinding;
    protected Binding m_defaultElementBinding;
    protected Binding m_loopIndexBinding;
    protected boolean m_wrapResult;

    public AutomatonInstruction() {
    }

    public AutomatonInstruction(Instruction source, Instruction initialState, Match[] matches2, Instruction defaultCase, Type stateComboType, Object defaultStateVarName, Object defaultElementVarName, Object loopIndexVarName, boolean wrapResult) {
        this.m_source = source;
        this.m_initialState = initialState;
        this.m_matches = matches2;
        this.m_default = defaultCase;
        this.m_stateComboType = stateComboType;
        if (loopIndexVarName != null) {
            this.m_loopIndexBinding = new Binding(loopIndexVarName, (Type)IntType.s_intType, this);
        }
        if (defaultStateVarName != null) {
            this.m_defaultStateBinding = new Binding(defaultStateVarName, (Type)IntType.s_intType, this);
        }
        this.m_wrapResult = wrapResult;
        this.m_varType = new TypeVariable();
        if (defaultElementVarName != null) {
            this.m_defaultElementBinding = new Binding(defaultElementVarName, this.m_varType, this);
        }
    }

    public AutomatonInstruction(Instruction source, Instruction initialState, Match[] matches2, Instruction defaultCase, Type stateComboType, Object defaultStateVarName, Object defaultElementVarName, Object loopIndexVarName, boolean wrapResult, ICollectionType collectionType) {
        this.m_source = source;
        this.m_initialState = initialState;
        this.m_matches = matches2;
        this.m_default = defaultCase;
        this.m_stateComboType = stateComboType;
        if (loopIndexVarName != null) {
            this.m_loopIndexBinding = new Binding(loopIndexVarName, (Type)IntType.s_intType, this);
        }
        if (defaultStateVarName != null) {
            this.m_defaultStateBinding = new Binding(defaultStateVarName, (Type)IntType.s_intType, this);
        }
        this.m_wrapResult = wrapResult;
        this.m_collectionType = (Type)((Object)collectionType);
        this.m_varType = collectionType.getElementType();
        if (defaultElementVarName != null) {
            this.m_defaultElementBinding = new Binding(defaultElementVarName, this.m_varType, this);
        }
    }

    public void resetCollectionType() {
        this.m_collectionType = null;
        this.m_varType = new TypeVariable();
    }

    public void setCollectionType(Type t) {
        this.m_collectionType = t;
    }

    public AbstractDataType.Constructor getStateComboConstructor(TypeEnvironment tenv) {
        return ((NamedType)this.getStateComboType().resolveType((TypeEnvironment)tenv)).resolveNameToADT((TypeEnvironment)tenv).m_constructors[0];
    }

    public Type getStateComboType() {
        return this.m_stateComboType;
    }

    public boolean getWrapResult() {
        return this.m_wrapResult;
    }

    public void setWrapResult(boolean b) {
        this.m_wrapResult = b;
    }

    public Instruction getSource() {
        return this.m_source;
    }

    public Instruction getInitialState() {
        return this.m_initialState;
    }

    public Set getKnownStates() {
        HashSet<Integer> set2 = new HashSet<Integer>();
        for (int i = 0; i < this.m_matches.length; ++i) {
            set2.add(new Integer(this.m_matches[i].m_currentState));
        }
        return set2;
    }

    public Type getResultElementType(TypeEnvironment tenv) {
        Type outType = this.getStateComboConstructor((TypeEnvironment)tenv).m_parameters[0].getBindingType().resolveType(tenv);
        return ((ICollectionType)((Object)outType)).getElementType();
    }

    public void setInitialState(Instruction n2) {
        this.m_initialState = n2;
    }

    public void setSource(Instruction n2) {
        this.m_source = n2;
    }

    @Override
    public int getChildInstructionCount() {
        return (this.m_default == null ? 2 : 3) + this.m_matches.length * 2;
    }

    @Override
    public Instruction getChildInstruction(int i) {
        if (this.m_default != null) {
            if (i == 0) {
                return this.m_default;
            }
            --i;
        }
        switch (i) {
            case 0: {
                return this.m_source;
            }
            case 1: {
                return this.m_initialState;
            }
        }
        return (i -= 2) % 2 == 0 ? this.m_matches[i / 2].m_handler : this.m_matches[i / 2].m_nextState;
    }

    @Override
    public void setChildInstruction(int i, Instruction n2) {
        if (this.m_default != null) {
            if (i == 0) {
                this.m_default = n2;
                return;
            }
            --i;
        }
        switch (i) {
            case 0: {
                this.m_source = n2;
                break;
            }
            case 1: {
                this.m_initialState = n2;
                break;
            }
            default: {
                if ((i -= 2) % 2 == 0) {
                    this.m_matches[i / 2].m_handler = n2;
                    break;
                }
                this.m_matches[i / 2].m_nextState = n2;
            }
        }
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        Match[] matches2 = new Match[this.m_matches.length];
        for (int i = 0; i < matches2.length; ++i) {
            matches2[i] = this.m_matches[i].cloneWithoutTypeInformation();
        }
        if (this.m_varType instanceof TypeVariable) {
            AutomatonInstruction i = new AutomatonInstruction(this.m_source.cloneWithoutTypeInformation(), this.m_initialState.cloneWithoutTypeInformation(), matches2, this.m_default == null ? null : this.m_default.cloneWithoutTypeInformation(), this.getStateComboType(), this.m_defaultStateBinding == null ? null : this.m_defaultStateBinding.getName(), this.m_defaultElementBinding == null ? null : this.m_defaultElementBinding.getName(), this.m_loopIndexBinding == null ? null : this.m_loopIndexBinding.getName(), this.m_wrapResult);
            AutomatonInstruction.propagateInfo(this, i);
            return i;
        }
        AutomatonInstruction i = new AutomatonInstruction(this.m_source.cloneWithoutTypeInformation(), this.m_initialState.cloneWithoutTypeInformation(), matches2, this.m_default == null ? null : this.m_default.cloneWithoutTypeInformation(), this.getStateComboType(), this.m_defaultStateBinding == null ? null : this.m_defaultStateBinding.getName(), this.m_defaultElementBinding == null ? null : this.m_defaultElementBinding.getName(), this.m_loopIndexBinding == null ? null : this.m_loopIndexBinding.getName(), this.m_wrapResult, (ICollectionType)((Object)this.m_collectionType));
        AutomatonInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Instruction cloneShallow() {
        Match[] matches2 = new Match[this.m_matches.length];
        for (int i = 0; i < matches2.length; ++i) {
            matches2[i] = this.m_matches[i].cloneShallow();
        }
        if (this.m_varType instanceof TypeVariable) {
            AutomatonInstruction i = new AutomatonInstruction(this.m_source, this.m_initialState, matches2, this.m_default, this.getStateComboType(), this.m_defaultStateBinding == null ? null : this.m_defaultStateBinding.getName(), this.m_defaultElementBinding == null ? null : this.m_defaultElementBinding.getName(), this.m_loopIndexBinding == null ? null : this.m_loopIndexBinding.getName(), this.m_wrapResult);
            AutomatonInstruction.propagateInfo(this, i);
            return i;
        }
        AutomatonInstruction i = new AutomatonInstruction(this.m_source, this.m_initialState, matches2, this.m_default, this.getStateComboType(), this.m_defaultStateBinding == null ? null : this.m_defaultStateBinding.getName(), this.m_defaultElementBinding == null ? null : this.m_defaultElementBinding.getName(), this.m_loopIndexBinding == null ? null : this.m_loopIndexBinding.getName(), this.m_wrapResult, (ICollectionType)((Object)this.m_collectionType));
        AutomatonInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        super.doDefaultTypeCheck(tenv, benv, functionStack);
        Type sourceType = this.m_source.typeCheck(tenv, benv, functionStack);
        if (this.m_varType instanceof TypeVariable) {
            this.m_collectionType = this.m_varType.getStreamType();
        }
        BindingEnvironment benv1 = benv;
        if (this.m_loopIndexBinding != null) {
            benv1 = new BindingEnvironment(benv, this.m_loopIndexBinding);
        }
        tenv.unify(this.m_collectionType, sourceType, this);
        TypeVariable tvar = new TypeVariable();
        for (int i = 0; i < this.m_matches.length; ++i) {
            Match m = this.m_matches[i];
            if (m instanceof LiteralWildcardMatch) {
                ((LiteralWildcardMatch)m).m_source = this.m_source;
            }
            tenv.unify(tvar, m.doTypeCheck(tenv, benv1, functionStack), this);
            tenv.unify(m.getType(tenv), this.m_varType, this);
        }
        if (this.m_default != null) {
            BindingEnvironment benv2 = new BindingEnvironment(benv1);
            benv2.setVariableBinding(this.m_defaultStateBinding);
            benv2.setVariableBinding(this.m_defaultElementBinding);
            tenv.unify(this.m_stateComboType, this.m_default.typeCheck(tenv, benv2, functionStack), this);
        }
        tenv.unify(this.m_initialState.typeCheck(tenv, benv, functionStack), IntType.s_intType, this);
        tenv.unify(this.getStateComboConstructor((TypeEnvironment)tenv).m_parameters[0].getBindingType(), tvar, this);
        tenv.unify(IntType.s_intType, this.getStateComboConstructor((TypeEnvironment)tenv).m_parameters[1].getBindingType(), this);
        if (this.m_wrapResult) {
            return this.setCachedType(this.m_stateComboType);
        }
        return this.setCachedType(this.getStateComboConstructor((TypeEnvironment)tenv).m_parameters[0].getBindingType());
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        return this.m_wrapResult ? this.m_stateComboType : this.getStateComboConstructor((TypeEnvironment)tenv).m_parameters[0].getBindingType();
    }

    public Instruction getDefaultHandler() {
        return this.m_default;
    }

    public void setDefaultHandler(Instruction n2) {
        this.m_default = n2;
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cg, CodeGenerationTracker cgt0, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        return this.generateCode(cg, il, null, null, cgt0, false);
    }

    protected FcgType generateCode(FcgCodeGenHelper cgh, FcgInstructionList il, String streamName, Binding memberInADT, CodeGenerationTracker cgt0, boolean objectless) {
        TypeEnvironment tenv = cgt0.m_typeEnvironment;
        ICollectionType collectionType = (ICollectionType)((Object)this.m_collectionType);
        if (collectionType == null) {
            collectionType = (ICollectionType)((Object)cgt0.resolveType(this.m_source));
        }
        FcgType collectionElemType = collectionType.getElementType().getFCGType(cgh);
        IBinding toSkip = ((IdentifierInstruction)this.m_source).getBinding(cgt0.m_bindingEnvironment);
        cgt0.generateFreeBindings(this, cgh, il, toSkip, false, false, ValueGenStyle.DEFAULT);
        String varName = streamName == null ? cgh.generateNewLocalVariableName() : streamName;
        StreamType outType = (StreamType)this.getStateComboConstructor((TypeEnvironment)tenv).m_parameters[0].getBindingType();
        if (streamName == null) {
            il.defineVar(outType.getFCGType(cgh), varName, false);
            outType.generateCreateStream(varName, 128, cgh, il);
        }
        String stateName = cgh.generateNewLocalVariableName() + "_automatonState";
        FcgType stateType = cgt0.generateConventionally(this.m_initialState, cgh, false, il, ValueGenStyle.DEFAULT);
        FcgVariable stateVar = il.defineVar(stateType, stateName, true);
        boolean usesLoopIndex = this.m_loopIndexBinding != null && cgt0.isBindingUsed(this.m_loopIndexBinding);
        String loopIndex = null;
        FcgVariable loopIndexVar = null;
        if (usesLoopIndex) {
            loopIndex = cgh.generateNewLocalVariableName();
            il.loadLiteral(0);
            loopIndexVar = il.defineVar(FcgType.INT, loopIndex, true);
        }
        FcgVariable current2 = collectionType.generateLoopStart(cgh, il, this.m_source, collectionElemType, cgt0);
        CodeGenerationTracker cgt = cgt0;
        if (usesLoopIndex) {
            cgt = cgt0.cloneBranch();
            cgt.registerExtantBinding(this.m_loopIndexBinding, loopIndex);
        }
        if (this.m_matches.length > 0) {
            il.comment("automaton state in FCG");
            il.loadVar(stateVar);
            il.beginSwitch();
        }
        HashSet<Integer> examinedStates = new HashSet<Integer>();
        for (int k = 0; k < this.m_matches.length; ++k) {
            int nextState = this.m_matches[k].m_currentState;
            if (examinedStates.contains(new Integer(nextState))) continue;
            examinedStates.add(new Integer(nextState));
            il.comment("the automaton state number");
            il.beginSwitchCaseBlock(nextState);
            boolean didDefault = false;
            if (this.m_matches[0] instanceof DeconstructionMatch) {
                HashMap constructorMap = new HashMap();
                for (int i = 0; i < this.m_matches.length; ++i) {
                    DeconstructionMatch dm = (DeconstructionMatch)this.m_matches[i];
                    if (dm.m_currentState != nextState) continue;
                    if (constructorMap.containsKey(dm.m_constructor.getName())) {
                        ((List)constructorMap.get(dm.m_constructor.getName())).add(dm);
                        continue;
                    }
                    LinkedList<DeconstructionMatch> newList = new LinkedList<DeconstructionMatch>();
                    newList.add(dm);
                    constructorMap.put(dm.m_constructor.getName(), newList);
                }
                AbstractDataType adt = ((DeconstructionMatch)this.m_matches[0]).m_constructor.getAbstractDataType();
                FcgVariable adtType = adt.generateConstructorTypeDeconstructionCode(cgh, current2.getName(), il);
                il.beginSwitch();
                Iterator constructorIterator = constructorMap.keySet().iterator();
                while (constructorIterator.hasNext()) {
                    Iterator matchIterator = ((List)constructorMap.get(constructorIterator.next())).iterator();
                    boolean first = true;
                    while (matchIterator.hasNext()) {
                        DeconstructionMatch dm = (DeconstructionMatch)matchIterator.next();
                        if (first) {
                            il.comment(dm.m_constructor.getName());
                            il.beginSwitchCaseBlock(dm.m_constructor.getIndex());
                            first = false;
                        }
                        dm.addIfMatchesLiterals(cgh, cgt, il, current2);
                        CodeGenerationTracker cgt2 = adt.generateConstructorDeconstructionCodeForSome(cgh, il, current2.getName(), cgt, dm.getBindings(), dm.m_constructor, null, memberInADT, dm.getWhichAreBindings());
                        cgt2.generateAddToStream(dm.m_handler, varName, outType, cgh, il, false, ValueGenStyle.DEFAULT);
                        boolean resultForkable = this.getType(cgt.m_typeEnvironment, cgt.m_bindingEnvironment).isForkReleaseManaged(cgt);
                        dm.m_nextState.generateCode(cgh, cgt.cloneBranch(), null, false, il, ValueGenStyle.DEFAULT_NO_PUSH);
                        il.storeVar(stateVar);
                        il.endIf();
                    }
                    il.endSwitchCaseBlock();
                }
            } else if (this.m_matches[0] instanceof LiteralMatch || this.m_matches[0] instanceof LiteralWildcardMatch) {
                il.loadVar(current2);
                il.beginSwitch();
                for (int i = 0; i < this.m_matches.length; ++i) {
                    if (this.m_matches[i] instanceof LiteralWildcardMatch) {
                        LiteralWildcardMatch lwm = (LiteralWildcardMatch)this.m_matches[i];
                        if (lwm.m_currentState != nextState || didDefault) continue;
                        didDefault = true;
                        il.beginSwitchDefaultBlock();
                        CodeGenerationTracker cgt2 = cgt.cloneBranch();
                        cgt2.registerExtantBinding(lwm.m_binding, current2.getName());
                        cgt2.generateAddToStream(lwm.m_handler, varName, outType, cgh, il, false, ValueGenStyle.DEFAULT);
                        lwm.m_nextState.generateCode(cgh, cgt.cloneBranch(), null, false, il, ValueGenStyle.DEFAULT_NO_PUSH);
                        il.storeVar(stateVar);
                        il.endSwitchDefaultBlock();
                        continue;
                    }
                    LiteralMatch lm = (LiteralMatch)this.m_matches[i];
                    if (lm.m_currentState != nextState) continue;
                    il.comment("the literal");
                    lm.m_literal.generateBeginSwitchCase(il);
                    cgt.cloneBranch().generateAddToStream(lm.m_handler, varName, outType, cgh, il, false, ValueGenStyle.DEFAULT);
                    lm.m_nextState.generateCode(cgh, cgt.cloneBranch(), null, false, il, ValueGenStyle.DEFAULT_NO_PUSH);
                    il.storeVar(stateVar);
                    il.endSwitchCaseBlock();
                }
            }
            if (!didDefault) {
                il.beginSwitchDefaultBlock();
                if (this.m_default != null) {
                    FcgType retType;
                    boolean generatedObjectless = false;
                    CodeGenerationTracker cgt2 = cgt.cloneBranch();
                    cgt2.registerExtantBinding(this.m_defaultStateBinding, stateName);
                    cgt2.registerExtantBinding(this.m_defaultElementBinding, current2.getName());
                    if (this.m_default.supportsCodeGenerationOptimization(StreamInADTOptimizationStyle.s_streamInADTOptimizationStyle, cgt.m_typeEnvironment, cgt.m_bindingEnvironment)) {
                        generatedObjectless = ((IStreamInADTOptimizationInstruction)((Object)this.m_default)).canGenerateObjectless(cgt.m_typeEnvironment);
                        retType = ((IStreamInADTOptimizationInstruction)((Object)this.m_default)).generateCode(cgh, il, varName, this.getStateComboConstructor((TypeEnvironment)tenv).m_parameters[0], cgt2, generatedObjectless, false);
                    } else {
                        FcgType fcgTypeElement = this.m_default.generateCode(cgh, cgt2, null, false, il, ValueGenStyle.DEFAULT_NO_PUSH);
                        Type itemToAppendType = this.m_default.getType(cgt.m_typeEnvironment, cgt.m_bindingEnvironment);
                        retType = outType.generateAddMultipleElementsToStream(cgh, cgt, il, varName, itemToAppendType, fcgTypeElement);
                    }
                    if (generatedObjectless) {
                        il.storeVar(stateVar);
                    } else {
                        String fieldName = this.getStateComboConstructor(tenv).getConstructorQualifiedFieldName(1, cgh);
                        il.loadInstanceField((FcgClassReferenceType)retType, fieldName, stateType);
                        il.storeVar(stateVar);
                    }
                    il.endSwitchDefaultBlock();
                } else {
                    il.loadLiteral("No match in automaton");
                    il.createObjectExpr((FcgType)FcgType.RUNTIME_EXCEPTION, 1);
                    il.throwObject();
                    il.endSwitchDefaultBlockFallThru();
                }
            }
            il.endSwitch();
            il.endSwitchCaseBlock();
        }
        if (this.m_matches.length > 0) {
            il.beginSwitchDefaultBlock();
        }
        if (this.m_default != null) {
            FcgType retType;
            boolean generatedObjectless = false;
            CodeGenerationTracker cgt2 = cgt.cloneBranch();
            cgt2.registerExtantBinding(this.m_defaultStateBinding, stateName);
            cgt2.registerExtantBinding(this.m_defaultElementBinding, current2.getName());
            if (this.m_default.supportsCodeGenerationOptimization(StreamInADTOptimizationStyle.s_streamInADTOptimizationStyle, cgt.m_typeEnvironment, cgt.m_bindingEnvironment)) {
                generatedObjectless = ((IStreamInADTOptimizationInstruction)((Object)this.m_default)).canGenerateObjectless(cgt.m_typeEnvironment);
                retType = ((IStreamInADTOptimizationInstruction)((Object)this.m_default)).generateCode(cgh, il, varName, this.getStateComboConstructor((TypeEnvironment)tenv).m_parameters[0], cgt2, generatedObjectless, false);
            } else {
                FcgType fcgTypeElement = this.m_default.generateCode(cgh, cgt2, null, false, il, ValueGenStyle.DEFAULT_NO_PUSH);
                Type itemToAppendType = this.m_default.getCachedType();
                retType = outType.generateAddMultipleElementsToStream(cgh, cgt, il, varName, itemToAppendType, fcgTypeElement);
            }
            if (generatedObjectless) {
                il.storeVar(stateVar);
            } else {
                String fieldName = this.getStateComboConstructor(tenv).getConstructorQualifiedFieldName(1, cgh);
                il.loadInstanceField((FcgClassReferenceType)retType, fieldName, stateType);
                il.storeVar(stateVar);
            }
            if (this.m_matches.length > 0) {
                il.endSwitchDefaultBlock();
            }
        } else {
            il.createObjectExpr((FcgType)cgh.getClassReferenceType("java.lang.RuntimeException"), 0);
            il.throwObject();
            if (this.m_matches.length > 0) {
                il.endSwitchDefaultBlockFallThru();
            }
        }
        if (this.m_matches.length > 0) {
            il.endSwitch();
        }
        if (usesLoopIndex) {
            il.incrementVarStmt(loopIndexVar);
        }
        collectionType.generateLoopEnd(cgh, il, current2, cgt);
        if (streamName == null) {
            outType.generateCompactStream(varName, cgh, il);
        }
        FcgType retType = null;
        if (!this.m_wrapResult) {
            if (streamName != null && memberInADT == null) {
                return null;
            }
            il.loadVar(il.findVar(varName));
            retType = outType.getFCGType(cgh);
        } else if (objectless) {
            il.loadVar(stateVar);
            retType = FcgType.INT;
        } else {
            il.loadVar(il.findVar(varName + "_stream"));
            il.loadVar(stateVar);
            il.createObjectExpr(this.getStateComboType().getFCGType(cgh), 2);
            retType = outType.getFCGType(cgh);
        }
        return retType;
    }

    @Override
    public void accumulateNonLiteralFreeBindings(Set set2, BindingEnvironment benv) {
        super.accumulateNonLiteralFreeBindings(set2, benv);
        for (int i = 0; i < this.m_matches.length; ++i) {
            Match m = this.m_matches[i];
            if (m instanceof DeconstructionMatch) {
                DeconstructionMatch dm = (DeconstructionMatch)m;
                Binding[] bb = dm.getBindings();
                for (int j = 0; j < bb.length; ++j) {
                    set2.remove(bb[j]);
                }
                continue;
            }
            if (!(m instanceof LiteralWildcardMatch)) continue;
            LiteralWildcardMatch lwm = (LiteralWildcardMatch)m;
            set2.remove(lwm.m_binding);
        }
        if (this.m_defaultElementBinding != null) {
            set2.remove(this.m_defaultElementBinding);
        }
        if (this.m_defaultStateBinding != null) {
            set2.remove(this.m_defaultStateBinding);
        }
        if (this.m_loopIndexBinding != null) {
            set2.remove(this.m_loopIndexBinding);
        }
    }

    @Override
    public void accumulateFreeBindings(Set set2, BindingEnvironment benv) {
        super.accumulateFreeBindings(set2, benv);
        for (int i = 0; i < this.m_matches.length; ++i) {
            Match m = this.m_matches[i];
            if (m instanceof DeconstructionMatch) {
                DeconstructionMatch dm = (DeconstructionMatch)m;
                Binding[] bb = dm.getBindings();
                for (int j = 0; j < bb.length; ++j) {
                    set2.remove(bb[j]);
                }
                continue;
            }
            if (!(m instanceof LiteralWildcardMatch)) continue;
            LiteralWildcardMatch lwm = (LiteralWildcardMatch)m;
            set2.remove(lwm.m_binding);
        }
        if (this.m_defaultElementBinding != null) {
            set2.remove(this.m_defaultElementBinding);
        }
        if (this.m_defaultStateBinding != null) {
            set2.remove(this.m_defaultStateBinding);
        }
        if (this.m_loopIndexBinding != null) {
            set2.remove(this.m_loopIndexBinding);
        }
    }

    @Override
    public void typeCheckReduced(TypeEnvironment tenv, BindingEnvironment benv, LinkedList<Function> functionStack) {
        if (this.m_loopIndexBinding != null) {
            benv.setVariableBinding(this.m_loopIndexBinding);
        }
        if (this.m_default != null) {
            benv.setVariableBinding(this.m_defaultElementBinding);
            benv.setVariableBinding(this.m_defaultStateBinding);
        }
        for (int i = 0; i < this.m_matches.length; ++i) {
            Match m = this.m_matches[i];
            if (m instanceof LiteralWildcardMatch) {
                ((LiteralWildcardMatch)m).m_source = this.m_source;
            }
            m.doTypeCheckReduced(tenv, benv);
            if (m instanceof DeconstructionMatch) {
                DeconstructionMatch dm = (DeconstructionMatch)m;
                Binding[] bb = dm.getBindings();
                for (int j = 0; j < bb.length; ++j) {
                    benv.setVariableBinding(bb[j]);
                }
                continue;
            }
            if (!(m instanceof LiteralWildcardMatch)) continue;
            LiteralWildcardMatch lwm = (LiteralWildcardMatch)m;
            benv.setVariableBinding(lwm.m_binding);
        }
        this.m_collectionType = this.m_source.getType(tenv, benv).resolveType(tenv);
        super.typeCheckReduced(tenv, benv, functionStack);
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cgh, FcgInstructionList il, String streamName, Binding memberInADT, CodeGenerationTracker cgt0, boolean objectless, boolean tailPosition) {
        return this.generateCode(cgh, il, streamName, memberInADT, cgt0, objectless);
    }

    @Override
    public void generateCodeWithStreamOptimization(FcgCodeGenHelper cgh, FcgInstructionList il, String streamName, IConstructableAsStreamType type2, CodeGenerationTracker cgt, boolean tailPosition, ValueGenStyle valueStyleRequest) {
        this.generateCode(cgh, il, streamName, null, cgt, false);
    }

    @Override
    public void generateReducedForm(ReductionHelper rh, Instruction[] state, BindingEnvironment benv) {
        Instruction source = rh.reduceToBasicInstruction(state, this.m_source, benv);
        Instruction initialState = rh.reduceToBasicInstruction(state, this.m_initialState, benv);
        Instruction defaultHandler = null;
        if (this.m_default != null) {
            ReductionHelper rh2 = (ReductionHelper)rh.clone();
            if (this.m_defaultStateBinding != null) {
                rh2.upgradeBinding(this.m_defaultStateBinding);
                benv.setVariableBinding(this.m_defaultStateBinding);
            }
            if (this.m_defaultElementBinding != null) {
                rh2.upgradeBinding(this.m_defaultElementBinding);
                benv.setVariableBinding(this.m_defaultElementBinding);
            }
            if (this.m_loopIndexBinding != null) {
                rh2.upgradeBinding(this.m_loopIndexBinding);
                benv.setVariableBinding(this.m_loopIndexBinding);
            }
            defaultHandler = rh2.reduce(this.m_default, benv);
        }
        for (Match m : this.m_matches) {
            ReductionHelper rh2;
            if (m instanceof DeconstructionMatch) {
                ReductionHelper rh22 = (ReductionHelper)rh.clone();
                DeconstructionMatch dm = (DeconstructionMatch)m;
                int c2 = dm.m_bindingNames.length;
                for (int i2 = 0; i2 < c2; ++i2) {
                    if (dm.m_bindingNames[i2].isBinding()) {
                        Binding b = dm.m_bindingNames[i2].getBinding();
                        ((DeconstructionMatch)dm).m_bindingNames[i2] = new BindingOrLiteral(rh22.upgradeBinding(b));
                        Binding b2 = dm.m_bindingNames[i2].getBinding();
                        benv.setVariableBinding(b2);
                        b2.setType(dm.m_constructor.m_parameters[i2].getBindingType());
                        continue;
                    }
                    ((DeconstructionMatch)dm).m_bindingNames[i2] = dm.m_bindingNames[i2].cloneMe();
                }
                if (this.m_loopIndexBinding != null) {
                    rh22.upgradeBinding(this.m_loopIndexBinding);
                    benv.setVariableBinding(this.m_loopIndexBinding);
                }
                dm.m_handler = rh22.reduce(dm.m_handler, benv);
                dm.m_nextState = rh22.reduce(dm.m_nextState, benv);
                continue;
            }
            if (m instanceof LiteralWildcardMatch) {
                LiteralWildcardMatch lwm = (LiteralWildcardMatch)m;
                rh2 = (ReductionHelper)rh.clone();
                Object newBindingName = rh2.upgradeBinding(lwm.m_binding);
                if (this.m_loopIndexBinding != null) {
                    rh2.upgradeBinding(this.m_loopIndexBinding);
                    benv.setVariableBinding(this.m_loopIndexBinding);
                }
                lwm.m_handler = rh2.reduce(lwm.m_handler, benv);
                lwm.m_nextState = rh2.reduce(lwm.m_nextState, benv);
                lwm.m_binding = new Binding(newBindingName, this);
                lwm.m_binding.setType(((StreamType)this.m_source.getType(rh.m_typeEnvironment, benv)).getElementType());
                benv.setVariableBinding(lwm.m_binding);
                continue;
            }
            LiteralMatch lm = (LiteralMatch)m;
            rh2 = (ReductionHelper)rh.clone();
            if (this.m_loopIndexBinding != null) {
                rh2.upgradeBinding(this.m_loopIndexBinding);
                benv.setVariableBinding(this.m_loopIndexBinding);
            }
            lm.m_handler = rh2.reduce(lm.m_handler, benv);
            lm.m_nextState = rh2.reduce(lm.m_nextState, benv);
        }
        this.m_source = source;
        this.m_initialState = initialState;
        this.m_default = defaultHandler;
        state[0] = this;
        this.m_bindingEnvironment = null;
    }

    @Override
    protected boolean supportsCodeGenerationOptimizationInternal(CodeGenerationOptimizationStyle cgos, TypeEnvironment tenv, BindingEnvironment benv) {
        if (cgos instanceof StreamOptimizationStyle) {
            return !this.m_wrapResult;
        }
        if (cgos instanceof StreamInADTOptimizationStyle) {
            return this.m_wrapResult;
        }
        return super.supportsCodeGenerationOptimizationInternal(cgos, tenv, benv);
    }

    @Override
    public boolean canGenerateObjectless(TypeEnvironment tenv) {
        return this.m_wrapResult;
    }

    public Binding getDefaultElementBinding() {
        return this.m_defaultElementBinding;
    }

    public Binding getDefaultStateBinding() {
        return this.m_defaultStateBinding;
    }

    public Binding getLoopIndexBinding() {
        return this.m_loopIndexBinding;
    }

    public void setLoopIndexVar(Object name2) {
        if (this.m_loopIndexBinding != null) {
            throw new Error("can't reset livn");
        }
        this.m_loopIndexBinding = new Binding(name2, this);
    }

    @Override
    public void toString(PrettyPrinter pw, int indent) {
        String label;
        if (this.m_loopIndexBinding != null) {
            pw.newline();
            pw.indent(indent);
            pw.println(";;indexVar=" + this.m_loopIndexBinding.getName());
        }
        String string2 = label = this.m_wrapResult ? "automaton-i" : "automaton";
        if (this.m_varType instanceof TypeVariable) {
            pw.printFormOpen(label, indent);
        } else {
            pw.printFormOpen(label + "@" + this.m_collectionType.prettyPrint(), indent);
        }
        this.m_source.toString(pw, indent + 1);
        this.m_initialState.toString(pw, indent + 1);
        pw.printToken(this.getStateComboType().prettyPrint(), indent + 1);
        for (int i = 0; i < this.m_matches.length; ++i) {
            Match c = this.m_matches[i];
            c.toString(pw, indent + 1);
        }
        if (this.m_default != null) {
            pw.printFormOpen("otherwise", indent + 1);
            pw.printIdentifier(this.m_defaultStateBinding, indent + 2);
            pw.printIdentifier(this.m_defaultElementBinding, indent + 2);
            this.m_default.toString(pw, indent + 2);
            pw.printFormClose(indent + 1);
        }
        pw.printFormClose(indent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        if (null != di) {
            di.enter(this, e, f2);
        }
        e.pushForkScope();
        Object ans = null;
        try {
            CharArrayWriterStream out;
            int state = (Integer)this.m_initialState.evaluate(e, f2, di, false);
            IStream is2 = (IStream)this.m_source.evaluate(e, f2, di, false);
            Iterator<Object> i = is2.iterator();
            IAppendableStream iAppendableStream = out = CharType.s_charType.getStreamType().equals(this.getCachedType()) ? new CharArrayWriterStream() : (IAppendableStream)((Object)e.pushIForkReleaseManagedForRelease(new ListStream()));
            while (i.hasNext()) {
                Object o = i.next();
                boolean done = false;
                for (int j = 0; j < this.m_matches.length; ++j) {
                    Match m = this.m_matches[j];
                    if (m.m_currentState != state) continue;
                    if (m instanceof LiteralMatch) {
                        LiteralMatch lm = (LiteralMatch)m;
                        Object value2 = lm.m_literal.evaluate(e, f2, di, false);
                        if (!value2.equals(o)) continue;
                        lm.m_handler.evaluate(out, e, f2, di);
                        done = true;
                        state = (Integer)lm.m_nextState.evaluate(e, f2, di, false);
                        break;
                    }
                    if (m instanceof DeconstructionMatch) {
                        DeconstructionMatch dm = (DeconstructionMatch)m;
                        AbstractDataObject ado = (AbstractDataObject)o;
                        if (dm.m_constructor != ado.getConstructor()) continue;
                        AbstractDataType.Constructor c = dm.m_constructor;
                        Object[] values2 = ado.getValues();
                        int bindingK = 0;
                        for (int k = 0; k < dm.m_bindingNames.length; ++k) {
                            if (!dm.m_bindingNames[k].isBinding()) continue;
                            e.bindInCurrentFrame(dm.getBindings()[bindingK++], values2[k]);
                        }
                        dm.m_handler.evaluate(out, e, f2, di);
                        done = true;
                        state = (Integer)dm.m_nextState.evaluate(e, f2, di, false);
                        break;
                    }
                    if (!(m instanceof LiteralWildcardMatch)) continue;
                    LiteralWildcardMatch lwm = (LiteralWildcardMatch)m;
                    e.bindInCurrentFrame(lwm.m_binding, o);
                    lwm.m_handler.evaluate(out, e, f2, di);
                    done = true;
                    state = (Integer)lwm.m_nextState.evaluate(e, f2, di, false);
                    break;
                }
                if (done) continue;
                if (this.m_default == null) {
                    throw new RuntimeException();
                }
                e.bindInCurrentFrame(this.m_defaultElementBinding, o);
                e.bindInCurrentFrame(this.m_defaultStateBinding, new Integer(state));
                AbstractDataObject ado = (AbstractDataObject)this.m_default.evaluate(e, f2, di, false);
                out.append(ado.getValues()[0], ado.getConstructor().getParameterTypes()[0]);
                state = (Integer)ado.getValues()[1];
            }
            if (this.m_wrapResult) {
                AbstractDataObject ado = new AbstractDataObject(this.getStateComboConstructor(f2.getTypeEnvironment()), new Object[]{out, new Integer(state)}, true);
                ans = ado;
            } else {
                ans = out;
            }
            e.popForkScope(ans);
        }
        catch (Throwable throwable) {
            e.popForkScope(ans);
            throw throwable;
        }
        return Debugger.leave(di, this, e, f2, ans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evaluate(IAppendableStream as, Environment e, Function f2, IDebuggerInterceptor di) {
        e.pushForkScope();
        try {
            IAppendableStream asOriginal = as;
            if (this.m_wrapResult) {
                ListStream list = new ListStream();
                e.pushIForkReleaseManagedForRelease(list);
                as = list;
            }
            if (null != di) {
                di.enter(this, e, f2);
            }
            int state = (Integer)this.m_initialState.evaluate(e, f2, di, false);
            IStream is2 = (IStream)this.m_source.evaluate(e, f2, di, false);
            Iterator<Object> i = is2.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                boolean done = false;
                for (int j = 0; j < this.m_matches.length; ++j) {
                    Match m = this.m_matches[j];
                    if (m.m_currentState != state) continue;
                    if (m instanceof LiteralMatch) {
                        LiteralMatch lm = (LiteralMatch)m;
                        Object value2 = lm.m_literal.evaluate(e, f2, di, false);
                        if (!value2.equals(o)) continue;
                        lm.m_handler.evaluate(as, e, f2, di);
                        done = true;
                        state = (Integer)lm.m_nextState.evaluate(e, f2, di, false);
                        break;
                    }
                    if (m instanceof DeconstructionMatch) {
                        DeconstructionMatch dm = (DeconstructionMatch)m;
                        AbstractDataObject ado = (AbstractDataObject)o;
                        if (dm.m_constructor != ado.getConstructor()) continue;
                        Object[] values2 = ado.getValues();
                        int bindingK = 0;
                        for (int k = 0; k < dm.m_bindingNames.length; ++k) {
                            if (!dm.m_bindingNames[k].isBinding()) continue;
                            e.bindInCurrentFrame(dm.getBindings()[bindingK++], values2[k]);
                        }
                        dm.m_handler.evaluate(as, e, f2, di);
                        done = true;
                        state = (Integer)dm.m_nextState.evaluate(e, f2, di, false);
                        break;
                    }
                    if (!(m instanceof LiteralWildcardMatch)) continue;
                    LiteralWildcardMatch lwm = (LiteralWildcardMatch)m;
                    e.bindInCurrentFrame(lwm.m_binding, o);
                    lwm.m_handler.evaluate(as, e, f2, di);
                    done = true;
                    state = (Integer)lwm.m_nextState.evaluate(e, f2, di, false);
                    break;
                }
                if (done) continue;
                if (this.m_default == null) {
                    System.out.println("======state=====\n" + state);
                    System.out.println("======o=====\n" + o);
                    System.out.println("======source=====\n" + this.m_source);
                    System.out.println("======source.eval=====\n" + this.m_source.evaluate(e, f2, di, false));
                    System.out.println("======Automaton=====\n" + this);
                    System.out.println("======F=====\n" + f2);
                    throw new RuntimeException();
                }
                e.bindInCurrentFrame(this.m_defaultElementBinding, o);
                e.bindInCurrentFrame(this.m_defaultStateBinding, new Integer(state));
                AbstractDataObject ado = (AbstractDataObject)this.m_default.evaluate(e, f2, di, false);
                as.append(ado.getValues()[0], ado.getConstructor().getParameterTypes()[0]);
                state = (Integer)ado.getValues()[1];
            }
            if (this.m_wrapResult) {
                AbstractDataObject ado = new AbstractDataObject(this.getStateComboConstructor(f2.getTypeEnvironment()), new Object[]{as, new Integer(state)});
                asOriginal.append(ado, ado.getConstructor().getAbstractDataType().getNamedType());
            }
        }
        finally {
            e.popForkScope();
        }
        Debugger.leave(di, this, e, f2, null);
    }

    @Override
    public Instruction assignNewNames(Map names, INewNameGenerator ing) {
        int i;
        Match[] matches2 = new Match[this.m_matches.length];
        for (i = 0; i < matches2.length; ++i) {
            matches2[i] = this.m_matches[i].cloneShallow();
        }
        for (i = 0; i < matches2.length; ++i) {
            Match m = matches2[i];
            if (m instanceof DeconstructionMatch) {
                DeconstructionMatch dm = (DeconstructionMatch)m;
                for (int j = 0; j < dm.m_bindingNames.length; ++j) {
                    Object s = ing.getNewName();
                    BindingOrLiteral bol = dm.m_bindingNames[j];
                    if (!bol.isBinding()) continue;
                    names.put(bol.m_binding.getName(), new IdentifierInstruction(s));
                    ((DeconstructionMatch)dm).m_bindingNames[j] = new BindingOrLiteral(s);
                }
            } else if (m instanceof LiteralWildcardMatch) {
                LiteralWildcardMatch lwm = (LiteralWildcardMatch)m;
                Object s = ing.getNewName();
                names.put(lwm.m_binding, new IdentifierInstruction(s));
                lwm.m_binding = new Binding(s, this);
            }
            m.m_handler = m.m_handler.assignNewNames(names, ing);
            m.m_nextState = m.m_nextState.assignNewNames(names, ing);
        }
        Object defaultStateVarName = null;
        if (this.m_defaultStateBinding != null) {
            Object s = ing.getNewName();
            names.put(this.m_defaultStateBinding.getName(), new IdentifierInstruction(s));
            defaultStateVarName = s;
        }
        Object defaultElementVarName = null;
        if (this.m_defaultElementBinding != null) {
            Object s = ing.getNewName();
            names.put(this.m_defaultElementBinding.getName(), new IdentifierInstruction(s));
            defaultElementVarName = s;
        }
        Object loopIndexVarName = null;
        if (this.m_loopIndexBinding != null) {
            Object s = ing.getNewName();
            names.put(this.m_loopIndexBinding.getName(), new IdentifierInstruction(s));
            loopIndexVarName = s;
        }
        if (this.m_varType instanceof TypeVariable) {
            return new AutomatonInstruction(this.m_source.assignNewNames(names, ing), this.m_initialState.assignNewNames(names, ing), matches2, this.m_default == null ? null : this.m_default.assignNewNames(names, ing), this.getStateComboType(), defaultStateVarName, defaultElementVarName, loopIndexVarName, this.m_wrapResult);
        }
        return new AutomatonInstruction(this.m_source.assignNewNames(names, ing), this.m_initialState.assignNewNames(names, ing), matches2, this.m_default == null ? null : this.m_default.assignNewNames(names, ing), this.getStateComboType(), defaultStateVarName, defaultElementVarName, loopIndexVarName, this.m_wrapResult, (ICollectionType)((Object)this.m_collectionType));
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        wofh.writeInstruction(this.m_source);
        wofh.writeInstruction(this.m_initialState);
        wofh.writeBoolean(this.m_wrapResult);
        wofh.writeType(this.m_stateComboType);
        wofh.writeType(this.m_collectionType);
        wofh.writeBoolean(this.m_default != null);
        if (this.m_default != null) {
            wofh.writeInstruction(this.m_default);
            wofh.writeBindingName(this.m_defaultStateBinding.getName());
            wofh.writeBindingName(this.m_defaultElementBinding.getName());
        }
        int c = this.m_matches.length;
        wofh.writeInt(c);
        for (int i = 0; i < c; ++i) {
            if (this.m_matches[i] instanceof LiteralMatch) {
                wofh.writeInt(0);
            } else if (this.m_matches[i] instanceof DeconstructionMatch) {
                wofh.writeInt(1);
            } else {
                wofh.writeInt(2);
            }
            this.m_matches[i].write(wofh);
        }
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        this.m_source = rofh.readInstruction(benv);
        this.m_initialState = rofh.readInstruction(benv);
        this.m_wrapResult = rofh.readBoolean();
        this.m_stateComboType = rofh.readType();
        this.m_collectionType = rofh.readType();
        this.m_varType = this.m_collectionType == null ? new TypeVariable() : ((ICollectionType)((Object)this.m_collectionType)).getElementType();
        boolean b = rofh.readBoolean();
        if (b) {
            this.m_default = rofh.readInstruction(benv);
            this.m_defaultStateBinding = new Binding(rofh.readBindingName(), (Type)IntType.s_intType, this);
            this.m_defaultElementBinding = new Binding(rofh.readBindingName(), this.m_varType, this);
        }
        int c = rofh.readInt();
        this.m_matches = new Match[c];
        for (int i = 0; i < c; ++i) {
            switch (rofh.readInt()) {
                case 0: {
                    this.m_matches[i] = new LiteralMatch();
                    break;
                }
                case 1: {
                    this.m_matches[i] = new DeconstructionMatch();
                    break;
                }
                case 2: {
                    this.m_matches[i] = new LiteralWildcardMatch();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            this.m_matches[i].read(rofh, benv);
        }
    }

    @Override
    public int getTypeParameterCount() {
        return this.m_collectionType == null ? 1 : 2;
    }

    @Override
    public Type getTypeParameter(int i) {
        switch (i) {
            case 0: {
                return this.m_stateComboType;
            }
            case 1: {
                return this.m_collectionType;
            }
        }
        return null;
    }

    @Override
    public void setTypeParameter(int i, Type n2) {
        switch (i) {
            case 0: {
                this.m_stateComboType = n2;
                break;
            }
            case 1: {
                this.m_collectionType = n2;
            }
        }
    }

    @Override
    public boolean isChildInstructionBody(int i) {
        return this.getChildInstructionBindings(i) != null;
    }

    @Override
    public IBinding[] getChildInstructionBindings(int i) {
        if (this.m_default != null) {
            --i;
        }
        if (this.m_matches == null) {
            return null;
        }
        switch (i) {
            case -1: {
                if (this.m_loopIndexBinding != null) {
                    return new IBinding[]{this.m_defaultElementBinding, this.m_defaultStateBinding, this.m_loopIndexBinding};
                }
                return new IBinding[]{this.m_defaultElementBinding, this.m_defaultStateBinding};
            }
            case 0: 
            case 1: {
                return null;
            }
        }
        if (i % 2 != 0) {
            return null;
        }
        IBinding[] bb = this.m_matches[(i - 2) / 2].getBindings();
        return bb;
    }

    @Override
    public boolean isChildInstructionInTailPosition(int i) {
        return false;
    }

    public static class DeconstructionMatch
    extends Match {
        protected AbstractDataType.Constructor m_constructor;
        protected String m_constructorName;
        private BindingOrLiteral[] m_bindingNames;
        private int m_numBindings;

        public boolean[] getWhichAreBindings() {
            boolean[] ans = new boolean[this.m_bindingNames.length];
            for (int i = 0; i < this.m_bindingNames.length; ++i) {
                ans[i] = this.m_bindingNames[i].isBinding();
            }
            return ans;
        }

        public int getNumberOfBindings(BindingOrLiteral[] arr) {
            int ans = 0;
            for (int i = 0; i < arr.length; ++i) {
                if (!arr[i].isBinding()) continue;
                ++ans;
            }
            return ans;
        }

        public Instruction[] getUsedParameters(Instruction[] params) {
            Instruction[] ans = new Instruction[this.getNumberOfBindings(this.m_bindingNames)];
            int j = 0;
            for (int i = 0; i < params.length; ++i) {
                if (!this.m_bindingNames[i].isBinding()) continue;
                ans[j] = params[i];
                ++j;
            }
            return ans;
        }

        public BindingOrLiteral[] getBindingNames() {
            return this.m_bindingNames;
        }

        @Override
        public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
            this.m_currentState = rofh.readInt();
            this.m_numBindings = rofh.readInt();
            this.m_bindingNames = new BindingOrLiteral[rofh.readInt()];
            for (int i = 0; i < this.m_bindingNames.length; ++i) {
                this.m_bindingNames[i] = new BindingOrLiteral();
                this.m_bindingNames[i].read(rofh, benv);
            }
            this.m_constructorName = rofh.readString();
            this.m_handler = rofh.readInstruction(benv);
            this.m_nextState = rofh.readInstruction(benv);
            this.createBindings();
        }

        @Override
        public void write(WriteObjectFileHelper wofh) throws IOException {
            wofh.writeInt(this.m_currentState);
            wofh.writeInt(this.m_numBindings);
            wofh.writeInt(this.m_bindingNames.length);
            for (int i = 0; i < this.m_bindingNames.length; ++i) {
                this.m_bindingNames[i].write(wofh);
            }
            wofh.writeString(this.m_constructorName);
            wofh.writeInstruction(this.m_handler);
            wofh.writeInstruction(this.m_nextState);
        }

        public DeconstructionMatch() {
        }

        public int compare(LiteralInstruction.KnownValue[] actualValues) {
            boolean mightMatch = true;
            for (int i = 0; i < this.m_bindingNames.length; ++i) {
                if (0 == this.m_bindingNames[i].m_kind) continue;
                LiteralInstruction.KnownValue literal = 1 == this.m_bindingNames[i].m_kind ? new LiteralInstruction.KnownValue(this.m_bindingNames[i].m_literal) : new LiteralInstruction.KnownValue(this.m_bindingNames[i].m_literalStream);
                if (null == actualValues[i]) {
                    mightMatch = false;
                    continue;
                }
                if (literal.equals(actualValues[i])) continue;
                return 0;
            }
            if (mightMatch) {
                return 1;
            }
            return -1;
        }

        public DeconstructionMatch(int state, String constructorName, BindingOrLiteral[] bindings, Instruction handler, Instruction nextState) {
            this.m_constructorName = constructorName;
            this.m_bindingNames = bindings;
            this.m_handler = handler;
            this.m_currentState = state;
            this.m_nextState = nextState;
            this.m_numBindings = this.getNumberOfBindings(this.m_bindingNames);
            this.createBindings();
        }

        private void createBindings() {
        }

        public AbstractDataType.Constructor getConstructor() {
            return this.m_constructor;
        }

        public String getConstructorName() {
            return this.m_constructorName;
        }

        @Override
        public Type getType(TypeEnvironment tenv) {
            return this.m_constructor.getAbstractDataType().getNamedType();
        }

        @Override
        public Type doTypeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
            this.m_constructor = tenv.getModule().getConstructor(this.m_constructorName);
            if (this.m_constructor == null) {
                throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Unknown constructor: " + this.m_constructorName), this.m_handler);
            }
            BindingEnvironment benv2 = new BindingEnvironment(benv);
            int j = 0;
            for (int i = 0; i < this.m_constructor.m_parameters.length; ++i) {
                if (!this.m_bindingNames[i].isBinding()) continue;
                Binding b = this.m_bindingNames[i].getBinding();
                b.setType(this.m_constructor.m_parameters[i].getBindingType());
                benv2.setVariableBinding(b);
                ++j;
            }
            tenv.unify(this.m_nextState.typeCheck(tenv, benv, functionStack), IntType.s_intType, this.m_nextState);
            return this.m_handler.typeCheck(tenv, benv2, functionStack);
        }

        @Override
        public void doTypeCheckReduced(TypeEnvironment tenv, BindingEnvironment benv) {
            this.m_constructor = tenv.getModule().getConstructor(this.m_constructorName);
            if (this.m_constructor == null) {
                throw new XylemError("ERR_SYSTEM", "Unknown constructor: " + this.m_constructorName);
            }
            int j = 0;
            for (int i = 0; i < this.m_constructor.m_parameters.length; ++i) {
                if (!this.m_bindingNames[i].isBinding()) continue;
                Binding b = this.m_bindingNames[i].getBinding();
                b.setType(this.m_constructor.m_parameters[i].getBindingType());
                benv.setVariableBinding(b);
                ++j;
            }
        }

        BindingOrLiteral[] cloneBindingNames() {
            BindingOrLiteral[] out = new BindingOrLiteral[this.m_bindingNames.length];
            for (int i = 0; i < this.m_bindingNames.length; ++i) {
                out[i] = this.m_bindingNames[i].cloneMe();
            }
            return out;
        }

        @Override
        public Match cloneWithoutTypeInformation() {
            return new DeconstructionMatch(this.m_currentState, this.m_constructorName, this.cloneBindingNames(), this.m_handler.cloneWithoutTypeInformation(), this.m_nextState.cloneWithoutTypeInformation());
        }

        @Override
        public Match cloneShallow() {
            return new DeconstructionMatch(this.m_currentState, this.m_constructorName, this.cloneBindingNames(), this.m_handler, this.m_nextState);
        }

        @Override
        public void toString(PrettyPrinter pw, int indent) {
            pw.printFormOpen("state", indent);
            pw.printToken(Integer.toString(this.m_currentState), indent + 1);
            pw.printFormOpen(this.m_constructorName, indent + 1);
            for (int i = 0; i < this.m_bindingNames.length; ++i) {
                if (this.m_bindingNames[i].isLiteral()) {
                    this.m_bindingNames[i].getLiteral().toString(pw, indent + 2);
                    continue;
                }
                if (this.m_bindingNames[i].isBinding()) {
                    pw.printIdentifier(this.m_bindingNames[i].getBinding(), indent + 2);
                    continue;
                }
                if (this.m_bindingNames[i].isLiteralStream()) {
                    new StreamInstruction(this.m_bindingNames[i].getLiteralStreamElementType(), this.m_bindingNames[i].getLiteralStream()).toString(pw, indent + 2);
                    continue;
                }
                pw.printToken("ERROR-5365", indent + 2);
            }
            pw.printFormClose(indent + 1);
            this.m_handler.toString(pw, indent + 1);
            this.m_nextState.toString(pw, indent + 1);
            pw.printFormClose(indent);
        }

        public IdentifierInstruction getXylemIfMatches(ConstructorInstantiationInstruction cii, LetChainManager lcm, LetInstruction before2) {
            Instruction[] boundValues = new Instruction[this.m_bindingNames.length];
            for (int i = 0; i < this.m_bindingNames.length; ++i) {
                BindingOrLiteral bol = this.m_bindingNames[i];
                boundValues[i] = bol.isBinding() ? null : cii.m_parameters[i].cloneWithoutTypeInformation();
            }
            LinkedList<Instruction> list = new LinkedList<Instruction>();
            list.add(LiteralInstruction.booleanTrueLiteral());
            boolean[] whichAreBindings = this.getWhichAreBindings();
            for (int i = 0; i < whichAreBindings.length; ++i) {
                if (whichAreBindings[i]) continue;
                IdentifierInstruction myLiteral = lcm.insertBody(this.m_bindingNames[i].getXylemConstant(), before2);
                IdentifierInstruction booleanArg = lcm.insertBody(new DeepEqualityInstruction(myLiteral, boundValues[i]), before2);
                list.add(booleanArg);
            }
            return lcm.insertBody(new AndInstruction(list), before2);
        }

        public void addIfMatchesLiterals(FcgCodeGenHelper cgh, CodeGenerationTracker cgt, FcgInstructionList il, FcgVariable var) {
            boolean[] whichAreBindings = this.getWhichAreBindings();
            il.loadLiteral(true);
            for (int i = 0; i < whichAreBindings.length; ++i) {
                if (whichAreBindings[i]) continue;
                Type paramType = this.m_constructor.getParameterTypes()[i];
                FcgClassReferenceType type2 = (FcgClassReferenceType)il.loadVar(var);
                il.loadInstanceField(type2, this.m_constructor.getConstructorQualifiedFieldName(i, cgh), paramType.getFCGType(cgh));
                this.m_bindingNames[i].generateEquals(paramType, cgh, cgt, il);
                il.binaryOperationExpr(FcgBinOp.LOGICAL_AND);
            }
            il.beginIf();
        }

        @Override
        public Binding[] getBindings() {
            Binding[] bindings = new Binding[this.m_numBindings];
            int j = 0;
            for (int i = 0; i < this.m_bindingNames.length; ++i) {
                if (!this.m_bindingNames[i].isBinding()) continue;
                bindings[j++] = this.m_bindingNames[i].getBinding();
            }
            return bindings;
        }
    }

    public static class BindingOrLiteral {
        private int m_kind;
        private Binding m_binding;
        private LiteralInstruction m_literal;
        private LiteralInstruction[] m_literalStream;

        public String toString() {
            switch (this.m_kind) {
                case 0: {
                    return "Binding " + this.m_binding;
                }
                case 1: {
                    return "Literal " + this.m_literal;
                }
                case 2: {
                    return "LiteralStream " + this.m_literalStream.toString();
                }
            }
            return "Unknown BindingOrLiteral";
        }

        public void write(WriteObjectFileHelper wofh) throws IOException {
            wofh.writeInt(this.m_kind);
            switch (this.m_kind) {
                case 0: {
                    wofh.writeBindingName(this.m_binding.getName());
                    break;
                }
                case 1: {
                    this.m_literal.write(wofh);
                    break;
                }
                case 2: {
                    wofh.writeInt(this.m_literalStream.length);
                    for (int i = 0; i < this.m_literalStream.length; ++i) {
                        this.m_literalStream[i].write(wofh);
                    }
                    break;
                }
            }
        }

        public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
            this.m_kind = rofh.readInt();
            switch (this.m_kind) {
                case 0: {
                    this.m_binding = new Binding(rofh.readBindingName());
                    break;
                }
                case 1: {
                    this.m_literal = new LiteralInstruction();
                    this.m_literal.read(rofh, benv);
                    break;
                }
                case 2: {
                    this.m_literalStream = new LiteralInstruction[rofh.readInt()];
                    for (int i = 0; i < this.m_literalStream.length; ++i) {
                        this.m_literalStream[i] = new LiteralInstruction();
                        this.m_literalStream[i].read(rofh, benv);
                    }
                    break;
                }
            }
        }

        public BindingOrLiteral(Object str) {
            this.m_kind = 0;
            this.m_binding = new Binding(str, (Type)null);
        }

        public BindingOrLiteral(LiteralInstruction instr) {
            this.m_kind = 1;
            this.m_literal = instr;
        }

        public BindingOrLiteral(LiteralInstruction[] instrs) {
            this.m_kind = 2;
            this.m_literalStream = instrs;
        }

        public BindingOrLiteral() {
        }

        public boolean isBinding() {
            return 0 == this.m_kind;
        }

        public boolean isLiteral() {
            return 1 == this.m_kind;
        }

        public boolean isLiteralStream() {
            return 2 == this.m_kind;
        }

        public LiteralInstruction getLiteral() {
            return this.m_literal;
        }

        public LiteralInstruction[] getLiteralStream() {
            return this.m_literalStream;
        }

        public Binding getBinding() {
            return this.m_binding;
        }

        public Type getLiteralStreamElementType() {
            return this.m_literalStream[0].getType();
        }

        public BindingOrLiteral cloneMe() {
            switch (this.m_kind) {
                case 0: {
                    return new BindingOrLiteral(this.m_binding.getName());
                }
                case 1: {
                    return new BindingOrLiteral(this.m_literal);
                }
                case 2: {
                    return new BindingOrLiteral(this.m_literalStream);
                }
            }
            return null;
        }

        public Instruction getXylemConstant() {
            switch (this.m_kind) {
                case 0: {
                    throw new XylemError("ERR_SYSTEM", "Should not reach");
                }
                case 1: {
                    return this.m_literal;
                }
                case 2: {
                    return new StreamInstruction(this.getLiteralStreamElementType(), this.m_literalStream);
                }
            }
            return null;
        }

        public void generateEquals(Type type2, FcgCodeGenHelper cgh, CodeGenerationTracker cgt, FcgInstructionList il) {
            switch (this.m_kind) {
                case 0: {
                    throw new XylemError("ERR_SYSTEM", "Should not reach");
                }
                case 1: {
                    il.loadLiteral(Integer.parseInt(this.m_literal.toString()));
                    il.binaryOperationExpr(FcgBinOp.COMPARE_EQ);
                }
                case 2: {
                    Type t = ((StreamType)type2).getElementType();
                    StreamInstruction.insertStreamConstant(this.m_literalStream, t, cgh, cgt, il);
                    FcgClassReferenceType arraysType = cgh.getClassReferenceType("java.util.Arrays");
                    il.invokeClassMethod(arraysType, "equals", (FcgType)FcgType.BOOLEAN, 2);
                }
            }
        }
    }

    public static class LiteralWildcardMatch
    extends Match {
        protected Instruction m_source = null;
        public Binding m_binding;

        public void setSource(Instruction s) {
            this.m_source = s;
        }

        public LiteralWildcardMatch() {
        }

        @Override
        public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
            this.m_currentState = rofh.readInt();
            this.m_binding = new Binding(rofh.readBindingName());
            this.m_handler = rofh.readInstruction(benv);
            this.m_nextState = rofh.readInstruction(benv);
        }

        @Override
        public void write(WriteObjectFileHelper wofh) throws IOException {
            wofh.writeInt(this.m_currentState);
            wofh.writeBindingName(this.m_binding.getName());
            wofh.writeInstruction(this.m_handler);
            wofh.writeInstruction(this.m_nextState);
        }

        public LiteralWildcardMatch(int state, Object ident, Instruction handler, Instruction nextState) {
            this.m_currentState = state;
            this.m_binding = new Binding(ident, (Type)null);
            this.m_handler = handler;
            this.m_nextState = nextState;
        }

        public Object getIdent() {
            return this.m_binding.getName();
        }

        public Binding getBinding() {
            return this.m_binding;
        }

        @Override
        public Type getType(TypeEnvironment tenv) {
            return ((StreamType)this.m_source.getCachedType()).getElementType();
        }

        @Override
        public Type doTypeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
            BindingEnvironment benv2 = new BindingEnvironment(benv);
            this.m_binding.setTypeEnvironment(tenv);
            this.m_binding.setType(this.getType(tenv));
            benv2.setVariableBinding(this.m_binding);
            tenv.unify(this.m_nextState.typeCheck(tenv, benv, functionStack), IntType.s_intType, this.m_handler);
            return this.m_handler.typeCheck(tenv, benv2, functionStack);
        }

        @Override
        public void doTypeCheckReduced(TypeEnvironment tenv, BindingEnvironment benv) {
            this.m_binding.setType(((StreamType)this.m_source.getType(tenv, benv)).getElementType());
            benv.setVariableBinding(this.m_binding);
        }

        @Override
        public Match cloneWithoutTypeInformation() {
            return new LiteralWildcardMatch(this.m_currentState, this.m_binding.getName(), this.m_handler.cloneWithoutTypeInformation(), this.m_nextState.cloneWithoutTypeInformation());
        }

        @Override
        public Match cloneShallow() {
            return new LiteralWildcardMatch(this.m_currentState, this.m_binding.getName(), this.m_handler, this.m_nextState);
        }

        @Override
        public void toString(PrettyPrinter pw, int indent) {
            pw.printFormOpen("state", indent);
            pw.printToken(Integer.toString(this.m_currentState), indent + 1);
            pw.printIdentifier(this.m_binding, indent + 1);
            this.m_handler.toString(pw, indent + 1);
            this.m_nextState.toString(pw, indent + 1);
            pw.printFormClose(indent);
        }

        @Override
        public Binding[] getBindings() {
            return new Binding[]{this.m_binding};
        }
    }

    public static class LiteralMatch
    extends Match {
        protected LiteralInstruction m_literal;

        public LiteralMatch() {
        }

        public LiteralMatch(int state, LiteralInstruction literal, Instruction handler, Instruction nextState) {
            this.m_currentState = state;
            this.m_literal = literal;
            this.m_handler = handler;
            this.m_nextState = nextState;
        }

        public LiteralInstruction getLiteral() {
            return this.m_literal;
        }

        @Override
        public Type getType(TypeEnvironment tenv) {
            return this.m_literal.getType();
        }

        @Override
        public Type doTypeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
            tenv.unify(this.m_nextState.typeCheck(tenv, benv, functionStack), IntType.s_intType, this.m_literal);
            return this.m_handler.typeCheck(tenv, benv, functionStack);
        }

        @Override
        public void doTypeCheckReduced(TypeEnvironment tenv, BindingEnvironment benv) {
        }

        @Override
        public Match cloneWithoutTypeInformation() {
            return new LiteralMatch(this.m_currentState, this.m_literal, this.m_handler.cloneWithoutTypeInformation(), this.m_nextState.cloneWithoutTypeInformation());
        }

        @Override
        public Match cloneShallow() {
            return new LiteralMatch(this.m_currentState, this.m_literal, this.m_handler, this.m_nextState);
        }

        @Override
        public void toString(PrettyPrinter pw, int indent) {
            pw.printFormOpen("state", indent);
            pw.printToken(Integer.toString(this.m_currentState), indent + 1);
            this.m_literal.toString(pw, indent + 1);
            this.m_handler.toString(pw, indent + 1);
            this.m_nextState.toString(pw, indent + 1);
            pw.printFormClose(indent);
        }

        @Override
        public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
            this.m_currentState = rofh.readInt();
            this.m_literal = new LiteralInstruction();
            this.m_literal.read(rofh, benv);
            this.m_handler = rofh.readInstruction(benv);
            this.m_nextState = rofh.readInstruction(benv);
        }

        @Override
        public void write(WriteObjectFileHelper wofh) throws IOException {
            wofh.writeInt(this.m_currentState);
            this.m_literal.write(wofh);
            wofh.writeInstruction(this.m_handler);
            wofh.writeInstruction(this.m_nextState);
        }

        @Override
        public Binding[] getBindings() {
            return ISpecialForm.NO_BINDINGS;
        }
    }

    public static abstract class Match {
        Instruction m_handler;
        Instruction m_nextState;
        int m_currentState;

        public abstract Type getType(TypeEnvironment var1);

        public abstract Type doTypeCheck(TypeEnvironment var1, BindingEnvironment var2, LinkedList var3) throws TypeCheckException;

        public abstract void doTypeCheckReduced(TypeEnvironment var1, BindingEnvironment var2);

        public abstract Match cloneWithoutTypeInformation();

        public abstract Match cloneShallow();

        public abstract Binding[] getBindings();

        public int getCurrentState() {
            return this.m_currentState;
        }

        public void getCurrentState(int s) {
            this.m_currentState = s;
        }

        public Instruction getHandler() {
            return this.m_handler;
        }

        public void setHandler(Instruction h) {
            this.m_handler = h;
        }

        public Instruction getNextState() {
            return this.m_nextState;
        }

        public void setNextState(Instruction s) {
            this.m_nextState = s;
        }

        public abstract void read(ReadObjectFileHelper var1, BindingEnvironment var2) throws Exception;

        public abstract void write(WriteObjectFileHelper var1) throws IOException;

        public abstract void toString(PrettyPrinter var1, int var2);
    }
}

