/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.INewNameGenerator;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.ILazyStreamFixedIndexOptimizationInstruction;
import com.ibm.xltxe.rnm1.xylem.codegen.LazyStreamFixedIndexOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Closure;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.interpreter.LazyStream;
import com.ibm.xltxe.rnm1.xylem.optimizers.FindFreeVariables;
import com.ibm.xltxe.rnm1.xylem.types.BooleanType;
import com.ibm.xltxe.rnm1.xylem.types.LazyStreamType;
import com.ibm.xltxe.rnm1.xylem.types.NamedType;
import com.ibm.xltxe.rnm1.xylem.types.TupleType;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class BuildLazyStreamInstruction
extends Instruction
implements ISpecialForm,
ILazyStreamFixedIndexOptimizationInstruction {
    protected Instruction m_body;
    protected Binding[] m_hintBindings;
    protected Instruction[] m_initialHints;
    protected Type m_tupleType;
    protected Type m_elementType;

    public BuildLazyStreamInstruction() {
    }

    public BuildLazyStreamInstruction(Instruction[] initialHints, Object[] vars, Instruction body) {
        if (initialHints.length != vars.length) {
            throw new IllegalArgumentException();
        }
        this.m_initialHints = initialHints;
        this.m_hintBindings = new Binding[vars.length];
        for (int i = 0; i < this.m_hintBindings.length; ++i) {
            this.m_hintBindings[i] = new Binding(vars[i], (Type)new TypeVariable(), this);
        }
        this.m_body = body;
    }

    public Instruction getBody() {
        return this.m_body;
    }

    public void setBody(Instruction n2) {
        this.m_body = n2;
    }

    @Override
    public int getChildInstructionCount() {
        return 1 + this.m_initialHints.length;
    }

    @Override
    public Instruction getChildInstruction(int i) {
        switch (i) {
            case 0: {
                return this.m_body;
            }
        }
        return this.m_initialHints[i - 1];
    }

    @Override
    public void setChildInstruction(int i, Instruction n2) {
        switch (i) {
            case 0: {
                this.m_body = n2;
                break;
            }
            default: {
                this.m_initialHints[i - 1] = n2;
            }
        }
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        Instruction[] newHints = new Instruction[this.m_initialHints.length];
        for (int i = 0; i < newHints.length; ++i) {
            newHints[i] = this.m_initialHints[i].cloneWithoutTypeInformation();
        }
        BuildLazyStreamInstruction blsi = new BuildLazyStreamInstruction(newHints, Binding.getNames(this.m_hintBindings), this.m_body.cloneWithoutTypeInformation());
        if (this.m_tupleType != null) {
            blsi.m_tupleType = this.m_tupleType;
        }
        blsi.m_elementType = this.m_elementType;
        BuildLazyStreamInstruction.propagateInfo(this, blsi);
        return blsi;
    }

    @Override
    public Instruction cloneShallow() {
        BuildLazyStreamInstruction blsi = new BuildLazyStreamInstruction((Instruction[])this.m_initialHints.clone(), Binding.getNames(this.m_hintBindings), this.m_body.cloneWithoutTypeInformation());
        if (this.m_tupleType != null) {
            blsi.m_tupleType = this.m_tupleType;
        }
        blsi.m_elementType = this.m_elementType;
        BuildLazyStreamInstruction.propagateInfo(this, blsi);
        return blsi;
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        super.doDefaultTypeCheck(tenv, benv, functionStack);
        Type[] tupleElementTypes = new Type[2 + this.m_initialHints.length];
        BindingEnvironment benv2 = new BindingEnvironment(benv);
        for (int i = 0; i < this.m_initialHints.length; ++i) {
            Type type2 = this.m_initialHints[i].typeCheck(tenv, benv, functionStack);
            tupleElementTypes[i + 2] = type2;
            this.m_hintBindings[i].setType(type2);
            benv2.setVariableBinding(this.m_hintBindings[i]);
        }
        this.m_elementType = new TypeVariable();
        tupleElementTypes[0] = this.m_elementType.getStreamType();
        tupleElementTypes[1] = BooleanType.s_booleanType;
        this.m_tupleType = new TupleType(tupleElementTypes);
        tenv.unify(this.m_tupleType, this.m_body.typeCheck(tenv, benv2, functionStack), this);
        return this.setCachedType(new LazyStreamType(this.m_elementType));
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        return new LazyStreamType(this.m_elementType);
    }

    @Override
    public void accumulateNonLiteralFreeBindings(Set set2, BindingEnvironment benv) {
        super.accumulateNonLiteralFreeBindings(set2, benv);
        for (int i = 0; i < this.m_hintBindings.length; ++i) {
            set2.remove(this.m_hintBindings[i]);
        }
    }

    @Override
    public void accumulateFreeBindings(Set set2, BindingEnvironment benv) {
        super.accumulateFreeBindings(set2, benv);
        for (int i = 0; i < this.m_hintBindings.length; ++i) {
            set2.remove(this.m_hintBindings[i]);
        }
    }

    @Override
    public void typeCheckReduced(TypeEnvironment tenv, BindingEnvironment benv, LinkedList<Function> functionStack) {
        for (int i = 0; i < this.m_initialHints.length; ++i) {
            this.m_initialHints[i].typeCheckReduced(tenv, benv, functionStack);
            this.m_hintBindings[i].setType(this.m_initialHints[i].getType(tenv, benv));
            benv.setVariableBinding(this.m_hintBindings[i]);
        }
        this.m_body.typeCheckReduced(tenv, benv, functionStack);
        this.clearLocalForTypecheckReduced();
    }

    @Override
    public void generateReducedForm(ReductionHelper rh, Instruction[] state, BindingEnvironment benv) {
        for (int i = 0; i < this.m_hintBindings.length; ++i) {
            this.m_initialHints[i] = rh.reduceToBasicInstruction(state, this.m_initialHints[i], benv);
        }
        ReductionHelper rh2 = (ReductionHelper)rh.clone();
        for (int i = 0; i < this.m_hintBindings.length; ++i) {
            rh2.upgradeBinding(this.m_hintBindings[i]);
            benv.setVariableBinding(this.m_hintBindings[i]);
        }
        this.m_body = rh2.reduce(this.m_body, benv);
        state[0] = this;
        this.m_bindingEnvironment = null;
    }

    @Override
    public void toString(PrettyPrinter pw, int indent) {
        int i;
        String x = "build-lazy-stream";
        pw.printFormOpen(x, indent);
        pw.print(" (");
        for (i = 0; i < this.m_hintBindings.length; ++i) {
            pw.printIdentifier(this.m_hintBindings[i], indent + 2);
        }
        pw.printFormClose(indent + 1);
        for (i = 0; i < this.m_hintBindings.length; ++i) {
            this.m_initialHints[i].toString(pw, indent + 1);
        }
        this.m_body.toString(pw, indent + 1);
        pw.print(")");
    }

    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        if (null != di) {
            di.enter(this, e, f2);
        }
        BindingEnvironment benv = this.evaluateBindingEnvironment(f2);
        Set<Object> freeBindings = FindFreeVariables.findFreeVariables(this);
        Iterator<Object> i = freeBindings.iterator();
        int j = 0;
        IBinding[] closureBindings = new IBinding[freeBindings.size()];
        Object[] closureValues = new Object[freeBindings.size()];
        while (i.hasNext()) {
            IBinding b;
            Object o = i.next();
            closureBindings[j] = b = benv.getVariableBinding(o);
            Object value2 = e.lookupBoundValue(b);
            Type t = b.getBindingType();
            value2 = t.evaluateVariableFork(value2);
            closureValues[j++] = value2;
        }
        Closure c = new Closure(closureBindings, closureValues, f2, this.m_body, this.m_hintBindings, this.m_sourceFilename, this.m_sourceLineNumber, 0);
        Object[] hints = new Object[this.m_initialHints.length];
        for (j = 0; j < hints.length; ++j) {
            hints[j] = this.m_initialHints[j].evaluate(e, f2, di, false);
        }
        LazyStream ans = new LazyStream(c, e, di, hints);
        return Debugger.leave(di, this, e, f2, (Object)ans);
    }

    @Override
    protected boolean supportsCodeGenerationOptimizationInternal(CodeGenerationOptimizationStyle cgos, TypeEnvironment tenv, BindingEnvironment benv) {
        if (cgos instanceof LazyStreamFixedIndexOptimizationStyle) {
            return true;
        }
        return super.supportsCodeGenerationOptimizationInternal(cgos, tenv, benv);
    }

    @Override
    public Instruction assignNewNames(Map names, INewNameGenerator ing) {
        Object[] newNames = new Object[this.m_hintBindings.length];
        Instruction[] newHints = new Instruction[this.m_hintBindings.length];
        for (int i = 0; i < this.m_hintBindings.length; ++i) {
            Object var = ing.getNewName();
            names.put(this.m_hintBindings[i].getName(), new IdentifierInstruction(var));
            newNames[i] = var;
            newHints[i] = this.m_initialHints[i].assignNewNames(names, ing);
        }
        BuildLazyStreamInstruction blsi = new BuildLazyStreamInstruction(newHints, newNames, this.m_body.assignNewNames(names, ing));
        if (this.m_tupleType != null && this.m_tupleType instanceof NamedType) {
            blsi.m_tupleType = this.m_tupleType;
        }
        blsi.m_elementType = this.m_elementType;
        return blsi;
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        int c = rofh.readInt();
        this.m_initialHints = new Instruction[c];
        for (int i = 0; i < c; ++i) {
            this.m_initialHints[i] = rofh.readInstruction(benv);
        }
        this.m_hintBindings = rofh.readTypeSpecificBindingSet();
        this.m_body = rofh.readInstruction(benv);
        if (rofh.readBoolean()) {
            this.m_tupleType = rofh.readType();
        }
        if (rofh.readBoolean()) {
            this.m_elementType = rofh.readType();
        }
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        int c = this.m_initialHints.length;
        wofh.writeInt(c);
        for (int i = 0; i < c; ++i) {
            wofh.writeInstruction(this.m_initialHints[i]);
        }
        wofh.writeTypeSpecificBindingSet(this.m_hintBindings);
        wofh.writeInstruction(this.m_body);
        wofh.writeBoolean(this.m_tupleType != null);
        if (this.m_tupleType != null) {
            wofh.writeType(this.m_tupleType);
        }
        wofh.writeBoolean(this.m_elementType != null);
        if (this.m_elementType != null) {
            wofh.writeType(this.m_elementType);
        }
    }

    @Override
    public int getTypeParameterCount() {
        return 2 + this.m_initialHints.length;
    }

    @Override
    public Type getTypeParameter(int i) {
        return i == 0 ? this.m_tupleType : (i == 1 ? this.m_elementType : this.m_hintBindings[i - 2].getBindingType());
    }

    @Override
    public void setTypeParameter(int i, Type n2) {
        if (i == 0) {
            this.m_tupleType = n2;
        } else if (i == 1) {
            this.m_elementType = n2;
        } else {
            this.m_hintBindings[i - 2].setType(n2);
        }
    }

    @Override
    public boolean isChildInstructionBody(int i) {
        return i == 0;
    }

    @Override
    public IBinding[] getChildInstructionBindings(int i) {
        if (i != 0) {
            return null;
        }
        return this.m_hintBindings;
    }

    @Override
    public boolean isChildInstructionInTailPosition(int i) {
        return false;
    }
}

