/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.INewNameGenerator;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.ILazyStreamFixedIndexOptimizationInstruction;
import com.ibm.xltxe.rnm1.xylem.codegen.LazyStreamFixedIndexOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Closure;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.interpreter.LazyStream;
import com.ibm.xltxe.rnm1.xylem.optimizers.FindFreeVariables;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.types.BooleanType;
import com.ibm.xltxe.rnm1.xylem.types.NamedType;
import com.ibm.xltxe.rnm1.xylem.types.TupleType;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class BuildMultiStreamInstruction
extends Instruction
implements ISpecialForm,
ILazyStreamFixedIndexOptimizationInstruction {
    protected Instruction m_body;
    protected Binding[] m_hintBindings;
    protected Instruction[] m_initialHints;
    protected Type m_tupleType;

    public BuildMultiStreamInstruction() {
    }

    public BuildMultiStreamInstruction(Instruction[] initialHints, Object[] hintVars, Instruction body) {
        if (initialHints.length != hintVars.length) {
            throw new IllegalArgumentException();
        }
        this.m_initialHints = initialHints;
        this.m_hintBindings = new Binding[hintVars.length];
        for (int i = 0; i < this.m_hintBindings.length; ++i) {
            this.m_hintBindings[i] = new Binding(hintVars[i], (Type)new TypeVariable(), this);
        }
        this.m_body = body;
    }

    public Instruction getBody() {
        return this.m_body;
    }

    public void setBody(Instruction n2) {
        this.m_body = n2;
    }

    @Override
    public int getChildInstructionCount() {
        return 1 + this.m_initialHints.length;
    }

    @Override
    public Instruction getChildInstruction(int i) {
        switch (i) {
            case 0: {
                return this.m_body;
            }
        }
        return this.m_initialHints[i - 1];
    }

    @Override
    public void setChildInstruction(int i, Instruction n2) {
        switch (i) {
            case 0: {
                this.m_body = n2;
                break;
            }
            default: {
                this.m_initialHints[i - 1] = n2;
            }
        }
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        Instruction[] newHints = new Instruction[this.m_initialHints.length];
        for (int i = 0; i < newHints.length; ++i) {
            newHints[i] = this.m_initialHints[i].cloneWithoutTypeInformation();
        }
        BuildMultiStreamInstruction blsi = new BuildMultiStreamInstruction(newHints, Binding.getNames(this.m_hintBindings), this.m_body.cloneWithoutTypeInformation());
        if (this.m_tupleType != null) {
            blsi.m_tupleType = this.m_tupleType;
        }
        BuildMultiStreamInstruction.propagateInfo(this, blsi);
        return blsi;
    }

    @Override
    public Instruction cloneShallow() {
        BuildMultiStreamInstruction blsi = new BuildMultiStreamInstruction((Instruction[])this.m_initialHints.clone(), Binding.getNames(this.m_hintBindings), this.m_body.cloneWithoutTypeInformation());
        if (this.m_tupleType != null) {
            blsi.m_tupleType = this.m_tupleType;
        }
        BuildMultiStreamInstruction.propagateInfo(this, blsi);
        return blsi;
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        super.doDefaultTypeCheck(tenv, benv, functionStack);
        BindingEnvironment benv2 = new BindingEnvironment(benv);
        Type[] tupleElementTypes = new Type[1 + this.m_initialHints.length];
        tupleElementTypes[0] = BooleanType.s_booleanType;
        int k = 1;
        for (int i = 0; i < this.m_initialHints.length; ++i) {
            tupleElementTypes[k] = this.m_initialHints[i].typeCheck(tenv, benv, functionStack);
            this.m_hintBindings[i].setType(tupleElementTypes[k]);
            benv2.setVariableBinding(this.m_hintBindings[i]);
            ++k;
        }
        Type bodyType = this.m_body.typeCheck(tenv, benv2, functionStack);
        Type resolvedBodyType = bodyType.resolveTypeAsMuchAsPossible(tenv, new HashSet());
        if (!(resolvedBodyType instanceof TypeVariable)) {
            if (resolvedBodyType instanceof TupleType) {
                TupleType tupTyp = (TupleType)resolvedBodyType;
                Type[] bodyTypes = tupTyp.getElementTypes();
                if (bodyTypes.length < 1 + this.m_initialHints.length) {
                    throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Body of build-multi-stream should be a tuple that (at least) has a continue hint and a final value for each initial param"), this);
                }
                tenv.unify(BooleanType.s_booleanType, bodyTypes[0], this);
                for (int i = 0; i < this.m_initialHints.length; ++i) {
                    tenv.unify(this.m_hintBindings[i].getBindingType(), bodyTypes[i + 1], this);
                }
                for (int j = i + 1; j < bodyTypes.length; ++j) {
                    tenv.unify(new TypeVariable().getStreamType(), bodyTypes[j], this);
                }
            } else {
                throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Body of build-multi-stream should be a tuple but found type " + resolvedBodyType.prettyPrint() + " instead"), this);
            }
        }
        this.m_tupleType = resolvedBodyType;
        return this.setCachedType(resolvedBodyType);
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        return this.m_tupleType;
    }

    @Override
    public Type getPreTypecheckType(ModuleSignature msig) {
        return this.m_tupleType;
    }

    @Override
    public void accumulateNonLiteralFreeBindings(Set set2, BindingEnvironment benv) {
        super.accumulateNonLiteralFreeBindings(set2, benv);
        for (int i = 0; i < this.m_hintBindings.length; ++i) {
            set2.remove(this.m_hintBindings[i]);
        }
    }

    @Override
    public void accumulateFreeBindings(Set set2, BindingEnvironment benv) {
        super.accumulateFreeBindings(set2, benv);
        for (int i = 0; i < this.m_hintBindings.length; ++i) {
            set2.remove(this.m_hintBindings[i]);
        }
    }

    @Override
    public void typeCheckReduced(TypeEnvironment tenv, BindingEnvironment benv, LinkedList<Function> functionStack) {
        for (int i = 0; i < this.m_initialHints.length; ++i) {
            this.m_initialHints[i].typeCheckReduced(tenv, benv, functionStack);
            this.m_hintBindings[i].setType(this.m_initialHints[i].getType(tenv, benv));
            benv.setVariableBinding(this.m_hintBindings[i]);
        }
        this.m_body.typeCheckReduced(tenv, benv, functionStack);
        this.clearLocalForTypecheckReduced();
    }

    @Override
    public void generateReducedForm(ReductionHelper rh, Instruction[] state, BindingEnvironment benv) {
        for (int i = 0; i < this.m_hintBindings.length; ++i) {
            this.m_initialHints[i] = rh.reduceToBasicInstruction(state, this.m_initialHints[i], benv);
        }
        ReductionHelper rh2 = (ReductionHelper)rh.clone();
        for (int i = 0; i < this.m_hintBindings.length; ++i) {
            rh2.upgradeBinding(this.m_hintBindings[i]);
            benv.setVariableBinding(this.m_hintBindings[i]);
        }
        this.m_body = rh2.reduce(this.m_body, benv);
        state[0] = this;
        this.m_bindingEnvironment = null;
    }

    @Override
    public void toString(PrettyPrinter pw, int indent) {
        int i;
        String x = "build-multi-stream";
        pw.printFormOpen(x, indent);
        pw.print(" (");
        for (i = 0; i < this.m_hintBindings.length; ++i) {
            pw.printIdentifier(this.m_hintBindings[i], indent + 2);
        }
        pw.printFormClose(indent + 1);
        for (i = 0; i < this.m_hintBindings.length; ++i) {
            this.m_initialHints[i].toString(pw, indent + 1);
        }
        pw.printFormClose(indent + 1);
        this.m_body.toString(pw, indent + 1);
        pw.print(")");
    }

    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        if (null != di) {
            di.enter(this, e, f2);
        }
        BindingEnvironment benv = this.evaluateBindingEnvironment(f2);
        Set<Object> freeBindings = FindFreeVariables.findFreeVariables(this);
        Iterator<Object> i = freeBindings.iterator();
        int j = 0;
        IBinding[] closureBindings = new IBinding[freeBindings.size()];
        Object[] closureValues = new Object[freeBindings.size()];
        while (i.hasNext()) {
            IBinding b;
            Object o = i.next();
            closureBindings[j] = b = benv.getVariableBinding(o);
            Object value2 = e.lookupBoundValue(b);
            Type t = b.getBindingType();
            value2 = t.evaluateVariableFork(value2);
            closureValues[j++] = value2;
        }
        Closure c = new Closure(closureBindings, closureValues, f2, this.m_body, this.m_hintBindings, this.m_sourceFilename, this.m_sourceLineNumber, 0);
        Object[] hints = new Object[this.m_initialHints.length];
        for (j = 0; j < hints.length; ++j) {
            hints[j] = this.m_initialHints[j].evaluate(e, f2, di, false);
        }
        LazyStream ans = new LazyStream(c, e, di, hints);
        return Debugger.leave(di, this, e, f2, (Object)ans);
    }

    @Override
    protected boolean supportsCodeGenerationOptimizationInternal(CodeGenerationOptimizationStyle cgos, TypeEnvironment tenv, BindingEnvironment benv) {
        if (cgos instanceof LazyStreamFixedIndexOptimizationStyle) {
            return true;
        }
        return super.supportsCodeGenerationOptimizationInternal(cgos, tenv, benv);
    }

    @Override
    public Instruction assignNewNames(Map names, INewNameGenerator ing) {
        Object[] newNames = new Object[this.m_hintBindings.length];
        Instruction[] newHints = new Instruction[this.m_hintBindings.length];
        for (int i = 0; i < this.m_hintBindings.length; ++i) {
            Object var = ing.getNewName();
            names.put(this.m_hintBindings[i].getName(), new IdentifierInstruction(var));
            newNames[i] = var;
            newHints[i] = this.m_initialHints[i].assignNewNames(names, ing);
        }
        BuildMultiStreamInstruction blsi = new BuildMultiStreamInstruction(newHints, newNames, this.m_body.assignNewNames(names, ing));
        if (this.m_tupleType != null && this.m_tupleType instanceof NamedType) {
            blsi.m_tupleType = this.m_tupleType;
        }
        return blsi;
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        int c = rofh.readInt();
        this.m_initialHints = new Instruction[c];
        for (int i = 0; i < c; ++i) {
            this.m_initialHints[i] = rofh.readInstruction(benv);
        }
        this.m_hintBindings = rofh.readTypeSpecificBindingSet();
        this.m_body = rofh.readInstruction(benv);
        if (rofh.readBoolean()) {
            this.m_tupleType = rofh.readType();
        }
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        int c = this.m_initialHints.length;
        wofh.writeInt(c);
        for (int i = 0; i < c; ++i) {
            wofh.writeInstruction(this.m_initialHints[i]);
        }
        wofh.writeTypeSpecificBindingSet(this.m_hintBindings);
        wofh.writeInstruction(this.m_body);
        wofh.writeBoolean(this.m_tupleType != null);
        if (this.m_tupleType != null) {
            wofh.writeType(this.m_tupleType);
        }
    }

    @Override
    public int getTypeParameterCount() {
        return 1 + this.m_initialHints.length;
    }

    @Override
    public Type getTypeParameter(int i) {
        if (i == 0) {
            return this.m_tupleType;
        }
        return this.m_hintBindings[--i].getBindingType();
    }

    @Override
    public void setTypeParameter(int i, Type n2) {
        int loggedI1 = i;
        if (i == 0) {
            this.m_tupleType = n2;
            return;
        }
        int loggedI2 = --i;
        this.m_hintBindings[i].setType(n2);
    }

    @Override
    public boolean isChildInstructionBody(int i) {
        return i == 0;
    }

    @Override
    public IBinding[] getChildInstructionBindings(int i) {
        if (i != 0) {
            return null;
        }
        if (this.m_hintBindings == null) {
            return null;
        }
        IBinding[] binds = new IBinding[this.m_hintBindings.length];
        System.arraycopy(this.m_hintBindings, 0, binds, 0, this.m_hintBindings.length);
        return binds;
    }

    @Override
    public boolean isChildInstructionInTailPosition(int i) {
        return false;
    }
}

