/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.NavigationUtilities;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.UnaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.interpreter.IStream;
import com.ibm.xltxe.rnm1.xylem.types.CharType;
import com.ibm.xltxe.rnm1.xylem.types.JavaObjectType;
import java.util.LinkedList;

public class CharStreamToJavaStringInstruction
extends UnaryPrimopInstruction {
    public CharStreamToJavaStringInstruction(Instruction op2) {
        super(op2);
        this.setCachedType();
    }

    public CharStreamToJavaStringInstruction() {
        this.setCachedType();
    }

    private void setCachedType() {
        this.setCachedType(JavaObjectType.s_javaStringType);
    }

    public static Instruction literal(String val) {
        return new CharStreamToJavaStringInstruction(StreamInstruction.charStreamLiteral(val));
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        return JavaObjectType.s_javaStringType;
    }

    @Override
    public Type getPreTypecheckType(ModuleSignature msig) {
        return JavaObjectType.s_javaStringType;
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        CharStreamToJavaStringInstruction i = new CharStreamToJavaStringInstruction(this.m_operand.cloneWithoutTypeInformation());
        CharStreamToJavaStringInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        tenv.unify(this.m_operand.typeCheck(tenv, benv, functionStack), CharType.s_charType.getStreamType(), this);
        return this.setCachedType(JavaObjectType.s_javaStringType);
    }

    @Override
    public String innerToString() {
        return "char-stream-to-java-string";
    }

    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        IStream x;
        if (null != di) {
            di.enter(this, e, f2);
        }
        if ((x = (IStream)this.m_operand.evaluate(e, f2, di, false)) == null) {
            throw new RuntimeException();
        }
        String ans = ((Object)x).toString();
        return Debugger.leave(di, this, e, f2, (Object)ans);
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction operand2) {
        CharStreamToJavaStringInstruction i = new CharStreamToJavaStringInstruction(operand2);
        CharStreamToJavaStringInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public boolean isStatic(BindingEnvironment benv) {
        return this.getOperand().isStatic(benv);
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cgh, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        return CharStreamToJavaStringInstruction.generateJavaString(cgh, cgt, this.m_operand, varNameSuggestion, il);
    }

    public static FcgType generateJavaString(FcgCodeGenHelper cgh, CodeGenerationTracker cgt, Instruction operand2, String varNameSuggestion, FcgInstructionList il) {
        BindingEnvironment benv = cgt.m_bindingEnvironment;
        if (operand2.isStatic(benv)) {
            StreamInstruction si;
            Instruction y = NavigationUtilities.resolveReducedIdentifier(operand2, benv);
            if (y instanceof StreamInstruction && (si = (StreamInstruction)y).isStoredAsString()) {
                il.loadLiteral(si.getStringContent());
                return FcgType.STRING;
            }
            FcgInstructionList il2 = cgh.startConstantGeneration();
            FcgType paramType = cgt.generateConventionally(operand2, cgh, false, il2, ValueGenStyle.STRING);
            il.convertExpr(paramType, FcgType.STRING);
            cgh.finishConstantGeneration(null, FcgType.STRING, il2);
            return FcgType.STRING;
        }
        FcgType paramType = cgt.generateConventionally(operand2, cgh, false, il, ValueGenStyle.STRING);
        il.convertExpr(paramType, FcgType.STRING);
        return FcgType.STRING;
    }
}

