/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgVariable;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.IMatchDestructable;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.PolymorphicADTDesugarer;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.IStreamInADTOptimizationInstruction;
import com.ibm.xltxe.rnm1.xylem.codegen.StreamInADTOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.MatchInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.NaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.AbstractDataObject;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.types.AbstractDataType;
import com.ibm.xltxe.rnm1.xylem.types.AbstractDataTypeLambda;
import com.ibm.xltxe.rnm1.xylem.types.ConstructorDataType;
import com.ibm.xltxe.rnm1.xylem.types.NamedType;
import com.ibm.xltxe.rnm1.xylem.types.StreamType;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;

public class ConstructorInstantiationInstruction
extends NaryPrimopInstruction
implements IStreamInADTOptimizationInstruction,
IMatchDestructable {
    protected String m_constructorName;
    protected AbstractDataType.Constructor m_constructor;
    protected NamedType m_namedType;

    @Override
    public int byteCodeSize() {
        return 2 + 2 * this.m_parameters.length;
    }

    public ConstructorInstantiationInstruction() {
    }

    public ConstructorInstantiationInstruction(String constructor, Instruction[] parameters) {
        super(parameters);
        this.m_constructorName = constructor;
    }

    public ConstructorInstantiationInstruction(AbstractDataType.Constructor constructor, Instruction[] parameters) {
        super(parameters);
        this.m_constructorName = constructor.getName();
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        return this.m_namedType;
    }

    public AbstractDataType.Constructor getConstructor() {
        return this.m_constructor;
    }

    public String getConstructorName() {
        return this.m_constructorName;
    }

    public void setConstructor(AbstractDataType.Constructor c) {
        this.m_constructor = c;
        this.m_constructorName = c.getName();
        this.setCachedType(this.m_constructor.getAbstractDataType().getNamedType());
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        super.doDefaultTypeCheck(tenv, benv, functionStack);
        this.m_constructor = tenv.getModule().getConstructor(this.m_constructorName);
        if (this.m_constructor == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Unknown constructor: " + this.m_constructorName), this);
        }
        if (this.m_parameters.length != this.m_constructor.m_parameters.length) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Invalid number of parameters to constructor " + this.m_constructorName + "\n  expected " + this.m_constructor.m_parameters.length + ", found " + this.m_parameters.length), this);
        }
        AbstractDataType adt = this.m_constructor.getAbstractDataType();
        if (adt instanceof AbstractDataTypeLambda) {
            AbstractDataTypeLambda adtl = (AbstractDataTypeLambda)adt;
            HashMap typeMap = new HashMap();
            NamedType nt = (NamedType)adt.getNamedType().duplicateType(typeMap);
            TypeVariable[] tvars = adtl.getTypeParameters();
            Type[] constructorTypes = this.m_constructor.getParameterTypes();
            for (int i = 0; i < constructorTypes.length; ++i) {
                Type t = constructorTypes[i];
                if (t instanceof TypeVariable) {
                    for (int j = 0; j < tvars.length; ++j) {
                        if (tvars[j] != t) continue;
                        tenv.unify(nt.getChildType(j), this.m_parameters[i].typeCheck(tenv, benv, functionStack), this);
                    }
                    continue;
                }
                tenv.unify(this.m_parameters[i].typeCheck(tenv, benv, functionStack), this.m_constructor.m_parameters[i].getBindingType().duplicateType(typeMap), this);
            }
            this.m_namedType = nt;
            return this.setCachedType(this.m_namedType);
        }
        for (int i = 0; i < this.m_parameters.length; ++i) {
            tenv.unify(this.m_parameters[i].typeCheck(tenv, benv, functionStack), this.m_constructor.m_parameters[i].getBindingType(), this);
        }
        this.m_namedType = adt.getNamedType();
        return this.setCachedType(this.m_namedType);
    }

    @Override
    public void typeCheckReduced(TypeEnvironment tenv, BindingEnvironment benv, LinkedList<Function> functionStack) {
        super.typeCheckReduced(tenv, benv, functionStack);
        this.m_constructor = tenv.getModule().getConstructor(this.m_constructorName);
        AbstractDataType adt = this.m_constructor.getAbstractDataType();
        if (adt instanceof AbstractDataTypeLambda) {
            AbstractDataTypeLambda adtl = (AbstractDataTypeLambda)adt;
            if (this.m_namedType == null) {
                this.m_namedType = adt.instantiateNamedType();
            }
            TypeVariable[] tvars = adtl.getTypeParameters();
            Type[] constructorTypes = this.m_constructor.getParameterTypes();
            for (int i = 0; i < constructorTypes.length; ++i) {
                Type t = constructorTypes[i];
                if (!(t instanceof TypeVariable)) continue;
                for (int j = 0; j < tvars.length; ++j) {
                    if (tvars[j] != t) continue;
                    try {
                        tenv.unify(this.m_namedType.getChildType(j), this.m_parameters[i].getType(tenv, benv), this);
                        continue;
                    }
                    catch (TypeCheckException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        } else {
            this.m_namedType = adt.getNamedType();
        }
        super.typeCheckReduced(tenv, benv, functionStack);
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        Instruction[] parameters = new Instruction[this.m_parameters.length];
        for (int i = 0; i < this.m_parameters.length; ++i) {
            parameters[i] = this.m_parameters[i].cloneWithoutTypeInformation();
        }
        ConstructorInstantiationInstruction cii = new ConstructorInstantiationInstruction(this.m_constructorName, parameters);
        cii.m_namedType = this.m_namedType;
        cii.m_constructor = this.m_constructor;
        ConstructorInstantiationInstruction.propagateInfo(this, cii);
        return cii;
    }

    @Override
    public Instruction cloneShallow() {
        Instruction[] parameters = (Instruction[])this.m_parameters.clone();
        ConstructorInstantiationInstruction cii = new ConstructorInstantiationInstruction(this.m_constructorName, parameters);
        cii.m_namedType = this.m_namedType;
        cii.m_constructor = this.m_constructor;
        ConstructorInstantiationInstruction.propagateInfo(this, cii);
        return cii;
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cg, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        il.comment("ConstructorInstantiation handed off to the ctor's generateConConCode");
        return this.m_constructor.getAbstractDataType().generateConstructorConstructionCode(cg, cgt, this.m_constructor, this.m_parameters, this.m_constructor.getAbstractDataType().getNamedType(), il);
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cgh, FcgInstructionList il, String streamName, Binding memberInADT, CodeGenerationTracker cgt, boolean objectless, boolean tailPosition) {
        FcgType retType;
        if (!(this.m_constructor.getAbstractDataType() instanceof ConstructorDataType)) {
            throw new UnsupportedOperationException("stream-in-adt optimization only supported for ConstructorDataTypes");
        }
        if (objectless) {
            il.comment("ConstructorInstantiation, objectless stream-in-adt mode");
            retType = cgt.resolveType(this).getFCGType(cgh);
            for (int i = 0; i < this.m_constructor.m_parameters.length; ++i) {
                Binding param = this.m_constructor.m_parameters[i];
                if (param == memberInADT && streamName != null) {
                    cgt.generateAddToStream(this.m_parameters[i], streamName, (StreamType)this.m_constructor.m_parameters[i].getBindingType(), cgh, il, false, ValueGenStyle.DEFAULT);
                    continue;
                }
                cgt.generateConventionally(this.m_parameters[i], cgh, false, il, ValueGenStyle.DEFAULT);
                Type t1 = this.m_parameters[i].evaluateType(cgt.m_function);
                t1.generateObjectFork(cgh, il, cgt, ValueGenStyle.DEFAULT_WITH_PUSH);
            }
        } else {
            il.comment("ConstructorInstantiation, object stream-in-adt mode");
            String className = this.m_constructor.getAbstractDataType().getImplementationName(cgh);
            FcgClassReferenceType classType = cgh.getClassReferenceType(className);
            String objName = cgh.generateNewLocalVariableName();
            il.loadLiteral(this.m_constructor.getIndex());
            il.createObjectExpr((FcgType)classType, 1);
            FcgVariable tmpObj = il.defineVar(classType, objName, true);
            for (int i = 0; i < this.m_constructor.m_parameters.length; ++i) {
                FcgType paramType;
                if (this.m_constructor.m_parameters[i] == memberInADT && streamName != null) {
                    il.loadVar(tmpObj);
                    cgt.generateAddToStream(this.m_parameters[i], streamName, (StreamType)this.m_constructor.m_parameters[i].getBindingType(), cgh, il, false, ValueGenStyle.DEFAULT);
                    paramType = il.loadVar(il.findVar(streamName + "_stream"));
                    il.storeInstanceFieldStmt(classType, this.m_constructor.getConstructorQualifiedFieldName(i, cgh), paramType);
                    continue;
                }
                il.loadVar(tmpObj);
                paramType = cgt.generateConventionally(this.m_parameters[i], cgh, false, il, ValueGenStyle.DEFAULT);
                Type t1 = this.m_parameters[i].evaluateType(cgt.m_function);
                t1.generateObjectFork(cgh, il, cgt, ValueGenStyle.DEFAULT_WITH_PUSH);
                il.storeInstanceFieldStmt(classType, this.m_constructor.getConstructorQualifiedFieldName(i, cgh), paramType);
            }
            retType = il.loadVar(tmpObj);
        }
        return retType;
    }

    @Override
    public boolean isStatic(BindingEnvironment benv) {
        for (int i = 0; i < this.m_parameters.length; ++i) {
            if (this.m_parameters[i].isStatic(benv)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean supportsCodeGenerationOptimizationInternal(CodeGenerationOptimizationStyle cgos, TypeEnvironment tenv, BindingEnvironment benv) {
        if (cgos instanceof StreamInADTOptimizationStyle) {
            return this.m_constructor.getAbstractDataType() instanceof ConstructorDataType;
        }
        return super.supportsCodeGenerationOptimizationInternal(cgos, tenv, benv);
    }

    @Override
    public boolean canGenerateObjectless(TypeEnvironment tenv) {
        return true;
    }

    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        if (null != di) {
            di.enter(this, e, f2);
        }
        Object[] values2 = new Object[this.m_parameters.length];
        for (int i = 0; i < this.m_parameters.length; ++i) {
            Object val;
            values2[i] = val = this.m_parameters[i].evaluateToOwnForkReleaseable(e, f2, di);
        }
        AbstractDataObject ans = new AbstractDataObject(this.m_constructor, values2, false);
        e.pushIForkReleaseManagedForRelease(ans);
        return Debugger.leave(di, this, e, f2, (Object)ans);
    }

    @Override
    public void toString(PrettyPrinter pw, int indent) {
        pw.newline();
        pw.printFormOpen("construct", indent);
        pw.printToken(this.m_constructorName, indent + 1);
        for (int i = 0; i < this.m_parameters.length; ++i) {
            this.m_parameters[i].toString(pw, indent + 1);
        }
        pw.print(")");
    }

    @Override
    public boolean equals(Object arg0) {
        if (!super.equals(arg0)) {
            return false;
        }
        ConstructorInstantiationInstruction cii = (ConstructorInstantiationInstruction)arg0;
        if (this.m_constructor == null || cii.m_constructor == null) {
            return this.m_constructorName.equals(cii.m_constructorName);
        }
        return cii.m_constructor == this.m_constructor;
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        super.read(rofh, benv);
        this.m_constructorName = rofh.readString();
        this.m_namedType = (NamedType)rofh.readType();
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        super.write(wofh);
        wofh.writeString(this.m_constructorName);
        wofh.writeType(this.m_namedType);
    }

    public void desugarADTLambdas(TypeEnvironment tenv, BindingEnvironment benv, PolymorphicADTDesugarer td) {
        AbstractDataType adt = this.m_constructor.getAbstractDataType();
        if (adt instanceof AbstractDataTypeLambda) {
            NamedType nt = (NamedType)td.convertType(this.getType(tenv, benv));
            AbstractDataType adt2 = nt.resolveNameToADT(tenv);
            this.m_constructor = adt2.m_constructors[this.m_constructor.getIndex()];
            this.m_constructorName = this.m_constructor.getName();
            this.m_namedType = adt2.getNamedType();
        }
    }

    @Override
    public void generateReducedForm(ReductionHelper rh, Instruction[] state, BindingEnvironment benv) {
        this.m_namedType = (NamedType)this.getCachedType().resolveTypeAsMuchAsPossible(rh.m_typeEnvironment, new HashSet());
        super.generateReducedForm(rh, state, benv);
    }

    @Override
    public int getTypeParameterCount() {
        return 1;
    }

    @Override
    public Type getTypeParameter(int i) {
        if (i == 0) {
            return this.m_namedType;
        }
        return null;
    }

    @Override
    public void setTypeParameter(int i, Type n2) {
        if (i == 0) {
            this.m_namedType = (NamedType)n2;
        }
    }

    @Override
    public Type typeCheckDestruction(TypeEnvironment tenv, BindingEnvironment benv) throws TypeCheckException {
        this.m_constructor = tenv.getModule().getConstructor(this.m_constructorName);
        if (this.m_constructor == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Unknown constructor: " + this.m_constructorName), this);
        }
        for (int i = 0; i < this.m_parameters.length; ++i) {
            Instruction n2 = this.m_parameters[i];
            if (!(n2 instanceof IMatchDestructable)) {
                throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", n2 + " not supported in match2 pattern"), this);
            }
            tenv.unify(((IMatchDestructable)((Object)n2)).typeCheckDestruction(tenv, benv), this.m_constructor.m_parameters[i].getBindingType(), this);
        }
        return this.m_constructor.getAbstractDataType().getNamedType();
    }

    @Override
    public Instruction desugarDestruction(Instruction toMatch, final ReductionHelper rh, IMatchDestructable.Generator trueCode, final IMatchDestructable.Generator falseCode, final BindingEnvironment benv) {
        Object[] bindings = new Object[this.m_constructor.m_parameters.length];
        for (int i = 0; i < bindings.length; ++i) {
            bindings[i] = rh.generateReducedIdentifier("");
        }
        MatchInstruction.DeconstructionMatch dm = new MatchInstruction.DeconstructionMatch(this.m_constructor, bindings, null);
        final Binding[] realBindings = dm.getBindings();
        for (int i = realBindings.length - 1; i >= 0; --i) {
            final IMatchDestructable md = (IMatchDestructable)((Object)this.m_parameters[i]);
            final int i0 = i;
            final IMatchDestructable.Generator oldTrueCode = trueCode;
            benv.setVariableBinding(realBindings[i]);
            trueCode = new IMatchDestructable.Generator(){

                @Override
                public Instruction generate() {
                    return md.desugarDestruction(new IdentifierInstruction(realBindings[i0].getName()), rh, oldTrueCode, falseCode, benv).assignNewNames(new HashMap());
                }
            };
        }
        dm.m_handler = trueCode.generate();
        return new MatchInstruction(toMatch, new MatchInstruction.Match[]{dm}, falseCode.generate());
    }
}

