/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.IStreamInADTOptimizationInstruction;
import com.ibm.xltxe.rnm1.xylem.codegen.IStreamOptimizationInstruction;
import com.ibm.xltxe.rnm1.xylem.codegen.StreamOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.BinaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.types.CharType;
import com.ibm.xltxe.rnm1.xylem.types.IConstructableAsStreamType;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.util.HashMap;
import java.util.LinkedList;

public class DebugInstruction
extends BinaryPrimopInstruction
implements IStreamInADTOptimizationInstruction,
IStreamOptimizationInstruction {
    private String m_category;
    private boolean m_printValue;
    private static HashMap s_settings = new HashMap();

    public static void enable(String category) {
        s_settings.put("DEBUG." + category, "true");
    }

    public static Instruction makeDebugInstruction(Instruction message, Instruction value2, String category, boolean printValue) {
        if (s_settings.get("DEBUG." + category) != null) {
            return new DebugInstruction(message, value2, category, printValue);
        }
        return value2;
    }

    private DebugInstruction(Instruction message, Instruction value2, String category, boolean printValue) {
        super(message, value2);
        this.m_category = category;
        this.m_printValue = printValue;
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction op1, Instruction op2) {
        return new DebugInstruction(this.getOperand1(), this.getOperand2(), this.m_category, this.m_printValue);
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        super.doDefaultTypeCheck(tenv, benv, functionStack);
        tenv.unify(CharType.s_charType.getStreamType(), this.getOperand1().typeCheck(tenv, benv, functionStack), this);
        return this.setCachedType(this.getOperand2().typeCheck(tenv, benv, functionStack));
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        return this.getOperand2().getType(tenv, benv);
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        DebugInstruction i = new DebugInstruction(this.getOperand1(), this.getOperand2(), this.m_category, this.m_printValue);
        DebugInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    protected boolean supportsCodeGenerationOptimizationInternal(CodeGenerationOptimizationStyle cgos, TypeEnvironment tenv, BindingEnvironment benv) {
        if (cgos instanceof StreamOptimizationStyle) {
            return this.getOperand2().supportsCodeGenerationOptimization(cgos, tenv, benv);
        }
        return super.supportsCodeGenerationOptimizationInternal(cgos, tenv, benv);
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cgh, FcgInstructionList il, String streamName, Binding memberInADT, CodeGenerationTracker cgt, boolean objectless, boolean tailPosition) {
        throw new XylemError("ERR_SYSTEM", "DebugInstruction:generateCode not yet implemented");
    }

    @Override
    public boolean canGenerateObjectless(TypeEnvironment tenv) {
        return ((IStreamInADTOptimizationInstruction)((Object)this.getOperand2())).canGenerateObjectless(tenv);
    }

    @Override
    public void generateCodeWithStreamOptimization(FcgCodeGenHelper cgh, FcgInstructionList il, String streamName, IConstructableAsStreamType type2, CodeGenerationTracker cgt, boolean tailPosition, ValueGenStyle valueStyleRequest) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String innerToString() {
        if (this.m_printValue) {
            return "debug-value";
        }
        return "debug";
    }

    @Override
    public void toString(PrettyPrinter pw, int indent) {
        pw.printFormOpen(this.innerToString(), indent);
        pw.printIdentifier(this.m_category, indent + 1);
        this.m_operand1.toString(pw, indent + 1);
        this.m_operand2.toString(pw, indent + 1);
        pw.printFormClose(indent);
    }
}

