/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.UnaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.interpreter.StringStream;
import com.ibm.xltxe.rnm1.xylem.parser.ClassLoaderSourceResolver;
import com.ibm.xltxe.rnm1.xylem.parser.Parser;
import com.ibm.xltxe.rnm1.xylem.parser.ParserSource;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.types.CharType;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import com.ibm.xml.ras.LoggerUtil;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EvalInstruction
extends UnaryPrimopInstruction {
    private static final Logger s_logger = LoggerUtil.getLogger(EvalInstruction.class);
    private static final String s_className = EvalInstruction.class.getName();
    private Instruction m_script;
    private Type m_type;

    public EvalInstruction(Type t, Instruction script) {
        this.m_script = script;
        this.m_type = t;
        if (t == null) {
            this.m_type = new TypeVariable();
        }
    }

    public EvalInstruction(Type t, String script) {
        this(t, StreamInstruction.charStreamLiteral(script));
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction operand2) {
        EvalInstruction i = new EvalInstruction(this.m_type, operand2);
        EvalInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        Type scriptType = this.m_script.typeCheck(tenv, benv, functionStack);
        tenv.unify(scriptType, CharType.s_charType.getStreamType(), this);
        return this.m_type;
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        return this.m_type;
    }

    @Override
    public Type getPreTypecheckType(ModuleSignature msig) {
        return this.m_type;
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cg, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        throw new UnsupportedOperationException("FCG codegen Eval");
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        EvalInstruction i = new EvalInstruction(this.m_type, this.m_script.cloneWithoutTypeInformation());
        EvalInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Type getTypeParameter(int i) {
        return i == 0 ? this.m_type : null;
    }

    @Override
    public int getTypeParameterCount() {
        return 1;
    }

    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        Instruction n2;
        ClassLoaderSourceResolver resolver2 = new ClassLoaderSourceResolver();
        StringStream script = (StringStream)this.m_script.evaluate(e, f2, di, false);
        Parser parser = new Parser(resolver2, new ParserSource(new StringReader(script.toString())));
        try {
            n2 = parser.parseExpression(f2.getTypeEnvironment().getModule());
        }
        catch (Exception t) {
            String message = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{"error parsing script : " + this.m_script});
            s_logger.logp(Level.SEVERE, s_className, "evaluate", message, t);
            throw new Error();
        }
        return n2.evaluate(e, f2, di, false);
    }

    @Override
    public String innerToString() {
        return "eval";
    }
}

