/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgBinOp;
import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.UnaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.interpreter.StringStream;
import com.ibm.xltxe.rnm1.xylem.types.ByteType;
import com.ibm.xltxe.rnm1.xylem.types.CharType;
import com.ibm.xltxe.rnm1.xylem.types.INumericalType;
import com.ibm.xltxe.rnm1.xylem.types.IPrimitiveType;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.util.LinkedList;

public class HexEscapeInstruction
extends UnaryPrimopInstruction {
    public HexEscapeInstruction() {
    }

    public HexEscapeInstruction(Instruction parameter) {
        super(parameter);
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        HexEscapeInstruction i = new HexEscapeInstruction(this.m_operand.cloneWithoutTypeInformation());
        HexEscapeInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        super.doDefaultTypeCheck(tenv, benv, functionStack);
        Type t = this.m_operand.typeCheck(tenv, benv, functionStack);
        if (t.equals(IntType.s_intType, tenv)) {
            tenv.unify(t, IntType.s_intType, this);
        } else if (t.equals(ByteType.s_byteType, tenv)) {
            tenv.unify(t, ByteType.s_byteType, this);
        } else {
            tenv.unify(t, CharType.s_charType, this);
        }
        return this.setCachedType(CharType.s_charType.getStreamType());
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        this.m_operand.getType(tenv, benv);
        return CharType.s_charType.getStreamType();
    }

    @Override
    public Type getPreTypecheckType(ModuleSignature msig) {
        return CharType.s_charType.getStreamType();
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cg, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        cgt.generateConventionally(this.m_operand, cg, false, il, ValueGenStyle.DEFAULT);
        Type t = cgt.resolveType(this.m_operand);
        if (t instanceof INumericalType) {
            if (t instanceof ByteType) {
                il.loadLiteral(255);
                il.binaryOperationExpr(FcgBinOp.BITWISE_AND);
            } else if (!(t instanceof IPrimitiveType)) {
                throw new XylemError("ERR_SYSTEM", "Hex-Escape not supported for type " + t);
            }
        } else {
            throw new XylemError("ERR_SYSTEM", "Hex-Escape not supported for type " + t);
        }
        il.loadLiteral(16);
        FcgClassReferenceType classRefType = cg.getClassReferenceType("java.lang.Integer");
        il.invokeClassMethod(classRefType, "toString", (FcgType)FcgType.STRING, 2);
        classRefType = cg.getClassReferenceType("java.lang.String");
        il.invokeInstanceMethod(classRefType, "toUpperCase", (FcgType)FcgType.STRING, 0);
        classRefType = cg.getClassReferenceType("java.lang.String");
        il.invokeInstanceMethod(classRefType, "toCharArray", (FcgType)FcgType.CHAR_ARRAY, 0);
        return FcgType.CHAR_ARRAY;
    }

    @Override
    public String innerToString() {
        return "hex-escape";
    }

    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        Object x;
        if (null != di) {
            di.enter(this, e, f2);
        }
        if ((x = this.m_operand.evaluate(e, f2, di, false)) instanceof Byte) {
            byte b = (Byte)x;
            StringStream ans = new StringStream(Integer.toString(b & 0xFF, 16).toUpperCase());
            return Debugger.leave(di, this, e, f2, (Object)ans);
        }
        if (x instanceof Number) {
            StringStream ans = new StringStream(Integer.toString(((Number)x).intValue(), 16).toUpperCase());
            return Debugger.leave(di, this, e, f2, (Object)ans);
        }
        if (x instanceof Character) {
            StringStream ans = new StringStream(Integer.toString(((Character)x).charValue(), 16).toUpperCase());
            return Debugger.leave(di, this, e, f2, (Object)ans);
        }
        throw new UnsupportedOperationException("Hex-Escape is not supported on type " + x.getClass() + " with value:" + x);
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction operand2) {
        HexEscapeInstruction i = new HexEscapeInstruction(operand2);
        HexEscapeInstruction.propagateInfo(this, i);
        return i;
    }
}

