/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingDependencyInfo;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.IMatchDestructable;
import com.ibm.xltxe.rnm1.xylem.INewNameGenerator;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.ConventionalGenerationState;
import com.ibm.xltxe.rnm1.xylem.codegen.GenerationState;
import com.ibm.xltxe.rnm1.xylem.codegen.IStreamInADTOptimizationInstruction;
import com.ibm.xltxe.rnm1.xylem.codegen.IStreamOptimizationInstruction;
import com.ibm.xltxe.rnm1.xylem.codegen.StreamInADTOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.StreamInADTOptimizedGenerationState;
import com.ibm.xltxe.rnm1.xylem.codegen.StreamOptimizationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.ChooseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.DeepEqualityInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetBaseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.types.IConstructableAsStreamType;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xml.ras.LoggerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class IdentifierInstruction
extends Instruction
implements IStreamInADTOptimizationInstruction,
IStreamOptimizationInstruction,
IMatchDestructable {
    private Object m_variable;
    private IBinding m_binding;
    private static final Logger s_logger = LoggerUtil.getLogger(IdentifierInstruction.class);
    private static final String s_className = IdentifierInstruction.class.getName();
    private static final boolean showIdentifierTypeAnnotations = false;

    public IdentifierInstruction() {
    }

    public IdentifierInstruction(Object variable2) {
        if (variable2 == null || variable2 instanceof Instruction || variable2 instanceof Binding) {
            throw new IllegalArgumentException("" + variable2);
        }
        this.m_variable = variable2;
        if (null == this.m_variable) {
            throw new Error("II.<init>: null m_variable");
        }
    }

    public IdentifierInstruction(BindingEnvironment benv, IBinding binding) {
        this.m_variable = binding.getName();
        try {
            this.typeCheckKnownBinding(benv, binding);
        }
        catch (TypeCheckException e) {
            throw new XylemError("ERR_SYSTEM", "Type Check Exception: " + e);
        }
    }

    public Object getVariable() {
        return this.m_variable;
    }

    public IBinding getBinding() {
        return this.m_binding;
    }

    public void setBinding(IBinding b) {
        this.m_binding = b;
    }

    public IBinding getBinding(BindingEnvironment benv) {
        return benv.getVariableBinding(this.m_variable);
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        super.doDefaultTypeCheck(tenv, benv, functionStack);
        this.m_binding = benv.getVariableBinding(this.m_variable);
        if (this.m_binding == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Unbound variable: " + this.m_variable), this);
        }
        return this.setCachedType(this.m_binding.getBindingType());
    }

    private Type typeCheckKnownBinding(BindingEnvironment benv, IBinding binding) throws TypeCheckException {
        super.doDefaultTypeCheck(null, benv, new LinkedList());
        this.m_binding = binding;
        return this.setCachedType(this.m_binding.getBindingType());
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        if (benv == null) {
            throw new XylemError("ERR_SYSTEM", "no binding environment: " + this.m_variable + " " + this.m_variable.getClass());
        }
        IBinding b = benv.getVariableBinding(this.m_variable);
        if (b == null) {
            throw new XylemError("ERR_SYSTEM", "cannot find binding: " + this.m_variable + " " + this.m_variable.getClass());
        }
        Type t = b.getBindingType(tenv, benv);
        if (t == null) {
            throw new XylemError("ERR_SYSTEM", "ii:" + this);
        }
        return t;
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        IdentifierInstruction i = new IdentifierInstruction(this.m_variable);
        IdentifierInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public void clearTypeInformation() {
        super.clearTypeInformation();
        this.m_binding = null;
    }

    @Override
    public void accumulateNonLiteralFreeBindings(Set set2, BindingEnvironment benv) {
        IBinding binding;
        IBinding iBinding = binding = benv != null ? this.getBinding(benv) : this.getBinding();
        if (binding == null) {
            throw new XylemError("ERR_SYSTEM", "no binding for " + this);
        }
        if (binding.getLet() == null || !(binding.getLet().getValue() instanceof LiteralInstruction)) {
            set2.add(binding);
        }
    }

    @Override
    public void accumulateFreeBindings(Set set2, BindingEnvironment benv) {
        IBinding binding = benv != null ? this.getBinding(benv) : this.getBinding();
        set2.add(binding);
        if (binding == null) {
            // empty if block
        }
    }

    public void dump(PrettyPrinter pw, int indent) {
        pw.space();
        pw.print(this.m_variable);
    }

    @Override
    public boolean equals(Object arg0) {
        if (arg0 == null || !(arg0 instanceof IdentifierInstruction)) {
            return false;
        }
        IdentifierInstruction ii = (IdentifierInstruction)arg0;
        if (!this.m_variable.equals(ii.m_variable)) {
            return false;
        }
        return this.getBinding() == ii.getBinding();
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cgh, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        FcgType type2 = cgt.generateConventionally(this, cgh, tailPosition, il, valueStyleRequest);
        return type2;
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cgh, FcgInstructionList il, String streamName, Binding memberInADT, CodeGenerationTracker cgt, boolean objectless, boolean tailPosition) {
        GenerationState gs = cgt.getGenerationState(this.getBinding(cgt.m_bindingEnvironment));
        FcgType retType = null;
        if (gs instanceof StreamInADTOptimizedGenerationState || ((ConventionalGenerationState)gs).getNumDependencies() != 1 || !((ConventionalGenerationState)gs).getInstruction().supportsCodeGenerationOptimization(StreamInADTOptimizationStyle.s_streamInADTOptimizationStyle, cgt.m_typeEnvironment, cgt.m_bindingEnvironment)) {
            throw new UnsupportedOperationException();
        }
        Instruction inst = ((ConventionalGenerationState)gs).getInstruction();
        retType = ((IStreamInADTOptimizationInstruction)((Object)inst)).generateCode(cgh, il, streamName, memberInADT, cgt, objectless, tailPosition);
        return retType;
    }

    @Override
    public void generateCodeWithStreamOptimization(FcgCodeGenHelper cgh, FcgInstructionList il, String streamName, IConstructableAsStreamType type2, CodeGenerationTracker cgt, boolean tailPosition, ValueGenStyle valueStyleRequest) {
        Type idValueType = cgt.resolveType(this);
        if (idValueType instanceof IConstructableAsStreamType && ((IConstructableAsStreamType)((Object)idValueType)).getElementType().equals(idValueType)) {
            cgt.generateAddElementToStream(this, streamName, type2, cgh, il, tailPosition);
        } else {
            cgt.generateAddToStream(this, streamName, type2, cgh, il, tailPosition, valueStyleRequest);
        }
    }

    @Override
    public void determineDataDependencies(Binding[] specificBindings, HashMap collectedBindings, Instruction parent2, int index2, BindingEnvironment benv) {
        ArrayList<BindingDependencyInfo> list;
        if (benv == null && (benv = this.getBindingEnvironment()) == null) {
            throw new XylemError("ERR_SYSTEM", "???" + this);
        }
        IBinding binding = this.getBinding();
        if (binding == null) {
            binding = benv.getVariableBinding(this.m_variable);
        }
        if (specificBindings != null) {
            boolean found = false;
            for (int i = 0; i < specificBindings.length; ++i) {
                if (specificBindings[i] != binding) continue;
                found = true;
                break;
            }
            if (!found) {
                return;
            }
        }
        if ((list = (ArrayList<BindingDependencyInfo>)collectedBindings.get(binding)) == null) {
            list = new ArrayList<BindingDependencyInfo>();
            collectedBindings.put(binding, list);
        }
        list.add(new BindingDependencyInfo(this, parent2, index2));
    }

    @Override
    public void determineDataDependencies(Set bindingNames) {
        bindingNames.add(this.m_variable);
    }

    @Override
    public void generateReducedForm(ReductionHelper rh, Instruction[] state, BindingEnvironment benv) {
        IBinding binding = rh.lookupConvertedBinding(this.getBinding());
        this.m_binding = null;
        this.m_variable = binding.getName();
        if (this.m_variable == null) {
            throw new Error("generateReduced: null m_variable");
        }
        state[0] = this;
        this.m_bindingEnvironment = null;
    }

    @Override
    protected boolean supportsCodeGenerationOptimizationInternal(CodeGenerationOptimizationStyle cgos, TypeEnvironment tenv, BindingEnvironment benv) {
        if (cgos instanceof StreamOptimizationStyle) {
            IBinding b = this.getBinding(benv);
            if (null == b) {
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
                    s_logger.logp(Level.FINEST, s_className, "supportsCodeGenerationOptimizationInternal", "II(): this=" + this + "\n  Null binding for " + this.m_variable + "\n  in " + benv);
                }
                throw new Error("null binding (" + this.m_variable + ") exception...");
            }
            if (b.getLet() == null) {
                return true;
            }
            return b.getLet().getValue().supportsCodeGenerationOptimization(cgos, tenv, benv);
        }
        if (cgos instanceof StreamInADTOptimizationStyle) {
            IBinding b = this.getBinding(benv);
            if (null == b) {
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
                    s_logger.logp(Level.FINEST, s_className, "supportsCodeGenerationOptimizationInternal", "II(): this=" + this + "\n  Null binding for " + this.m_variable + "\n  in " + benv);
                }
                throw new Error("null binding (" + this.m_variable + ") exception...");
            }
            if (b.getLet() == null) {
                return true;
            }
            return b.getLet().getValue().supportsCodeGenerationOptimization(cgos, tenv, benv);
        }
        return super.supportsCodeGenerationOptimizationInternal(cgos, tenv, benv);
    }

    @Override
    public boolean canGenerateObjectless(TypeEnvironment tenv) {
        return false;
    }

    @Override
    public void toString(PrettyPrinter pw, int indent) {
        Object var = this.m_variable;
        if (null != this.m_binding) {
            var = pw.getAnnotations(this.m_binding, PrettyPrinter.prettyPrintIdentifier(var));
        }
        pw.printIdentifier(var, indent);
    }

    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        if (null != di && di.getVerbosityLevel() == 0) {
            di.quietEnter(this, e, f2);
        }
        IBinding b = this.m_binding == null ? this.getBinding(f2.getBindingEnvironment()) : this.m_binding;
        Object ans = e.lookupBoundValue(b);
        if (null != di && di.getVerbosityLevel() == 0) {
            return Debugger.quietLeave(di, this, e, f2, ans);
        }
        return ans;
    }

    @Override
    public boolean isStatic(BindingEnvironment benv) {
        IBinding binding;
        IBinding iBinding = binding = benv == null ? this.getBinding() : this.getBinding(benv);
        if (binding != null) {
            return binding.getLet() != null && binding.getLet().getValue().isStatic(benv);
        }
        return false;
    }

    @Override
    public Instruction replaceBindings(Map bindings) {
        Object n2 = bindings.get(this.m_variable);
        if (n2 != null) {
            return new IdentifierInstruction(n2);
        }
        return this;
    }

    @Override
    public Instruction assignNewNames(Map names, INewNameGenerator ing) {
        Instruction n2 = (Instruction)names.get(this.m_variable);
        if (n2 != null) {
            return n2.cloneWithoutTypeInformation();
        }
        return this.cloneWithoutTypeInformation();
    }

    @Override
    public Instruction cloneShallow() {
        return this.cloneWithoutTypeInformation();
    }

    @Override
    public Instruction removeAliases(HashMap aliases) {
        Object x = aliases.get(this.m_variable);
        if (x != null) {
            return new IdentifierInstruction(x);
        }
        return this;
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        this.m_variable = rofh.readBindingName();
        if (null == this.m_variable) {
            throw new Error("read: null m_variable");
        }
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        wofh.writeBindingName(this.m_variable);
    }

    @Override
    public Type typeCheckDestruction(TypeEnvironment tenv, BindingEnvironment benv) throws TypeCheckException {
        Object var = this.getVariable();
        IBinding binding = benv.getVariableBinding(var);
        if (binding == null) {
            TypeVariable tv = new TypeVariable();
            this.m_binding = new Binding(var, tv);
            benv.setVariableBinding(this.m_binding);
            return tv;
        }
        this.m_bindingEnvironment = benv;
        this.m_binding = binding;
        return binding.getBindingType();
    }

    @Override
    public Instruction desugarDestruction(Instruction toMatch, ReductionHelper rh, IMatchDestructable.Generator trueCode, IMatchDestructable.Generator falseCode, BindingEnvironment benv) {
        if (this.m_bindingEnvironment != null) {
            IBinding binding = rh.lookupConvertedBinding(this.getBinding());
            Object x = rh.generateReducedIdentifier("");
            LetInstruction leti = new LetInstruction(x, new DeepEqualityInstruction(toMatch, new IdentifierInstruction(binding.getName())), new ChooseInstruction(new IdentifierInstruction(x), trueCode.generate(), falseCode.generate()));
            return leti;
        }
        Object x = rh.generateReducedIdentifier(this.getVariable());
        LetInstruction leti = new LetInstruction(x, toMatch, null);
        rh.registerConvertedBinding(this.m_binding, leti);
        benv.setVariableBinding(leti);
        leti.setBody(trueCode.generate());
        return leti;
    }

    @Override
    public void typeCheckReduced(TypeEnvironment tenv, BindingEnvironment benv, LinkedList<Function> functionStack) {
        this.clearLocalForTypecheckReduced();
    }

    @Override
    public Type getPreTypecheckType(ModuleSignature msig) {
        Instruction resolvedMaybe;
        if (this.m_bindingEnvironment != null && (resolvedMaybe = this.tryToResolveIdentifier(this.m_bindingEnvironment)) != null) {
            return resolvedMaybe.getPreTypecheckType(msig);
        }
        return this.getCachedType();
    }

    public Instruction tryToResolveIdentifier(BindingEnvironment bindingEnvironment) {
        LetInstruction let;
        Instruction instr = null;
        IdentifierInstruction ident = this;
        IBinding binding = bindingEnvironment.getVariableBinding(ident.getVariable());
        HashSet<Object> visited = new HashSet<Object>();
        visited.add(ident.getVariable());
        while ((let = binding.getLet()) != null) {
            IdentifierInstruction ident2;
            instr = let.getValue();
            if (instr instanceof LetBaseInstruction) {
                binding = (LetBaseInstruction)instr;
                continue;
            }
            if (!(instr instanceof IdentifierInstruction) || visited.contains((ident2 = (IdentifierInstruction)instr).getVariable())) break;
            visited.add(ident2.getVariable());
            binding = bindingEnvironment.getVariableBinding(ident2.getVariable());
        }
        return instr;
    }

    public Instruction tryToResolveIdentifier(CodeGenerationTracker cgt) {
        LetInstruction let;
        Instruction instr = null;
        IdentifierInstruction ident = this;
        IBinding binding = cgt.m_bindingEnvironment.getVariableBinding(ident.getVariable());
        HashSet<Object> visited = new HashSet<Object>();
        visited.add(ident.getVariable());
        while ((let = binding.getLet()) != null) {
            IdentifierInstruction ident2;
            instr = let.getValue();
            if (instr instanceof LetBaseInstruction) {
                binding = (LetBaseInstruction)instr;
                continue;
            }
            if (!(instr instanceof IdentifierInstruction) || visited.contains((ident2 = (IdentifierInstruction)instr).getVariable())) break;
            visited.add(ident2.getVariable());
            binding = cgt.m_bindingEnvironment.getVariableBinding(ident2.getVariable());
        }
        return instr;
    }
}

