/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.IImperativeInstruction;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.NaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xltxe.rnm1.xylem.types.JavaArrayType;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class JavaArrayLookupInstruction
extends NaryPrimopInstruction
implements IImperativeInstruction {
    protected Instruction m_array;

    public JavaArrayLookupInstruction() {
    }

    public JavaArrayLookupInstruction(Instruction lambda2, Instruction[] parameters) {
        super(parameters);
        this.m_array = lambda2;
    }

    public JavaArrayLookupInstruction(Instruction lambda2, List parameters) {
        super(parameters);
        this.m_array = lambda2;
    }

    public Instruction[] getParameters() {
        return this.m_parameters;
    }

    public int getParameterCount() {
        return this.m_parameters.length;
    }

    public Instruction getLambda() {
        return this.m_array;
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        return ((JavaArrayType)this.m_array.getType(tenv, benv).resolveType(tenv)).getElementType();
    }

    @Override
    public void generateReducedForm(ReductionHelper rh, Instruction[] state, BindingEnvironment benv) {
        this.m_array = rh.reduceToBasicInstruction(state, this.m_array, benv);
        super.generateReducedForm(rh, state, benv);
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        super.doDefaultTypeCheck(tenv, benv, functionStack);
        for (int i = 0; i < this.m_parameters.length; ++i) {
            tenv.unify(this.m_parameters[i].typeCheck(tenv, benv, functionStack), IntType.s_intType, this);
        }
        Type t = this.setCachedType(new TypeVariable());
        JavaArrayType lt2 = new JavaArrayType(t, this.m_parameters.length);
        tenv.unify(this.m_array.typeCheck(tenv, benv, functionStack), lt2, this);
        return t;
    }

    @Override
    public Instruction getChildInstruction(int i) {
        switch (i) {
            case 0: {
                return this.m_array;
            }
        }
        return this.m_parameters[i - 1];
    }

    @Override
    public int getChildInstructionCount() {
        return this.m_parameters.length + 1;
    }

    @Override
    public void setChildInstruction(int i, Instruction n2) {
        switch (i) {
            case 0: {
                this.m_array = n2;
                break;
            }
            default: {
                this.m_parameters[i - 1] = n2;
            }
        }
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        Instruction[] parameters = new Instruction[this.m_parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = this.m_parameters[i].cloneWithoutTypeInformation();
        }
        JavaArrayLookupInstruction i = new JavaArrayLookupInstruction(this.m_array.cloneWithoutTypeInformation(), parameters);
        JavaArrayLookupInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Instruction cloneShallow() {
        Instruction[] parameters = (Instruction[])this.m_parameters.clone();
        JavaArrayLookupInstruction i = new JavaArrayLookupInstruction(this.m_array, parameters);
        JavaArrayLookupInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public String innerToString() {
        return "lookup-java-array";
    }

    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        if (null != di) {
            di.enter(this, e, f2);
        }
        Object ans = null;
        return Debugger.leave(di, this, e, f2, ans);
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        super.read(rofh, benv);
        this.m_array = rofh.readInstruction(benv);
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        super.write(wofh);
        wofh.writeInstruction(this.m_array);
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cg, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        cgt.generateConventionally(this.m_array, cg, false, il, ValueGenStyle.DEFAULT_WITH_PUSH);
        for (int i = 0; i < this.m_parameters.length - 1; ++i) {
            FcgType parmType = cgt.generateConventionally(this.m_parameters[i], cg, false, il, ValueGenStyle.DEFAULT_WITH_PUSH);
            if (parmType != FcgType.INT) {
                throw new XylemError("ERR_SYSTEM", "JavaArrayLookupInstruction: unexpected array index type: " + parmType);
            }
            il.loadArrayElement(null);
        }
        JavaArrayType jat = (JavaArrayType)cgt.resolveType(this.m_array);
        Type t = jat.getElementType();
        FcgType arrElemType = t.getFCGType(cg);
        return arrElemType;
    }
}

