/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgInterfaceType;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.fcg.FcgTypeUtils;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.IImperativeInstruction;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.JavaClassImporter;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationSettings;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.NaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ObjectFactory;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.interpreter.IConvertible;
import com.ibm.xltxe.rnm1.xylem.interpreter.InterpreterUtilities;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.types.JavaClassInformation;
import com.ibm.xltxe.rnm1.xylem.types.JavaObjectType;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import com.ibm.xltxe.rnm1.xylem.types.UnitType;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.exec.BasicDynamicContext;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JavaMethodInvocationInstruction
extends NaryPrimopInstruction
implements IImperativeInstruction {
    private static final Logger s_logger = LoggerUtil.getLogger(JavaMethodInvocationInstruction.class);
    private static final String s_className = JavaMethodInvocationInstruction.class.getName();
    protected String m_function;
    public Instruction m_object;
    protected String m_classname;
    protected Type m_type;
    protected boolean m_isUserClass;

    public JavaMethodInvocationInstruction() {
    }

    public JavaMethodInvocationInstruction(String function2, Instruction object2, Instruction[] parameters, Type t) {
        this(function2, object2, parameters, t, false);
    }

    public JavaMethodInvocationInstruction(String function2, Instruction object2, Instruction[] parameters, Type t, boolean isUserClass) {
        super(parameters);
        this.m_function = function2;
        this.m_object = object2;
        if (t != null) {
            this.setCachedType(t);
        }
        this.m_type = t;
        this.m_isUserClass = isUserClass;
    }

    public JavaMethodInvocationInstruction(String function2, String classname, Instruction[] parameters, Type t) {
        this(function2, classname, parameters, t, false);
    }

    public JavaMethodInvocationInstruction(String function2, String classname, Instruction[] parameters, Type t, boolean isUserClass) {
        super(parameters);
        this.m_function = function2;
        this.m_classname = classname;
        this.setCachedType(t);
        this.m_isUserClass = isUserClass;
    }

    public String getFunction() {
        return this.m_function;
    }

    public String getClassName() {
        return this.m_classname;
    }

    public void setFunction(String n2) {
        this.m_function = n2;
    }

    public Instruction[] getParameters() {
        return this.m_parameters;
    }

    public int getParameterCount() {
        return this.m_parameters.length;
    }

    public Instruction getObject() {
        return this.m_object;
    }

    public void setIsUserClass(boolean val) {
        this.m_isUserClass = val;
    }

    public boolean getIsUserClass() {
        return this.m_isUserClass;
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        super.doDefaultTypeCheck(tenv, benv, functionStack);
        if (this.m_object != null) {
            this.m_object.typeCheck(tenv, benv, functionStack);
        }
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
            s_logger.logp(Level.FINEST, s_className, "typeCheck", "Checking " + this);
        }
        if (this.m_type == null) {
            JavaObjectType jot;
            if (this.m_object == null) {
                jot = new JavaObjectType(this.m_classname);
            } else {
                Type t = this.m_object.getCachedType();
                if (t == null) {
                    throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Could not find the type of " + this.m_object), this);
                }
                if ((t = t.resolveType(tenv)) == null) {
                    throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Could not infer the type of " + this.m_object), this);
                }
                if (!(t instanceof JavaObjectType)) {
                    throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", this.m_object + " is not a Java object"), this);
                }
                jot = (JavaObjectType)t;
            }
            JavaClassInformation info = jot.getInformation(tenv.getModule(), this.m_isUserClass);
            if (this.m_object == null) {
                throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Java instance method invocation without an object."), this);
            }
            Collection methods = this.getMethods(info, this.m_function, tenv.getModule());
            if (methods == null || methods.size() == 0) {
                if (jot.getInformation(tenv.getModule(), this.m_isUserClass).getBaseClassNames().size() == 0 && LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
                    s_logger.logp(Level.FINEST, s_className, "typeCheck", "Could not find any base classes for " + jot.getClassName() + ".  Maybe I can't find the class either.");
                }
                throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Class " + jot + " does not contain a method named " + this.m_function), this);
            }
            for (int j = 0; j < this.m_parameters.length; ++j) {
                this.m_parameters[j].typeCheck(tenv, benv, functionStack);
            }
            boolean fullySpecifiedArgs = true;
            for (int j = 0; j < this.m_parameters.length; ++j) {
                if (this.m_parameters[j].getCachedType().isFullySpecified()) continue;
                fullySpecifiedArgs = false;
                break;
            }
            if (!fullySpecifiedArgs) {
                int arityMatches = 0;
                for (JavaClassInformation.Method m : methods) {
                    Type[] types2 = m.getParameterTypes();
                    if (types2.length != this.m_parameters.length) continue;
                    ++arityMatches;
                }
                if (arityMatches > 1) {
                    this.m_type = this.setCachedType(new TypeVariable());
                    return this.m_type;
                }
            }
            for (JavaClassInformation.Method m : methods) {
                Type[] types3 = m.getParameterTypes();
                if (types3.length != this.m_parameters.length) continue;
                TypeEnvironment tenv2 = tenv.copy();
                try {
                    int j;
                    for (j = 0; j < types3.length; ++j) {
                        tenv2.unify(types3[j], this.m_parameters[j].getCachedType(), this);
                    }
                    for (j = 0; j < types3.length; ++j) {
                        tenv.unify(types3[j], this.m_parameters[j].getCachedType(), this);
                    }
                    this.m_type = this.setCachedType(m.getReturnType());
                    return this.m_type;
                }
                catch (TypeCheckException exn) {
                    if (!LoggerUtil.isAnyTracingEnabled() || !s_logger.isLoggable(Level.FINEST)) continue;
                    s_logger.logp(Level.FINEST, s_className, "typeCheck", "Method did not match.  reason: " + exn.getMessage());
                }
            }
            if (this.m_type == null) {
                throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Could not find a suitable method named " + this.m_function + " for " + this.m_object), this);
            }
        } else {
            for (int j = 0; j < this.m_parameters.length; ++j) {
                this.m_parameters[j].typeCheck(tenv, benv, functionStack);
            }
        }
        return this.setCachedType(this.m_type);
    }

    private Collection getMethods(JavaClassInformation info, String fname, Module m) {
        Set bases;
        Collection c = info.getMethods(fname);
        return c != null && c.size() > 0 ? c : ((bases = info.getBaseClassNames()).size() < 1 ? null : this.getMethods(bases, fname, m));
    }

    private Collection getMethods(Set bases, String fname, Module m) {
        Iterator i = bases.iterator();
        while (i.hasNext()) {
            try {
                JavaClassInformation info = JavaClassImporter.retrieveJavaClassInformation((String)i.next(), m, this.m_isUserClass);
                Collection c = this.getMethods(info, fname, m);
                if (c == null || c.size() <= 0) continue;
                return c;
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        return this.m_type;
    }

    @Override
    public Type getPreTypecheckType(ModuleSignature msig) {
        return this.m_type;
    }

    @Override
    public Instruction getChildInstruction(int i) {
        return i > 0 ? this.m_parameters[i - 1] : this.m_object;
    }

    @Override
    public int getChildInstructionCount() {
        return this.m_parameters.length + 1;
    }

    @Override
    public void setChildInstruction(int i, Instruction n2) {
        if (i == 0) {
            this.m_object = n2;
        } else {
            this.m_parameters[i - 1] = n2;
        }
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        Instruction[] parameters = new Instruction[this.m_parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = this.m_parameters[i].cloneWithoutTypeInformation();
        }
        if (this.m_classname == null) {
            JavaMethodInvocationInstruction i = new JavaMethodInvocationInstruction(this.m_function, this.m_object.cloneWithoutTypeInformation(), parameters, this.m_type, this.m_isUserClass);
            JavaMethodInvocationInstruction.propagateInfo(this, i);
            return i;
        }
        JavaMethodInvocationInstruction i = new JavaMethodInvocationInstruction(this.m_function, this.m_classname, parameters, this.m_type, this.m_isUserClass);
        JavaMethodInvocationInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Instruction cloneShallow() {
        Instruction[] parameters = (Instruction[])this.m_parameters.clone();
        if (this.m_classname == null) {
            JavaMethodInvocationInstruction i = new JavaMethodInvocationInstruction(this.m_function, this.m_object, parameters, this.m_type, this.m_isUserClass);
            JavaMethodInvocationInstruction.propagateInfo(this, i);
            return i;
        }
        JavaMethodInvocationInstruction i = new JavaMethodInvocationInstruction(this.m_function, this.m_classname, parameters, this.m_type, this.m_isUserClass);
        JavaMethodInvocationInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public String innerToString() {
        return "java-method-invoke";
    }

    @Override
    protected Type getTypeForTypeAnnotationPrettyPrint() {
        Type t = this.getCachedType();
        if (t == null) {
            t = this.m_type;
        }
        return t;
    }

    @Override
    public void toString(PrettyPrinter pw, int indent) {
        pw.printFormOpen(this.innerToString(), indent, this.getTypeForTypeAnnotationPrettyPrint());
        if (this.m_classname != null) {
            pw.print(" \"" + this.m_classname + "\" ");
        } else {
            this.m_object.toString(pw, indent + 1);
        }
        pw.printToken(this.m_function, indent + 1);
        if (this.getChildInstructionCount() > 0) {
            for (int i = 1; i < this.getChildInstructionCount(); ++i) {
                Instruction n2 = this.getChildInstruction(i);
                if (n2 != null) {
                    n2.toString(pw, indent + 1);
                    continue;
                }
                pw.printToken("null", indent + 1);
            }
        }
        pw.printFormClose(indent);
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cgh, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        SessionContext session = cgt.getSessionContext();
        BasicDynamicContext dynamicContext = new BasicDynamicContext(session);
        Environment e = new Environment(dynamicContext);
        CodeGenerationSettings cgs = cgh.getSettings();
        e.setArbitraryPrecision(cgs.getArbitraryPrecision());
        e.setOverflowDetection(cgs.getOverflowDetection());
        Method m = this.resolveMethod(e, cgh.getCurrentFunctionAsFunction(), null, false);
        e.release(null);
        boolean isStatic = Modifier.isStatic(m.getModifiers());
        TypeEnvironment tenv = cgt.m_typeEnvironment;
        Type retType = this.getType(tenv, cgt.m_bindingEnvironment);
        FcgType retFcgType = retType == UnitType.s_unitType ? FcgType.VOID : retType.getFCGType(cgh);
        if (!isStatic) {
            cgt.generateConventionally(this.m_object, cgh, false, il, ValueGenStyle.DEFAULT);
        }
        Class<?>[] types2 = m.getParameterTypes();
        FcgType[] paramTypes = new FcgType[this.m_parameters.length];
        for (int i = 0; i < this.m_parameters.length; ++i) {
            cgt.generateConventionally(this.m_parameters[i], cgh, false, il, ValueGenStyle.DEFAULT);
            paramTypes[i] = FcgTypeUtils.getFcgType(cgh, types2[i]);
        }
        FcgClassReferenceType theClass = cgh.getClassReferenceType(m.getDeclaringClass().getName());
        if (!isStatic) {
            if (m.getDeclaringClass().isInterface()) {
                FcgInterfaceType theInterface = cgh.getInterfaceType(m.getDeclaringClass().getName());
                il.invokeInterfaceMethod(theInterface, this.m_function, retFcgType, paramTypes);
            } else {
                il.invokeInstanceMethod(theClass, this.m_function, retFcgType, paramTypes);
            }
        } else {
            il.invokeClassMethod(theClass, this.m_function, retFcgType, paramTypes);
        }
        return retFcgType;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        if (null != di) {
            di.enter(this, e, f2);
        }
        Object obj = null;
        e.pushForkScope();
        Object ans = null;
        try {
            if (this.m_object != null) {
                Type objType = this.m_object.evaluateType(f2);
                obj = this.m_object.evaluate(e, f2, di, false);
                if (obj instanceof IConvertible) {
                    obj = ((IConvertible)obj).convert(e, objType);
                }
            }
            Object[] args = new Object[this.m_parameters.length];
            Type[] argTypes = new Type[this.m_parameters.length];
            int i = 0;
            while (true) {
                if (i >= this.m_parameters.length) {
                    Method m = this.resolveMethod(e, f2, di, tailPosition, argTypes);
                    Object ret = m.invoke(obj, args);
                    Type type2 = this.evaluateType(f2);
                    ans = type2.wrapForInterpreter(ret, e);
                    Object object2 = Debugger.leave(di, this, e, f2, ans);
                    e.popForkScope(ans);
                    return object2;
                }
                argTypes[i] = this.m_parameters[i].evaluateType(f2);
                Object param = this.m_parameters[i].evaluate(e, f2, di, false);
                if (param instanceof IConvertible) {
                    param = ((IConvertible)param).convert(e, argTypes[i]);
                }
                args[i] = param;
                ++i;
            }
        }
        catch (InvocationTargetException ee) {
            try {
                RuntimeException exception;
                Throwable target = ee.getTargetException();
                if (target instanceof RuntimeException) {
                    exception = (RuntimeException)target;
                    throw exception;
                }
                exception = new RuntimeException(target);
                throw exception;
                catch (Exception ee2) {
                    throw new RuntimeException(ee2);
                }
            }
            catch (Throwable throwable) {
                e.popForkScope(ans);
                throw throwable;
            }
        }
    }

    private Type[] getArgTypes(Environment e, Function f2) {
        Type[] argTypes = new Type[this.m_parameters.length];
        for (int i = 0; i < this.m_parameters.length; ++i) {
            argTypes[i] = this.m_parameters[i].evaluateType(f2);
        }
        return argTypes;
    }

    private Class[] getJavaArgTypes(Environment e, Type[] argTypes) {
        Class[] javaArgTypes = new Class[argTypes.length];
        for (int i = 0; i < argTypes.length; ++i) {
            javaArgTypes[i] = argTypes[i].getJavaType(e);
        }
        return javaArgTypes;
    }

    private Method resolveMethod(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition, Type[] argTypes) {
        Object obj = null;
        Class classType = null;
        if (this.m_object != null) {
            Type objType = this.m_object.evaluateType(f2);
            classType = objType.getJavaType(e);
        } else {
            String newName = this.m_classname;
            ClassLoader classLoader = this.m_isUserClass ? ObjectFactory.findClassLoader() : Module.class.getClassLoader();
            while (classType == null) {
                try {
                    classType = ObjectFactory.findProviderClass(newName, classLoader, true);
                }
                catch (ClassNotFoundException ex) {
                    int index2 = this.m_classname.lastIndexOf(46);
                    if (index2 != -1) {
                        newName = newName.substring(0, index2) + "$" + newName.substring(index2 + 1, newName.length());
                        continue;
                    }
                    throw new XylemError("ERR_SYSTEM", "Could not find class for " + this.m_classname);
                }
            }
        }
        try {
            Method m = InterpreterUtilities.getMethod(classType, this.m_function, this.getJavaArgTypes(e, argTypes));
            return m;
        }
        catch (Exception ee) {
            throw new RuntimeException(ee);
        }
    }

    private Method resolveMethod(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        return this.resolveMethod(e, f2, di, tailPosition, this.getArgTypes(e, f2));
    }

    @Override
    public boolean equals(Object arg0) {
        if (!super.equals(arg0)) {
            return false;
        }
        JavaMethodInvocationInstruction mii = (JavaMethodInvocationInstruction)arg0;
        return mii.m_function.equals(this.m_function);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.m_function.hashCode();
    }

    @Override
    public void generateReducedForm(ReductionHelper rh, Instruction[] state, BindingEnvironment benv) {
        this.m_object = rh.reduceToBasicInstruction(state, this.m_object, benv);
        super.generateReducedForm(rh, state, benv);
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        super.read(rofh, benv);
        this.m_object = rofh.readInstruction(benv);
        if (rofh.readBoolean()) {
            this.m_classname = rofh.readString();
        }
        this.m_function = rofh.readString();
        this.m_type = rofh.readType();
        this.setCachedType(this.m_type);
        this.m_isUserClass = rofh.readBoolean();
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        super.write(wofh);
        wofh.writeInstruction(this.m_object);
        wofh.writeBoolean(this.m_classname != null);
        if (this.m_classname != null) {
            wofh.writeString(this.m_classname);
        }
        wofh.writeString(this.m_function);
        wofh.writeType(this.m_type);
        wofh.writeBoolean(this.m_isUserClass);
    }
}

