/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.instructions;

import com.ibm.xltxe.rnm1.fcg.FcgAttrs;
import com.ibm.xltxe.rnm1.fcg.FcgClassGen;
import com.ibm.xltxe.rnm1.fcg.FcgClassReferenceType;
import com.ibm.xltxe.rnm1.fcg.FcgInstructionList;
import com.ibm.xltxe.rnm1.fcg.FcgMethodGen;
import com.ibm.xltxe.rnm1.fcg.FcgType;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.IDebuggerInterceptor;
import com.ibm.xltxe.rnm1.xylem.INewNameGenerator;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.ClosureGenerationUtilities;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationTracker;
import com.ibm.xltxe.rnm1.xylem.codegen.ConventionalGenerationState;
import com.ibm.xltxe.rnm1.xylem.codegen.LambdaFunctionGenerationStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.LazyAdditionGenerationState;
import com.ibm.xltxe.rnm1.xylem.codegen.ValueGenStyle;
import com.ibm.xltxe.rnm1.xylem.codegen.fcg.FcgCodeGenHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.interpreter.Closure;
import com.ibm.xltxe.rnm1.xylem.interpreter.Debugger;
import com.ibm.xltxe.rnm1.xylem.interpreter.Environment;
import com.ibm.xltxe.rnm1.xylem.types.LambdaType;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LambdaInstruction
extends Instruction
implements ISpecialForm {
    protected Binding[] m_parameters;
    protected Instruction m_body;
    protected boolean m_isPure = true;
    protected IBinding[] closureExternalBindings;
    protected IBinding[] closureInternalBindings;
    protected int stackFrameSize;

    public LambdaInstruction() {
    }

    public LambdaInstruction(Instruction op1, Binding[] parameters, boolean isPure) {
        this.m_body = op1;
        this.m_parameters = parameters;
        this.m_isPure = isPure;
    }

    @Override
    public Type getTypeInternal(TypeEnvironment tenv, BindingEnvironment benv) {
        Type[] paramTypes = new Type[this.m_parameters.length];
        for (int i = 0; i < this.m_parameters.length; ++i) {
            paramTypes[i] = this.m_parameters[i].getBindingType();
        }
        return new LambdaType(paramTypes, this.m_body.getType(tenv, benv), this.m_isPure);
    }

    protected LambdaFunctionGenerationStyle computeGenerationStyle(FcgCodeGenHelper cgh, TypeEnvironment tenv, BindingEnvironment benv, CodeGenerationTracker cgt, HashSet freeBindings, FcgInstructionList il) {
        this.m_body.accumulateFreeBindings(freeBindings, benv);
        for (int i = 0; i < this.m_parameters.length; ++i) {
            freeBindings.remove(this.m_parameters[i]);
        }
        FunctionCallInstruction fci = (FunctionCallInstruction)this.m_body;
        LambdaType lt2 = (LambdaType)this.getType(tenv, benv).resolveType(tenv);
        Function function2 = tenv.getModule().getFunction(fci.getFunction());
        IBinding[] bindings = new IBinding[this.m_parameters.length];
        LiteralInstruction[] literalParameters = new LiteralInstruction[fci.m_parameters.length];
        List paramInfo = ClosureGenerationUtilities.determineClosureFunctionCallFreeBindings(fci, freeBindings, tenv, benv, cgt, cgh, il);
        LambdaFunctionGenerationStyle cnlffgs = new LambdaFunctionGenerationStyle(function2, paramInfo, lt2, bindings, literalParameters);
        for (int i = 0; i < fci.m_parameters.length; ++i) {
            Instruction n2 = fci.m_parameters[i];
            if (n2 instanceof IdentifierInstruction) {
                IBinding b = ((IdentifierInstruction)n2).getBinding(benv);
                Binding b2 = function2.m_parameters[i];
                for (int j = 0; j < this.m_parameters.length; ++j) {
                    if (b != this.m_parameters[j]) continue;
                    bindings[j] = b2;
                }
                continue;
            }
            literalParameters[i] = (LiteralInstruction)n2;
        }
        return cnlffgs;
    }

    @Override
    public FcgType generateCode(FcgCodeGenHelper cgh, CodeGenerationTracker cgt, String varNameSuggestion, boolean tailPosition, FcgInstructionList il, ValueGenStyle valueStyleRequest) {
        TypeEnvironment tenv = cgt.m_typeEnvironment;
        BindingEnvironment benv = cgt.m_bindingEnvironment;
        if (this.m_body instanceof FunctionCallInstruction) {
            FunctionCallInstruction fci = (FunctionCallInstruction)this.m_body;
            HashSet freeBindings = new HashSet();
            for (int i = 0; i < this.m_parameters.length; ++i) {
                cgt.registerExtantBinding(this.m_parameters[i], this.m_parameters[i].getName().toString());
            }
            LambdaFunctionGenerationStyle cnlffgs = this.computeGenerationStyle(cgh, tenv, benv, cgt, freeBindings, il);
            String lambdaClassName = cgh.getClassName() + "$" + cnlffgs.generateClassName(cgh);
            FcgClassReferenceType lambdaType = cgh.getClassReferenceType(lambdaClassName);
            FcgClassReferenceType thisType = cgh.loadThisVar(il);
            List paramInfo = ClosureGenerationUtilities.generateClosureFunctionCallParameters(fci, freeBindings, cgt, cgh, il);
            FcgType[] params = new FcgType[paramInfo.size() + 1];
            params[0] = thisType;
            for (int i = 0; i < paramInfo.size(); ++i) {
                params[i + 1] = ((IBinding)paramInfo.get(i)).getBindingType(tenv, benv).getFCGType(cgh);
            }
            il.createObjectExpr((FcgType)lambdaType, params);
            cgh.requestFunctionGeneration(cnlffgs);
            return lambdaType;
        }
        CodeGenerationTracker cgt2 = cgt.cloneBranch();
        LambdaType lambdaType = (LambdaType)this.getType(tenv, cgt.m_bindingEnvironment).resolveType(cgt.m_typeEnvironment);
        String baseClassName = lambdaType.getImplementationName(cgh);
        String className = cgh.generateNewClassName();
        FcgClassReferenceType classType = cgh.getClassReferenceType(className);
        FcgClassGen classGen = cgh.newClassGen(classType, cgh.getClassReferenceType(baseClassName), FcgAttrs.PUBLIC_FINAL);
        FcgType fcgRetType = lambdaType.getReturnType().getFCGType(cgh);
        FcgMethodGen mg = classGen.newMethodGen(FcgAttrs.PUBLIC_FINAL, fcgRetType, "invoke");
        FcgInstructionList ilInvoke = mg.getInstructionList();
        for (int i = 0; i < this.m_parameters.length; ++i) {
            Binding b = this.m_parameters[i];
            String paramName = cgh.generateNewLocalVariableName(Binding.generateVariableName(b, cgh));
            FcgType paramType = b.getBindingType().getFCGType(cgh);
            cgt2.registerExtantBinding(b, paramName);
            mg.addParameter(paramType, paramName);
        }
        HashSet freeBindings = new HashSet();
        this.m_body.accumulateFreeBindings(freeBindings, cgt.m_bindingEnvironment);
        for (int i = 0; i < this.m_parameters.length; ++i) {
            freeBindings.remove(this.m_parameters[i]);
        }
        for (IBinding b : freeBindings) {
            if (b.getLet() != null && b.getLet().getValue() instanceof LiteralInstruction) {
                ConventionalGenerationState cgs = new ConventionalGenerationState(b, b.getLet().getValue(), -1);
                cgt2.registerBinding(b, cgs);
                continue;
            }
            FcgType type2 = b.getBindingType(tenv, benv).getFCGType(cgh);
            String fieldName = "m_" + cgh.getSafeName(b.getName().toString());
            cgt2.registerBinding(b, new LazyAdditionGenerationState(b, null, fieldName, type2));
        }
        ilInvoke.beginMethod();
        FcgClassReferenceType thisType = cgh.getClassReferenceType(cgh.getClassName());
        ilInvoke.loadThis();
        ilInvoke.loadInstanceField(classType, "__this__", thisType);
        ilInvoke.defineConstVar(thisType, "__this__");
        this.m_body.generateCode(cgh, cgt2, null, true, ilInvoke, valueStyleRequest);
        ilInvoke.returnInstruction(fcgRetType);
        ilInvoke.endMethod();
        ClosureGenerationUtilities.generateClosureInitSuffix(freeBindings, cgt, cgh, classGen, il);
        cgh.completeClassGeneration(classGen);
        return classType;
    }

    @Override
    public Instruction assignNewNames(Map names, INewNameGenerator ing) {
        Binding[] newParameters = new Binding[this.m_parameters.length];
        for (int i = 0; i < this.m_parameters.length; ++i) {
            Object s = ing.getNewName();
            names.put(this.m_parameters[i].getName(), new IdentifierInstruction(s));
            newParameters[i] = new Binding(s, this.m_parameters[i].getBindingType(), this);
        }
        return new LambdaInstruction(this.m_body.assignNewNames(names, ing), newParameters, this.m_isPure);
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        Binding[] clonedParams = new Binding[this.m_parameters.length];
        for (int i = 0; i < clonedParams.length; ++i) {
            clonedParams[i] = new Binding(this.m_parameters[i].getName(), this.m_parameters[i].getBindingType(), this);
        }
        LambdaInstruction cnlfi = new LambdaInstruction(this.m_body.cloneWithoutTypeInformation(), clonedParams, this.m_isPure);
        LambdaInstruction.propagateInfo(this, cnlfi);
        return cnlfi;
    }

    @Override
    public Instruction cloneShallow() {
        Binding[] clonedParams = new Binding[this.m_parameters.length];
        for (int i = 0; i < clonedParams.length; ++i) {
            clonedParams[i] = new Binding(this.m_parameters[i].getName(), this.m_parameters[i].getBindingType(), this);
        }
        LambdaInstruction i = new LambdaInstruction(this.m_body, clonedParams, this.m_isPure);
        LambdaInstruction.propagateInfo(this, i);
        return i;
    }

    @Override
    public Object evaluate(Environment e, Function f2, IDebuggerInterceptor di, boolean tailPosition) {
        if (null != di) {
            di.enter(this, e, f2);
        }
        int nFreeBindings = this.closureExternalBindings.length;
        Object[] closureValues = new Object[nFreeBindings];
        boolean mustRelease = false;
        for (int i = 0; i < nFreeBindings; ++i) {
            IBinding b = this.closureExternalBindings[i];
            Object val = e.lookupBoundValue(b);
            Type t = b.getBindingType();
            if (t == null) {
                t = this.closureInternalBindings[i].getBindingType();
            }
            closureValues[i] = val = t.evaluateVariableFork(val);
        }
        Closure c = new Closure(this.closureInternalBindings, closureValues, f2, this.m_body, this.m_parameters, this.m_sourceFilename, this.m_sourceLineNumber, this.stackFrameSize);
        c.m_mustForkAndRelease = mustRelease;
        e.pushIForkReleaseManagedForRelease(c);
        return Debugger.leave(di, this, e, f2, (Object)c);
    }

    public Instruction getBody() {
        return this.m_body;
    }

    public void setBody(Instruction x) {
        this.m_body = x;
    }

    @Override
    public String innerToString() {
        StringBuffer sb = new StringBuffer();
        sb.append("lambda (");
        for (int i = 0; i < this.m_parameters.length; ++i) {
            if (i != 0) {
                sb.append(' ');
            }
            sb.append(this.m_parameters[i].getName());
        }
        return sb + ")";
    }

    @Override
    public void toString(PrettyPrinter pw, int indent) {
        pw.printFormOpen("lambda", indent, this.getCachedType());
        pw.print(" (");
        for (int i = 0; i < this.m_parameters.length; ++i) {
            pw.printIdentifier(this.m_parameters[i], indent + 2);
            Type t = this.m_parameters[i].getBindingType();
            if (t == null) continue;
            pw.print("@");
            pw.print(t.prettyPrint());
        }
        pw.print(")");
        this.m_body.toString(pw, indent + 1);
        pw.print(")");
    }

    @Override
    public Type typeCheck(TypeEnvironment tenv, BindingEnvironment benv, LinkedList functionStack) throws TypeCheckException {
        super.doDefaultTypeCheck(tenv, benv, functionStack);
        Type[] paramTypes = new Type[this.m_parameters.length];
        BindingEnvironment benv2 = new BindingEnvironment(benv);
        for (int i = 0; i < this.m_parameters.length; ++i) {
            paramTypes[i] = this.m_parameters[i].getBindingType();
            benv2.setVariableBinding(this.m_parameters[i]);
        }
        if (this.closureExternalBindings != null) {
            Type[] freeBindingTypes = new Type[this.closureExternalBindings.length];
            for (int i = 0; i < this.closureExternalBindings.length; ++i) {
                Type t = this.closureExternalBindings[i].getBindingType(tenv, benv2);
                assert (t != null);
                assert (this.closureExternalBindings[i].getBindingType() != null);
            }
        }
        return this.setCachedType(new LambdaType(paramTypes, this.m_body.typeCheck(tenv, benv2, functionStack), this.m_isPure));
    }

    @Override
    public void generateReducedForm(ReductionHelper rh, Instruction[] state, BindingEnvironment benv) {
        LambdaInstruction cnlfi = this;
        ReductionHelper rh2 = (ReductionHelper)rh.clone();
        this.m_bindingEnvironment = null;
        for (int i = 0; i < this.m_parameters.length; ++i) {
            rh2.upgradeBinding(this.m_parameters[i]);
            benv.setVariableBinding(this.m_parameters[i]);
        }
        cnlfi.m_body = rh2.reduce(this.m_body, benv);
        state[0] = cnlfi;
    }

    @Override
    public int getChildInstructionCount() {
        return 1;
    }

    @Override
    public Instruction getChildInstruction(int i) {
        return i == 0 ? this.m_body : null;
    }

    @Override
    public void setChildInstruction(int i, Instruction n2) {
        if (i == 0) {
            this.m_body = n2;
        }
    }

    @Override
    public void accumulateNonLiteralFreeBindings(Set set2, BindingEnvironment benv) {
        super.accumulateNonLiteralFreeBindings(set2, benv);
        for (int i = 0; i < this.m_parameters.length; ++i) {
            set2.remove(this.m_parameters[i]);
        }
        if (set2.contains(this)) {
            throw new XylemError("ERR_SYSTEM", "Lambda has binding to itself!");
        }
    }

    @Override
    public void accumulateFreeBindings(Set set2, BindingEnvironment benv) {
        super.accumulateFreeBindings(set2, benv);
        for (int i = 0; i < this.m_parameters.length; ++i) {
            set2.remove(this.m_parameters[i]);
        }
    }

    @Override
    public void read(ReadObjectFileHelper rofh, BindingEnvironment benv) throws Exception {
        this.m_body = rofh.readInstruction(benv);
        this.m_isPure = rofh.readBoolean();
        this.m_parameters = rofh.readTypeSpecificBindingSet(this);
    }

    @Override
    public void write(WriteObjectFileHelper wofh) throws IOException {
        wofh.writeInstruction(this.m_body);
        wofh.writeBoolean(this.m_isPure);
        wofh.writeTypeSpecificBindingSet(this.m_parameters);
    }

    @Override
    public void typeCheckReduced(TypeEnvironment tenv, BindingEnvironment benv, LinkedList<Function> functionStack) {
        Type[] paramTypes = new Type[this.m_parameters.length];
        for (int i = 0; i < this.m_parameters.length; ++i) {
            paramTypes[i] = this.m_parameters[i].getBindingType();
            benv.setVariableBinding(this.m_parameters[i]);
        }
        super.typeCheckReduced(tenv, benv, functionStack);
    }

    @Override
    public Type getTypeParameter(int i) {
        return this.m_parameters[i].getBindingType();
    }

    @Override
    public int getTypeParameterCount() {
        return this.m_parameters.length;
    }

    @Override
    public void setTypeParameter(int i, Type n2) {
        this.m_parameters[i].setType(n2);
    }

    @Override
    public boolean isChildInstructionBody(int i) {
        return true;
    }

    @Override
    public IBinding[] getChildInstructionBindings(int i) {
        return this.m_parameters;
    }

    public List getBindings() {
        ArrayList<Binding> list = new ArrayList<Binding>();
        list.addAll(Arrays.asList(this.m_parameters));
        return list;
    }

    public Binding[] getParameters() {
        return this.m_parameters;
    }

    @Override
    public boolean equals(Object arg0) {
        if (!super.equals(arg0)) {
            return false;
        }
        LambdaInstruction li = (LambdaInstruction)arg0;
        int c = this.m_parameters.length;
        if (li.m_parameters.length != c) {
            return false;
        }
        for (int i = 0; i < c; ++i) {
            if (li.m_parameters[i].getName().equals(this.m_parameters[i].getName())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isChildInstructionInTailPosition(int i) {
        return false;
    }

    public IBinding[] getFreeBindings() {
        return this.closureExternalBindings;
    }

    public void setFreeBindings(Set<IBinding> freeBindings, Function f2) {
        this.closureExternalBindings = new IBinding[freeBindings.size()];
        this.closureInternalBindings = new IBinding[freeBindings.size()];
        int i = 0;
        Iterator<IBinding> i$ = freeBindings.iterator();
        while (i$.hasNext()) {
            IBinding b;
            this.closureExternalBindings[i] = b = i$.next();
            Type btype = b.getBindingType();
            if (btype == null) {
                btype = this.extractType(b, f2);
            }
            assert (btype != null);
            Binding internalBinding = new Binding(b.getName(), btype);
            internalBinding.setStackFramePos(i + this.m_parameters.length);
            this.closureInternalBindings[i] = internalBinding;
            ++i;
        }
    }

    private Type extractType(IBinding b, Function f2) {
        BindingEnvironment be = this.getBindingEnvironment();
        if (be == null) {
            be = f2.getBindingEnvironment();
        }
        assert (be != null);
        TypeEnvironment te = f2.getTypeEnvironment();
        assert (te != null);
        Type type2 = b.getBindingType(te, be);
        return type2;
    }

    public IBinding[] getClosureInternalBindings() {
        return this.closureInternalBindings;
    }

    public int getStackFrameSize() {
        return this.stackFrameSize;
    }

    public void setStackFrameSize(int stackFrameSize) {
        this.stackFrameSize = stackFrameSize;
    }
}

